/*************************************************************************
 *
 *  $RCSfile: sysfile.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:50:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define ENABLE_BYTESTRING_STREAM_OPERATORS	1

// include ---------------------------------------------------------------

#include "os.hxx"

#include <tools/stream.hxx>
#define _SVSTDARR_STRINGSDTOR
#include <svtools/svstdarr.hxx>

const char PATH[]       = "Path";
const char LIBPATH[]    = "Libpath";
const char CONFIG_SYS[] = "config.sys";

// -----------------------------------------------------------------------

void ChangeConfigFile
(
	ByteString const& rFile,
	ByteString const& rKey,
	ByteString const& rDestPath
)
{
	SvByteStringsDtor aList;
	ByteString* psLine = 0;
	ByteString sLine;
	SvFileStream aStrm( rFile, STREAM_READ );

	while ( aStrm.ReadLine( sLine ) )
	{
		ByteString sTmp( sLine );
		sTmp.ToLower();
		USHORT nPos = sTmp.Search( rKey.Lower() );
		USHORT nREM_Pos = sTmp.Search( "rem" );

		if( nREM_Pos ==	STRING_NOTFOUND &&
			nPos != STRING_NOTFOUND &&
			(nPos == 0 || sTmp(nPos-1) == ' ' || sTmp(nPos-1) == '\t') )
		{
			if ( sTmp.Search( rDestPath.Lower() ) == STRING_NOTFOUND )
			{
				// CODE um uns davor zu haengen!
				/***
				ByteString aDest(rDestPath);
				aDest += ";";
				USHORT nInsPos = sLine.Search( '=', nPos);
				sLine.Insert( aDest, nInsPos + 1 );
				***/

				// CODE um uns hinten anzuhaengen!
				if ( sLine( sLine.Len() - 1 ) != ';' )
					sLine.Insert( ';' );
				sLine.Insert( rDestPath );
			}
		}
		psLine = new ByteString( sLine );
		aList.Insert( psLine, aList.Count() );
	}
	aStrm.Close();
	SvFileStream aNewStrm( rFile, STREAM_WRITE | STREAM_TRUNC );

	for ( USHORT i = 0; i < aList.Count(); ++i )
		aNewStrm.WriteLine( *aList[i] );
}

// -----------------------------------------------------------------------

void RestoreConfigFile
(
	ByteString const& rFile,
	ByteString const& rKey,
	ByteString const& rDestPath
)
{
	SvByteStringsDtor aList;
	ByteString* psLine = 0;
	ByteString sLine;
	SvFileStream aStrm( rFile, STREAM_READ );

	while ( aStrm.ReadLine( sLine ) )
	{
		ByteString sTmp( sLine );
		sTmp.ToLower();
		USHORT nPos = sTmp.Search( rKey.Lower() );

		if ( nPos != STRING_NOTFOUND &&
			 ( nPos == 0 || sTmp(nPos-1) == ' ' || sTmp(nPos-1) == '\t' ) )
		{
			if ( ( nPos = sTmp.Search( rDestPath.Lower() )  ) !=
				 STRING_NOTFOUND )
			{
				USHORT nLen = rDestPath.Len(), nTmpPos = nPos + nLen;

				while ( sLine( nTmpPos ) == ' ' || sLine( nTmpPos ) == ';' )
				{
					// Leerzeichen und das Semikolon auch lo"schen
					nTmpPos++;
					nLen++;
				}
				sLine.Erase( nPos, nLen );

				if ( sLine( sLine.Len() - 1 ) == ';' )
					// das letzte Zeichen der Zeile ist ein Semikolon
					// dieses entfernen
					sLine.Erase( sLine.Len() - 1 );
			}
		}
		psLine = new ByteString( sLine );
		aList.Insert( psLine, aList.Count() );
	}
	aStrm.Close();
	SvFileStream aNewStrm( rFile, STREAM_WRITE | STREAM_TRUNC );

	for ( USHORT i = 0; i < aList.Count(); ++i )
		aNewStrm.WriteLine( *aList[i] );
}


BOOL Os2OS::AddDestPathToConfigSys(BOOL bModifyCopy, ByteString const &rDestPath)
{
	SiDirEntry aCfgEntry  = Os2OS::GetBootDrive();
			 aCfgEntry += ByteString(CONFIG_SYS);

	if (!aCfgEntry.Exists())
		return FALSE;

	if (!bModifyCopy)
	{
		SiDirEntry aTmp = aCfgEntry;
		aTmp.SetExtension("set");

		if (aTmp.Exists())
			aTmp.Kill();

		if (aCfgEntry.CopyTo(aTmp, TRUE) == FSYS_ERR_OK)
		{
			ChangeConfigFile(aCfgEntry.GetFull(), LIBPATH,  rDestPath);
			ChangeConfigFile(aCfgEntry.GetFull(), PATH,     rDestPath);
		}
	}
	else
	{
		SiDirEntry aTmp  = rDestPath;
				 aTmp += ByteString(CONFIG_SYS);
		aTmp.SetExtension( "set" );
		ByteString aCfgBackup( aTmp.GetFull() );

		if (aTmp.Exists())
			aTmp.Kill();

		if (aCfgEntry.CopyTo(aTmp, TRUE) == FSYS_ERR_OK)
		{
			ChangeConfigFile(aCfgBackup, LIBPATH,  rDestPath);
			ChangeConfigFile(aCfgBackup, PATH,     rDestPath);
		}
	}

	return TRUE;
}

BOOL Os2OS::RemoveDestPathFromConfigSys(ByteString const &rDestPath)
{
	SiDirEntry aCfgEntry  = Os2OS::GetBootDrive();
			 aCfgEntry += ByteString(CONFIG_SYS);

	if (!aCfgEntry.Exists())
		return FALSE;

	RestoreConfigFile(aCfgEntry.GetFull(), LIBPATH,  rDestPath);
	RestoreConfigFile(aCfgEntry.GetFull(), PATH,     rDestPath);

	aCfgEntry  = rDestPath;
	aCfgEntry += ByteString("config.set");

	if (aCfgEntry.Exists())
		aCfgEntry.Kill();

	return TRUE;
}
