/*************************************************************************
 *
 *  $RCSfile: rapcommandenvironment.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/07/27 13:50:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPCOMMANDENVIRONMENT_HXX
#include "rapcommandenvironment.hxx"
#endif
#ifndef _UCPRMT_RMTCONN_HXX_
#include "rmtconn.hxx"
#endif

#ifndef _COM_SUN_STAR_TASK_XINTERACTIONHANDLER_HPP_
#include "com/sun/star/task/XInteractionHandler.hpp"
#endif
#ifndef _COM_SUN_STAR_TASK_XINTERACTIONREQUEST_HPP_
#include "com/sun/star/task/XInteractionRequest.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVEAUGMENTEDIOEXCEPTION_HPP_
#include "com/sun/star/ucb/InteractiveAugmentedIOException.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include "com/sun/star/uno/Any.hxx"
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include "com/sun/star/uno/Reference.hxx"
#endif
#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include "com/sun/star/uno/RuntimeException.hpp"
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include "cppuhelper/implbase1.hxx"
#endif
#ifndef _OSL_DIAGNOSE_H_
#include "osl/diagnose.h"
#endif
#ifndef _RTL_USTRING_H_
#include "rtl/ustring.h"
#endif
#ifndef _RTL_USTRING_HXX_
#include "rtl/ustring.hxx"
#endif

#ifndef INCLUDED_NEW
#include <new>
#define INCLUDED_NEW
#endif

using namespace com::sun;
using ucprmt::CommandEnvironment;

namespace {

class Request: public cppu::WeakImplHelper1< star::task::XInteractionRequest >
{
public:
    inline
    Request(star::uno::Reference< star::task::XInteractionRequest > const &
                rOriginalRequest,
            star::uno::Any const & rRequest)
        SAL_THROW(());

    virtual inline star::uno::Any SAL_CALL getRequest()
        throw (star::uno::RuntimeException)
    { return m_aRequest; }

    virtual inline
    star::uno::Sequence< star::uno::Reference<
                             star::task::XInteractionContinuation > >
    SAL_CALL
    getContinuations()
        throw (star::uno::RuntimeException)
    { return m_xOriginalRequest->getContinuations(); }

private:
    star::uno::Reference< star::task::XInteractionRequest >
        m_xOriginalRequest;
    star::uno::Any m_aRequest;
};

inline
Request::Request(
    star::uno::Reference< star::task::XInteractionRequest > const &
        rOriginalRequest,
    star::uno::Any const & rRequest)
    SAL_THROW(()):
    m_xOriginalRequest(rOriginalRequest),
    m_aRequest(rRequest)
{
    OSL_ENSURE(m_xOriginalRequest.is(), "specification violation");
}

}

CommandEnvironment::CommandEnvironment(
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment,
    rtl::Reference< ucprmt::Connection > const & rConnection)
    SAL_THROW(()):
    m_xEnvironment(rEnvironment),
    m_xConnection(rConnection)
{
    OSL_ENSURE(m_xEnvironment.is(), "specification violation");
    OSL_ENSURE(m_xConnection.is(), "specification violation");
}

CommandEnvironment::~CommandEnvironment() SAL_THROW(())
{}

star::uno::Reference< star::task::XInteractionHandler > SAL_CALL
CommandEnvironment::getInteractionHandler()
    throw (star::uno::RuntimeException)
{
    return this;
}

star::uno::Reference< star::ucb::XProgressHandler > SAL_CALL
CommandEnvironment::getProgressHandler()
    throw (star::uno::RuntimeException)
{
    return m_xEnvironment->getProgressHandler();
}

void SAL_CALL
CommandEnvironment::handle(
    star::uno::Reference< star::task::XInteractionRequest > const & rRequest)
    throw (star::uno::RuntimeException)
{
    if (!rRequest.is())
        return;
    star::uno::Reference< star::task::XInteractionHandler >
        xHandler(m_xEnvironment->getInteractionHandler());
    if (!xHandler.is())
        return;
    star::uno::Reference< star::task::XInteractionRequest >
        xRequest(rRequest);
    star::ucb::InteractiveAugmentedIOException aException;
    if (xRequest->getRequest() >>= aException)
        try
        {
            xRequest = new Request(rRequest,
                                   star::uno::makeAny(m_xConnection->
                                                          mapToLocalException(
                                                              aException)));
        }
        catch (std::bad_alloc const &)
        {
            throw star::uno::RuntimeException(
                      rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                        "Out of memory")),
                      *this);
        }
    xHandler->handle(xRequest);
}
