/*************************************************************************
 *
 *  $RCSfile: dos.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _dos_hxx
#define _dos_hxx

#include <stdio.h>

#define DEFSTYLE        FSYS_STYLE_MSDOS
#ifdef W30
#define CMP_LOWER(s)    Lower_Impl( s )
#else
#define CMP_LOWER(s)    ( String( s ).Lower() )
#endif

#if defined(WIN) || defined(W30)
#include <svwin.h>
#define START_DRV 'a'
#define DRIVE_EXISTS(c) ( GetDriveType( c - 'a' ) > 1 )
#else
#define START_DRV 'c'
#define DRIVE_EXISTS(c) DirEntry(String(c)+String(':')).SetCWD()
#endif

#include <time.h>
#include <datetime.hxx>

String Lower_Impl( const char * );

inline Time MsDos2Time( int nTime )
{
    return Time( nTime >> 11, ( nTime << 5 ) >> 10, 2 * ( nTime & 31 ) );
}

inline Date MsDos2Date( int nDate )
{
    return Date( ( nDate >> 9 ) + 1980, ( nDate << 5 ) >> 10 + 1, nDate & 31 );
}

Time MsDos2Time( const time_t *pTimeT );

Date MsDos2Date( const time_t *pTimeT );

const char* TempDirImpl( char *pBuf);

//--------------------------------------------------------------------

#define FSysFailOnErrorImpl()


#endif
