/*************************************************************************
 *
 *  $RCSfile: time.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2003/07/16 17:14:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _TOOLS_TIME_HXX
#define _TOOLS_TIME_HXX

#ifndef _SOLAR_H
#include <solar.h>
#endif

class ResId;

// --------
// - Time -
// --------

class Time
{
private:
	long			nTime;

public:
					Time();
					Time( const ResId & rResId );
					Time( long _nTime ) { Time::nTime = _nTime; }
					Time( const Time& rTime );
					Time( ULONG nHour, ULONG nMin,
						  ULONG nSec = 0, ULONG n100Sec = 0 );

	void			SetTime( long nNewTime ) { nTime = nNewTime; }
	long			GetTime() const { return nTime; }

	void			SetHour( USHORT nNewHour );
	void			SetMin( USHORT nNewMin );
	void			SetSec( USHORT nNewSec );
	void			Set100Sec( USHORT nNew100Sec );
	USHORT			GetHour() const
						{ ULONG nTempTime = (nTime >= 0) ? nTime : nTime*-1;
						  return (USHORT)(nTempTime / 1000000); }
	USHORT			GetMin() const
						{ ULONG nTempTime = (nTime >= 0) ? nTime : nTime*-1;
						  return (USHORT)((nTempTime / 10000) % 100); }
	USHORT			GetSec() const
						{ ULONG nTempTime = (nTime >= 0) ? nTime : nTime*-1;
						  return (USHORT)((nTempTime / 100) % 100); }
	USHORT			Get100Sec() const
						{ ULONG nTempTime = (nTime >= 0) ? nTime : nTime*-1;
						  return (USHORT)(nTempTime % 100); }

	long			GetMSFromTime() const;
	void			MakeTimeFromMS( long nMS );

                    /// 12 hours == 0.5 days
    double          GetTimeInDays() const;

	BOOL			IsBetween( const Time& rFrom, const Time& rTo ) const
						{ return ((nTime >= rFrom.nTime) && (nTime <= rTo.nTime)); }

    BOOL            IsEqualIgnore100Sec( const Time& rTime ) const;

	BOOL			operator ==( const Time& rTime ) const
						{ return (nTime == rTime.nTime); }
	BOOL			operator !=( const Time& rTime ) const
						{ return (nTime != rTime.nTime); }
	BOOL			operator  >( const Time& rTime ) const
						{ return (nTime > rTime.nTime); }
	BOOL			operator  <( const Time& rTime ) const
						{ return (nTime < rTime.nTime); }
	BOOL			operator >=( const Time& rTime ) const
						{ return (nTime >= rTime.nTime); }
	BOOL			operator <=( const Time& rTime ) const
						{ return (nTime <= rTime.nTime); }

	static Time 	GetUTCOffset();
	static ULONG	GetSystemTicks();		// Elapsed time
	static ULONG	GetProcessTicks();		// CPU time

	void			ConvertToUTC()		 { *this -= Time::GetUTCOffset(); }
	void			ConvertToLocalTime() { *this += Time::GetUTCOffset(); }

	Time&			operator =( const Time& rTime );
	Time			operator -() const
						{ return Time( nTime * -1 ); }
	Time&			operator +=( const Time& rTime );
	Time&			operator -=( const Time& rTime );
	friend Time 	operator +( const Time& rTime1, const Time& rTime2 );
	friend Time 	operator -( const Time& rTime1, const Time& rTime2 );

	void setTime( UINT32 _nTime ) { SetTime( _nTime ); }
	UINT32 getTime() const { return GetTime(); }

#ifdef SMART_UNO_GENERATION
	UINT16			getHundredthSeconds() const { return Get100Sec(); }
	UINT16			getSeconds() const { return GetSec(); }
	UINT16			getMinutes() const { return GetMin(); }
	UINT16			getHours() const { return GetHour(); }

	void			setHundredthSeconds( UINT16 n ) { Set100Sec( n ); }
	void			setSeconds( UINT16 n ) { SetSec( n ); }
	void			setMinutes( UINT16 n ) { SetMin( n ); }
	void			setHours( UINT16 n ) { SetHour( n ); }
#endif
};

#endif // _TOOLS_TIME_HXX
