/*************************************************************************
 *
 *  $RCSfile: db_atr.cxx,v $
 *
 *  $Revision: 1.17 $
 *
 *  last change: $Author: rt $ $Date: 2003/05/27 16:12:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#define ITEMID_BOXINFO      SID_ATTR_BORDER_INNER
#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

#ifndef _SVX_ADJITEM_HXX //autogen
#include <svx/adjitem.hxx>
#endif
#ifndef _SVX_TSTPITEM_HXX //autogen
#include <svx/tstpitem.hxx>
#endif
#ifndef _SVX_LSPCITEM_HXX //autogen
#include <svx/lspcitem.hxx>
#endif
#ifndef _SVX_BOXITEM_HXX //autogen
#include <svx/boxitem.hxx>
#endif
#ifndef _SVX_PBINITEM_HXX //autogen
#include <svx/pbinitem.hxx>
#endif
#ifndef _SVX_ULSPITEM_HXX //autogen
#include <svx/ulspitem.hxx>
#endif
#ifndef _SVX_PRSZITEM_HXX //autogen
#include <svx/prszitem.hxx>
#endif
#ifndef _SVX_BRKITEM_HXX //autogen
#include <svx/brkitem.hxx>
#endif
#ifndef _SVX_LANGITEM_HXX //autogen
#include <svx/langitem.hxx>
#endif
#ifndef _SVX_WRLMITEM_HXX //autogen
#include <svx/wrlmitem.hxx>
#endif
#ifndef _SVX_KERNITEM_HXX //autogen
#include <svx/kernitem.hxx>
#endif
#ifndef _SVX_ESCPITEM_HXX //autogen
#include <svx/escpitem.hxx>
#endif
#ifndef _SVX_LRSPITEM_HXX //autogen
#include <svx/lrspitem.hxx>
#endif
#ifndef _SVX_AKRNITEM_HXX //autogen
#include <svx/akrnitem.hxx>
#endif
#ifndef _SVX_CMAPITEM_HXX //autogen
#include <svx/cmapitem.hxx>
#endif
#ifndef _SVX_SHDDITEM_HXX //autogen
#include <svx/shdditem.hxx>
#endif
#ifndef _SVX_CRSDITEM_HXX //autogen
#include <svx/crsditem.hxx>
#endif
#ifndef _SVX_UDLNITEM_HXX //autogen
#include <svx/udlnitem.hxx>
#endif
#ifndef _SVX_FONTITEM_HXX //autogen
#include <svx/fontitem.hxx>
#endif
#ifndef _SVX_FHGTITEM_HXX //autogen
#include <svx/fhgtitem.hxx>
#endif
#ifndef _SVX_COLRITEM_HXX //autogen
#include <svx/colritem.hxx>
#endif
#ifndef _SVX_WGHTITEM_HXX //autogen
#include <svx/wghtitem.hxx>
#endif
#ifndef _SVX_POSTITEM_HXX //autogen
#include <svx/postitem.hxx>
#endif
#ifndef _SVX_CNTRITEM_HXX //autogen
#include <svx/cntritem.hxx>
#endif
#ifndef _SVX_BRSHITEM_HXX //autogen
#include <svx/brshitem.hxx>
#endif
#ifndef _SVX_PGRDITEM_HXX //autogen
#include <svx/pgrditem.hxx>
#endif

#ifndef _SFXMACITEM_HXX //autogen
#include <svtools/macitem.hxx>
#endif

#include <stdio.h>
#ifndef _FCHRFMT_HXX //autogen
#include <fchrfmt.hxx>
#endif
#ifndef _FMTFLD_HXX //autogen
#include <fmtfld.hxx>
#endif
#ifndef _FMTRFMRK_HXX //autogen
#include <fmtrfmrk.hxx>
#endif
#ifndef _FMTCNTNT_HXX //autogen
#include <fmtcntnt.hxx>
#endif
#ifndef _FMTHDFT_HXX //autogen
#include <fmthdft.hxx>
#endif
#ifndef _FMTORNT_HXX //autogen
#include <fmtornt.hxx>
#endif
#ifndef _FMTPDSC_HXX //autogen
#include <fmtpdsc.hxx>
#endif
#ifndef _TXATBASE_HXX //autogen
#include <txatbase.hxx>
#endif
#ifndef _FMTFSIZE_HXX //autogen
#include <fmtfsize.hxx>
#endif
#ifndef _FMTFORDR_HXX //autogen
#include <fmtfordr.hxx>
#endif
#ifndef _FMTANCHR_HXX //autogen
#include <fmtanchr.hxx>
#endif
#ifndef _CHARFMT_HXX //autogen
#include <charfmt.hxx>
#endif
#ifndef _FMTCLDS_HXX //autogen
#include <fmtclds.hxx>
#endif
#ifndef _FMTSRND_HXX //autogen wg. SwFmtSurround
#include <fmtsrnd.hxx>
#endif
#ifndef _SHELLIO_HXX
#include <shellio.hxx>
#endif
#ifndef _PAM_HXX
#include <pam.hxx>
#endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _NDTXT_HXX
#include <ndtxt.hxx>
#endif
#ifndef _PARATR_HXX
#include <paratr.hxx>
#endif
#ifndef _FLDBAS_HXX
#include <fldbas.hxx>
#endif
#ifndef _GRFATR_HXX
#include <grfatr.hxx>
#endif
#ifndef _CELLATR_HXX
#include <cellatr.hxx>
#endif
#ifndef SW_TGRDITEM_HXX
#include <tgrditem.hxx>
#endif
#ifndef _NDGRF_HXX
#include <ndgrf.hxx>
#endif
#ifndef _TOX_HXX
#include <tox.hxx>
#endif
#ifndef _WRT_DB_HXX
#include <wrt_db.hxx>
#endif
#ifndef _SWTABLE_HXX
#include <swtable.hxx>
#endif
#ifndef _PAGEDESC_HXX
#include <pagedesc.hxx>
#endif
#ifndef _SECTION_HXX
#include <section.hxx>
#endif

/*
 * um nicht immer wieder nach einem Update festzustellen, das irgendwelche
 * Hint-Ids dazugekommen sind, wird hier definiert, die Groesse der Tabelle
 * definiert und mit der akt. verglichen. Bei unterschieden wird der
 * Compiler schon meckern.
 */
#define ATTRFNTAB_SIZE 130
#if !defined(UNX) && !defined(MSC) && !defined(CSET) && !defined(__MWERKS__)
#if ATTRFNTAB_SIZE != POOLATTR_END - POOLATTR_BEGIN
#error "Attribut-Tabelle ist ungueltigt. Wurden neue Hint-ID's zugefuegt ??"
#endif
#endif

#define FORMATTAB_SIZE 7
#if !defined(UNX) && !defined(MSC) && !defined(__MWERKS__)
#if FORMATTAB_SIZE != RES_FMT_END - RES_FMT_BEGIN
#error "Format-Tabelle ist ungueltigt. Wurden neue Hint-ID's zugefuegt ??"
#endif
#endif

#define NODETAB_SIZE 3
#if !defined(UNX) && !defined(MSC) && !defined(__MWERKS__)
#if NODETAB_SIZE != RES_NODE_END - RES_NODE_BEGIN
#error "Node-Tabelle ist ungueltigt. Wurden neue Hint-ID's zugefuegt ??"
#endif
#endif


static Writer& OutDB_TxtAttr( Writer& rWrt, const SwTxtAttr& rHt );

static sal_Char __FAR_DATA sAttrEnd[] = "] ";
static sal_Char __FAR_DATA sKlammerEnd[] = "] ";

static SvStream& WriteString( SvStream& rStrm, const String& rStr )
{
	ByteString s( rStr, gsl_getSystemTextEncoding() );
	rStrm << s.GetBuffer();
	return rStrm;
}

//-----------------------------------------------------------------------

Writer& OutDB_SwChar( Writer& rWrt, sal_Unicode c )
{
	// BP 9.12.92: fuer SwTxtHints ohne Endindex werden CH_TXTATR
	// eingefuegt, die beim Herausschreiben ignoriert werden muessen.
	if( CH_TXTATR_BREAKWORD == c || CH_TXTATR_INWORD == c )
		return rWrt;

	sal_Unicode aCode = c;
/*	os: no conversion??
	sal_Char 	aCode;
	CharSet eDfltCSet = GetSystemCharSet();
	CharSet eCodeSet =
#ifdef MAC
		CHARSET_MAC
#else
#ifdef DOS
		CHARSET_IBMPC
#else
		CHARSET_ANSI
#endif
#endif
		;


 	if( eDfltCSet == eCodeSet )
		aCode = (sal_Char)c;
	else
	{
		String aStr;
		sal_Char cC = aStr.Convert( (sal_Char)c, eDfltCSet, eCodeSet );
		if( !cC )
		{
			rWrt.Strm() << '@';     // ***** ?????? *******
			return rWrt;
		}
		aCode = cC;
	}
*/
	//????? 	if( pCh->IsDigit() || pCh->IsLetter() ) ?????
	if( aCode >= ' ' && aCode <= '~' )
		rWrt.Strm() << (sal_Char)aCode;
	else if( aCode == '\t' )          // ein Text-Tab ?
		rWrt.Strm() << "\\tab ";
	else if( aCode == '\n' )          // ein Text-Tab ?
		rWrt.Strm() << "\\line ";
	else
	{
		rWrt.Strm() << "\\'";
		rWrt.OutHex( aCode );
	}
	return rWrt;
}

// fuer die Formate muesste eine einzige Ausgabe-Funktion genuegen !


/*
 * Formate wie folgt ausgeben:
 *		- fuege das Format in der Tabelle und gebe die Nr aus
 *		- gebe alle Attribute vom Format aus
 */

Writer& OutDB_SwFmt( Writer& rWrt, const SwFmt& rFmt )
{
	const SwFmt* pFmt = &rFmt;
	BOOL bFirst = TRUE;
	do
	{
		if( !bFirst )
			rWrt.Strm() << " (->";

		rWrt.Strm() << " Nm: ";
		WriteString( rWrt.Strm(), pFmt->GetName() ) << " [";

		// erst die eigenen Attribute ausgeben
		Out_SfxItemSet( aDBAttrFnTab, rWrt, pFmt->GetAttrSet(), FALSE );

		rWrt.Strm() << ']' << SwDBWriter::sNewLine;
		if( !bFirst )
			rWrt.Strm() << sKlammerEnd;
		bFirst = FALSE;
	} while( 0 != ( pFmt = pFmt->DerivedFrom() ));

	return rWrt;
}


Writer& OutDB_SwPageDescs( Writer& rWrt, const SwDoc& rDoc)
{
	USHORT nCnt = rDoc.GetPageDescCnt();
	for ( USHORT i=0; i<nCnt; ++i )
	{
		const SwPageDesc& rPgDsc = rDoc.GetPageDesc( i );
		rWrt.Strm() << SwDBWriter::sNewLine << "No: ";
		rWrt.OutULong(i);
		rWrt.Strm() << ' ';
		WriteString( rWrt.Strm(), rPgDsc.GetName() );
		rWrt.Strm() << ", Follow: ";
		WriteString( rWrt.Strm(), rPgDsc.GetFollow()->GetName() );
		rWrt.Strm() << ", UseOn: 0x";

		rWrt.OutHex4( rPgDsc.ReadUseOn() ) << SwDBWriter::sNewLine
			<< "Master:" << SwDBWriter::sNewLine;
		OutDB_SwFmt( rWrt, rPgDsc.GetMaster() );
		rWrt.Strm() << SwDBWriter::sNewLine << "Left:" << SwDBWriter::sNewLine;
		OutDB_SwFmt( rWrt, rPgDsc.GetLeft() );
	}
	return rWrt;
}

Writer& OutDB_SwNumFmt( Writer& rWrt, const SwNumFmt& rFmt )
{
	rWrt.Strm() << " Type: (";
	String sStr;
	switch( rFmt.GetNumberingType() )
	{
	case SVX_NUM_CHARS_UPPER_LETTER:	sStr.AssignAscii("upper letter"); break;
	case SVX_NUM_CHARS_LOWER_LETTER:	sStr.AssignAscii("lower letter"); break;
	case SVX_NUM_ROMAN_UPPER: 			sStr.AssignAscii("upper roman"); break;
	case SVX_NUM_ROMAN_LOWER:			sStr.AssignAscii("lower roman"); break;
	case SVX_NUM_ARABIC: 				sStr.AssignAscii("number"); break;
	case SVX_NUM_NUMBER_NONE: 			sStr.AssignAscii("no number"); break;
	case SVX_NUM_BITMAP:
		{
			const SvxBrushItem* pBr = rFmt.GetBrush();
			sStr.AssignAscii("Graphic: ");
			sStr.Append(*pBr->GetGraphicLink());
			sStr.AppendAscii(" Size (");
			WriteString( rWrt.Strm(), sStr );
			rWrt.OutULong( rFmt.GetGraphicSize().Width() ) << '|';
			rWrt.OutULong( rFmt.GetGraphicSize().Height() ) << ") Orient:";
			rWrt.OutULong( rFmt.GetGraphicOrientation()->GetVertOrient() );
			sStr.Erase();
		}
		break;
	case SVX_NUM_CHAR_SPECIAL:
		rWrt.Strm() << "Bullet: ";
		rWrt.OutULong( rFmt.GetBulletChar() );
		if( rFmt.GetBulletFont() )
			(sStr.AssignAscii(" Font: ") ) .Append(rFmt.GetBulletFont()->GetName());
		break;
	}
	if( sStr.Len() )
		WriteString( rWrt.Strm(), sStr );

	rWrt.Strm() << ") ULevel: ";
	rWrt.OutULong( rFmt.GetIncludeUpperLevels() ) << " Adjust: ";
	rWrt.OutULong( rFmt.GetNumAdjust() ) << " AbsSpace: ";
	rWrt.OutULong( rFmt.GetAbsLSpace() ) << " FirstOffs: ";
	rWrt.OutLong( rFmt.GetFirstLineOffset() ) << " TextOffs: ";
	rWrt.OutULong( rFmt.GetCharTextDistance() ) << " Start: ";
	rWrt.OutULong( rFmt.GetStart() );

	if( rFmt.GetPrefix().Len() )
	{
		rWrt.Strm() << " Prefix: (";
		WriteString( rWrt.Strm(), rFmt.GetPrefix() );
		rWrt.Strm() << ')';
	}
	if( rFmt.GetSuffix().Len() )
	{
		rWrt.Strm() << " Postfix: (";
		WriteString( rWrt.Strm(), rFmt.GetSuffix() );
		rWrt.Strm() << ')';
	}
	if( rFmt.GetCharFmt() )
	{
		rWrt.Strm() << " CharFmt: ";
		WriteString( rWrt.Strm(), rFmt.GetCharFmt()->GetName() );
	}

	rWrt.Strm() << SwDBWriter::sNewLine;
	return rWrt;
}

Writer& OutDB_SwNumRule( Writer& rWrt, const SwNumRule& rRule )
{
	rWrt.Strm() << "Name: ";
	WriteString( rWrt.Strm(), rRule.GetName() );
	rWrt.Strm() << " Type: ";
	rWrt.OutULong( rRule.GetRuleType() );
	if( rRule.IsContinusNum() )
		rWrt.Strm() << " continue";
	rWrt.Strm() << SwDBWriter::sNewLine;

	for( BYTE n = 0; n < MAXLEVEL; ++n )
		if( rRule.GetNumFmt( n ))
		{
			rWrt.Strm() << "Fmt "; rWrt.OutULong( n ) << ':';
			OutDB_SwNumFmt( rWrt, *rRule.GetNumFmt( n ) );
		}
	return rWrt;
}

Writer& OutDB_SwSnapToGrid( Writer& rWrt, const SfxPoolItem& rHt )
{
    const SvxParaGridItem& rAttr = (const SvxParaGridItem&) rHt;

    if ( rAttr.GetValue() )
        rWrt.Strm() << "Snap to grid enabled ";
    else
        rWrt.Strm() << "Snap to grid disabled ";

	return rWrt;
}




/* Ausgabe der Nodes */

/*
 *	Ausgabe der Texte-Attribute:
 *		Die Text-Attribute sind in einem VarArray nach ihren Start-Positionen
 *		sortiert. Fuer den RTF-Writer ist aber auch das Ende von Bedeutung.
 *		Darum die Idee, sobald im SwpHints-Array ein Attribut mit der Start-
 *		Position gefunden wurde, in einem Sortierten-Array die Endposition
 *		zu speichern. Sobald der Writer die Position erreicht hat, wird die
 *		schliessende Klammer ausgegeben und die Position aus dem Sort.Array
 *		geloescht.
 */

struct DBSttEndPos
{
	USHORT nStart, nEnd;
	DBSttEndPos( USHORT nStt, USHORT nEd )
		{ nStart = nStt; nEnd = nEd; }
	DBSttEndPos( const DBSttEndPos & rSEPos )
		{ nStart = rSEPos.nStart; nEnd = rSEPos.nEnd; }
	BOOL operator==( const DBSttEndPos & rSEPos )
		{ return nStart == rSEPos.nStart && nEnd == rSEPos.nEnd; }
};

SV_DECL_VARARR( _DBEndPosLst, DBSttEndPos, 5, 5 )
SV_IMPL_VARARR( _DBEndPosLst, DBSttEndPos )

class DBEndPosLst : private _DBEndPosLst
{
public:
	DBEndPosLst() : _DBEndPosLst( 5 ) {}

	BOOL Insert( DBSttEndPos aNew );
	void Delete()
		{ _DBEndPosLst::Remove( 0 ); }
	DBSttEndPos operator[]( USHORT nPos )
		{ return _DBEndPosLst::operator[]( nPos ); }
	USHORT Count()
		{ return _DBEndPosLst::Count(); }


};

BOOL DBEndPosLst::Insert( DBSttEndPos aNew )
{
	// kein Bereich ?? dann nicht aufnehmen, wird nie wirksam !!
	if( aNew.nStart == aNew.nEnd )
		return FALSE;

	for( USHORT nPos = 0; nPos < Count(); nPos++ )
	{
		DBSttEndPos aTmp = _DBEndPosLst::operator[]( nPos );
		if( aNew == aTmp )
			return FALSE;		// schon vorhanden
		if( aNew.nEnd < aTmp.nEnd )
		{
			_DBEndPosLst::Insert( aNew, nPos );
			return TRUE;
		}
	}
	_DBEndPosLst::Insert( aNew, nPos );
	return TRUE;
}



static Writer& OutDB_SwTxtNode( Writer& rWrt, SwCntntNode & rNode )
{
	SwTxtNode * pNd = &((SwTxtNode&)rNode);

	rWrt.Strm() << SwDBWriter::sNewLine << "TextNd: FmtColl: ";

	SwFmtColl *pColl = pNd->GetTxtColl();
	ASSERT(pColl, "keine TxtFmtcoll");

	if( pColl )
	{
		if( ((SwDBWriter&)rWrt).pNdFmt != pColl )
		{
			((SwDBWriter&)rWrt).pNdFmt = pColl;
			OutDB_SwFmt( rWrt, *pColl );
		}
		else
			WriteString( rWrt.Strm(), pColl->GetName() );
	}

	if( 0 != ( pColl = pNd->GetCondFmtColl() ))
	{
		rWrt.Strm() << SwDBWriter::sNewLine << "CondColl: ";
		if( ((SwDBWriter&)rWrt).pNdCondColl != pColl )
		{
			((SwDBWriter&)rWrt).pNdCondColl = pColl;
			rWrt.Strm() << '(';
			OutDB_SwFmt( rWrt, *pColl );
			rWrt.Strm() << SwDBWriter::sNewLine << sKlammerEnd;
		}
		else
			WriteString( rWrt.Strm(), pColl->GetName() );
	}

	if( pNd->GetpSwAttrSet() )		// Harte-Attributierung ?
	{
		rWrt.Strm() << SwDBWriter::sNewLine << "Auto: (";
		Out_SfxItemSet( aDBAttrFnTab, rWrt, *pNd->GetpSwAttrSet(), FALSE );
		rWrt.Strm() << SwDBWriter::sNewLine << sKlammerEnd;
	}

	// erstmal den Start berichtigen. D.h. wird nur ein Teil vom Satz
	// ausgegeben, so muessen auch da die Attribute stimmen!!
	if( pNd->GetNum() &&
		NO_NUMBERING != pNd->GetNum()->GetLevel() )
	{
		rWrt.Strm() << " NumRule [Lvl: ";
		rWrt.OutLong( pNd->GetNum()->GetLevel() ) << ", Name: ";
		if( pNd->GetNumRule() )
			WriteString( rWrt.Strm(), pNd->GetNumRule()->GetName() );
		else
			rWrt.Strm() << "<NO_NUM_RULE>";
		rWrt.Strm() << sKlammerEnd << SwDBWriter::sNewLine;
	}

	if( pNd->GetOutlineNum() &&
		NO_NUMBERING != pNd->GetOutlineNum()->GetLevel() )
	{
		rWrt.Strm() << " OutlineNum [Lvl: ";
		rWrt.OutLong( pNd->GetOutlineNum()->GetLevel() ) << ", Name: ";
		if( rWrt.pDoc->GetOutlineNumRule()  )
			WriteString( rWrt.Strm(), rWrt.pDoc->GetOutlineNumRule()->GetName());
		else
			rWrt.Strm() << "<NO_OUTLINE_RULE>";
		rWrt.Strm() << sKlammerEnd << SwDBWriter::sNewLine;
	}

	rWrt.Strm() << '"';

	DBEndPosLst aEndPosLst;
	USHORT nAttrPos = 0;
	USHORT nStrPos = rWrt.pCurPam->GetPoint()->nContent.GetIndex();
	USHORT nEnde;
	BOOL bNoNewLine;
	if( TRUE == ( bNoNewLine = rWrt.pCurPam->GetPoint()->nNode ==
								rWrt.pCurPam->GetMark()->nNode ) )
		nEnde = rWrt.pCurPam->GetMark()->nContent.GetIndex();
	else
		nEnde = pNd->GetTxt().Len();


	const SwTxtAttr * pHt = 0;
	USHORT nCntAttr = pNd->HasHints() ? pNd->GetSwpHints().Count() : 0;
	if( 0 < nCntAttr &&
		nStrPos > *( pHt = pNd->GetSwpHints()[ 0 ] )->GetStart() )
	{
		// Ok, es gibt vorher Attribute, die ausgegeben werden muessen
		((SwDBWriter&)rWrt).bTxtAttr = TRUE;
		do {
			if( pHt->GetEnd() &&
				*pHt->GetStart() != *pHt->GetEnd() &&
				aEndPosLst.Insert( DBSttEndPos( *pHt->GetStart(),
												*pHt->GetEnd() )))
				rWrt.Strm() << '{';
			OutDB_TxtAttr( rWrt, *pHt );
			nAttrPos++;
		} while( nAttrPos < nCntAttr && nStrPos >
			*( pHt = pNd->GetSwpHints()[ nAttrPos ] )->GetStart() );
		((SwDBWriter&)rWrt).bTxtAttr = FALSE;
	}

	for( ; nStrPos <= nEnde; nStrPos++ )
	{
		while( 0 != aEndPosLst.Count() && nStrPos != nEnde &&
				nStrPos == aEndPosLst[ 0 ].nEnd )
		{
			rWrt.Strm() << '}';
			aEndPosLst.Delete();
		}

		if( nAttrPos < nCntAttr && *pHt->GetStart() == nStrPos )
		{
			((SwDBWriter&)rWrt).bTxtAttr = TRUE;
			do {
				BOOL bEmpty = FALSE;
				if( pHt->GetEnd() && ( TRUE == (
						bEmpty = *pHt->GetEnd() == nStrPos ) ||
					  aEndPosLst.Insert( DBSttEndPos( nStrPos,
											*pHt->GetEnd() ))))
					rWrt.Strm() << '{';
				OutDB_TxtAttr( rWrt, *pHt );
				if( bEmpty )
					rWrt.Strm() << '}';
				nAttrPos++;
			} while( nAttrPos < nCntAttr && nStrPos ==
				*( pHt = pNd->GetSwpHints()[ nAttrPos ] )->GetStart() );
			((SwDBWriter&)rWrt).bTxtAttr = FALSE;
			rWrt.Strm() << ' ';
		}
		if( nStrPos != nEnde )
			OutDB_SwChar( rWrt, pNd->GetTxt().GetChar( nStrPos ) );
	}


	// noch eine schliesende Klammer da ??
	while( 0 != aEndPosLst.Count() )
	{	// fuer's vi '{' matching
		rWrt.Strm() << '}';
		aEndPosLst.Delete();
	}

	rWrt.Strm() << '"';

	// wirklich eine neue Zeile ??
	if( !bNoNewLine )
		rWrt.Strm() << SwDBWriter::sNewLine;

	return rWrt;
}



static Writer& OutDB_SwGrfNode( Writer& rWrt, SwCntntNode & rNode )
{
	SwGrfNode * pNd = &((SwGrfNode&)rNode);
	rWrt.Strm() << SwDBWriter::sNewLine << "GrfNd: FmtColl: ";

	SwGrfFmtColl *pColl = pNd->GetGrfColl();
	ASSERT(pColl, "keine GrfFmtcoll");
	if ( pColl )
		WriteString( rWrt.Strm(), pColl->GetName() );

	if( pNd->IsGrfLink() )
	{
		String aNm, aFltrNm;
		if( pNd->GetFileFilterNms( &aNm, &aFltrNm ) )
		{
			rWrt.Strm() << "Name: (";
			WriteString( rWrt.Strm(), aNm );
			rWrt.Strm() << " Filter: ";
			WriteString( rWrt.Strm(), aFltrNm );
			rWrt.Strm() << ')'<< SwDBWriter::sNewLine;
		}
	}

	((SwDBWriter&)rWrt).pNdFmt = pColl;
	((SwDBWriter&)rWrt).pNdCondColl = 0;
	OutDB_SwFmt( rWrt, *pColl );

	if( pNd->GetpSwAttrSet() )		// Harte-Attributierung ?
	{
		rWrt.Strm() << SwDBWriter::sNewLine << "Auto: (";
		Out_SfxItemSet( aDBAttrFnTab, rWrt, *pNd->GetpSwAttrSet(), FALSE );
		rWrt.Strm() << SwDBWriter::sNewLine << sKlammerEnd;
	}

	return rWrt;
}

// -- Tabelle ausgeben -----

static void OutDB_SwTblLine( Writer&, SwTableLine&, String& );


static void OutDB_SwTblBox( Writer&, SwTableBox&, String& );

static void OutDB_SwTblLine( Writer& rWrt, SwTableLine& rLine, String& rStr )
{
	WriteString( rWrt.Strm(), rStr );
	rWrt.Strm() << " Line: [ Fmt:(";
	rWrt.OutHex8( (ULONG)rLine.GetFrmFmt() ) << sKlammerEnd;
	OutDB_SwFmt( rWrt, *rLine.GetFrmFmt() );

	String aStr( String::CreateFromAscii("\t.") );
	aStr.Insert( rStr, 1 );
	for( USHORT n = 0; n < rLine.GetTabBoxes().Count(); ++n )
	{
		String aTmpStr( aStr );
		aTmpStr += String::CreateFromInt32( n+1 );
		OutDB_SwTblBox( rWrt, *rLine.GetTabBoxes()[n], aTmpStr );
	}
	rWrt.Strm() << sAttrEnd << SwDBWriter::sNewLine;
}


static void OutDB_SwTblBox( Writer& rWrt, SwTableBox& rBox, String& rStr )
{
	WriteString( rWrt.Strm(), rStr );
	rWrt.Strm() << " Box: [ Fmt:(";
	rWrt.OutHex8( (ULONG)rBox.GetFrmFmt() ) << sKlammerEnd;
	OutDB_SwFmt( rWrt, *rBox.GetFrmFmt() );

	if( rBox.GetTabLines().Count() )
	{
		String aStr( String::CreateFromAscii("\t.") );
		aStr.Insert( rStr, 1 );
		for( USHORT n = 0; n < rBox.GetTabLines().Count(); ++n )
		{
			String aTmpStr( aStr );
			aTmpStr += String::CreateFromInt32( n+1 );
			OutDB_SwTblLine( rWrt, *rBox.GetTabLines()[n], aTmpStr );
		}
	}
	rWrt.Strm() << sAttrEnd << SwDBWriter::sNewLine;

	if( !rBox.GetTabLines().Count() )
	{
		SwPaM *pOldPam = rWrt.pCurPam,
			  *pOldEnd = ((SwDBWriter&)rWrt).GetEndPaM();
		BOOL bOldOutTable = ((SwDBWriter&)rWrt).bOutTable;

		rWrt.pCurPam = rWrt.NewSwPaM( *rWrt.pDoc,
				rBox.GetSttIdx(), rBox.GetSttNd()->EndOfSectionIndex() );
		((SwDBWriter&)rWrt).SetEndPaM( rWrt.pCurPam );
		rWrt.pCurPam->Exchange();

		((SwDBWriter&)rWrt).bOutTable = FALSE;

		// damit kein \par ausgegeben wird !!
//        rWrt.pCurPam->GetMark()->nContent++;
		((SwDBWriter&)rWrt).Out_SwDoc( rWrt.pCurPam,
							rBox.GetSttNd()->GetNodes() );

		delete rWrt.pCurPam;					// Pam wieder loeschen

		rWrt.pCurPam = pOldPam;
		((SwDBWriter&)rWrt).SetEndPaM( pOldEnd );
		((SwDBWriter&)rWrt).bOutTable = bOldOutTable;

		rWrt.Strm() << SwDBWriter::sNewLine;
	}
}


Writer& OutDB_SwTableNode( Writer& rWrt, SwTableNode & rNode )
{
	rWrt.Strm() << " Table: [ Fmt:(";
	rWrt.OutHex8( (ULONG)rNode.GetTable().GetFrmFmt() ) << sKlammerEnd;
	OutDB_SwFmt( rWrt, *rNode.GetTable().GetFrmFmt() );

	for( USHORT n = 0; n < rNode.GetTable().GetTabLines().Count(); ++n )
	{
		String aTmpStr( String::CreateFromInt32( n+1 ));
		OutDB_SwTblLine( rWrt, *rNode.GetTable().GetTabLines()[n], aTmpStr );
	}
	rWrt.Strm() << sAttrEnd << SwDBWriter::sNewLine;
	// hinter die Tabelle setzen
	while( rNode.EndOfSectionIndex() >
		   rWrt.pCurPam->GetPoint()->nNode.GetIndex() )
		rWrt.pCurPam->GetPoint()->nNode++;

	return rWrt;
}

Writer& OutDB_SwSectionNode( Writer& rWrt, SwSectionNode& rNode )
{
	const SwSection& rSect = rNode.GetSection();
	rWrt.Strm() << " Section: [ Fmt:(";
	rWrt.OutHex8( (ULONG)rSect.GetFmt() ) << sKlammerEnd << endl << '\t';
	OutDB_SwFmt( rWrt, *rSect.GetFmt() );

	const sal_Char* pTypeStr;
	switch ( rSect.GetType() )
	{
	case CONTENT_SECTION:       pTypeStr = "Content"; break;
	case TOX_HEADER_SECTION:    pTypeStr = "TOX-Header"; break;
	case TOX_CONTENT_SECTION:   pTypeStr = "TOX-Content"; break;
	case DDE_LINK_SECTION:		pTypeStr = "DDE-Link"; break;
	case FILE_LINK_SECTION:		pTypeStr = "File-Link"; break;
	default:
		pTypeStr = "?";
	}
	const sal_Char* pHiddenStr;
	if( rSect.IsHidden() )
		pHiddenStr = "versteckt";
	else
		pHiddenStr = "NICHT versteckt";
	const sal_Char* pProtectStr;
	if( rSect.IsProtect() )
		pProtectStr = "geschuetzt";
	else
		pProtectStr = "NICHT geschuetzt";

	rWrt.Strm() << " [Nm: ";
	WriteString( rWrt.Strm(), rSect.GetName() );
	rWrt.Strm()	<< ", Type: " << pTypeStr
				<< ", " << pHiddenStr
				<< ", " << pProtectStr
				<< sKlammerEnd << endl;


	return rWrt;
}


/* File CHRATR.HXX: */


static Writer& OutDB_TxtAttr( Writer& rWrt, const SwTxtAttr& rHt )
{
	rWrt.Strm() << " Txt-";
	Out( aDBAttrFnTab, rHt.GetAttr(), rWrt );
	rWrt.Strm() << "<S:";
	rWrt.OutULong( *rHt.GetStart() );
	rWrt.Strm() << '>';

	if( rHt.GetEnd() )
	{
		rWrt.Strm() << "<E:";
		rWrt.OutULong( *rHt.GetEnd() );
		rWrt.Strm() << '>';
	}
	return rWrt;
}


static Writer& OutDB_SwFont( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SvxFontItem& rFont = (const SvxFontItem&)rHt;

	rWrt.Strm() << "Font";
	switch( rHt.Which() )
	{
	case RES_CHRATR_CJK_FONT:	rWrt.Strm() << "(CJK)";	break;
	case RES_CHRATR_CTL_FONT:	rWrt.Strm() << "(CTL)";	break;
	}
	rWrt.Strm() << ": Fam[";
	rWrt.OutULong( rFont.GetFamily() ) << "] Nm[";
	WriteString( rWrt.Strm(), rFont.GetFamilyName());
	rWrt.Strm() << "] Pitch[";
	rWrt.OutULong( rFont.GetPitch() ) << "] CharSet[";
	rWrt.OutULong( rFont.GetCharSet() ) << sAttrEnd;
	return rWrt;
}


static Writer& OutDB_SwPosture( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "Posture";
	switch( rHt.Which() )
	{
	case RES_CHRATR_CJK_POSTURE:	rWrt.Strm() << "(CJK)";	break;
	case RES_CHRATR_CTL_POSTURE:	rWrt.Strm() << "(CTL)";	break;
	}
	rWrt.Strm() << ": Style[";
	rWrt.OutULong( ((const SvxPostureItem&)rHt).GetValue() ) << sAttrEnd;
	return rWrt;
}



static Writer& OutDB_SwWeight( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "Weight";
	switch( rHt.Which() )
	{
	case RES_CHRATR_CJK_WEIGHT:	rWrt.Strm() << "(CJK)";	break;
	case RES_CHRATR_CTL_WEIGHT:	rWrt.Strm() << "(CTL)";	break;
	}
	rWrt.Strm() << ": Style[";
	rWrt.OutULong( ((const SvxWeightItem&)rHt).GetValue() ) << sAttrEnd;
	return rWrt;
}


static Writer& OutDB_SwCharFmt( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "CharFormat [";
	if( ((const SwFmtCharFmt&)rHt).GetCharFmt() )
		WriteString( rWrt.Strm(), ((const SwFmtCharFmt&)rHt).GetCharFmt()->GetName());
	else
		rWrt.Strm() << "NONE";
	rWrt.Strm() << sAttrEnd;
	return rWrt;
}


static Writer& OutDB_SwShadowed( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "Shadowed: Style[" <<
			( ((const SvxShadowedItem&)rHt).GetValue() ? "ON]" : "OFF]" );
	return rWrt;
}


static Writer& OutDB_SwAutoKern( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "AutoKern: Style[" <<
			( ((const SvxAutoKernItem&)rHt).GetValue() ? "ON]" : "OFF]" );
	return rWrt;
}


static Writer& OutDB_SwWordLineMode( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "WordLineMode: Style[" <<
			( ((const SvxWordLineModeItem&)rHt).GetValue() ? "ON]" : "OFF]" );
	return rWrt;
}



static Writer& OutDB_SwContour( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "Contour: Style[" <<
			( ((const SvxContourItem&)rHt).GetValue() ? "ON]" : "OFF]" );
	return rWrt;
}



static Writer& OutDB_SwKerning( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "Kerning: Style[";
	rWrt.OutULong( ((const SvxKerningItem&)rHt).GetValue() ) << sAttrEnd;
	return rWrt;
}



static Writer& OutDB_SwCrossedOut( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "CrossedOut: Style[";
	rWrt.OutULong( ((const SvxCrossedOutItem&)rHt).GetValue() ) << sAttrEnd;
	return rWrt;
}



static Writer& OutDB_SwCaseMap( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "CaseMap: Style[";
	rWrt.OutULong( ((const SvxCaseMapItem&)rHt).GetValue() ) << sAttrEnd;
	return rWrt;
}


static Writer& OutDB_SwUnderline( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "Undeline: Style[";
	rWrt.OutULong( ((const SvxUnderlineItem&)rHt).GetValue() ) << sAttrEnd;
	return rWrt;
}



static Writer& OutDB_SwLanguage( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "Language";
	switch( rHt.Which() )
	{
	case RES_CHRATR_CJK_LANGUAGE:	rWrt.Strm() << "(CJK)";	break;
	case RES_CHRATR_CTL_LANGUAGE:	rWrt.Strm() << "(CTL)";	break;
	}
	rWrt.Strm() << ": No[";
	rWrt.OutULong( ((const SvxLanguageItem&)rHt).GetValue() ) << sAttrEnd;
	return rWrt;
}



static Writer& OutDB_SwEscapement( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "Escapement: Style[";
	rWrt.OutULong( ((const SvxEscapementItem&)rHt).GetEsc() ) << ", ";
	rWrt.OutULong( ((const SvxEscapementItem&)rHt).GetProp() ) << sAttrEnd;
	return rWrt;
}



static Writer& OutDB_SwSize( Writer& rWrt, const SfxPoolItem& rHt )
{
sal_Char __READONLY_DATA
	sU0[] = "SFX_MAPUNIT_100TH_MM",		sU1[] = "SFX_MAPUNIT_10TH_MM",
	sU2[] = "SFX_MAPUNIT_MM", 			sU3[] = "SFX_MAPUNIT_CM",
	sU4[] = "SFX_MAPUNIT_1000TH_INCH",  sU5[] = "SFX_MAPUNIT_100TH_INCH",
	sU6[] = "SFX_MAPUNIT_10TH_INCH",	sU7[] = "SFX_MAPUNIT_INCH",
	sU8[] = "SFX_MAPUNIT_POINT", 		sU9[] = "SFX_MAPUNIT_TWIP",
	sU10[] = "SFX_MAPUNIT_PIXEL", 		sU11[] = "SFX_MAPUNIT_SYSFONT",
	sU12[] = "SFX_MAPUNIT_APPFONT", 	sU13[] = "SFX_MAPUNIT_RELATIVE";
const sal_Char* __READONLY_DATA aUArr[] =
{
	sU0,sU1,sU2,sU3,sU4,sU5,sU6,sU7,sU8,sU9,sU10,sU11,sU12,sU13
};

	rWrt.Strm() << "FontSize";
	switch( rHt.Which() )
	{
	case RES_CHRATR_CJK_FONTSIZE:	rWrt.Strm() << "(CJK)";	break;
	case RES_CHRATR_CTL_FONTSIZE:	rWrt.Strm() << "(CTL)";	break;
	}
	rWrt.Strm() << ": Size[";
	rWrt.OutULong( ((const SvxFontHeightItem&)rHt).GetHeight() ) << ',';
	rWrt.OutULong( ((const SvxFontHeightItem&)rHt).GetProp() ) << ','
			<< aUArr[ ((const SvxFontHeightItem&)rHt).GetPropUnit() ]
			<< sAttrEnd;
	return rWrt;

}



static Writer& OutDB_SwPropSize( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "PropSize: Size[";
	rWrt.OutULong( ((const SvxPropSizeItem&)rHt).GetValue() ) << sAttrEnd;
	return rWrt;
}



static Writer& OutDB_SwColor( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "Color: Red[";
	rWrt.OutULong( ((const SvxColorItem&)rHt).GetValue().GetRed() ) << "] Green[";
	rWrt.OutULong( ((const SvxColorItem&)rHt).GetValue().GetGreen() ) << "] Blue[";
	rWrt.OutULong( ((const SvxColorItem&)rHt).GetValue().GetBlue() ) << sAttrEnd;
	return rWrt;


}


static Writer& OutDB_SwField( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SwField & rFld = *((const SwFmtFld&)rHt).GetFld();

	rWrt.Strm() << "SwTxtFld: Nm[";
	WriteString( rWrt.Strm(), rFld.GetTyp()->GetName());
	rWrt.Strm() << "] Id[";
	rWrt.OutULong( rFld.GetTyp()->Which() ) << "] Fmt[";
	rWrt.OutULong( rFld.GetFormat() ) << sAttrEnd;

	return rWrt;
}



static Writer& OutDB_SwTxtTOXMark( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SwTOXMark & rAttr = (const SwTOXMark&)rHt;

	rWrt.Strm() << "SwToxMark: AltTxt[";
	WriteString( rWrt.Strm(), rAttr.GetAlternativeText() );
	rWrt.Strm() << "] Level:[" << rAttr.GetLevel()
		<< sAttrEnd;

	return rWrt;
}



static Writer& OutDB_SwRefMark( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SwFmtRefMark & rAttr = (const SwFmtRefMark&)rHt;

	rWrt.Strm() << "SwRefMark: Name[";
	WriteString( rWrt.Strm(), rAttr.GetRefName() );
	rWrt.Strm() << sAttrEnd;

	return rWrt;
}

/* File FRMATR.HXX */



static Writer& OutDB_SwFrmSize( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SwFmtFrmSize& rSz = (const SwFmtFrmSize&)rHt;
	rWrt.Strm() << "FrmSize: [Type: ";
	rWrt.OutULong( rSz.GetSizeType() ) << ", Width: ";
	if( rSz.GetWidthPercent() )
		rWrt.OutULong( rSz.GetWidthPercent() ) << " %";
	else
		rWrt.OutULong( rSz.GetWidth() );

	rWrt.Strm() << ", Height: ";
	if( rSz.GetHeightPercent() )
		rWrt.OutULong( rSz.GetHeightPercent() ) << " %";
	else
		rWrt.OutULong( rSz.GetHeight() );

	rWrt.Strm() << sAttrEnd;
	return rWrt;
}



static Writer& OutDB_SwFillOrder( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "FillOrder: State[";
	rWrt.OutULong( ((const SwFmtFillOrder&)rHt).GetFillOrder() ) << sAttrEnd;
	return rWrt;
}



static Writer& OutDB_SwFmtBreak( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SvxFmtBreakItem& rAttr = (const SvxFmtBreakItem&)rHt;
	rWrt.Strm() << "PageBreak: State[";
	rWrt.OutULong( rAttr.GetBreak() ) << sAttrEnd;
	return rWrt;
}



static Writer& OutDB_SwPaperBin( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "PaperTray: BinNumber[";
	rWrt.OutULong( ((const SvxPaperBinItem&)rHt).GetValue() ) << sAttrEnd;
	return rWrt;
}



static Writer& OutDB_SwLRSpace( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SvxLRSpaceItem & rAttr = (const SvxLRSpaceItem&) rHt;
	rWrt.Strm() << "LRSpace: Left[";
	rWrt.OutULong( rAttr.GetLeft() ) << "] Right[";
	rWrt.OutULong( rAttr.GetRight() ) << sAttrEnd;
	return rWrt;
}



static Writer& OutDB_SwULSpace( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SvxULSpaceItem & rAttr = (const SvxULSpaceItem&) rHt;
	rWrt.Strm() << "ULSpace: Upper[";
	rWrt.OutULong( rAttr.GetUpper() ) << "] Lower[";
	rWrt.OutULong( rAttr.GetLower() ) << sAttrEnd;
	return rWrt;
}


static Writer& OutDB_SwCntnt( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "Cntnt: [";
	rWrt.OutULong( ((SwFmtCntnt&)rHt).GetCntntIdx()->GetIndex() ) << sAttrEnd;
	return rWrt;
}


static Writer& OutDB_SwHeader( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SwFmtHeader &rAttr = (const SwFmtHeader&) rHt;
	const SwFrmFmt* pFmt = rAttr.GetHeaderFmt();
	rWrt.Strm() << "Header: [";
	if ( rAttr.IsActive() )
		rWrt.Strm() << "Active -> ";
	else
		rWrt.Strm() << "not Active -> ";

	if ( pFmt )
		::OutDB_SwFmt( rWrt, *pFmt );
	else
		rWrt.Strm() << "none";
	rWrt.Strm() << sAttrEnd;
	return rWrt;
}


static Writer& OutDB_SwFooter( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SwFmtFooter & rAttr = (const SwFmtFooter&) rHt;
	const SwFrmFmt* pFmt = rAttr.GetFooterFmt();
	rWrt.Strm() << "Footer: [";

	if ( rAttr.IsActive() )
		rWrt.Strm() << "Active -> ";
	else
		rWrt.Strm() << "not Active -> ";

	if ( pFmt )
		::OutDB_SwFmt( rWrt, *pFmt );
	else
		rWrt.Strm() << "none";
	rWrt.Strm() << sAttrEnd;
	return rWrt;
}



static Writer& OutDB_SwSurround( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SwFmtSurround& rAttr = (const SwFmtSurround&) rHt;
	rWrt.Strm() << "Surround [ Surround: ";
	rWrt.OutULong( rAttr.GetSurround() ) << " AnchorOnly: ";
	rWrt.OutULong( rAttr.IsAnchorOnly() ? 1 : 0 ) << " Contour: ";
	rWrt.OutULong( rAttr.IsContour() ? 1 : 0 ) << " Outside: ";
	rWrt.OutULong( rAttr.IsOutside() ? 1 : 0  )	<< " ]";
	return rWrt;
}

static Writer& OutDB_HoriOrient( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SwFmtHoriOrient& rAttr = (const SwFmtHoriOrient&) rHt;
	rWrt.Strm() << "FlyHoriOrient [ Hori: ";
	rWrt.OutULong( rAttr.GetHoriOrient() ) << " R.Orient: ";
	rWrt.OutULong( rAttr.GetRelationOrient() ) << " Pos: ";
	rWrt.OutULong( rAttr.GetPos() )	<< " ]";
	return rWrt;
}

static Writer& OutDB_VertOrient( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SwFmtVertOrient& rAttr = (const SwFmtVertOrient&) rHt;
	rWrt.Strm() << "FlyVertOrient [ Vert: ";
	rWrt.OutULong( rAttr.GetVertOrient() ) << " R.Orient: ";
	rWrt.OutULong( rAttr.GetRelationOrient() ) << " Pos: ";
	rWrt.OutULong( rAttr.GetPos() )	<< " ]";
	return rWrt;
}



static Writer& OutDB_Anchor( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SwFmtAnchor& rAttr = (const SwFmtAnchor&) rHt;
	rWrt.Strm() << "Anchor: [Id";
	rWrt.OutULong( rAttr.GetAnchorId() );
	switch( rAttr.GetAnchorId() )
	{
	case FLY_IN_CNTNT:
	case FLY_AUTO_CNTNT:
		if( rAttr.GetCntntAnchor() )
		{
			rWrt.Strm() << "Cntnt:";
			rWrt.OutULong( rAttr.GetCntntAnchor()->nContent.GetIndex() );
		}
		else
			rWrt.Strm() << "Cntnt: [NoPointer]";
		// kein break;
	case FLY_AT_CNTNT:
		if( rAttr.GetCntntAnchor() )
		{
			rWrt.Strm() << "Node:";
			rWrt.OutULong( rAttr.GetCntntAnchor()->nNode.GetIndex() );
		}
		else
			rWrt.Strm() << "Cntnt: [NoPointer]";
		break;
	case FLY_PAGE:
		rWrt.Strm() << "Page:";
		rWrt.OutULong( rAttr.GetPageNum() );
		break;
	}
	rWrt.Strm() << sAttrEnd;
	return rWrt;
}



static Writer& OutDB_SwFmtPageDesc( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SwFmtPageDesc & rAttr = (const SwFmtPageDesc&) rHt;
	rWrt.Strm() << "PageDesc: ";
	if( rAttr.GetPageDesc() )
		WriteString( rWrt.Strm(), rAttr.GetPageDesc()->GetName() );
	else
		rWrt.Strm() << "none";

	return rWrt;
}


static Writer& OutDB_SvxMacro( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SvxMacroItem& rAttr = (const SvxMacroItem&) rHt;
	rWrt.Strm() << "MacroItem: [\n";

	SvxMacroTableDtor& rTbl = (SvxMacroTableDtor&)rAttr.GetMacroTable();
	SvxMacro* pMac = rTbl.First();
	while( pMac )
	{
		rWrt.Strm() << "[Event: ";
		rWrt.OutULong( rTbl.GetCurKey() );
		rWrt.Strm()<< " Lib: ";
		WriteString( rWrt.Strm(), pMac->GetLibName());
		rWrt.Strm()<< " Mac: ";
		WriteString( rWrt.Strm(), pMac->GetMacName());
		rWrt.Strm() << "]\t";
		pMac = rTbl.Next();
	}

	rWrt.Strm() << "] ";
	return rWrt;
}
static Writer& OutDB_SwFmtCol( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SwFmtCol& rAttr = (const SwFmtCol&) rHt;
	rWrt.Strm() << "Column: [Cols: ";
	rWrt.OutULong( rAttr.GetNumCols() ) << ", WishW: ";
	rWrt.OutULong( rAttr.GetWishWidth() ) << ", Ortho: ";

	if( rAttr.IsOrtho() )
		rWrt.Strm() << "Ja";
	else
	{
		rWrt.Strm() << "Nein\n";
		const SwColumns& rCol = rAttr.GetColumns();
		for( USHORT n = 0; n < rCol.Count(); ++n )
		{
			const SwColumn* pCol = rCol[ n ];
			rWrt.OutULong( n ) << ": [Width: ";
			rWrt.OutULong( pCol->GetWishWidth() );
			if( pCol->GetUpper() )
			{
				rWrt.Strm() << ", Upper: ";
				rWrt.OutULong( pCol->GetUpper() );
			}
			if( pCol->GetLower() )
			{
				rWrt.Strm() << ", Lower: ";
				rWrt.OutULong( pCol->GetLower() );
			}
			if( pCol->GetLeft() )
			{
				rWrt.Strm() << ", Left: ";
				rWrt.OutULong( pCol->GetLeft() );
			}
			if( pCol->GetRight() )
			{
				rWrt.Strm() << ", Right: ";
				rWrt.OutULong( pCol->GetRight() );
			}
			rWrt.Strm() << "]\n";
		}
	}

	rWrt.Strm() << "] ";
	return rWrt;
}

static Writer& OutDB_Grid( Writer& rWrt, const SfxPoolItem& rHt )
{
    const SwTextGridItem& rAttr = (const SwTextGridItem&) rHt;

    switch ( rAttr.GetGridType() )
    {
    case GRID_NONE:
        rWrt.Strm() << "No Grid ";
        break;
    case GRID_LINES_ONLY :
        rWrt.Strm() << "Line Grid ";
        break;
    case GRID_LINES_CHARS :
        rWrt.Strm() << "Full Grid ";
        break;
    }

    rWrt.Strm() << "Grid Lines: ";
    rWrt.OutLong( rAttr.GetLines() ) << " BaseHeight: ";
    rWrt.OutLong( rAttr.GetBaseHeight() ) << " RubyHeight: ";
    rWrt.OutLong( rAttr.GetRubyHeight() );

	return rWrt;
}

void OutDB_Borderline( Writer& rWrt, const sal_Char* pSttStr,
						const SvxBorderLine& rLine )
{
	rWrt.Strm() << pSttStr << "Col: ";

	switch( rLine.GetColor().GetColor() )
	{
	case COL_BLACK:				rWrt.Strm() << "BLACK ";	break;
	case COL_BLUE:				rWrt.Strm() << "BLUE ";	break;
	case COL_GREEN:				rWrt.Strm() << "GREEN ";	break;
	case COL_CYAN:				rWrt.Strm() << "CYAN ";	break;
	case COL_RED:				rWrt.Strm() << "RED ";	break;
	case COL_MAGENTA:			rWrt.Strm() << "MAGENTA ";	break;
	case COL_BROWN:				rWrt.Strm() << "BROWN ";	break;
	case COL_GRAY:				rWrt.Strm() << "GRAY ";	break;
	case COL_LIGHTGRAY:			rWrt.Strm() << "LIGHTGRAY ";	break;
	case COL_LIGHTBLUE:			rWrt.Strm() << "LIGHTBLUE ";	break;
	case COL_LIGHTGREEN:		rWrt.Strm() << "LIGHTGREEN ";	break;
	case COL_LIGHTCYAN:			rWrt.Strm() << "LIGHTCYAN ";	break;
	case COL_LIGHTRED:			rWrt.Strm() << "LIGHTRED ";	break;
	case COL_LIGHTMAGENTA:		rWrt.Strm() << "LIGHTMAGENTA ";	break;
	case COL_YELLOW:			rWrt.Strm() << "YELLOW ";	break;
	case COL_WHITE:				rWrt.Strm() << "WHITE ";	break;

	default:
		rWrt.Strm() << '(';
		rWrt.OutLong( rLine.GetColor().GetRed() ) << '|';
		rWrt.OutLong( rLine.GetColor().GetGreen() ) << '|';
		rWrt.OutLong( rLine.GetColor().GetBlue() ) << ") ";
	}

	rWrt.Strm() << "OutW: ";
	rWrt.OutLong( rLine.GetOutWidth() ) << " InW: ";
	rWrt.OutLong( rLine.GetInWidth() ) << " Dist: ";
	rWrt.OutLong( rLine.GetDistance() ) << ']';


}

static Writer& OutDB_SvxBox( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SvxBoxItem& rBox = (const SvxBoxItem&) rHt;
	rWrt.Strm() << "BoxItem: Dist: ";
	rWrt.OutLong( rBox.GetDistance() );

	if( rBox.GetLeft() )
		OutDB_Borderline( rWrt, "\n[Left: ", *rBox.GetLeft() );
	if( rBox.GetTop() )
		OutDB_Borderline( rWrt, "\n[Top: ", *rBox.GetTop() );
	if( rBox.GetRight() )
		OutDB_Borderline( rWrt, "\n[Right: ", *rBox.GetRight() );
	if( rBox.GetBottom() )
		OutDB_Borderline( rWrt, "\n[Bottom: ", *rBox.GetBottom() );

	rWrt.Strm() << "] ";
	return rWrt;
}

/* File GRFATR.HXX */


static Writer& OutDB_SwMirrorGrf( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "MirrorGrf: State[";
	rWrt.OutULong( ((const SwMirrorGrf&)rHt).GetValue() ) << sAttrEnd;
	return rWrt;
}


static Writer& OutDB_SwCropGrf( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SwCropGrf &rAttr = (const SwCropGrf &) rHt;
	rWrt.Strm() << "CropGrf: Left[";
	rWrt.OutLong( rAttr.GetLeft() ) << "] Right[";
	rWrt.OutLong( rAttr.GetRight() ) << "] Top[";
	rWrt.OutLong( rAttr.GetTop() ) << "] Bottom[";
	rWrt.OutLong( rAttr.GetBottom() ) << sAttrEnd;
	return rWrt;
}

/* File BOXATR.HXX	*/


static Writer& OutDB_SwBoxFmt( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SwTblBoxNumFormat& rAttr = (const SwTblBoxNumFormat&) rHt;
	rWrt.Strm() << "BoxNumFmt: [";
	rWrt.OutULong( rAttr.GetValue() ) << sAttrEnd;
	return rWrt;
}


static Writer& OutDB_SwBoxFormula( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SwTblBoxFormula& rAttr = (const SwTblBoxFormula&) rHt;
	rWrt.Strm() << "BoxFormel: [";
	WriteString( rWrt.Strm(), rAttr.GetFormula() );
	rWrt.Strm()	<< sAttrEnd;
	return rWrt;
}



static Writer& OutDB_SwBoxValue( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SwTblBoxValue& rAttr = (const SwTblBoxValue&) rHt;
    ByteString sBuff(ByteString::CreateFromDouble(rAttr.GetValue()));
    sBuff.Append((char)0);
	rWrt.Strm() << "BoxValue: [" << sBuff.GetBuffer() << sAttrEnd;
	return rWrt;
}


/* File PARATR.HXX	*/



static Writer& OutDB_SwLineSpacing( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SvxLineSpacingItem &rAttr =  (const SvxLineSpacingItem &) rHt;
	rWrt.Strm() << "LineSpacing: Size[";
	rWrt.OutULong( rAttr.GetPropLineSpace() ) << "] Sp.Rule[ ";
	rWrt.OutULong( rAttr.GetLineSpaceRule() ) << "] In.Sp.Rule[ ";
	rWrt.OutULong( rAttr.GetInterLineSpaceRule() ) << "] In.Space[ ";
	rWrt.OutULong( rAttr.GetInterLineSpace() ) << "] Height[ ";
	rWrt.OutULong( rAttr.GetLineHeight() ) << sAttrEnd;
	return rWrt;
}



static Writer& OutDB_SwAdjust( Writer& rWrt, const SfxPoolItem& rHt )
{
	rWrt.Strm() << "Adjust: Style[";
	rWrt.OutULong( ((const SvxAdjustItem&)rHt).GetAdjust() ) << sAttrEnd;
	return rWrt;
}



static Writer& OutDB_SwTabStop( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SvxTabStopItem & rAttr = (const SvxTabStopItem&)rHt;
	rWrt.Strm() << "TabStops: (";
	for( USHORT n = 0; n < rAttr.Count(); n++ )
	{
		const SvxTabStop & rTab = rAttr[ n ];
		rWrt.Strm() << "TabStop: Style[";
		rWrt.OutULong( rTab.GetAdjustment() ) << "] Pos[";
		rWrt.OutLong( rTab.GetTabPos() )
			<< "] Around[" << (sal_Char) rTab.GetDecimal()
			<< "] Fill[" << (sal_Char) rTab.GetFill() << sAttrEnd;
	}
	rWrt.Strm() << sKlammerEnd;
	return rWrt;
}
static Writer& OutDB_SwNumRule( Writer& rWrt, const SfxPoolItem& rHt )
{
	const SwNumRuleItem& rAttr = (const SwNumRuleItem&) rHt;
	rWrt.Strm() << "NumRule: [";
	WriteString( rWrt.Strm(), rAttr.GetValue() );
	rWrt.Strm() << sAttrEnd;
	return rWrt;
}


static Writer& OutDB_Dummy( Writer& rWrt, const SfxPoolItem& rHt )
{
	const sal_Char* pStr;
	switch( rHt.Which() )
	{
	case RES_CHRATR_CASEMAP:               pStr = "CASEMAP"; break;
	case RES_CHRATR_CHARSETCOLOR:          pStr = "CHARSETCOLOR"; break;
	case RES_CHRATR_COLOR:                 pStr = "COLOR"; break;
	case RES_CHRATR_CONTOUR:               pStr = "CONTOUR"; break;
	case RES_CHRATR_CROSSEDOUT:            pStr = "CROSSEDOUT"; break;
	case RES_CHRATR_ESCAPEMENT:            pStr = "ESCAPEMENT"; break;
	case RES_CHRATR_FONT:                  pStr = "FONT"; break;
	case RES_CHRATR_FONTSIZE:              pStr = "FONTSIZE"; break;
	case RES_CHRATR_KERNING:               pStr = "KERNING"; break;
	case RES_CHRATR_LANGUAGE:              pStr = "LANGUAGE"; break;
	case RES_CHRATR_POSTURE:               pStr = "POSTURE"; break;
	case RES_CHRATR_PROPORTIONALFONTSIZE:  pStr = "PROPORTIONALFONTSIZE"; break;
	case RES_CHRATR_SHADOWED:              pStr = "SHADOWED"; break;
	case RES_CHRATR_UNDERLINE:             pStr = "UNDERLINE"; break;
	case RES_CHRATR_WEIGHT:                pStr = "WEIGHT"; break;
	case RES_CHRATR_WORDLINEMODE:          pStr = "WORDLINEMODE"; break;
	case RES_CHRATR_AUTOKERN:              pStr = "AUTOKERN"; break;
	case RES_CHRATR_BLINK:	               pStr = "BLINK"; break;
	case RES_CHRATR_NOHYPHEN:              pStr = "NOHYPHEN"; break;
	case RES_CHRATR_NOLINEBREAK:           pStr = "NOLINEBREAK"; break;
	case RES_CHRATR_BACKGROUND:	           pStr = "CHARBACKGROUND"; break;
	case RES_CHRATR_CJK_FONT:              pStr = "CJK_FONT"; break;
	case RES_CHRATR_CJK_FONTSIZE:          pStr = "CJK_FONTSIZE"; break;
	case RES_CHRATR_CJK_LANGUAGE:          pStr = "CJK_LANGUAGE"; break;
	case RES_CHRATR_CJK_POSTURE:           pStr = "CJK_POSTURE"; break;
	case RES_CHRATR_CJK_WEIGHT:            pStr = "CJK_WEIGHT"; break;
	case RES_CHRATR_CTL_FONT:              pStr = "CTL_FONT"; break;
	case RES_CHRATR_CTL_FONTSIZE:          pStr = "CTL_FONTSIZE"; break;
	case RES_CHRATR_CTL_LANGUAGE:          pStr = "CTL_LANGUAGE"; break;
	case RES_CHRATR_CTL_POSTURE:           pStr = "CTL_POSTURE"; break;
	case RES_CHRATR_CTL_WEIGHT:            pStr = "CTL_WEIGHT"; break;
	case RES_CHRATR_ROTATE:     		   pStr = "ROTATE"; break;
	case RES_CHRATR_EMPHASIS_MARK:	       pStr = "EMPHASIS_MARK"; break;
	case RES_CHRATR_TWO_LINES:		       pStr = "Char 2 Lines"; break;
	case RES_CHRATR_SCALEW:	               pStr = "ScaleWidth"; break;
	case RES_CHRATR_RELIEF:	               pStr = "Relief"; break;

	case RES_CHRATR_DUMMY1:	               pStr = "Char Dummy1"; break;

	case RES_TXTATR_INETFMT:    		   pStr = "INETFMT"; break;
	case RES_TXTATR_DUMMY4:		           pStr = "Text Dummy4 Old"; break;
	case RES_TXTATR_REFMARK:               pStr = "REFMARK"; break;
	case RES_TXTATR_TOXMARK:               pStr = "TOXMARK"; break;
	case RES_TXTATR_CHARFMT:               pStr = "CHARFMT"; break;
	case RES_TXTATR_DUMMY5:	               pStr = "Text Dummy5"; break;
	case RES_TXTATR_CJK_RUBY:		       pStr = "Text CJK-Ruby"; break;
	case RES_TXTATR_UNKNOWN_CONTAINER:	   pStr = "Text UnknownContainer"; break;
	case RES_TXTATR_DUMMY6:		           pStr = "Text Dummy6"; break;
	case RES_TXTATR_DUMMY7:		           pStr = "Text Dummy7"; break;

	case RES_TXTATR_FIELD:                 pStr = "FIELD"; break;
	case RES_TXTATR_FLYCNT:                pStr = "FLYCNT"; break;
	case RES_TXTATR_FTN:                   pStr = "FTN"; break;
	case RES_TXTATR_HARDBLANK:             pStr = "HARDBLANK"; break;
	case RES_TXTATR_DUMMY1:	               pStr = "Text Dummy1"; break;
	case RES_TXTATR_DUMMY2:	               pStr = "Text Dummy2"; break;

	case RES_PARATR_LINESPACING:           pStr = "LINESPACING"; break;
	case RES_PARATR_ADJUST:                pStr = "ADJUST"; break;
	case RES_PARATR_SPLIT:                 pStr = "SPLIT"; break;
	case RES_PARATR_WIDOWS:                pStr = "WIDOWS"; break;
	case RES_PARATR_ORPHANS:               pStr = "ORPHANS"; break;
	case RES_PARATR_TABSTOP:               pStr = "TABSTOP"; break;
	case RES_PARATR_HYPHENZONE:            pStr = "HYPHENZONE"; break;
	case RES_PARATR_DROP:                  pStr = "DROP"; break;
	case RES_PARATR_REGISTER:	           pStr = "REGISTER"; break;
	case RES_PARATR_NUMRULE:	           pStr = "NUMRULE"; break;
	case RES_PARATR_SCRIPTSPACE:	       pStr = "SCRIPTSPACE"; break;
	case RES_PARATR_HANGINGPUNCTUATION:	   pStr = "HANGINGPUNCTUATION"; break;
	case RES_PARATR_FORBIDDEN_RULES:	   pStr = "FORBIDDEN_RULES"; break;
	case RES_PARATR_VERTALIGN:             pStr = "VERTICAL ALIGNMENT"; break;
    case RES_PARATR_SNAPTOGRID:            pStr = "PARASNAPTOGRID"; break;
    case RES_PARATR_CONNECT_BORDER:        pStr = "PARACONNECTBORDER"; break;
	case RES_PARATR_DUMMY5:	               pStr = "Para Dummy5"; break;
	case RES_PARATR_DUMMY6:	               pStr = "Para Dummy6"; break;
	case RES_PARATR_DUMMY7:	               pStr = "Para Dummy7"; break;
	case RES_PARATR_DUMMY8:	               pStr = "Para Dummy8"; break;

	case RES_FILL_ORDER:                   pStr = "ORDER"; break;
	case RES_FRM_SIZE:                     pStr = "SIZE"; break;
	case RES_PAPER_BIN:                    pStr = "BIN"; break;
	case RES_LR_SPACE:                     pStr = "SPACE"; break;
	case RES_UL_SPACE:                     pStr = "SPACE"; break;
	case RES_PAGEDESC:                     pStr = "PAGEDESC"; break;
	case RES_BREAK:                        pStr = "BREAK"; break;
	case RES_CNTNT:                        pStr = "CNTNT"; break;
	case RES_HEADER:                       pStr = "HEADER"; break;
	case RES_FOOTER:                       pStr = "FOOTER"; break;
	case RES_PRINT:                        pStr = "PRINT"; break;
	case RES_OPAQUE:                       pStr = "OPAQUE"; break;
	case RES_PROTECT:                      pStr = "PROTECT"; break;
	case RES_SURROUND:                     pStr = "SURROUND"; break;
	case RES_VERT_ORIENT:                  pStr = "ORIENT"; break;
	case RES_HORI_ORIENT:                  pStr = "ORIENT"; break;
	case RES_ANCHOR:                       pStr = "ANCHOR"; break;
	case RES_BACKGROUND:                   pStr = "BACKGROUND"; break;
	case RES_BOX:                          pStr = "BOX"; break;
	case RES_SHADOW:                       pStr = "SHADOW"; break;
	case RES_FRMMACRO:                     pStr = "FRMMACRO"; break;
	case RES_COL:                          pStr = "COL"; break;
	case RES_KEEP:                         pStr = "KEEP"; break;
	case RES_URL:	               		   pStr = "URL"; break;
	case RES_EDIT_IN_READONLY:	           pStr = "EDIT_IN_READONLY"; break;
	case RES_LAYOUT_SPLIT:				   pStr = "RES_LAYOUT_SPLIT"; break;
	case RES_CHAIN:						   pStr = "RES_CHAIN"; break;
    case RES_TEXTGRID:                     pStr = "RES_TEXTGRID"; break;
	case RES_LINENUMBER:				   pStr = "RES_LINENUMBER"; break;
	case RES_FTN_AT_TXTEND:				   pStr = "RES_FTN_AT_TXTEND"; break;
	case RES_END_AT_TXTEND:				   pStr = "RES_END_AT_TXTEND"; break;
	case RES_COLUMNBALANCE:				   pStr = "RES_COLUMNBALANCE"; break;

	case RES_GRFATR_MIRRORGRF:             pStr = "MIRRORGRF"; break;
	case RES_GRFATR_CROPGRF:               pStr = "CROPGRF"; break;
	case RES_GRFATR_ROTATION:              pStr = "ROTATION"; break;
	case RES_GRFATR_LUMINANCE:             pStr = "LUMINANCE"; break;
	case RES_GRFATR_CONTRAST:              pStr = "CONTRAST"; break;
	case RES_GRFATR_CHANNELR:              pStr = "CHANNELR"; break;
	case RES_GRFATR_CHANNELG:              pStr = "CHANNELG"; break;
	case RES_GRFATR_CHANNELB:              pStr = "CHANNELB"; break;
	case RES_GRFATR_GAMMA:                 pStr = "GAMMA"; break;
	case RES_GRFATR_INVERT:                pStr = "INVERT"; break;
	case RES_GRFATR_TRANSPARENCY:          pStr = "TRANSPARENCY"; break;
	case RES_GRFATR_DRAWMODE:              pStr = "DRAWMODE"; break;
	case RES_GRFATR_DUMMY1:                pStr = "DUMMY1"; break;
	case RES_GRFATR_DUMMY2:                pStr = "DUMMY2"; break;
	case RES_GRFATR_DUMMY3:                pStr = "DUMMY3"; break;
	case RES_GRFATR_DUMMY4:                pStr = "DUMMY4"; break;
	case RES_GRFATR_DUMMY5:                pStr = "DUMMY5"; break;

	case RES_UNKNOWNATR_CONTAINER:         pStr = "XML_ATTR_CONTAINER"; break;

	default:
		pStr = "unbekanntes Item!"; break;
	}
	rWrt.Strm() << pStr << ' ';
	return rWrt;
}


/*
 * lege hier die Tabellen fuer die RTF-Funktions-Pointer auf
 * die Ausgabe-Funktionen an.
 * Es sind lokale Strukturen, die nur innerhalb der RTF-DLL
 * bekannt sein muessen.
 */

SwAttrFnTab aDBAttrFnTab = {
/* RES_CHRATR_CASEMAP	*/			OutDB_SwCaseMap,
/* RES_CHRATR_CHARSETCOLOR */		OutDB_Dummy,
/* RES_CHRATR_COLOR */				OutDB_SwColor,
/* RES_CHRATR_CONTOUR	*/			OutDB_SwContour,
/* RES_CHRATR_CROSSEDOUT	*/		OutDB_SwCrossedOut,
/* RES_CHRATR_ESCAPEMENT	*/		OutDB_SwEscapement,
/* RES_CHRATR_FONT	*/				OutDB_SwFont,
/* RES_CHRATR_FONTSIZE	*/			OutDB_SwSize,
/* RES_CHRATR_KERNING	*/			OutDB_SwKerning,
/* RES_CHRATR_LANGUAGE	*/			OutDB_SwLanguage,
/* RES_CHRATR_POSTURE	*/			OutDB_SwPosture,
/* RES_CHRATR_PROPORTIONALFONTSIZE*/OutDB_SwPropSize,
/* RES_CHRATR_SHADOWED	*/			OutDB_SwShadowed,
/* RES_CHRATR_UNDERLINE */			OutDB_SwUnderline,
/* RES_CHRATR_WEIGHT	*/			OutDB_SwWeight,
/* RES_CHRATR_WORDLINEMODE	*/	 	OutDB_SwWordLineMode,
/* RES_CHRATR_AUTOKERN	*/			OutDB_SwAutoKern,
/* RES_CHRATR_BLINK	*/				OutDB_Dummy,
/* RES_CHRATR_NOHYPHEN	*/			OutDB_Dummy,
/* RES_CHRATR_NOLINEBREAK	*/		OutDB_Dummy,
/* RES_CHRATR_BACKGROUND */         OutDB_Dummy,
/* RES_CHRATR_CJK_FONT */			OutDB_SwFont,
/* RES_CHRATR_CJK_FONTSIZE */		OutDB_SwSize,
/* RES_CHRATR_CJK_LANGUAGE */		OutDB_SwLanguage,
/* RES_CHRATR_CJK_POSTURE */		OutDB_SwPosture,
/* RES_CHRATR_CJK_WEIGHT */			OutDB_SwWeight,
/* RES_CHRATR_CTL_FONT */			OutDB_SwFont,
/* RES_CHRATR_CTL_FONTSIZE */		OutDB_SwSize,
/* RES_CHRATR_CTL_LANGUAGE */		OutDB_SwLanguage,
/* RES_CHRATR_CTL_POSTURE */		OutDB_SwPosture,
/* RES_CHRATR_CTL_WEIGHT */			OutDB_SwWeight,
/* RES_CHRATR_WRITING_DIRECTION */	OutDB_Dummy,
/* RES_CHRATR_EMPHASIS_MARK */ 		OutDB_Dummy,
/* RES_CHRATR_TWO_LINES */ 			OutDB_Dummy,
/* RES_CHRATR_DUMMY4 */				OutDB_Dummy,
/* RES_CHRATR_DUMMY5 */				OutDB_Dummy,
/* RES_CHRATR_DUMMY1 */				OutDB_Dummy,

/* RES_TXTATR_INETFMT	*/			OutDB_Dummy,
/* RES_TXTATR_DUMMY4	*/			OutDB_Dummy,
/* RES_TXTATR_REFMARK 		*/		OutDB_SwRefMark,
/* RES_TXTATR_TOXMARK */ 			OutDB_SwTxtTOXMark,
/* RES_TXTATR_CHARFMT	*/			OutDB_SwCharFmt,
/* RES_TXTATR_DUMMY5 */				OutDB_Dummy,
/* RES_TXTATR_CJK_RUBY */			OutDB_Dummy,
/* RES_TXTATR_UNKNOWN_CONTAINER */	OutDB_Dummy,
/* RES_TXTATR_DUMMY6 */				OutDB_Dummy,
/* RES_TXTATR_DUMMY7 */				OutDB_Dummy,

/* RES_TXTATR_FIELD */				OutDB_SwField,
/* RES_TXTATR_FLYCNT */ 			OutDB_Dummy,
/* RES_TXTATR_FTN				*/	OutDB_Dummy,
/* RES_TXTATR_SOFTHYPH			*/	0,
/* RES_TXTATR_HARDBLANK 		*/	OutDB_Dummy,
/* RES_TXTATR_DUMMY1 */             OutDB_Dummy,
/* RES_TXTATR_DUMMY2 */				OutDB_Dummy,

/* RES_PARATR_LINESPACING	*/		OutDB_SwLineSpacing,
/* RES_PARATR_ADJUST	*/			OutDB_SwAdjust,
/* RES_PARATR_SPLIT    */			OutDB_Dummy,
/* RES_PARATR_WIDOWS	*/			OutDB_Dummy,
/* RES_PARATR_ORPHANS   */          OutDB_Dummy,
/* RES_PARATR_TABSTOP	*/			OutDB_SwTabStop,
/* RES_PARATR_HYPHENZONE */			OutDB_Dummy,
/* RES_PARATR_DROP */				OutDB_Dummy,
/* RES_PARATR_REGISTER */           OutDB_Dummy,
/* RES_PARATR_NUMRULE */            OutDB_SwNumRule,
/* RES_PARATR_SCRIPTSPACE */   	    OutDB_Dummy,
/* RES_PARATR_HANGINGPUNCTUATION */	OutDB_Dummy,
/* RES_PARATR_DUMMY1 */        	    OutDB_Dummy,
/* RES_PARATR_VERTALIGN */     	    OutDB_Dummy,
/* RES_PARATR_SNAPTOGRID */         OutDB_SwSnapToGrid,
/* RES_PARATR_CONNECT_BORDER */     OutDB_Dummy,
/* RES_PARATR_DUMMY5 */        	    OutDB_Dummy,
/* RES_PARATR_DUMMY6 */        	    OutDB_Dummy,
/* RES_PARATR_DUMMY7 */        	    OutDB_Dummy,
/* RES_PARATR_DUMMY8 */        	    OutDB_Dummy,


/* RES_FILL_ORDER	*/				OutDB_SwFillOrder,
/* RES_FRM_SIZE */					OutDB_SwFrmSize,
/* RES_PAPER_BIN	*/				OutDB_SwPaperBin,
/* RES_LR_SPACE */					OutDB_SwLRSpace,
/* RES_UL_SPACE */					OutDB_SwULSpace,
/* RES_PAGEDESC */					OutDB_SwFmtPageDesc,
/* RES_BREAK */						OutDB_SwFmtBreak,
/* RES_CNTNT */						OutDB_SwCntnt,
/* RES_HEADER */					OutDB_SwHeader,
/* RES_FOOTER */					OutDB_SwFooter,
/* RES_PRINT */						OutDB_Dummy,
/* RES_OPAQUE */					OutDB_Dummy,
/* RES_PROTECT */					OutDB_Dummy,
/* RES_SURROUND */					OutDB_SwSurround,
/* RES_VERT_ORIENT */               OutDB_VertOrient,
/* RES_HORI_ORIENT */				OutDB_HoriOrient,
/* RES_ANCHOR */					OutDB_Anchor,
/* RES_BACKGROUND */				OutDB_Dummy,
/* RES_BOX	*/						OutDB_SvxBox,
/* RES_SHADOW */					OutDB_Dummy,
/* RES_FRMMACRO */					OutDB_SvxMacro,
/* RES_COL */						OutDB_SwFmtCol,
/* RES_KEEP */						OutDB_Dummy,
/* RES_URL */        	    		OutDB_Dummy,
/* RES_EDIT_IN_READONLY */        	OutDB_Dummy,
/* RES_LAYOUT_SPLIT */ 	    		OutDB_Dummy,
/* RES_FRMATR_DUMMY1 */        	    OutDB_Dummy, // Dummy:
/* RES_TEXTGRID */                  OutDB_Grid,
/* RES_FRMATR_DUMMY3 */        	    OutDB_Dummy, // Dummy:
/* RES_FRMATR_DUMMY4 */        	    OutDB_Dummy, // Dummy:
/* RES_FRMATR_DUMMY5 */        	    OutDB_Dummy, // Dummy:
/* RES_FRMATR_DUMMY6 */        	    OutDB_Dummy, // Dummy:
/* RES_FRMATR_DUMMY7 */        	    OutDB_Dummy, // Dummy:
/* RES_FRMATR_DUMMY8 */        	    OutDB_Dummy, // Dummy:
/* RES_FRMATR_DUMMY9 */        	    OutDB_Dummy, // Dummy:

/* RES_GRFATR_MIRRORGRF */			OutDB_SwMirrorGrf,
/* RES_GRFATR_CROPGRF	*/			OutDB_SwCropGrf,
/* RES_GRFATR_ROTATION */			OutDB_Dummy,
/* RES_GRFATR_LUMINANCE */			OutDB_Dummy,
/* RES_GRFATR_CONTRAST */			OutDB_Dummy,
/* RES_GRFATR_CHANNELR */			OutDB_Dummy,
/* RES_GRFATR_CHANNELG */			OutDB_Dummy,
/* RES_GRFATR_CHANNELB */			OutDB_Dummy,
/* RES_GRFATR_GAMMA */				OutDB_Dummy,
/* RES_GRFATR_INVERT */				OutDB_Dummy,
/* RES_GRFATR_TRANSPARENCY */		OutDB_Dummy,
/* RES_GRFATR_DRWAMODE */			OutDB_Dummy,
/* RES_GRFATR_DUMMY1 */				OutDB_Dummy,
/* RES_GRFATR_DUMMY2 */				OutDB_Dummy,
/* RES_GRFATR_DUMMY3 */				OutDB_Dummy,
/* RES_GRFATR_DUMMY4 */				OutDB_Dummy,
/* RES_GRFATR_DUMMY5 */				OutDB_Dummy,

/* RES_BOXATR_FORMAT */				OutDB_SwBoxFmt,
/* RES_BOXATR_FORMULA */			OutDB_SwBoxFormula,
/* RES_BOXATR_VALUE */				OutDB_SwBoxValue,

/* RES_UNKNOWNATR_CONTAINER */		OutDB_Dummy
};

SwNodeFnTab aDBNodeFnTab = {
/* RES_TXTNODE	*/					 OutDB_SwTxtNode,
/* RES_GRFNODE	*/					 OutDB_SwGrfNode,
/* RES_OLENODE	*/					 0
};

