/*************************************************************************
 *
 *  $RCSfile: scpzip.cxx,v $
 *
 *  $Revision: 1.42.14.2 $
 *
 *  last change: $Author: vg $ $Date: 2004/01/28 11:18:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef WNT
// #define UNDER_WINDOWS_DEBUGGING
// Nice feature, to debug under windows, install msdev locally and use DebugBreak() to stop a new process at a point you want.
#ifdef UNDER_WINDOWS_DEBUGGING
#include <tools/presys.h>
#include <windows.h>
#include <tools/postsys.h>

#define VCL_NEED_BASETSD

#endif /* UNDER_WINDOWS_DEBUGGING */
#endif /* WNT */


#include <stdio.h>
#ifdef UNX
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <grp.h>
#endif
#include <time.h>

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _VOS_PROCESS_HXX
#include <vos/process.hxx>
#endif
#ifndef _FSYS_HXX
#include <tools/fsys.hxx>
#endif
#ifndef _OSL_THREAD_H_
#include <osl/thread.h>
#endif
#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#include <com/sun/star/setup/OSType.hpp>

#include "rtl/crc.h"

#include "setup2/sistream.hxx"
#include "setup2/script.hxx"
#include "setup2/instdb.hxx"
#include "setup2/zipfile.hxx"
#include "setup2/hashtbl.hxx"
#include "setup2/sifsys.hxx"

#include "protocol.hxx"
#include "scplink.hxx"

#include "searchcache.hxx"
#include <vector>
#include "parameterhelper.hxx"
#include "md5.hxx"

ParameterHelper::Association aGlobalAssociation;

// ============================================================================

using namespace com::sun::star::setup;
using namespace StringHelper;

// ============================================================================

#define NORMAL_DIRNAME				"normal"
#define MERGE_DIRNAME				"download"
#define SPLIT_DIRNAME				"splitdownload"
#define WEB_DIRNAME					"web"

#define JUNK_EXTENSION		   		"bin"
#define MASTER_EXTENSION_UNX		"bin"
#define MASTER_EXTENSION	   		"exe"

USHORT 			nGlobalSetupID		= 0;
USHORT 			nGlobalID			= 0;

ByteString		aBasePath;
ByteString		aDestinationPath;
ByteString		aMergeDestinationPath;
ByteString		aSplitDestinationPath;
ByteString		aWebDestinationPath;
ByteString		aBuildID;
ByteString		aChecksums;

rtl::OUString   suDestinationPath;
rtl::OUString   suReplacementFiles;				 // Files which will manipulated with parameter '-r'
BOOL bUseReplacement = FALSE;

ByteString		aMergeFilename;
ByteString		aHTMLFilename;

BOOL			bTestOnly			= FALSE;
BOOL			bOldSetupZIPStyle	= FALSE;
BOOL			bWebScript 			= FALSE;
BOOL			bStripBinaries		= FALSE;

USHORT 			nCompression		= 5;
USHORT 			nProcessorType 		= 0; 			// 0 == INTEL, 1 == SPARC
USHORT 			nTargetSystem		= 0;	        // 0 == WNT, 1 == OS2, 2 == UNX
USHORT 			nUnzipedFiles		= 0;
ULONG 			nUnzipedSize		= 0;
USHORT 			nDefLang			= 0;
ULONG 			nSplitSize			= 0;
ULONG           nVersion            = 0;

Protocol*		pLog				= NULL;

SvFileStream aChecksumsFile;


DECLARE_HASHTABLE(DoneList,ByteString,UINT32);
DoneList aDoneList(1017);

#ifdef UNX
gid_t	gr_gid;
#endif

// Prototypes
BOOL ReplaceStringsInFile(rtl::OUString const& _suFileName, sal_Bool bEncodingIsUTF8);

///////////////////////////////////////////////////////////////////////////////

void PrintZipUsage()
{
	fprintf( stderr, "usage:\n" );
	fprintf( stderr, "\t-<1..9> compression (default is 5)\n" );
	fprintf( stderr, "\t-o test only\n" );
	fprintf( stderr, "\t-l <langcode,...> (first langcode is default language)\n" );
	fprintf( stderr, "\t-h <INTEL | SPARC> (INTEL)\n" );
	fprintf( stderr, "\t-t <WNT | OS2 | UNX> (default WNT)\n" );
	fprintf( stderr, "\t-m <filename> merge all files to one file\n" );
	fprintf( stderr, "\t-z <size> split merged file in <size> blocks\n" );
	fprintf( stderr, "\t-s <source script>\n" );
	fprintf( stderr, "\t-d <destination path>\n" );
	fprintf( stderr, "\t-i <include path,...>\n" );
	fprintf( stderr, "\t-e <filename> (write a non HTML error log)\n" );
	fprintf( stderr, "\t-p <filename> (write a HTML protocol)\n" );
	fprintf( stderr, "\t-w generate a webinstall script\n" );
	fprintf( stderr, "\t-u use old setup.zip style\n" );
	fprintf( stderr, "\t-b build id\n" );
	fprintf( stderr, "\t-S strip binaries\n" );
	fprintf( stderr, "\t-r \"%REPLACEMENTVALUE=new value\" replacement helper, the \" is to support spaces. Strings will be trimed\n" );
	fprintf( stderr, "\t-C <filename> Write checksums of the packed binaries to <filename>\n" );
}

///////////////////////////////////////////////////////////////////////////////

void __EnumFilesCallBack( char *pFile, ULONG nSize, void *pObject )
{
	nUnzipedSize += nSize;
}

///////////////////////////////////////////////////////////////////////////////

void _rawZip( ByteString& aSource, SiDirEntry& aDestination )
{
	ByteString aCompressionParam( '-' );
	aCompressionParam += ByteString::CreateFromInt32( nCompression );

	ByteString aSys( "zip -j ");
	aSys += aCompressionParam;
	aSys += " \"";
	aSys += aDestination.GetFull();
	aSys += "\" \"";
	aSys += aSource;
	aSys += "\"";
	pLog->Log( aSys );

// Test OProcess also under UNIX

#ifndef UNX

	USHORT nOptions = NAMESPACE_VOS(OProcess)::TOption_SearchPath |
						NAMESPACE_VOS(OProcess)::TOption_Wait;

	NAMESPACE_VOS(OProcess)::TProcessOption eOptions =
						(NAMESPACE_VOS(OProcess)::TProcessOption)nOptions;

	::rtl::OUString* pArgs = new ::rtl::OUString [ 4 ];

	pArgs[0] = ::rtl::OUString::createFromAscii( "-j" );
	pArgs[1] = ::rtl::OUString::createFromAscii( aCompressionParam.GetBuffer() );
	pArgs[2] = ::rtl::OUString::createFromAscii( aDestination.GetFull().GetBuffer() );
	pArgs[3] = ::rtl::OUString::createFromAscii( aSource.GetBuffer() );

	NAMESPACE_VOS(OArgumentList) aArgs( pArgs, 4 );

	NAMESPACE_VOS(OProcess) aProcess( ::rtl::OUString::createFromAscii("zip.exe") );
	aProcess.execute( eOptions, aArgs );
	aProcess.join();

	delete [] pArgs;
#else

	//# LLA:
	//# If OProcess does not work, we should think about this code,
	//# always better than system()
	//# works nice in loader.exe

	//# char* pArgs = new char* [ 5 ];
	//# ByteString sStrJ("-j");
	//# pArgs[0] = sStrJ.GetBuffer();
	//# pArgs[1] = aCompressionParam.GetBuffer();
	//# pArgs[2] = aDestination.GetFull().GetBuffer();
	//# pArgs[3] = aSource.GetBuffer();
	//# pArgs[4] = NULL;
	//# ByteString sStrZip("zip");
    //# if ( execv( sStrZip.GetBuffer(), pArgs ) < 0 )
    //# {
	//# 	ByteString aSys( "zip failed: with error code: ");
	//# 	aSys += ByteString::CreateFromInt32(errno);
	//# 	pLog->Log( aSys );
    //# }
	//# delete [] pArgs;
//	aSys += " >>zipoutput.log";
	if (pLog->getStreamFileName().Len() > 0)
	{
		aSys += " >>";
		aSys += pLog->getStreamFileName();
	}
	if (pLog->getErrorStreamFileName().Len() > 0)
	{
		aSys += " 2>>";
		aSys += pLog->getErrorStreamFileName();
	}

	system( aSys.GetBuffer() );

#endif
}

///////////////////////////////////////////////////////////////////////////////

void FileCopy(const SiDirEntry& rSource, const SiDirEntry& rDest)
{
    SiDirEntry aSource(rSource);
    aSource.ToAbs();
    ::rtl::OUString aSourcePath(aSource.GetFullUni());
    ::rtl::OUString aSourceURL;
    ::osl::File::getFileURLFromSystemPath(aSourcePath, aSourceURL);

    SiDirEntry aDest(rDest);
    aDest.ToAbs();
    ::rtl::OUString aDestPath(aDest.GetFullUni());
    ::rtl::OUString aDestURL;
    ::osl::File::getFileURLFromSystemPath(aDestPath, aDestURL);

    sal_Int32 rc;
    /* Surprise, surprise 
     * ::osl::File::copy() copies symlinks as ... symlinks. Ugh.
     * We have to check for symlinks as source first before
     * copying. 
     */
    ::osl::DirectoryItem aDirItem;
    ::osl::FileStatus aStatus(FileStatusMask_Type|FileStatusMask_LinkTargetURL);
    rc = ::osl::DirectoryItem::get(aSourceURL, aDirItem);
    if ( rc != ::osl::FileBase::E_None )
        goto ERROR;
    rc = aDirItem.getFileStatus(aStatus);
    if ( rc != ::osl::FileBase::E_None )
        goto ERROR;
    if ( aStatus.getFileType() == ::osl::FileStatus::Link ) {
        aSourceURL = aStatus.getLinkTargetURL();
    }
    
    rc = ::osl::File::copy(aSourceURL, aDestURL);
    if ( rc != ::osl::FileBase::E_None )
        goto ERROR;
    return;

  ERROR:
    ByteString aMsg("error: file copy failed, error code: ");
    aMsg += ByteString::CreateFromInt32( rc );
    pLog->Log(aMsg);
    return;
}

///////////////////////////////////////////////////////////////////////////////

void KillingAction()
{
	SiDirEntry aKillfile( aBasePath );
	aKillfile += ByteString("bastard.kil");
	if( aKillfile.Exists() )
	{
		aKillfile.Kill();

		SiDirEntry aDestDir( aDestinationPath );
		Dir aDir( aDestDir, FSYS_KIND_FILE );
		for( USHORT i = 0; i < aDir.Count(); ++i )
		{
			SiDirEntry aEntry( aDir[i] );
			aEntry.Kill();
		}

		aDestDir.Kill();

		aDestDir.SetName( UniString::CreateFromAscii(MERGE_DIRNAME) );
		aDestDir.Kill();

		aDestDir.SetName( UniString::CreateFromAscii(SPLIT_DIRNAME) );
		aDestDir.Kill();

		pLog->Log( "*** KILLED ***" );
		exit( 0 );
	}
}

#define SCPZIP_REPLACE_TRUE  (TRUE)
#define SCPZIP_REPLACE_FALSE (FALSE)

void ZipFile( SiFile* pFile, USHORT nLang, BOOL _bScpzipReplaceAction = SCPZIP_REPLACE_FALSE )
{
	// Zip a File as f0_000 or f_0000, if _bScpzipReplaceAction is SCPZIP_REPLACE_TRUE, take some
	// replacements

	// LLA: Debug Code, to fast find files
	if (1)
	{
		ByteString sFileName(pFile->GetName());
		sal_Int32 nPos = sFileName.ToLowerAscii().Search("readme");
		if (nPos != STRING_NOTFOUND)
		{
			volatile int dummy = 0;
		}
	}
	
	BOOL bRemoveIt = FALSE;
	ByteString aDoneID( pFile->GetScpExtSearchName().Len() ? pFile->GetScpExtSearchName() : pFile->GetName() );
	aDoneID += ByteString::CreateFromInt32( nLang );
	aDoneID += pFile->GetID();
	if( aDoneList.Find(aDoneID) != 0 )
		return;
	else
		aDoneList.Insert( aDoneID, 1 );

	ByteString aSource;
	if( !pFile->GetScpExtSearchName().Len() )
	{
		// LLA: could be helpful to know that we also find files, which have an other upper and lower case
		// ByteString aMsg( "warning: source file '" );
		// aMsg += pFile->GetName();
		// aMsg += "' cannot be found. Try case insensitive.";
		// pLog->Log( aMsg );
		aSource = FindSourcefile(pFile, nLang);
	}
	
	if( !aSource.Len() )
	{
		ByteString aFilename;
		if( pFile->GetScpExtSearchName().Len() )
			aFilename = pFile->GetScpExtSearchName();
		else
			aFilename = pFile->GetName();

		ByteString aExtSearchFilename = aFilename;

		USHORT nTmp = 0;
		USHORT nPos = STRING_NOTFOUND;
		while( (nTmp = aFilename.Search("/", nTmp)) != STRING_NOTFOUND ) {
			nPos = nTmp;
			nTmp += 1;
		}
		if( nPos != STRING_NOTFOUND )
		{
			ByteString aPath( aFilename );
			aPath.Erase( nPos );
			aPath.Erase( 0, 1 );

			aFilename.Erase( 0, nPos+1 );
			aSource = ExtNOCacheSearch( aFilename, aPath, nLang );
			if( aSource.Len() )
			{
				pFile->SetScpExtSearchName( aExtSearchFilename );
				pFile->SetProperty( "Name", aFilename );
			}
		}
	}

	if( !aSource.Len() )
	{
		ByteString aMsg( "error: source file '" );
		aMsg += pFile->GetName();
		aMsg += "' cannot be found.";
		pLog->Log( aMsg );
		return ;
	}

	if( bTestOnly ) return;

	ByteString aOriginalSource(aSource);

	if ( bStripBinaries )
	{
		// If file is an executable or shared library, copy the file to a
		// temporary location and reset aSource to the temporary file so that
		// we can package the stripped file instead of the unstripped original
		// file
#if defined(UNX)
		BOOL bStripCurrent = FALSE;

		ByteString aExecExt( "." );
		aExecExt += MASTER_EXTENSION_UNX;
#ifdef MACOSX
		ByteString aLibExt( ".dylib" );
		ByteString aSys( "strip -S -x " );
#else
		ByteString aLibExt( ".so" );
		ByteString aSys( "strip " );
#endif
		SiDirEntry aStripSource(aSource);
		SiDirEntry aStripDest( aDestinationPath );
		aStripDest += aStripSource.GetName();

		// Check for files with the .bin and .so extensions
		if ( aSource.Equals( aExecExt, aSource.Len() - aExecExt.Len(), aExecExt.Len() ) || aSource.Equals( aLibExt, aSource.Len() - aLibExt.Len(), aLibExt.Len() ) )
			bStripCurrent = TRUE;

		// Check for files with the .bin.* and .so.* extensions (for versioned
		// binaries)
		aExecExt += ".";
		aLibExt += ".";
		if ( aSource.Search( aExecExt ) != STRING_NOTFOUND || aSource.Search( aLibExt ) != STRING_NOTFOUND )
			bStripCurrent = TRUE;

		if ( bStripCurrent )
		{
			FileCopy(aStripSource, aStripDest);
			aSource = aStripDest.GetFull();
			bRemoveIt = TRUE;
			chown( aStripDest.GetFull().GetBuffer(), -1, gr_gid );
			chmod( aStripDest.GetFull().GetBuffer(), S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH );
			aSys += aSource;
 			system( aSys.GetBuffer() );
		}
#endif
	}


	// #99548# replace flag is set, we need some action to this file
	// so first, copy the file
	if (_bScpzipReplaceAction == SCPZIP_REPLACE_TRUE)
	{
		ByteString aMsg( "ReplaceAction starts" );
		pLog->Log( aMsg );

		SiDirEntry aStripSource(aSource);
		SiDirEntry aStripDest( aDestinationPath );
		aStripDest += pFile->GetName();

		aMsg = "copy ";
		aMsg += aStripSource.GetFull();
		aMsg += " ";
		aMsg += aStripDest.GetFull();
		pLog->Log( aMsg );

		FileCopy(aStripSource, aStripDest);

		aSource = aStripDest.GetFull();
		bRemoveIt = TRUE;

		rtl::OUString suSource(aStripDest.GetFullUni() );
		if (!ReplaceStringsInFile(suSource, sal_True) )
		{
			ByteString aMsg = "warning: problems replacing variables in file: ";
			aMsg += ByteString(rtl::OUStringToOString(suSource, osl_getThreadTextEncoding()));
			pLog->Log( aMsg );
		}
		aMsg = "ReplaceAction ends";
		pLog->Log( aMsg );
	}

    if ( aChecksums.Len() )
    {
        ByteString aChecksum;
		rtlDigestError error = calc_md5_checksum( aSource.GetBuffer(), aChecksum );

		if ( rtl_Digest_E_None == error )
        {
            aChecksumsFile << aChecksum.GetBuffer();
            aChecksumsFile << "  ";
            aChecksumsFile << aOriginalSource.GetBuffer();
            aChecksumsFile << "\n";
            aChecksumsFile.Flush();
        }
        else
        {
            ByteString aMsg( "genarating Checksum failed for " );
            aMsg += aOriginalSource;
    		pLog->Log( aMsg );
        }
    }


	SiDirEntry aDestination( aDestinationPath );
	if( pFile->IsArchive() || pFile->IsPacked() )
	{
		ByteString aPackedname;
		if( bOldSetupZIPStyle && pFile->IsSetupZip() )
			aPackedname = "f_0000";
		else
		{
			aPackedname = pFile->IsSetupZip() ?
							ByteString::CreateFromInt32( ++nGlobalSetupID ) :
							ByteString::CreateFromInt32( ++nGlobalID );

			USHORT n = pFile->IsSetupZip()? 3 : 4;
			while( aPackedname.Len() < n )
				aPackedname.Insert( "0", 0 );

			if( pFile->IsSetupZip() )
				aPackedname.Insert( "f0_", 0 );
			else
				aPackedname.Insert( "f_", 0 );
		}

		aDestination += aPackedname;
		if( !pFile->IsSetupZip() && aDestination.Exists() )
			aDestination.Kill();

		if( pFile->IsArchive() )
		{
			SiDirEntry aEntry(aSource);
			FileCopy(aEntry, aDestination);
		}
		else
		{
			_rawZip( aSource, aDestination );
		}

		if( (bOldSetupZIPStyle && !pFile->IsSetupZip()) ||
			!bOldSetupZIPStyle )
		{
			// rename destination
			SiDirEntry aExtension( aDestination );
			aExtension.SetExtension( UniString::CreateFromAscii("zip") );
			aExtension.MoveTo( aDestination );
			if( pFile->IsArchive() || pFile->IsPacked() )
				pFile->SetProperty( "PackedName", aPackedname );
		}
	}
	else
	{
		aDestination += pFile->GetName();
		SiDirEntry aSrcEntry( aSource );

		ByteString aMsg( "copy " );
		aMsg += aSrcEntry.GetFull();
		aMsg += " ";
		aMsg += aDestination.GetFull();

        // when a file has been stripped and is not to be packed it is in place already so don't copy and don't remove it
        if ( aSrcEntry == aDestination )
        {
            bRemoveIt = FALSE;
            aMsg += " (keep)";
        }
	    FileCopy(aSrcEntry, aDestination);

        pLog->Log( aMsg );
	}

	// adjust file properties
	SiDirEntry aEntry;
	if( pFile->IsArchive() ) aEntry = aDestination; else aEntry = aSource;
	FileStat aFileStat( aEntry );
	long nSz = aFileStat.GetSize();
	pFile->SetProperty( "Size", nSz );

	if( bWebScript )
	{
		aEntry = aDestination;
		aFileStat.Update( aEntry );
		nSz = aFileStat.GetSize();
		pFile->SetProperty( "DownloadSize", nSz );
	}

	if( pFile->IsArchive() )
	{
		SiZipFile aZipFile;
		aZipFile.DetectFilesAndSize( aSource );

		pFile->SetProperty( "ArchiveFiles", (long) aZipFile.GetFiles() );
		pFile->SetProperty( "ArchiveSize", (long) aZipFile.GetSize() );
	}
#ifdef UNX
	SiDirEntry aDest( aDestination );
	chown( aDestination.GetFull().GetBuffer(), -1, gr_gid );

	int nOctal	= 0;
	int nRights	= pFile->GetScpUnixRights();

	nOctal 	 = nRights / 100;
	nRights %= 100;
	nOctal  *= 8;
	nOctal  += nRights / 10;
	nRights %= 10;
	nOctal  *= 8;
	nOctal  += nRights;

	chmod( aDestination.GetFull().GetBuffer(), nOctal );
#endif

    if ( bRemoveIt )
	{
		SiDirEntry aSrcEntry( aSource );
		aSrcEntry.Kill();
	}
}

void ZipInstallation( SiModule* pModule )
{
	const SiFileList& rFLst = pModule->GetFileList();
	USHORT i;
	for( i = 0; i < rFLst.Count(); ++i )
	{
		KillingAction();

		SiFile* pFile = rFLst.GetObject(i);
		BOOL bScpzipReplaceAction = SCPZIP_REPLACE_FALSE;
		if (pFile->IsScpzipReplace())
		{
			bScpzipReplaceAction = SCPZIP_REPLACE_TRUE;
		}
		if( pFile->DeleteOnly() )
			continue;

		if( pFile->HasLangRef() )
		{
			for( USHORT xx = 0; xx < aLanguageList.Count(); ++xx )
			{
				USHORT nLang = aLanguageList.GetObject(xx)->nId;
				SiFile* pLangRef = (SiFile*) pFile->GetLangRef( nLang );
				if( pLangRef && pLangRef->GetName().Len() )
				{
					pLangRef->JoinWithParent();
					ZipFile( pLangRef, nLang, bScpzipReplaceAction );
				}
			}
		}
		else
			ZipFile( pFile, nDefLang, bScpzipReplaceAction );
	}

	const SiProfileItemList& rPLst = pModule->GetProfileItemList();
	for( i = 0; i < rPLst.Count(); ++i )
	{
		SiProfileItem* pItem = rPLst.GetObject(i);
		ByteString aVal = pItem->GetValue();
		xub_StrLen nStartPos = aVal.Search( '<' );
		if( nStartPos != STRING_NOTFOUND )
		{
			aVal.SearchAndReplace( "<buildid>", aBuildID );
			if( pItem->HasLangRef() )
			{
				for( USHORT xx = 0; xx < aLanguageList.Count(); ++xx )
				{
					USHORT nLang = aLanguageList.GetObject(xx)->nId;
					SiProfileItem* pLangRef = (SiProfileItem*) pItem->GetLangRef( nLang );
					if( pLangRef ) pLangRef->SetProperty( "Value", aVal );
				}
			}
			else
				pItem->SetProperty( "Value", aVal );
		}
	}

	const SiModuleList* pModuleList = pModule->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
		ZipInstallation( pModuleList->GetObject(x) );
}

///////////////////////////////////////////////////////////////////////////////

void DoScpActions( SiCompiledScript* pCS )
{
	const SiScpActionList& rLst = pCS->GetScpActionList();
	for( USHORT x = 0; x < rLst.Count(); x++ )
	{
		KillingAction();
		SiScpAction* pAction = rLst.GetObject(x);

		////////////////////////////////////////
		// scp copy action
		if( pAction->GetCpySource().Len() && pAction->GetCpyDestination().Len() )
		{
			ByteString aSource( FindSourcefile(pAction->GetCpySource(), nDefLang) );
			ByteString aMsg;
			if( !aSource.Len() )
			{
				aMsg = "error: source file '";
				aMsg += pAction->GetCpySource();
				aMsg += " ";
				aMsg += "' cannot be found.";
				pLog->Log( aMsg );
				continue;
			}

			if( bTestOnly ) continue;

			SiDirEntry aSrc(aSource);
			SiDirEntry aDst(aDestinationPath);
			aDst += pAction->GetCpyDestination();

			aMsg = "copy ";
			aMsg += aSrc.GetFull();
			aMsg += " ";
			aMsg += aDst.GetFull();
			pLog->Log( aMsg );

			FileCopy(aSrc, aDst);

            if ( pAction->IsScpzipReplace() )
            {
                ByteString aMsg( "ReplaceAction starts" );
                pLog->Log( aMsg );

                rtl::OUString suSource( aDst.GetFullUni() );
                if ( !ReplaceStringsInFile( suSource, sal_True ) )
                {
                    ByteString aMsg = "warning: problems replacing variables in file: ";
                    aMsg += ByteString(rtl::OUStringToOString(suSource, osl_getThreadTextEncoding()));
                    pLog->Log( aMsg );
                }
                aMsg = "ReplaceAction ends";
                pLog->Log( aMsg );
            }

		#ifdef UNX
			chown( aDst.GetFull().GetBuffer(), -1, gr_gid );
			chmod( aDst.GetFull().GetBuffer(), S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH );
		#endif
		}
		////////////////////////////////////////
		// scp flat setupzip action
		else if( pAction->GetFlatLoaderZip().Len() )
		{
			ByteString aSource( FindSourcefile(pAction->GetFlatLoaderZip(), nDefLang) );
			ByteString aMsg;

			if( !aSource.Len() )
			{
				ByteString aFilename( pAction->GetFlatLoaderZip() );

				USHORT nTmp = 0;
				USHORT nPos = STRING_NOTFOUND;
				while( (nTmp = aFilename.Search("/", nTmp)) != STRING_NOTFOUND )
				{
					nPos = nTmp;
					nTmp += 1;
				}

				if( nPos != STRING_NOTFOUND )
				{
					ByteString aPath( aFilename );
					aPath.Erase( nPos );
					aPath.Erase( 0, 1 );

					aFilename.Erase( 0, nPos+1 );
					aSource = ExtNOCacheSearch( aFilename, aPath, nDefLang );
				}
			}

			if( !aSource.Len() )
			{
				aMsg = "error: source file '";
				aMsg += pAction->GetFlatLoaderZip();
				aMsg += " ";
				aMsg += "' cannot be found.";
				pLog->Log( aMsg );
				continue;
			}

			if( bTestOnly ) continue;

			ByteString aPackedname = ByteString::CreateFromInt32( ++nGlobalSetupID );
			while( aPackedname.Len() < 3 )
				aPackedname.Insert( "0", 0 );
			aPackedname.Insert( "f0_", 0 );

			SiDirEntry aDestination( aDestinationPath );
			aDestination += aPackedname;

			_rawZip( aSource, aDestination );

            if( !bOldSetupZIPStyle )
		    {
			    // rename destination
			    SiDirEntry aExtension( aDestination );
			    aExtension.SetExtension( UniString::CreateFromAscii("zip") );
			    aExtension.MoveTo( aDestination );
//			    if( pFile->IsArchive() || pFile->IsPacked() )
//				    pFile->SetProperty( "PackedName", aPackedname );
		    }
		}
	}
}

///////////////////////////////////////////////////////////////////////////////

#define _BUF_LEN 32000

void Splitter()
{
	ByteString aMsg( "\nsplit merged file into " );
	aMsg += ByteString::CreateFromInt32( nSplitSize );
	aMsg += " byte blocks:\n";
	pLog->Log( aMsg );

	ByteString aSourceName	( aMergeFilename );
	ByteString aMergeName	( aMergeFilename );
	aSourceName += ".";
	aMergeName += "-000.";

	if( nTargetSystem == 2 )
	{
		aSourceName += MASTER_EXTENSION_UNX;
		aMergeName += MASTER_EXTENSION_UNX;
	}
	else
	{
		aSourceName += MASTER_EXTENSION;
		aMergeName += MASTER_EXTENSION;
	}

	SiDirEntry aSource( aMergeDestinationPath );
	aSource += ByteString( aSourceName );

	SiDirEntry aNewEXE( aSplitDestinationPath );
	aNewEXE += aMergeName;

	SiDirEntry aFirstEXE( aNewEXE );

	SvFileStream aStrm( aSource.GetFullUni(), STREAM_READ );
	SvFileStream* pSplitterStrm = new SvFileStream( aNewEXE.GetFullUni(), STREAM_WRITE | STREAM_TRUNC );

	aMsg = "split: ";
	aMsg += aNewEXE.GetFull();
	pLog->Log( aMsg );

	char cBuf[_BUF_LEN];
	ULONG nActSplitSize = 0;
	USHORT nSplitPart = 0;

	while( !aStrm.IsEof() )
	{
		ULONG nDoRead = _BUF_LEN;
		memset( cBuf, 0, _BUF_LEN );

		if( nActSplitSize < nSplitSize )
			if( nActSplitSize + _BUF_LEN > nSplitSize )
				nDoRead = nSplitSize - nActSplitSize;

		ULONG nRead = aStrm.Read( cBuf, nDoRead );
		nActSplitSize += nRead;

		pSplitterStrm->Write( cBuf, nRead );
		if( nActSplitSize == nSplitSize || aStrm.IsEof() )
		{
			nActSplitSize = 0;
			pSplitterStrm->Close();
			delete pSplitterStrm;
			pSplitterStrm = NULL;
			if( !aStrm.IsEof() )
			{
				ByteString aExtension( ByteString::CreateFromInt32(++nSplitPart) );
				while( aExtension.Len() < 3 )
					aExtension.Insert( "0", 0 );

				USHORT nPos = aMergeName.SearchBackward( '-' );
				ByteString aNewName( aMergeName.Copy(0, nPos+1) );
				aNewName += aExtension;
				aNewName += '.';
				aNewName += JUNK_EXTENSION;

				aNewEXE = aSplitDestinationPath;
				aNewEXE += aNewName;

				pSplitterStrm = new SvFileStream( aNewEXE.GetFullUni(), STREAM_WRITE | STREAM_TRUNC );

				aMsg = "split: ";
				aMsg += aNewEXE.GetFull();
				pLog->Log( aMsg );
			}
		}
	}

	if( pSplitterStrm )
	{
		pSplitterStrm->Close();
		delete pSplitterStrm;
	}
	aStrm.Close();

#ifdef UNX
	chown( aFirstEXE.GetFull().GetBuffer(), -1, gr_gid );
	chmod( aFirstEXE.GetFull().GetBuffer(), S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH );
#endif
}

///////////////////////////////////////////////////////////////////////////////

void MergeFiles()
{
	ByteString aMsg( "merge all files to one (" );
	aMsg += aMergeFilename;
	aMsg += "):";

	ByteString aMergeName( aMergeFilename );
	aMergeName += '.';
	if( nTargetSystem == 2 )
		aMergeName += MASTER_EXTENSION_UNX;
	else
		aMergeName += MASTER_EXTENSION;

	pLog->NewLine();
	pLog->Log( aMsg, TRUE );
	pLog->NewLine();

	SiDirEntry aSetupEXE( aDestinationPath );
	if( nTargetSystem == 2 )
		aSetupEXE += ByteString("setup");
	else
		aSetupEXE += ByteString("setup.exe");

	// quick hack beta 5.2
	if( !aSetupEXE.Exists() )
	{
		aSetupEXE = aDestinationPath;
		if( nTargetSystem == 2 )
			aSetupEXE += ByteString("adabas");
		else
			aSetupEXE += ByteString("adabas.exe");
	}

	SiDirEntry aNewEXE( aMergeDestinationPath );
	aNewEXE += aMergeName;

	if( !aSetupEXE.Exists() )
	{
		aMsg = "error: setup (loader) binary  file '";
    	aMsg += aSetupEXE.GetFull();
	  	aMsg += "' cannot be found.";
		pLog->Log( aMsg );
		return ;
	}

	SvFileStream aNewStrm( aNewEXE.GetFullUni(), STREAM_WRITE | STREAM_TRUNC );
	if( nProcessorType == 1 )           // SPARC
		aNewStrm.SetNumberFormatInt( NUMBERFORMAT_INT_BIGENDIAN );

	SvFileStream aOldStrm( aSetupEXE.GetFullUni(), STREAM_READ );

	FileStat aStat( aSetupEXE );
	ULONG nSz = aStat.GetSize();

	// patch size
	char cBuf[_BUF_LEN];
	while( !aOldStrm.IsEof() )
	{
		memset( cBuf, 0, _BUF_LEN );
		ULONG nRead = aOldStrm.Read( cBuf, _BUF_LEN );

		for( USHORT i = 0; i < nRead; ++i )
			if( cBuf[i] == 'B' && (((ULONG)(i + 15)) <= nRead) )
				if( strncmp(&(cBuf[i]), "BIGFILE:", 8) == 0 )
				{
					ByteString aSz = ByteString::CreateFromInt32(nSz);
                    long nLen = aSz.Len()+1;
                    if ( nLen <= _BUF_LEN - i -8 )
                        strncpy( &(cBuf[i+8]), aSz.GetBuffer(), nLen );
				}
		aNewStrm.Write( cBuf, nRead );
	}
	aOldStrm.Close();
	//! aSetupEXE.Kill();

	SiDirEntry aDirEntry( aMergeDestinationPath );
	SiDirEntry aDataEntry( aMergeDestinationPath );

	aDirEntry	+= ByteString( "~dir.tmp" );
	aDataEntry	+= ByteString( "~data.tmp" );

	SvFileStream aDirStrm( aDirEntry.GetFullUni(), STREAM_READ | STREAM_WRITE | STREAM_TRUNC );
	if( nProcessorType == 1 )           // SPARC
		aDirStrm.SetNumberFormatInt( NUMBERFORMAT_INT_BIGENDIAN );

	// copy files
	ULONG nOffset = 0;
	ULONG nDirCnt = 0;
	Dir aFiles(aDestinationPath, FSYS_KIND_FILE);
    
    USHORT i;
	for( i = 0; i < aFiles.Count(); ++i )
	{
		KillingAction();

		SiDirEntry aEntry(aFiles[i]);
		ByteString aFilename( aEntry.GetName() );
		if( aFilename.CompareIgnoreCaseToAscii(aMergeName)				!= COMPARE_EQUAL &&
			aFilename.CompareIgnoreCaseToAscii(aDirEntry.GetName())		!= COMPARE_EQUAL &&
			aFilename.CompareIgnoreCaseToAscii(aDataEntry.GetName())	!= COMPARE_EQUAL )
		{
			FileStat aFSt( aEntry );

            ULONG nFileSize = aFSt.GetSize();

			aMsg = "merge ";
    		aMsg += aEntry.GetFull();
		  	aMsg += " (offset: ";
		  	aMsg += ByteString::CreateFromInt32( nOffset );
		  	aMsg += " size: ";
		  	aMsg += ByteString::CreateFromInt32( nFileSize );
		  	aMsg += ")";
			pLog->Log( aMsg );

			aDirStrm	<< (ULONG) nOffset;
			aDirStrm	<< (ULONG) nFileSize;
			aDirStrm	<< aEntry.GetName().GetBuffer();
			aDirStrm	<< (char) 0x00;

			nOffset += nFileSize;
			nDirCnt++;

			//! aEntry.Kill();
		}
	}

	aDirStrm.Flush();
	aDirStrm.Seek( STREAM_SEEK_TO_BEGIN );

	aNewStrm << (ULONG) 1;
	aNewStrm << (ULONG) nDirCnt;
	aNewStrm << aDirStrm;
	
    for( i = 0; i < aFiles.Count(); ++i )
	{
		KillingAction();

		SiDirEntry aEntry(aFiles[i]);
		ByteString aFilename( aEntry.GetName() );
		if( aFilename.CompareIgnoreCaseToAscii(aMergeName)				!= COMPARE_EQUAL &&
			aFilename.CompareIgnoreCaseToAscii(aDirEntry.GetName())		!= COMPARE_EQUAL &&
			aFilename.CompareIgnoreCaseToAscii(aDataEntry.GetName())	!= COMPARE_EQUAL )
		{
			SvFileStream aFile( aEntry.GetFullUni(), STREAM_READ );
			aNewStrm	<< aFile;
			aFile.Close();
		}
	}

	aNewStrm.Close();
	aDirStrm.Close();

	aDirEntry.Kill();
#ifdef UNX
	chown( aNewEXE.GetFull().GetBuffer(), -1, gr_gid );
	chmod( aNewEXE.GetFull().GetBuffer(), S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH );
#endif
}

///////////////////////////////////////////////////////////////////////////////
//	Fill SubFiles
///////////////////////////////////////////////////////////////////////////////

void _fillsubfiles_process( SiFile* pFile )
{
	SiDirEntry aPackednameSource( aDestinationPath );
	aPackednameSource += pFile->GetPackedName();

	if( pFile->IsArchive() && pFile->IsPackedName() )
	{
		SiZipFile aZipFile;
		aZipFile.AddSubfileListTo( aPackednameSource.GetFull(), pFile, "*" );
	}

	if( pFile->IsArchive() || pFile->IsPacked() )
	{
		FILE* file = fopen( aPackednameSource.GetFull().GetBuffer(), "rb" );
		sal_uInt32 nCRC = 0;

		if( file ) {
			char buf[1024];
			int num = 0;
			while( ( num = fread( buf, sizeof(char), 1024, file) ) > 0 )
				nCRC = rtl_crc32(nCRC, buf, num);
			fclose( file );
		}
		pFile->SetProperty( "CRC", nCRC );
	}

	if( pFile->GetName().CompareIgnoreCaseToAscii( "readme.txt" ) == COMPARE_EQUAL ||
		pFile->GetName().CompareIgnoreCaseToAscii( "license.txt" ) == COMPARE_EQUAL ||
		pFile->GetName().CompareIgnoreCaseToAscii( "LICENSE" ) == COMPARE_EQUAL ||
		pFile->GetName().CompareIgnoreCaseToAscii( "README" ) == COMPARE_EQUAL )
	{
		SiDirEntry aSrc( aDestinationPath );
		aSrc += UniString( pFile->GetName(), osl_getThreadTextEncoding() );

		SiDirEntry aDest( aWebDestinationPath );
		aDest += UniString( pFile->GetName(), osl_getThreadTextEncoding() );

		FileCopy(aSrc, aDest);
	}
}

void FillSubFiles( SiModule* pModule )
{
	const SiFileList& rFLst = pModule->GetFileList();
	for( USHORT i = 0; i < rFLst.Count(); ++i )
	{
		SiFile* pFile = rFLst.GetObject(i);
		if( pFile->HasLangRef() )
		{
			for( USHORT xx = 0; xx < aLanguageList.Count(); ++xx )
			{
				USHORT nLang = aLanguageList.GetObject(xx)->nId;
				SiFile* pLangRef = (SiFile*) pFile->GetLangRef( nLang );
				if( pLangRef )
				{
					pLangRef->JoinWithParent();
					_fillsubfiles_process( pLangRef );
				}
			}
		}
		else
			_fillsubfiles_process( pFile );
	}

	const SiModuleList* pModuleList = pModule->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
		FillSubFiles( pModuleList->GetObject(x) );
}

///////////////////////////////////////////////////////////////////////////////
//	Search Redundancy
///////////////////////////////////////////////////////////////////////////////
ULONG _searchredundancy_process( SiFile* pAFile, SiFile* pFile, DoneList& rDoneList )
{
	ByteString aDoneID( pFile->GetName() );
	aDoneID += ByteString::CreateFromInt32( pAFile->GetLanguage() );
	aDoneID += pFile->GetID();

	if( rDoneList.Find(aDoneID) != 0 )
		return 0;
	ULONG nSize = 0;

	if( (pAFile->IsPacked() && pFile->IsPacked() ||
		pAFile->IsArchive() && pFile->IsArchive()) &&
		pFile->GetPackedName().Len() && pAFile->GetPackedName().Len() &&
		(pFile->GetPackedName() != pAFile->GetPackedName() ) &&
		pAFile->GetName() == pFile->GetName() && pAFile->GetSize() == pFile->GetSize() )
	{
		rDoneList.Insert( aDoneID, 1 );

		nSize += pAFile->GetSize();

		ByteString aMsg( "eleminate redundancy: " );
		aMsg += pFile->GetPackedName();
		aMsg += " ==now==> ";
		aMsg += pAFile->GetPackedName();
		pLog->Log( aMsg );

		SiDirEntry aEntry( aDestinationPath );
		aEntry += pFile->GetPackedName();
		aEntry.Kill();

		pFile->SetProperty( "PackedName", pAFile->GetPackedName() );
	}

	return nSize;
}

ULONG SearchRedundancy( SiFile* pAFile, SiModule* pStartMod, DoneList& rDoneList )
{
	ULONG nSize = 0;
	const SiFileList& rLst = pStartMod->GetFileList();

	ByteString aDoneID( pAFile->GetName() );
	aDoneID += ByteString::CreateFromInt32( pAFile->GetLanguage() );
	aDoneID += pAFile->GetID();

	if( rDoneList.Find(aDoneID) != 0 )
		return 0;
	rDoneList.Insert( aDoneID, 1 );

	for( USHORT i = 0; i < rLst.Count(); ++i )
	{
		SiFile* pFile = rLst.GetObject(i);

		if( pFile->HasLangRef() )
		{
			for( USHORT xx = 0; xx < aLanguageList.Count(); ++xx )
			{
				USHORT nLang = aLanguageList.GetObject(xx)->nId;
				SiFile* pLangRef = (SiFile*) pFile->GetLangRef( nLang );
				if( pLangRef )
				{
					pLangRef->JoinWithParent();
					nSize += _searchredundancy_process( pAFile, pLangRef, rDoneList );
				}
			}
		}
		else
			nSize += _searchredundancy_process( pAFile, pFile, rDoneList );
	}

	const SiModuleList* pModuleList = pStartMod->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
		nSize += SearchRedundancy( pAFile, pModuleList->GetObject(x), rDoneList );

	return nSize;
}

ULONG OptimizeRedundancy( SiModule* pMod, DoneList& rDoneList, SiModule* pStartMod = NULL )
{
	ULONG nSize = 0;
	if( !pStartMod ) pStartMod = pMod;

	const SiFileList& rLst = pMod->GetFileList();
	for( USHORT i = 0; i < rLst.Count(); ++i )
	{
		SiFile* pFile = rLst.GetObject(i);
		if( pFile->HasLangRef() )
		{
			for( USHORT xx = 0; xx < aLanguageList.Count(); ++xx )
			{
				USHORT nLang = aLanguageList.GetObject(xx)->nId;
				SiFile* pLangRef = (SiFile*) pFile->GetLangRef( nLang );
				if( pLangRef )
				{
					pLangRef->JoinWithParent();
					nSize += SearchRedundancy( pLangRef, pStartMod, rDoneList );
				}
			}
		}
		else
			nSize += SearchRedundancy( pFile, pStartMod, rDoneList );
	}

	const SiModuleList* pModuleList = pMod->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
		nSize += OptimizeRedundancy( pModuleList->GetObject(x), rDoneList, pStartMod );

	return nSize;
}

///////////////////////////////////////////////////////////////////////////////
//	RemoveDeadLanguageFiles
///////////////////////////////////////////////////////////////////////////////
void RemoveDeadLanguageFiles( SiModule* pModule )
{
	const SiFileList& rFLst = pModule->GetFileList();
	for( USHORT i = 0; i < rFLst.Count(); ++i )
	{
		SiFile* pFile = rFLst.GetObject(i);
		if( pFile->DeleteOnly() ) continue;

		if( pFile->HasLangRef() )
		{
			BOOL bRemoveIt = TRUE;
			for( USHORT xx = 0; xx < aLanguageList.Count(); ++xx )
			{
				USHORT nLang = aLanguageList.GetObject(xx)->nId;
				SiFile* pLangRef = (SiFile*) pFile->GetLangRef( nLang );
				if( pLangRef )
					pLangRef->JoinWithParent();
				pLangRef = pLangRef? pLangRef : pFile;
				if( pLangRef && pLangRef->GetName().Len() )
				{
					bRemoveIt = FALSE;
					break;
				}
			}
			if( bRemoveIt )
			{
				ByteString aMsg("warning: no language instance for '");
				aMsg += pFile->GetID();
				aMsg += "', object removed!";
				pLog->Log( aMsg );
				pModule->Remove( pFile );
				i--;
			}
		}
		else if( !pFile->GetName().Len() )
		{
			ByteString aMsg("warning: no language instance for '");
			aMsg += pFile->GetID();
			aMsg += "', object removed!";
			pLog->Log( aMsg );
			pModule->Remove( pFile );
			i--;
		}
	}

	const SiModuleList* pModuleList = pModule->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
		RemoveDeadLanguageFiles( pModuleList->GetObject(x) );
}

// -----------------------------------------------------------------------------
rtl::OUString createReplaceBrackets(rtl::OUString const& _suFrom)
{
    // the variables are coded as ${VAR}
    rtl::OUString suFromComplete( rtl::OUString::createFromAscii( "${" ) );
    suFromComplete += _suFrom;
    suFromComplete += rtl::OUString::createFromAscii( "}" );
	return suFromComplete;
}

rtl::OString createReplaceBrackets(rtl::OString const& _sFrom)
{
    // the variables are coded as ${VAR}
    rtl::OString sFromComplete( "${" );
    sFromComplete += _sFrom;
    sFromComplete += "}";
	return sFromComplete;
}

// -----------------------------------------------------------------------------
// #99548#
rtl::OUString SearchAndReplaceAll(rtl::OUString const& _suThis, rtl::OUString const& _suFrom, rtl::OUString const& _suTo, sal_Int32 &_nReplacements)
{
// DESC: Replace all _suFrom which found in _suThis with _suTo, this function work also is _suThis is > 64KB
// tools/UniString.Search() says 65535 if string not found --> not >64KB save
	sal_Int32 nIdx = 0;
	rtl::OUString suNeu(_suThis);

	while ((nIdx = suNeu.indexOf(_suFrom, nIdx)) != -1)
	{
		rtl::OUString suPre  = suNeu.copy(0, nIdx);
		rtl::OUString suPost = suNeu.copy(nIdx + _suFrom.getLength()); 

		suNeu = suPre;
		suNeu += _suTo;
		suNeu += suPost;
		++_nReplacements;
	}
	return suNeu;
}

rtl::OString SearchAndReplaceAll(rtl::OString const& _sThis, rtl::OString const& _sFrom, rtl::OString const& _sTo, sal_Int32 &_nReplacements)
{
// DESC: Replace all _sFrom which found in _sThis with _sTo, this function work also is _sThis is > 64KB
// tools/UniString.Search() says 65535 if string not found --> not >64KB save
	sal_Int32 nIdx = 0;
	rtl::OString sNeu(_sThis);

	while ((nIdx = sNeu.indexOf(_sFrom, nIdx)) != -1)
	{
		rtl::OString sPre  = sNeu.copy(0, nIdx);
		rtl::OString sPost = sNeu.copy(nIdx + _sFrom.getLength()); 

		sNeu = sPre;
		sNeu += _sTo;
		sNeu += sPost;
		++_nReplacements;
	}
	return sNeu;
}

BOOL ReplaceStringsInFile(rtl::OUString const& _suFileName, sal_Bool bEncodingIsUTF8 )
{
	// read file as char
	
	SvFileStream aReadStrm(_suFileName, STREAM_READ);
	if( !aReadStrm.IsOpen() )
	{
    	rtl::OString sFileName = rtl::OUStringToOString(_suFileName, osl_getThreadTextEncoding());
		ByteString aSys( "error in ReplaceStringsInFile(): can not open source file ");
		aSys += ByteString(sFileName);
		if (pLog) pLog->Log( aSys );
		return FALSE;
	}
	
    aReadStrm.Seek( STREAM_SEEK_TO_END );
    ULONG nLength = aReadStrm.Tell();
    aReadStrm.Seek( STREAM_SEEK_TO_BEGIN );

    char* pBuf = new char[nLength+1];
	ULONG nRead = aReadStrm.Read( pBuf, nLength );
	aReadStrm.Close();
	pBuf[nRead] = 0x00;

    rtl::OUString suStr;
    rtl::OString sStr;
    if ( bEncodingIsUTF8 )
    {
	// convert from UTF8 to UniString
	// UniString suStr( pBuf, RTL_TEXTENCODING_UTF8 );
    	suStr = rtl::OUString(::rtl::OStringToOUString( pBuf, RTL_TEXTENCODING_UTF8 ));
    }
    else
    {
        // Handle as OString to support all encodings
        sStr = rtl::OString( pBuf );

    }
	delete[] pBuf;

	// OUStringBuffer suStrBuf(suStr);

/*
	ULONG nPos;
	while ( ( nPos = aStr.Search( (char) 12 ) ) != STRING_NOTFOUND )
		aStr.Erase( (USHORT)nPos, 1 );
	aTextEdit.SetText( aStr );
*/
	// make changes
	sal_Int32 nReplacements = 0;
	for (int i=0;i<aGlobalAssociation.getCount();++i)
	{
		rtl::OString sKey( createReplaceBrackets(rtl::OUStringToOString( aGlobalAssociation.getFirst(i), osl_getThreadTextEncoding())));
		rtl::OString sValue( rtl::OUStringToOString( aGlobalAssociation.getSecond(i), osl_getThreadTextEncoding()));
        fprintf( stdout, "Replacing %s with %s\n", sKey.getStr(), sValue.getStr() );
        if ( bEncodingIsUTF8 )
        {
		    rtl::OUString suKey(createReplaceBrackets(aGlobalAssociation.getFirst(i)));
		    rtl::OUString suValue(aGlobalAssociation.getSecond(i));
		    suStr = SearchAndReplaceAll(suStr, suKey, suValue, nReplacements);
        }
        else
        {
//		    rtl::OString sKey( rtl::OUStringToOString( aGlobalAssociation.getFirst(i), osl_getThreadTextEncoding()));
//		    rtl::OString sValue( rtl::OUStringToOString( aGlobalAssociation.getSecond(i), osl_getThreadTextEncoding()));
		    sStr = SearchAndReplaceAll(sStr, sKey, sValue, nReplacements);
        }
	}
	
	if (nReplacements > 0)
	{

        if ( bEncodingIsUTF8 )
        {
		    // convert UniString to UTF8 OString
		    sStr = ::rtl::OUStringToOString( suStr, RTL_TEXTENCODING_UTF8 );
        }

		// write file
		SvFileStream aWriteStrm(_suFileName, STREAM_WRITE | STREAM_TRUNC );
		if( !aWriteStrm.IsOpen() )
		{
        	rtl::OString sFileName = rtl::OUStringToOString(_suFileName, osl_getThreadTextEncoding());
			ByteString aSys( "error in ReplaceStringsInFile(): can not open destination file ");
			aSys += ByteString(sFileName);
			if (pLog) pLog->Log( aSys );

			return FALSE;
		}
		ULONG nWrite = aWriteStrm.Write( sStr.getStr(), sStr.getLength() );
		if( nWrite != sStr.getLength() )
		{
        	rtl::OString sFileName = rtl::OUStringToOString(_suFileName, osl_getThreadTextEncoding());
			ByteString aSys( "warning in ReplaceStringsInFile(): len of file differ with written bytes. File: ");
			aSys += ByteString(sFileName);
			if (pLog) pLog->Log( aSys );
		}

		aWriteStrm.Close();
	}
    return TRUE;
}

void ReplaceStringsInFiles(StringList const& _aList)
{
	for (StringList::const_iterator it = _aList.begin();
		 it != _aList.end();
		 ++it)
	{
		rtl::OUString suFileName(suDestinationPath);
		if (nTargetSystem == 0)
		{
			suFileName += ::rtl::OUString::createFromAscii( "\\" );
		}
		else if (nTargetSystem == 2)
		{
			suFileName += ::rtl::OUString::createFromAscii( "/" );
		}
		suFileName += *it;

		if (!ReplaceStringsInFile(suFileName, sal_True))
		{
			ByteString aMsg = "warning: file problems with file: ";
			aMsg += ByteString(rtl::OUStringToOString(suFileName, osl_getThreadTextEncoding()));
			pLog->Log( aMsg );
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
//	main
///////////////////////////////////////////////////////////////////////////////

int __LOADONCALLAPI main( int argv, char** argc )
{
	time_t start_time;
	time_t end_time;
	time( &start_time );

#ifdef UNDER_WINDOWS_DEBUGGING
	DebugBreak();
#endif

	fprintf( stderr, "\nScript Particel Zip (c) 2000 Sun Microsystems\n" );
	if( argv == 1 ) {
		PrintZipUsage();
		exit( -1 );
	}

#ifdef UNX
	//struct group* pgrp = getgrnam("installer");
	//gr_gid = pgrp->gr_gid;
#endif

	///////////////////////////////////////////////////////////////////////////
	// parameter parse & check
	ByteString	aErrorLogFilename;
	ByteString	aScriptFilename;
	ByteString	aIncParam;
	BOOL		bMerge2One = FALSE;
	BOOL		bSplitBig = FALSE;

	ByteString aTitle( "ZIP Protocol " );
	DateTime aNow;
	aTitle += ByteString::CreateFromInt32( aNow.GetDay() );
	aTitle += ".";
	aTitle += ByteString::CreateFromInt32( aNow.GetMonth() );
	aTitle += ".";
	aTitle += ByteString::CreateFromInt32( aNow.GetYear() );
	aTitle += " / ";
	aTitle += ByteString::CreateFromInt32( aNow.GetHour() );
	aTitle += ":";
	aTitle += ByteString::CreateFromInt32( aNow.GetMin() );
	aTitle += ":";
	aTitle += ByteString::CreateFromInt32( aNow.GetSec() );

	pLog = new Protocol( aTitle );
	pLog->DoConsole();

	for( USHORT n = 1; n < argv; n++ )
	{
		if( argc[ n ][ 0 ] == '-' )
		{
			switch( argc[ n ][ 1 ] )
			{
				case 'u': bOldSetupZIPStyle = TRUE;
						  break;

				case 'w': bWebScript = TRUE;
						  break;

				case 'o': bTestOnly = TRUE;
						  break;

				case 'h': {
						  ByteString aTmp( argc[++n] );
						  if( aTmp.CompareIgnoreCaseToAscii("INTEL") == COMPARE_EQUAL )
							nProcessorType = 0;
						  else if( aTmp.CompareIgnoreCaseToAscii("SPARC") == COMPARE_EQUAL )
							nProcessorType = 1;
						  } break;

				case 'e': aErrorLogFilename = argc[ ++n ];
						  break;

				case 'p': aHTMLFilename = argc[ ++n ];
						  break;

				case 'i': aIncParam = argc[ ++n ];
						  break;

				case 'l': {
							ByteString aTmp( argc[ ++n ] );
							USHORT nDelimTok = 0;
							USHORT nTokCount = aTmp.GetTokenCount(PARA_DELIM);
							for( USHORT x = 0; x < nTokCount; ++x )
							{
								ByteString aLang = aTmp.GetToken(0, PARA_DELIM, nDelimTok);
								LangId* pNew = new LangId;
								pNew->nId = (USHORT)aLang.ToInt32();
								aLanguageList.Insert( pNew, LIST_APPEND );
							}
						  } break;

				case 'm':	aMergeFilename = argc[ ++n ];
							aMergeFilename.EraseLeadingChars('\"');
							aMergeFilename.EraseTrailingChars('\"');
							// aMergeFilename += "-000.";
							bMerge2One = TRUE;
							break;

				case 'v':   nVersion = ByteString(argc[++n]).ToInt32();
							break;

				case 'z':   nSplitSize = ByteString(argc[++n]).ToInt32();
							bSplitBig = TRUE;
							break;

				case 'd':	aBasePath = argc[ ++n ];
							break;

				case 's':	aScriptFilename = argc[ ++n ];
							break;

				case 'b':	aBuildID = argc[ ++n ];
							break;

				case 't': {
							ByteString aTmp = argc[ ++n ];
							if( aTmp.CompareIgnoreCaseToAscii("WNT") == COMPARE_EQUAL )
								nTargetSystem = 0;
							else if( aTmp.CompareIgnoreCaseToAscii("OS2") == COMPARE_EQUAL )
								nTargetSystem = 1;
							else if( aTmp.CompareIgnoreCaseToAscii("UNX") == COMPARE_EQUAL )
								nTargetSystem = 2;
							else
								nTargetSystem = USHRT_MAX;
						  } break;
				case 'S': {
							bStripBinaries = TRUE;
						  } break;

				case 'C':
					aChecksums = argc[++n];
					break;
				case 'r':
				{
					// #99548#
					if (argc[ n ][ 2 ] == 'f')
					{
						ByteString sReplacementFiles = argc[ ++n ];
						suReplacementFiles = rtl::OStringToOUString(sReplacementFiles, osl_getThreadTextEncoding());
					}
					else
					{
						ByteString sReplacementValue = argc[ ++n ];
						rtl::OUString suReplacementValue(rtl::OStringToOUString(sReplacementValue, osl_getThreadTextEncoding()));
						aGlobalAssociation.feedDictionary(suReplacementValue);
						bUseReplacement = TRUE;
					}
					break;
				}
			
				default: {
                            ByteString aVal(argc[ n ][1]);
                            if ( aVal.IsNumericAscii() && ( strlen( argc[n] ) == 2 ) )
                            {
							    nCompression = (USHORT) aVal.ToInt32();
                            }
                            else
                            {
                                fprintf( stderr, "\nUnknown Parameter %s\n", argc[n] );
                                PrintZipUsage();
                                exit( -1 );
                            }
						 } break;
			}
		}
	}

	if( !bTestOnly && aErrorLogFilename.Len() )
	{
		SiDirEntry aErrFile( aErrorLogFilename );
		aErrFile.GetPath().MakeDir();
		pLog->DoErrorFile( aErrorLogFilename );
	}

	if( !aLanguageList.Count() )
	{
		LangId* pNew = new LangId;
		pNew->nId = 1;
		aLanguageList.Insert( pNew, LIST_APPEND );
	}

	if( nTargetSystem == USHRT_MAX )
	{
		PrintZipUsage();
		pLog->Log( "error: wrong targetsystem" );
		delete pLog;
		exit( -1 );
	}

	if( !aBasePath.Len() ) {
		PrintZipUsage();
		pLog->Log( "error: no destinationpath" );
		delete pLog;
		exit( -1 );
	}

	if( !aScriptFilename.Len() ) {
		PrintZipUsage();
		pLog->Log( "error: no setup script" );
		delete pLog;
		exit( -1 );
	}

    if ( bSplitBig && !bMerge2One ) {
		PrintZipUsage();
		pLog->Log( "error: cannot split without merging (use '-m')" );
		delete pLog;
		exit( -1 );
	}

   	if( !bTestOnly && aChecksums.Len() )
	{
		SiDirEntry aChecksumsDir( aChecksums );
		aChecksumsDir.GetPath().MakeDir();
		aChecksumsFile.Open( UniString( aChecksums, osl_getThreadTextEncoding()), STREAM_WRITE | STREAM_TRUNC );
	}

	///////////////////////////////////////////////////////////////////////////

	SiDirEntry aScriptFile( aScriptFilename );
	if( !aScriptFile.Exists() ) {
		ByteString aMsg( "error: source '");
		aMsg += aScriptFile.GetFull();
		aMsg += "' cannot be found.";
		pLog->Log( aMsg );
		delete pLog;
		exit( -1 );
	}
	else
	{
		ByteString aLog( "sourcescript: " );
		aLog += aScriptFile.GetFull();
		pLog->Log( aLog );
	}

	SiDirEntry aEntry( aBasePath );
	aEntry += ByteString(NORMAL_DIRNAME);
	aDestinationPath = aEntry.GetFull();

	if( !bTestOnly && !aEntry.Exists() )
		aEntry.MakeDir();
    else
    {
        USHORT nEntries = Dir( aEntry, FSYS_KIND_FILE | FSYS_KIND_DIR ).Count();
        // The Count is only larger than 2 is the path is a directory which is not empty
        // the Count of 2 results from the "." and ".." directory
        if ( nEntries > 2 )
        {
		    pLog->Log( ByteString( "error: Directory not empty: " ).Append( aDestinationPath ) );
		    delete pLog;
		    exit( -1 );
        }
    }

	if( !bTestOnly && bMerge2One )
	{
		aEntry.SetName( UniString::CreateFromAscii(MERGE_DIRNAME) );
		aEntry.MakeDir();
		aMergeDestinationPath = aEntry.GetFull();

		if( bSplitBig )
		{
			aEntry.SetName( UniString::CreateFromAscii(SPLIT_DIRNAME) );
			aEntry.MakeDir();
			aSplitDestinationPath = aEntry.GetFull();
		}
	}
	if( !bTestOnly && bWebScript )
	{
		aEntry.SetName( UniString::CreateFromAscii(WEB_DIRNAME) );
		aEntry.MakeDir();
		aWebDestinationPath = aEntry.GetFull();
	}

	SiAnsiFileStream aStrm;
    aStrm.Open( aScriptFile.GetFullUni(), STREAM_READ );
	if( !aStrm.IsOpen() ) {
		ByteString aMsg( "error: script '");
		aMsg += aScriptFile.GetFull();
		aMsg += "' cannot be open.";
		pLog->Log( aMsg );
		delete pLog;
		exit( -1 );
	}
	OSType eOS = nTargetSystem == 0 ? OSType_WIN :
				 nTargetSystem == 1 ? OSType_OS2 : OSType_UNIX_SOLS;

	///////////////////////////////////////////////////////////////////////////

	ByteString aDefLangStr;
	ByteString aAllLangStr;
	for( USHORT q = 0; q < aLanguageList.Count(); ++q )
	{
		ByteString n( ByteString::CreateFromInt32(aLanguageList.GetObject(q)->nId) );
		if( aAllLangStr.Search(n) == STRING_NOTFOUND )
		{
			if( n.Len() == 1 )
				n.Insert( "0", 0 );
			if( !q )
			{
				aDefLangStr = n;
				nDefLang = (USHORT) aDefLangStr.ToInt32();
			}
			else
				aAllLangStr += ',';
			aAllLangStr += n;
		}
	}

	SiCompiledScript*	pCS = new SiCompiledScript;
	SiCompilerRef		xCompiler = new SiCompiler( aStrm, eOS );

	xCompiler->SetScpZipMode(TRUE);
	xCompiler->NoApplication();
	xCompiler->SetDefDefaultLanguage( aDefLangStr );
	xCompiler->SetDefLanguages( aAllLangStr );

	if( !xCompiler->CompileTo( pCS ) ) {
		pLog->Log( "error: script error." );
		return -1;
	}
	aStrm.Close();

	// do main action
	if( !bTestOnly && aHTMLFilename.Len() )
	{
		SiDirEntry aHTMLFile( aHTMLFilename );
		aHTMLFile.GetPath().MakeDir();
		pLog->DoHTML( aHTMLFilename );
	}

	pLog->Log( aTitle, TRUE );
	pLog->NewLine();

	PreCacheIncludes( aIncParam );
	RemoveDeadLanguageFiles( pCS->GetRootModule() );
	pLog->Log( "\n" );
	DoScpActions( pCS );
	ZipInstallation( pCS->GetRootModule() );

    //GH: Not needed anymore since replacement is done in the setup.inf afterwards by using ${PRODUCTNAME} ...
/*	if (bUseReplacement)
	{
		// replace productname
		ByteString sProductName   (rtl::OUStringToOString(aGlobalAssociation.getSecond("PRODUCTNAME" ), osl_getThreadTextEncoding()));
		ByteString sProductVersion(rtl::OUStringToOString(aGlobalAssociation.getSecond("PRODUCTVERSION" ), osl_getThreadTextEncoding()));
		ByteString sVendorName    (rtl::OUStringToOString(aGlobalAssociation.getSecond("VENDORNAME" ), osl_getThreadTextEncoding()));
		ByteString sVendorVersion (rtl::OUStringToOString(aGlobalAssociation.getSecond("VENDORVERSION" ), osl_getThreadTextEncoding()));
		
		if (sProductName.Len() == 0)
		{
			// HACK
			sProductName = "StarOffice" ;
			ByteString sErr("Error: Productname not set, hardcoded name (");
			sErr += sProductName;
			sErr += ") used.\n";
			pLog->Log( sErr.GetBuffer() );
		}
		if (sProductVersion.Len() == 0)
		{
			// HACK
			sProductVersion = "6.y";
			ByteString sErr("Error: Productversion not set, hardcoded version (");
			sErr += sProductVersion;
			sErr += ") used.\n";
			pLog->Log( sErr );
		}
		
		pCS->GetInstallation()->SetProperty( "ProductName",    sProductName );
		pCS->GetInstallation()->SetProperty( "ProductVersion", sProductVersion);
		pCS->GetInstallation()->SetProperty( "VendorName",     sVendorName);
		pCS->GetInstallation()->SetProperty( "VendorVersion",  sVendorVersion);
	}*/
	

	// optimize script
	DoneList aOptimizeDoneList(1017);
	ULONG nSpareSz = OptimizeRedundancy( pCS->GetRootModule(), aOptimizeDoneList );
	nSpareSz /= 1024;
	ByteString aMsg = "optimize summary: ";
	aMsg += ByteString::CreateFromInt32( nSpareSz );
	aMsg += " kb";
	pLog->Log( aMsg );

	if( bTestOnly ) exit( 0 );

	if( bOldSetupZIPStyle )
	{
		SiDirEntry aExtension(aDestinationPath);
		aExtension += ByteString("f_0000.zip");

		SiDirEntry aDestination(aExtension);
		aDestination.SetExtension( UniString::CreateFromAscii("") );
		aExtension.MoveTo(aDestination);
	}

	SiDirEntry aInstallationScript( aDestinationPath );
	if( nTargetSystem == 0 )
		aInstallationScript += ByteString("setup.inf");
	else
		aInstallationScript += ByteString("setup.ins");

	SiFileStream aOutScriptfile;
	aOutScriptfile.Open( aInstallationScript.GetFullUni(), STREAM_STD_WRITE | STREAM_TRUNC );
	SiDatabase aInstDB( aOutScriptfile );
	pCS->SetSecondLevel(TRUE);
	aInstDB.Create( pCS );
	aOutScriptfile.Close();

#ifdef UNX
	chown( aInstallationScript.GetFull().GetBuffer(), -1, gr_gid );
	chmod( aInstallationScript.GetFull().GetBuffer(), S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH );
#endif

	if (!ReplaceStringsInFile(aInstallationScript.GetFullUni(), sal_False) )
	{
		ByteString aMsg = "warning: problems replacing variables in file: ";
		aMsg += aInstallationScript.GetFull();
		pLog->Log( aMsg );
	}

	if( bMerge2One )
	{
		MergeFiles();
		if( bSplitBig )
			Splitter();
	}

	if( bWebScript )
	{
		FillSubFiles( pCS->GetRootModule() );

		SiDirEntry aWebScript( aWebDestinationPath );
		aWebScript += ByteString("webinstdb.inf");

		SiFileStream aOutScriptfile;
		aOutScriptfile.Open( aWebScript.GetFullUni(), STREAM_STD_WRITE | STREAM_TRUNC );

		SiDatabase aInstDB( aOutScriptfile );
		pCS->SetSecondLevel(TRUE);
		aInstDB.Create( pCS );

		aOutScriptfile.Close();
	}

	DeleteSearchCache();

	time( &end_time );
	time_t duration = end_time - start_time;
	struct tm* tm_duration = gmtime( &duration );

	aMsg = "\ntime needed: ";
	aMsg += ByteString::CreateFromInt32( tm_duration->tm_hour );
	aMsg += ":";
	aMsg += ByteString::CreateFromInt32( tm_duration->tm_min );
	aMsg += ":";
	aMsg += ByteString::CreateFromInt32( tm_duration->tm_sec );

	pLog->Log( aMsg );

	delete pCS;
	delete pLog;

	return 0;
}

