/*************************************************************************
 *
 *  $RCSfile: Userw9x.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: hro $ $Date: 2001/11/07 14:34:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//------------------------------------------------------------------------
// includes
//------------------------------------------------------------------------

#ifndef _WINDOWS_
#include <windows.h>
#endif

#include <systools/win32/AutoSystoolInit.hxx>
#include "..\inc\systsettings.h"

//------------------------------------------------------------------------
// forward declaration
//------------------------------------------------------------------------

static void WINAPI User9xInit( );
static void WINAPI User9xDeInit( );

//------------------------------------------------------------------------
// global object, used to automatically initialize the systools 
//------------------------------------------------------------------------

static OAutoSystoolInit initUser9x( User9xInit, User9xDeInit );

//------------------------------------------------------------------------
// function pointers, used instead of the real functions
//------------------------------------------------------------------------

extern "C"
{

typedef LRESULT ( WINAPI * SendMessageW_Proc_T ) (
	HWND hWnd,		// handle to the destination window
	UINT Msg,		// message
	WPARAM wParam,	// first message parameter
	LPARAM lParam	// second message parameter
);
SendMessageW_Proc_T lpfnSendMessageW;

typedef HWND ( WINAPI * CreateWindowExW_Proc_T ) (
	DWORD dwExStyle,      // extended window style
	LPCWSTR lpClassName,  // registered class name
	LPCWSTR lpWindowName, // window name
	DWORD dwStyle,        // window style
	int x,                // horizontal position of window
	int y,                // vertical position of window
	int nWidth,           // window width
	int nHeight,          // window height
	HWND hWndParent,      // handle to parent or owner window
	HMENU hMenu,          // menu handle or child identifier
	HINSTANCE hInstance,  // handle to application instance
	LPVOID lpParam        // window-creation data
);
CreateWindowExW_Proc_T lpfnCreateWindowExW;

typedef ATOM ( WINAPI * RegisterClassExW_Proc_T ) ( 
	CONST WNDCLASSEXW* lpwcx // class data
);
RegisterClassExW_Proc_T lpfnRegisterClassExW;

typedef BOOL ( WINAPI * UnregisterClassW_Proc_T ) (
	LPCWSTR lpClassName, // class name
	HINSTANCE hInstance	 // handle to application instance
);
UnregisterClassW_Proc_T lpfnUnregisterClassW;

typedef UINT (WINAPI * RegisterClipboardFormatW_Proc_T ) (
	LPCWSTR lpszFormat // name of new format
);
RegisterClipboardFormatW_Proc_T lpfnRegisterClipboardFormatW;

typedef int ( WINAPI * GetClipboardFormatNameW_Proc_T ) (
	UINT   format,			// clipboard format to retrieve
	LPWSTR lpszFormatName,	// format name
	int    cchMaxCount		// length of format name buffer
);
GetClipboardFormatNameW_Proc_T lpfnGetClipboardFormatNameW;

typedef BOOL ( WINAPI * SetWindowTextW_Proc_T ) (
	HWND hWnd,
    LPCWSTR lpString
);
SetWindowTextW_Proc_T lpfnSetWindowTextW;

typedef int ( WINAPI * GetWindowTextW_Proc_T ) (
	HWND hWnd,			// handle to the window or control
	LPWSTR lpString,	// text buffer
	int    nMaxCount		// length of text buffer
);
GetWindowTextW_Proc_T lpfnGetWindowTextW;

typedef BOOL ( WINAPI * InsertMenuItemW_Proc_T ) (
    HMENU hMenu,            // handle to menu
    UINT uItem,             // identifier or position
    BOOL fByPosition,       // meaning of uItem
    LPCMENUITEMINFOW lpmii  // menu item information
);
InsertMenuItemW_Proc_T lpfnInsertMenuItemW;

typedef int ( WINAPI * DrawTextW_Proc_T ) (
    HDC hDC,          // handle to DC
    LPCWSTR lpString, // text to draw
    int nCount,       // text length
    LPRECT lpRect,    // formatting dimensions
    UINT uFormat      // text-drawing options
);
DrawTextW_Proc_T lpfnDrawTextW;

typedef BOOL ( WINAPI * DrawStateW_Proc_T ) (
  HDC hdc,                     // handle to device context
  HBRUSH hbr,                  // handle to brush
  DRAWSTATEPROC lpOutputFunc,  // callback function
  LPARAM lData,                // image information
  WPARAM wData,                // more image information
  int x,                       // horizontal location
  int y,                       // vertical location
  int cx,                      // image width
  int cy,                      // image height
  UINT fuFlags                 // image type and state
);
DrawStateW_Proc_T	lpfnDrawStateW;

} // extern "C"

//------------------------------------------------------------------------
// initialize the user9x systools
//------------------------------------------------------------------------

static void WINAPI User9xInit( )
{
	HMODULE			hModule;
	OSVERSIONINFO	OSVerInfo;
	
	OSVerInfo.dwOSVersionInfoSize = sizeof( OSVERSIONINFO );
	GetVersionEx( &OSVerInfo );	

	// if windows 95/98
	if ( VER_PLATFORM_WIN32_WINDOWS == OSVerInfo.dwPlatformId )
	{		
		hModule = LoadLibraryA( SYSTOOLS_DLL_NAME );
		if ( NULL != hModule )
		{
			lpfnSendMessageW = ( SendMessageW_Proc_T )GetProcAddress(
				hModule, "SendMessageW_9x" );
			lpfnCreateWindowExW = ( CreateWindowExW_Proc_T )GetProcAddress(
				hModule, "CreateWindowExW_9x" );
			lpfnRegisterClassExW = ( RegisterClassExW_Proc_T )GetProcAddress(
				hModule, "RegisterClassExW_9x" );
			lpfnUnregisterClassW = ( UnregisterClassW_Proc_T )GetProcAddress(
				hModule, "UnregisterClassW_9x" );
			lpfnRegisterClipboardFormatW = ( RegisterClipboardFormatW_Proc_T )GetProcAddress(
				hModule, "RegisterClipboardFormatW_9x" );
			lpfnGetClipboardFormatNameW = ( GetClipboardFormatNameW_Proc_T )GetProcAddress( 
				hModule, "GetClipboardFormatNameW_9x" );
			lpfnSetWindowTextW = ( SetWindowTextW_Proc_T )GetProcAddress(
				hModule, "SetWindowTextW_9x" );            
            lpfnGetWindowTextW = ( GetWindowTextW_Proc_T )GetProcAddress(
                hModule, "GetWindowTextW_9x" );			
            lpfnInsertMenuItemW = ( InsertMenuItemW_Proc_T )GetProcAddress(
				hModule, "InsertMenuItemW_9x" );
            lpfnDrawTextW = ( DrawTextW_Proc_T )GetProcAddress(
                hModule, "DrawTextW_9x" );
            lpfnDrawStateW = ( DrawStateW_Proc_T )GetProcAddress(
                hModule, "DrawStateW_9x" );
		}		
	}
	else
	{
		lpfnSendMessageW             = SendMessageW;
		lpfnCreateWindowExW          = CreateWindowExW;
		lpfnRegisterClassExW         = RegisterClassExW;
		lpfnUnregisterClassW         = UnregisterClassW;
		lpfnRegisterClipboardFormatW = RegisterClipboardFormatW;
		lpfnGetClipboardFormatNameW  = GetClipboardFormatNameW;
		lpfnSetWindowTextW           = SetWindowTextW;
        lpfnGetWindowTextW           = GetWindowTextW;
		lpfnInsertMenuItemW          = InsertMenuItemW;
        lpfnDrawTextW                = DrawTextW;
        lpfnDrawStateW               = DrawStateW;
	}
}

//------------------------------------------------------------------------
// deinitialize the user9x systools
//------------------------------------------------------------------------

static void WINAPI User9xDeInit()
{
	// we do not explicitly free the shell9x library but rely
	// on the fact that sal will not be unloaded while the 
	// office is running, so the library will be free at
	// the office shutdown

    // we use this approach in order to unload the w9xucwrp.dll
    // GetModuleHandle will be used in order to avoid a global
    // variable HMODULE which would be set in ...Init
    // if the module handle is valid a LoadLibrary should have
    // been successful
    // nobody should use any of the above function pointer after
    // this call
    HMODULE hModule = GetModuleHandleA( SYSTOOLS_DLL_NAME );
    if ( hModule )
        FreeLibrary( hModule );
}
