/*************************************************************************
 *
 *  $RCSfile: general.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "general.hxx"
#include "sections.hrc"
#include "adrresid.hxx"
#include "datman.hxx"

#define LSTR_FIRST		L"Givenname"
#define LSTR_MIDDLE		L"Additionalnames"
#define LSTR_NAME		L"Surname"
#define LSTR_SUFFIX		L"Suffixes"
#define LSTR_SALUTATION	L"Mailgreeting"
#define LSTR_INITIALS	L"Initials"	
#define LSTR_COMPANY    L"Company"  
#define	LSTR_DEPARTMENT	L"Department"
#define	LSTR_SHOWNNAME	L"Shownname"

AdrGeneralPage::AdrGeneralPage(Window* pParent,AdrDataManagerHdl pDM):
	AdrBasePage(pParent,pDM,AdrResId(RID_TP_GENERAL)),
	aFtFirstMiddle	(this,ResId(FT_FIRST_MIDDLE	)),
	aEdFirst		(this,ResId(ED_FIRST		)),
	aEdMiddle		(this,ResId(ED_MIDDLE		)),
	aFtNameSuffix	(this,ResId(FT_NAME_SUFFIX	)),
	aEdName			(this,ResId(ED_NAME			)),
	aCbSuffix		(this,ResId(CB_SUFFIX		)),
	aFtSalutation	(this,ResId(FT_SALUTATION	)),	
	aCbSalutation	(this,ResId(CB_SALUTATION	)),
	aEdInitials		(this,ResId(ED_INITIALS		)), 
	aFtCompany		(this,ResId(FT_COMPANY      )),          
	aEdCompany		(this,ResId(ED_COMPANY		)),
	aFtDepartment	(this,ResId(FT_DEPARTMENT	)),
	aEdDepartment	(this,ResId(ED_DEPARTMENT	)),
	aFtShownname	(this,ResId(FT_SHOWNNAME	)),
	aEdShownname	(this,ResId(ED_SHOWNNAME	))
{
		FreeResource();

		Sequence<UString> aEmptySeq;
		
		InsertToFieldList(&aEdFirst,		 LSTR_FIRST,	aEmptySeq);
		InsertToFieldList(&aEdMiddle,		 LSTR_MIDDLE,	aEmptySeq);
		InsertToFieldList(&aEdName,			 LSTR_NAME,		aEmptySeq);
		InsertToFieldList(&aCbSuffix,		 LSTR_SUFFIX,	aEmptySeq);
		InsertToFieldList(&aCbSalutation,	 LSTR_SALUTATION,aEmptySeq);
		InsertToFieldList(&aEdInitials,		 LSTR_INITIALS,	aEmptySeq);
		InsertToFieldList(&aEdCompany,		 LSTR_COMPANY,	aEmptySeq);
		InsertToFieldList(&aEdDepartment,	 LSTR_DEPARTMENT,aEmptySeq);
		InsertToFieldList(&aEdShownname,	 LSTR_SHOWNNAME,aEmptySeq);
}


AdrGeneralPage* CreateGeneralPage( Window * pParent, AdrDataManagerHdl ppDM)
{
	AdrGeneralPage* pAdrGeneralPage=NULL;
	Sequence<UString> aEmptySeq;

	if(*ppDM != NULL)
	{
		AdrDataManagerPtr pDM= *ppDM;
		
		if(	pDM -> GetMaxFieldCount(LSTR_FIRST,aEmptySeq) >0 ||
			pDM -> GetMaxFieldCount(LSTR_MIDDLE,aEmptySeq) >0 ||
			pDM -> GetMaxFieldCount(LSTR_NAME,aEmptySeq)   >0 ||
			pDM -> GetMaxFieldCount(LSTR_SALUTATION,aEmptySeq)  >0 ||
			pDM -> GetMaxFieldCount(LSTR_INITIALS,aEmptySeq)>0 ||
			pDM -> GetMaxFieldCount(LSTR_COMPANY,aEmptySeq)	 >0 ||
			pDM -> GetMaxFieldCount(LSTR_DEPARTMENT,aEmptySeq)	 >0 ||
			pDM -> GetMaxFieldCount(LSTR_SHOWNNAME,aEmptySeq)  >0 )
		{
			pAdrGeneralPage = new AdrGeneralPage(pParent,ppDM);
		}
	}
	return pAdrGeneralPage;
}



