/*************************************************************************
 *
 *  $RCSfile: RowSetValue.cxx,v $
 *
 *  $Revision: 1.29 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/19 17:51:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef DBACCESS_CORE_API_ROWSETVALUE_HXX
#include "RowSetValue.hxx"
#endif
#ifndef _CONNECTIVITY_COMMONTOOLS_HXX_
#include <connectivity/CommonTools.hxx>
#endif
#ifndef _DBHELPER_DBCONVERSION_HXX_
#include <connectivity/dbconversion.hxx>
#endif
#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _TOOLS_SOLMATH_HXX
#include <tools/solmath.hxx>
#endif

using namespace dbaccess;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::io;

ORowSetValue::~ORowSetValue()
{
	free();
}
// -----------------------------------------------------------------------------
void ORowSetValue::setTypeKind(sal_Int32 _eType)		
{ 
	if(m_eTypeKind != _eType)
	{
		switch(_eType)
		{
			case DataType::VARCHAR:
			case DataType::CHAR:
			case DataType::DECIMAL:
			case DataType::NUMERIC:
			case DataType::BIGINT:
			case DataType::LONGVARCHAR:
				(*this) = getString();
				break;
			case DataType::DOUBLE:
			case DataType::FLOAT:
			case DataType::REAL:
				(*this) = getDouble();
				break;
			case DataType::TINYINT:
				(*this) = getInt8();
				break;
			case DataType::SMALLINT:
				(*this) = getInt16();
				break;
			case DataType::INTEGER:
				(*this) = getInt32();
				break;
			case DataType::BIT:
				(*this) = getBool();
				break;
			case DataType::DATE:
				(*this) = getDate();
				break;
			case DataType::TIME:
				(*this) = getTime();
				break;
			case DataType::TIMESTAMP:
				(*this) = getDateTime();
				break;
			case DataType::BINARY:
			case DataType::VARBINARY:
			case DataType::LONGVARBINARY:
				(*this) = getSequence();
				break;
			default:
				OSL_ENSURE(0,"ORowSetValue::makeAny(): UNSPUPPORTED TYPE!");
		}
		m_eTypeKind = _eType;
	}
}
// -----------------------------------------------------------------------------
ORowSetValue& ORowSetValue::operator=(const ORowSetValue& _rRH)
{
	if(&_rRH == this)
		return *this;

	if(m_eTypeKind != _rRH.m_eTypeKind || _rRH.m_bNull)
		free();

	m_bBound	= _rRH.m_bBound;
	m_eTypeKind	= _rRH.m_eTypeKind;

	if(m_bNull && !_rRH.m_bNull)
	{
		switch(_rRH.m_eTypeKind)
		{
			case DataType::CHAR:
			case DataType::VARCHAR:
			case DataType::DECIMAL:
			case DataType::NUMERIC:
			case DataType::LONGVARCHAR:
				m_aValue.m_pString = _rRH.m_aValue.m_pString;
				rtl_uString_acquire(m_aValue.m_pString);
				break;
			case DataType::DOUBLE:
			case DataType::FLOAT:
			case DataType::REAL:
				m_aValue.m_pValue	= new double(*(double*)_rRH.m_aValue.m_pValue);
				break;
			case DataType::DATE:
				m_aValue.m_pValue	= new Date(*(Date*)_rRH.m_aValue.m_pValue);
				break;
			case DataType::TIME:
				m_aValue.m_pValue	= new Time(*(Time*)_rRH.m_aValue.m_pValue);
				break;
			case DataType::TIMESTAMP:
				m_aValue.m_pValue	= new DateTime(*(DateTime*)_rRH.m_aValue.m_pValue);
				break;
			case DataType::BINARY:
			case DataType::VARBINARY:
			case DataType::LONGVARBINARY:
				m_aValue.m_pValue	= new Sequence<sal_Int8>(*(Sequence<sal_Int8>*)_rRH.m_aValue.m_pValue);
				break;
			case DataType::BIT:
				m_aValue.m_bBool	= _rRH.m_aValue.m_bBool;
				break;
			case DataType::TINYINT:
			case DataType::SMALLINT:
			case DataType::INTEGER:
				m_aValue.m_nInt32 = _rRH.m_aValue.m_nInt32;
				break;
			default:
				m_aValue.m_pValue	= new Any(*(Any*)_rRH.m_aValue.m_pValue);
		}
	}
	else if(!_rRH.m_bNull)
	{
		switch(_rRH.m_eTypeKind)
		{
			case DataType::CHAR:
			case DataType::VARCHAR:
			case DataType::DECIMAL:
			case DataType::NUMERIC:
			case DataType::LONGVARCHAR:
				(*this) = ::rtl::OUString(_rRH.m_aValue.m_pString);
				break;
			case DataType::DOUBLE:
			case DataType::FLOAT:
			case DataType::REAL:
				(*this) = *(double*)_rRH.m_aValue.m_pValue;
				break;
			case DataType::DATE:
				(*this) = *(Date*)_rRH.m_aValue.m_pValue;
			case DataType::TIME:
				(*this) = *(Time*)_rRH.m_aValue.m_pValue;
				break;
			case DataType::TIMESTAMP:
				(*this) = *(DateTime*)_rRH.m_aValue.m_pValue;
				break;
			case DataType::BINARY:
			case DataType::VARBINARY:
			case DataType::LONGVARBINARY:
				(*this) = *(Sequence<sal_Int8>*)_rRH.m_aValue.m_pValue;
				break;
			case DataType::BIT:
				m_aValue.m_bBool	= _rRH.m_aValue.m_bBool;
				break;
			case DataType::TINYINT:
			case DataType::SMALLINT:
			case DataType::INTEGER:
				m_aValue.m_nInt32 = _rRH.m_aValue.m_nInt32;
				break;
			default:
				(*(Any*)m_aValue.m_pValue)	= (*(Any*)_rRH.m_aValue.m_pValue);
		}
	}

	m_bNull		= _rRH.m_bNull;

	return *this;
}
// -------------------------------------------------------------------------

ORowSetValue& ORowSetValue::operator=(const Date& _rRH)
{
	if(m_eTypeKind != DataType::DATE)
		free();
	if(m_bNull)
	{
		m_aValue.m_pValue = new Date(_rRH);
		m_eTypeKind = DataType::DATE;
	}
	else
		*(Date*)m_aValue.m_pValue = _rRH;

	m_bNull = sal_False;
	return *this;
}
// -------------------------------------------------------------------------
ORowSetValue& ORowSetValue::operator=(const Time& _rRH)
{
	if(m_eTypeKind != DataType::TIME)
		free();
	if(m_bNull)
	{
		m_aValue.m_pValue = new Time(_rRH);
		m_eTypeKind = DataType::TIME;
	}
	else
		*(Time*)m_aValue.m_pValue = _rRH;

	m_bNull = sal_False;
	return *this;
}
// -------------------------------------------------------------------------
ORowSetValue& ORowSetValue::operator=(const DateTime& _rRH)
{
	if(m_eTypeKind != DataType::TIMESTAMP)
		free();
	if(m_bNull)
	{
		m_aValue.m_pValue = new DateTime(_rRH);
		m_eTypeKind = DataType::TIMESTAMP;
	}
	else
		*(DateTime*)m_aValue.m_pValue = _rRH;

	m_bNull = sal_False;

	return *this;
}
// -------------------------------------------------------------------------

ORowSetValue& ORowSetValue::operator=(const ::rtl::OUString& _rRH)
{
	if(m_eTypeKind == DataType::VARCHAR && !m_bNull && m_aValue.m_pString == _rRH.pData)
		return *this;
		
	free();

	m_bNull = sal_False;
	m_aValue.m_pString = _rRH.pData;
	rtl_uString_acquire(m_aValue.m_pString);
	m_eTypeKind = DataType::VARCHAR;

	return *this;
}
// -------------------------------------------------------------------------

ORowSetValue& ORowSetValue::operator=(const double& _rRH)
{
	if(m_eTypeKind != DataType::DOUBLE)
		free();
	if(m_bNull)
	{
		m_aValue.m_pValue = new double(_rRH);
		m_eTypeKind = DataType::DOUBLE;
	}
	else
		*(double*)m_aValue.m_pValue = _rRH;

	m_bNull = sal_False;
	return *this;
}
// -------------------------------------------------------------------------

ORowSetValue& ORowSetValue::operator=(const sal_Int8& _rRH)
{
	if(m_eTypeKind != DataType::TINYINT)
		free();
	
	m_bNull				= sal_False;
	m_aValue.m_nInt8	= _rRH;
	m_eTypeKind			= DataType::TINYINT;
	return *this;
}
// -------------------------------------------------------------------------

ORowSetValue& ORowSetValue::operator=(const sal_Int16& _rRH)
{
	if(m_eTypeKind != DataType::SMALLINT)
		free();
	
	m_bNull				= sal_False;
	m_aValue.m_nInt16	= _rRH;
	m_eTypeKind			= DataType::SMALLINT;
	return *this;
}
// -------------------------------------------------------------------------

ORowSetValue& ORowSetValue::operator=(const sal_Int32& _rRH)
{
	if(m_eTypeKind != DataType::INTEGER)
		free();
	
	m_bNull				= sal_False;
	m_aValue.m_nInt32	= _rRH;
	m_eTypeKind			= DataType::INTEGER;
	return *this;
}
// -------------------------------------------------------------------------

ORowSetValue& ORowSetValue::operator=(const sal_Bool _rRH)
{
	if(m_eTypeKind != DataType::BIT)
		free();
	m_bNull				= sal_False;
	m_aValue.m_bBool	= _rRH;
	m_eTypeKind			= DataType::BIT;
	return *this;
}
// -------------------------------------------------------------------------
ORowSetValue& ORowSetValue::operator=(const sal_Int64& _rRH)
{
	free();
	if(m_bNull)
	{
		m_aValue.m_pValue = new sal_Int64(_rRH);
		m_eTypeKind = DataType::DOUBLE;
	}
	else
		*(sal_Int64*)m_aValue.m_pValue = _rRH;
	m_bNull = sal_False;
	
	return *this;
}
// -------------------------------------------------------------------------
ORowSetValue& ORowSetValue::operator=(const Sequence<sal_Int8>& _rRH)
{
	free();
	if(m_bNull)
	{
		m_aValue.m_pValue = new Sequence<sal_Int8>(_rRH);
	}
	else
		*(Sequence<sal_Int8>*)m_aValue.m_pValue = _rRH;

	m_bNull = sal_False;
	
	return *this;
}
// -------------------------------------------------------------------------
ORowSetValue& ORowSetValue::operator=(const Any& _rAny)
{
	free();
	m_eTypeKind = DataType::OBJECT;
	if(m_bNull)
		m_aValue.m_pValue = new Any(_rAny);
	else
		*(Any*)m_aValue.m_pValue = _rAny;

	m_bNull = sal_False;
	
	return *this;
}
// -------------------------------------------------------------------------

sal_Bool operator==(const Date& _rLH,const Date& _rRH)
{
	return _rLH.Day == _rRH.Day && _rLH.Month == _rRH.Month && _rLH.Year == _rRH.Year;
}
// -------------------------------------------------------------------------

sal_Bool operator==(const Time& _rLH,const Time& _rRH)
{
	return _rLH.Minutes == _rRH.Minutes && _rLH.Hours == _rRH.Hours && _rLH.Seconds == _rRH.Seconds && _rLH.HundredthSeconds == _rRH.HundredthSeconds;
}
// -------------------------------------------------------------------------

sal_Bool operator==(const DateTime& _rLH,const DateTime& _rRH)
{
	return _rLH.Day == _rRH.Day && _rLH.Month == _rRH.Month && _rLH.Year == _rRH.Year &&
		_rLH.Minutes == _rRH.Minutes && _rLH.Hours == _rRH.Hours && _rLH.Seconds == _rRH.Seconds && _rLH.HundredthSeconds == _rRH.HundredthSeconds;
}
// -------------------------------------------------------------------------

ORowSetValue::operator==(const ORowSetValue& _rRH) const
{
	if(m_eTypeKind != _rRH.m_eTypeKind)
		return sal_False;
	if(m_bNull != _rRH.isNull())
		return sal_False;
	if(m_bNull && _rRH.isNull())
		return sal_True;	

	sal_Bool bRet = sal_False;
	switch(m_eTypeKind)
	{
		case DataType::VARCHAR:
		case DataType::CHAR:
		case DataType::DECIMAL:
		case DataType::NUMERIC:
		case DataType::LONGVARCHAR:
		{
			::rtl::OUString aVal1(m_aValue.m_pString);
			::rtl::OUString aVal2(_rRH.m_aValue.m_pString);
			bRet = aVal1 == aVal2;
			break;
		}
		case DataType::DOUBLE:
		case DataType::FLOAT:
		case DataType::REAL:
			bRet = *(double*)m_aValue.m_pValue == *(double*)_rRH.m_aValue.m_pValue;
			break;
		case DataType::TINYINT:
			bRet = m_aValue.m_nInt8 == _rRH.m_aValue.m_nInt8;
			break;
		case DataType::SMALLINT:
			bRet = m_aValue.m_nInt16 == _rRH.m_aValue.m_nInt16;
			break;
		case DataType::INTEGER:
			bRet = m_aValue.m_nInt32 == _rRH.m_aValue.m_nInt32;
			break;
		case DataType::BIT:
			bRet = m_aValue.m_bBool == _rRH.m_aValue.m_bBool;
			break;
		case DataType::DATE:
			bRet = *(Date*)m_aValue.m_pValue == *(Date*)_rRH.m_aValue.m_pValue;
			break;
		case DataType::TIME:
			bRet = *(Time*)m_aValue.m_pValue == *(Time*)_rRH.m_aValue.m_pValue;
			break;
		case DataType::TIMESTAMP:
			bRet = *(DateTime*)m_aValue.m_pValue == *(DateTime*)_rRH.m_aValue.m_pValue;
			break;
		case DataType::BINARY:
		case DataType::VARBINARY:
		case DataType::LONGVARBINARY:
			bRet = sal_False;
			break;
		default:
			OSL_ENSURE(0,"ORowSetValue::operator==(): UNSPUPPORTED TYPE!");
	}
	return bRet;
}
// -------------------------------------------------------------------------
Any ORowSetValue::makeAny() const
{
	Any rValue;
	if(isBound() && !isNull())
	{
		switch(getTypeKind())
		{
			case DataType::CHAR:
			case DataType::VARCHAR:
			case DataType::DECIMAL:
			case DataType::NUMERIC:
			case DataType::LONGVARCHAR:
				rValue <<= (::rtl::OUString)m_aValue.m_pString;
				break;
			case DataType::DOUBLE:
			case DataType::FLOAT:
			case DataType::REAL:
				rValue <<= *(double*)m_aValue.m_pValue;
				break;
			case DataType::DATE:
				rValue <<= *(Date*)m_aValue.m_pValue;
				break;
			case DataType::TIME:
				rValue <<= *(Time*)m_aValue.m_pValue;
				break;
			case DataType::TIMESTAMP:
				rValue <<= *(DateTime*)m_aValue.m_pValue;
				break;
			case DataType::BINARY:
			case DataType::VARBINARY:
			case DataType::LONGVARBINARY:
				rValue <<= *(Sequence<sal_Int8>*)m_aValue.m_pValue;
				break;
			case DataType::OBJECT:
				rValue = getAny();
				break;
			case DataType::BIT:
				rValue.setValue( &m_aValue.m_bBool, ::getCppuBooleanType() );
				break;
			case DataType::TINYINT:
				rValue <<= m_aValue.m_nInt8;
				break;
			case DataType::SMALLINT:
				rValue <<= m_aValue.m_nInt16;
				break;
			case DataType::INTEGER:
				rValue <<= m_aValue.m_nInt32;
				break;
			default:
				OSL_ENSURE(0,"ORowSetValue::makeAny(): UNSPUPPORTED TYPE!");
		}
	}
	return rValue;
}
// -------------------------------------------------------------------------
::rtl::OUString ORowSetValue::getString( ) const
{
	::rtl::OUString aRet;
	if(!m_bNull)
	{
		switch(getTypeKind())
		{
			case DataType::CHAR:
			case DataType::VARCHAR:
			case DataType::DECIMAL:
			case DataType::NUMERIC:
			case DataType::LONGVARCHAR:
				aRet = m_aValue.m_pString;
				break;
			case DataType::DOUBLE:
			case DataType::FLOAT:
			case DataType::REAL:
				{
					String sValue;
					SolarMath::DoubleToString(sValue,(double)*this,'A',INT_MAX,'.',TRUE);
					aRet = sValue;
				}
				break;
			case DataType::DATE:
				aRet = connectivity::toDateString(*this);
				break;
			case DataType::TIME:
				aRet = connectivity::toTimeString(*this);
				break;
			case DataType::TIMESTAMP:
				aRet = connectivity::toDateTimeString(*this);
				break;
			case DataType::BINARY:
			case DataType::VARBINARY:
			case DataType::LONGVARBINARY:
				{
					aRet = ::rtl::OUString::createFromAscii("0x");
					Sequence<sal_Int8> aSeq(getSequence());
					const sal_Int8* pBegin	= aSeq.getConstArray();
					const sal_Int8* pEnd	= pBegin + aSeq.getLength();
					for(;pBegin != pEnd;++pBegin)
						aRet += ::rtl::OUString::valueOf((sal_Int32)*pBegin,16);
				}
				break;
			case DataType::BIT:
				aRet = ::rtl::OUString::valueOf((sal_Int32)(sal_Bool)*this);
				break;
			case DataType::TINYINT:
				aRet = ::rtl::OUString::valueOf((sal_Int32)(sal_Int8)*this);
				break;
			case DataType::SMALLINT:
				aRet = ::rtl::OUString::valueOf((sal_Int32)(sal_Int16)*this);
				break;
			case DataType::INTEGER:
				aRet = ::rtl::OUString::valueOf((sal_Int32)*this);
				break;
			default:
				OSL_ENSURE(0,"ORowSetValue::makeAny(): UNSPUPPORTED TYPE!");
		}
	}
	return aRet;
}
// -------------------------------------------------------------------------
sal_Bool ORowSetValue::getBool()	const
{
	OSL_ENSURE(m_bBound,"Value is not bound!");

	sal_Bool bRet = sal_False;
	if(!m_bNull)
	{
		switch(getTypeKind())
		{
			case DataType::CHAR:
			case DataType::VARCHAR:
			case DataType::DECIMAL:
			case DataType::NUMERIC:
			case DataType::LONGVARCHAR:
				bRet = ::rtl::OUString(m_aValue.m_pString).toInt32() != 0;
				break;
			case DataType::DOUBLE:
			case DataType::FLOAT:
			case DataType::REAL:
				bRet = *(double*)m_aValue.m_pValue != 0.0;
				break;
			case DataType::DATE:
			case DataType::TIME:
			case DataType::TIMESTAMP:
			case DataType::BINARY:
			case DataType::VARBINARY:
			case DataType::LONGVARBINARY:
				OSL_ENSURE(sal_False, "getBool() for this type is not allowed!");
				break;
			case DataType::BIT:
				bRet = m_aValue.m_bBool;
				break;
			case DataType::TINYINT:
				bRet = m_aValue.m_nInt8  != 0;
				break;
			case DataType::SMALLINT:
				bRet = m_aValue.m_nInt16 != 0;
				break;
			case DataType::INTEGER:
				bRet = m_aValue.m_nInt32 != 0;
				break;
			default:
				OSL_ENSURE(0,"ORowSetValue::makeAny(): UNSPUPPORTED TYPE!");
		}
	}
	return bRet;
}
// -------------------------------------------------------------------------
sal_Int8 ORowSetValue::getInt8()	const
{
	OSL_ENSURE(m_bBound,"Value is not bound!");

	sal_Int8 nRet = 0;
	if(!m_bNull)
	{
		switch(getTypeKind())
		{
			case DataType::CHAR:
			case DataType::VARCHAR:
			case DataType::DECIMAL:
			case DataType::NUMERIC:
			case DataType::LONGVARCHAR:
				nRet = (sal_Int8)::rtl::OUString(m_aValue.m_pString).toInt32();
				break;
			case DataType::DOUBLE:
			case DataType::FLOAT:
			case DataType::REAL:
				nRet = (sal_Int8)*(double*)m_aValue.m_pValue;
				break;
			case DataType::DATE:
			case DataType::TIME:
			case DataType::TIMESTAMP:
			case DataType::BINARY:
			case DataType::VARBINARY:
			case DataType::LONGVARBINARY:
				OSL_ENSURE(sal_False, "getInt8() for this type is not allowed!");
				break;
			case DataType::BIT:
				nRet = m_aValue.m_bBool;
				break;
			case DataType::TINYINT:
				nRet = m_aValue.m_nInt8;
				break;
			case DataType::SMALLINT:
				nRet = (sal_Int8)m_aValue.m_nInt16;
				break;
			case DataType::INTEGER:
				nRet = (sal_Int8)m_aValue.m_nInt32;
				break;
			default:
				OSL_ENSURE(0,"ORowSetValue::makeAny(): UNSPUPPORTED TYPE!");
		}
	}
	return nRet;
}
// -------------------------------------------------------------------------
sal_Int16 ORowSetValue::getInt16()	const
{
	OSL_ENSURE(m_bBound,"Value is not bound!");

	sal_Int16 nRet = 0;
	if(!m_bNull)
	{
		switch(getTypeKind())
		{
			case DataType::CHAR:
			case DataType::VARCHAR:
			case DataType::DECIMAL:
			case DataType::NUMERIC:
			case DataType::LONGVARCHAR:
				nRet = (sal_Int16)::rtl::OUString(m_aValue.m_pString).toInt32();
				break;
			case DataType::DOUBLE:
			case DataType::FLOAT:
			case DataType::REAL:
				nRet = (sal_Int16)*(double*)m_aValue.m_pValue;
				break;
			case DataType::DATE:
			case DataType::TIME:
			case DataType::TIMESTAMP:
			case DataType::BINARY:
			case DataType::VARBINARY:
			case DataType::LONGVARBINARY:
				OSL_ENSURE(sal_False, "getInt16() for this type is not allowed!");
				break;
			case DataType::BIT:
				nRet = m_aValue.m_bBool;
				break;
			case DataType::TINYINT:
				nRet = m_aValue.m_nInt8;
				break;
			case DataType::SMALLINT:
				nRet = m_aValue.m_nInt16;
				break;
			case DataType::INTEGER:
				nRet = (sal_Int16)m_aValue.m_nInt32;
				break;
			default:
				OSL_ENSURE(0,"ORowSetValue::makeAny(): UNSPUPPORTED TYPE!");
		}
	}
	return nRet;
}
// -------------------------------------------------------------------------
sal_Int32 ORowSetValue::getInt32()	const
{
	OSL_ENSURE(m_bBound,"Value is not bound!");

	sal_Int32 nRet = 0;
	if(!m_bNull)
	{
		switch(getTypeKind())
		{
			case DataType::CHAR:
			case DataType::VARCHAR:
			case DataType::DECIMAL:
			case DataType::NUMERIC:
			case DataType::LONGVARCHAR:
				nRet = ::rtl::OUString(m_aValue.m_pString).toInt32();
				break;
			case DataType::DOUBLE:
			case DataType::FLOAT:
			case DataType::REAL:
				nRet = (sal_Int32)*(double*)m_aValue.m_pValue;
				break;
			case DataType::DATE:
				nRet = dbtools::DBTypeConversion::toDays(*(::com::sun::star::util::Date*)m_aValue.m_pValue);
				break;
			case DataType::TIME:
			case DataType::TIMESTAMP:
			case DataType::BINARY:
			case DataType::VARBINARY:
			case DataType::LONGVARBINARY:
				OSL_ENSURE(sal_False, "getInt32() for this type is not allowed!");
				break;
			case DataType::BIT:
				nRet = m_aValue.m_bBool;
				break;
			case DataType::TINYINT:
				nRet = m_aValue.m_nInt8;
				break;
			case DataType::SMALLINT:
				nRet = m_aValue.m_nInt16;
				break;
			case DataType::INTEGER:
				nRet = m_aValue.m_nInt32;
				break;
			default:
				OSL_ENSURE(0,"ORowSetValue::makeAny(): UNSPUPPORTED TYPE!");
		}
	}
	return nRet;
}
// -------------------------------------------------------------------------
double ORowSetValue::getDouble()	const
{
	OSL_ENSURE(m_bBound,"Value is not bound!");

	double nRet = 0;
	if(!m_bNull)
	{
		switch(getTypeKind())
		{
			case DataType::CHAR:
			case DataType::VARCHAR:
			case DataType::DECIMAL:
			case DataType::NUMERIC:
			case DataType::LONGVARCHAR:
				nRet = ::rtl::OUString(m_aValue.m_pString).toDouble();
				break;
			case DataType::DOUBLE:
			case DataType::FLOAT:
			case DataType::REAL:
				nRet = *(double*)m_aValue.m_pValue;
				break;
			case DataType::DATE:
				nRet = dbtools::DBTypeConversion::toDouble(*(::com::sun::star::util::Date*)m_aValue.m_pValue);
				break;
			case DataType::TIME:
				nRet = dbtools::DBTypeConversion::toDouble(*(::com::sun::star::util::Time*)m_aValue.m_pValue);
				break;
			case DataType::TIMESTAMP:
				nRet = dbtools::DBTypeConversion::toDouble(*(::com::sun::star::util::DateTime*)m_aValue.m_pValue);
				break;
			case DataType::BINARY:
			case DataType::VARBINARY:
			case DataType::LONGVARBINARY:
				OSL_ENSURE(sal_False, "getDouble() for this type is not allowed!");
				break;
			case DataType::BIT:
				nRet = m_aValue.m_bBool;
				break;
			case DataType::TINYINT:
				nRet = m_aValue.m_nInt8;
				break;
			case DataType::SMALLINT:
				nRet = m_aValue.m_nInt16;
				break;
			case DataType::INTEGER:
				nRet = m_aValue.m_nInt32;
				break;
			default:
				OSL_ENSURE(0,"ORowSetValue::makeAny(): UNSPUPPORTED TYPE!");
		}
	}
	return nRet;
}
// -------------------------------------------------------------------------
void ORowSetValue::setFromDouble(const double& _rVal,sal_Int32 _nDatatype)
{
	free();

	m_bNull = sal_False;
	switch(_nDatatype)
	{
		case DataType::CHAR:
		case DataType::VARCHAR:
		case DataType::DECIMAL:
		case DataType::NUMERIC:
		case DataType::LONGVARCHAR:
			{
				String sValue;
				SolarMath::DoubleToString(sValue,_rVal,'A',INT_MAX,'.',TRUE);
				::rtl::OUString aVal = sValue;
				m_aValue.m_pString = aVal.pData;
				rtl_uString_acquire(m_aValue.m_pString);
			}
			break;
		case DataType::DOUBLE:
		case DataType::FLOAT:
		case DataType::REAL:
			m_aValue.m_pValue = new double(_rVal);
			break;
		case DataType::DATE:
			m_aValue.m_pValue = new Date(dbtools::DBTypeConversion::toDate(_rVal));
			break;
		case DataType::TIME:
			m_aValue.m_pValue = new Time(dbtools::DBTypeConversion::toTime(_rVal));
			break;
		case DataType::TIMESTAMP:
			m_aValue.m_pValue = new DateTime(dbtools::DBTypeConversion::toDateTime(_rVal));
			break;
		case DataType::BINARY:
		case DataType::VARBINARY:
		case DataType::LONGVARBINARY:
			OSL_ENSURE(sal_False, "setFromDouble() for this type is not allowed!");
			break;
		case DataType::BIT:
			m_aValue.m_bBool = _rVal != 0.0;
			break;
		case DataType::TINYINT:
			m_aValue.m_nInt8 = (sal_Int8)_rVal;
			break;
		case DataType::SMALLINT:
			m_aValue.m_nInt16 = (sal_Int16)_rVal;
			break;
		case DataType::INTEGER:
			m_aValue.m_nInt32 = (sal_Int32)_rVal;
			break;
		default:
			OSL_ENSURE(0,"ORowSetValue::makeAny(): UNSPUPPORTED TYPE!");
	}
	m_eTypeKind = _nDatatype;
}
// -----------------------------------------------------------------------------
void ORowSetValue::setNull()
{
	free();
	m_bNull = sal_True;
	m_aValue.m_pString = NULL;
}
// -----------------------------------------------------------------------------
::com::sun::star::util::Date ORowSetValue::getDate()		const 
{ 
	OSL_ENSURE(m_bBound,"Value is not bound!");
	switch(m_eTypeKind)
	{
		case ::com::sun::star::sdbc::DataType::DATE:
			if(!m_bNull)
				return *(::com::sun::star::util::Date*)m_aValue.m_pValue; 
	}
	return ::com::sun::star::util::Date();
}
// -----------------------------------------------------------------------------
::com::sun::star::util::Time ORowSetValue::getTime()		const 
{ 
	OSL_ENSURE(m_bBound,"Value is not bound!");
	switch(m_eTypeKind)
	{
		case ::com::sun::star::sdbc::DataType::TIME:
			if(!m_bNull)
				return *(::com::sun::star::util::Time*)m_aValue.m_pValue; 
	}
	return ::com::sun::star::util::Time();
}
// -----------------------------------------------------------------------------
::com::sun::star::util::DateTime ORowSetValue::getDateTime()	const 
{ 
	OSL_ENSURE(m_bBound,"Value is not bound!");
	switch(m_eTypeKind)
	{
		case ::com::sun::star::sdbc::DataType::TIMESTAMP:
			if(!m_bNull)
				return *(::com::sun::star::util::DateTime*)m_aValue.m_pValue; 
	}
	return ::com::sun::star::util::DateTime();
}
// -----------------------------------------------------------------------------
void ORowSetValue::free()
{
	if(!m_bNull)
	{
		switch(m_eTypeKind)
		{
			case ::com::sun::star::sdbc::DataType::CHAR:
			case ::com::sun::star::sdbc::DataType::VARCHAR:
			case ::com::sun::star::sdbc::DataType::DECIMAL:
			case ::com::sun::star::sdbc::DataType::NUMERIC:
			case DataType::LONGVARCHAR:
				OSL_ENSURE(m_aValue.m_pString,"String pointer is null!");
				rtl_uString_release(m_aValue.m_pString);
				m_aValue.m_pString = NULL;
				break;
			case ::com::sun::star::sdbc::DataType::DOUBLE:
			case ::com::sun::star::sdbc::DataType::FLOAT:
			case ::com::sun::star::sdbc::DataType::REAL:
				delete (double*)m_aValue.m_pValue;
				m_aValue.m_pValue = NULL;
				break;
			case ::com::sun::star::sdbc::DataType::DATE:
				delete (::com::sun::star::util::Date*)m_aValue.m_pValue;
				m_aValue.m_pValue = NULL;
				break;
			case ::com::sun::star::sdbc::DataType::TIME:
				delete (::com::sun::star::util::Time*)m_aValue.m_pValue;
				m_aValue.m_pValue = NULL;
				break;
			case ::com::sun::star::sdbc::DataType::TIMESTAMP:
				delete (::com::sun::star::util::DateTime*)m_aValue.m_pValue;
				m_aValue.m_pValue = NULL;
				break;
			case ::com::sun::star::sdbc::DataType::BINARY:
			case ::com::sun::star::sdbc::DataType::VARBINARY:
			case ::com::sun::star::sdbc::DataType::LONGVARBINARY:
				delete static_cast< Sequence<sal_Int8>*>(m_aValue.m_pValue);
				m_aValue.m_pValue = NULL;
				break;
			case ::com::sun::star::sdbc::DataType::OBJECT:
				delete (Any*)m_aValue.m_pValue;
				m_aValue.m_pValue = NULL;
				break;

		}
		m_bNull = sal_True;
	}
}
// -----------------------------------------------------------------------------
Sequence<sal_Int8>	ORowSetValue::getSequence() const
{
	Sequence<sal_Int8> aSeq;
	if (!m_bNull)
	{
		switch(m_eTypeKind)
		{
			case DataType::OBJECT:
			case DataType::CLOB:
			case DataType::BLOB:
			{
				Reference<XInputStream> xStream;
				Any aValue = getAny();
				if(aValue.hasValue())
				{
					aValue >>= xStream;
					if(xStream.is())
						xStream->readBytes(aSeq,xStream->available());
				}
			}
			break;
			case ::com::sun::star::sdbc::DataType::BINARY:
			case ::com::sun::star::sdbc::DataType::VARBINARY:
			case ::com::sun::star::sdbc::DataType::LONGVARBINARY:
				aSeq = *(::com::sun::star::uno::Sequence<sal_Int8>*)m_aValue.m_pValue;
				break;
			default:
				;
		}
	}
	return aSeq;
		
}

