/*************************************************************************
 *
 *  $RCSfile: st_unit.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/11/01 17:13:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_STORE_ST_UNIT_HXX
#define ARY_STORE_ST_UNIT_HXX

// USED SERVICES
    // BASE CLASSES
    // COMPONENTS
#include <vector>
#include <cosv/template/dyn.hxx>
#include <cosv/template/tplutil.hxx>
    // PARAMETERS
#include <ary/x_ary.hxx>


namespace ary
{
namespace store
{


/** @att
    This class is ONLY to be used as element of ::ary::store::Container.
    Any other use may result in unpredictable behaviour.
*/
template <class ELEM>
class StorageUnit
{
  public:
    typedef StorageUnit<ELEM>                               self;
    typedef ELEM                                            element_type;

    // LIFECYCLE
                        StorageUnit()           {}
                        ~StorageUnit()          {}
    // OPERATIONS

    // INQUIRY
    bool                IsEmpty() const         { return bool(pEntity); }
    const element_type &
                        Entity() const          /// @precond bool(pEntity)
                                                { return *pEntity; }
    const element_type *
                        EntityPtr() const       { return pEntity.Ptr(); }
    RCid                EntityClass() const     { return pEntity
                                                    ?   pEntity->ClassId()
                                                    :   RCid(0);
                                                }
    // ACCESS
    /// Deletes an eventually previous present Entity.
    void                Set_Entity(
                            DYN ELEM &          let_drEntity )
                                                { pEntity = &let_drEntity; }
    element_type &      Entity()                /// @precond bool(pEntity)
                                                { return *pEntity; }
    element_type *      EntityPtr()             { return pEntity.Ptr(); }

  private:
    // Forbidden:
                        StorageUnit(const self & i_rOther);
    self &              operator=(const self & i_rOther);

    // DATA
    Dyn<ELEM>           pEntity;
};




}   // namespace store
}   // namespace ary

#endif
