/*************************************************************************
 *
 *  $RCSfile: window.h,v $
 *
 *  $Revision: 1.11.136.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/09 18:13:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_WINDOW_H
#define _SV_WINDOW_H

#ifndef _SV_SV_H
#include <sv.h>
#endif

#ifndef _SV_OUTDEV_HXX
#include <outdev.hxx>
#endif
#ifndef _SV_TIMER_HXX
#include <timer.hxx>
#endif
#ifndef _SV_INPUTCTX_HXX
#include <inputctx.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif

class Window;
class VirtualDevice;

struct SalPaintEvent;
class ImplDevFontList;
class ImplFontCache;

namespace com {
namespace sun {
namespace star {
namespace datatransfer {
namespace clipboard {
    class XClipboard;
}
namespace dnd {
    class XDragSource;
    class XDropTarget;
    class XDropTargetListener;
} } } } }

// ---------------
// - ImplWinData -
// ---------------

struct ImplWinData
{
    UniString*          mpExtOldText;
    USHORT*             mpExtOldAttrAry;
    Rectangle*          mpCursorRect;
    long                mnCursorExtWidth;
    Rectangle*          mpFocusRect;
    Rectangle*          mpTrackRect;
    USHORT              mnTrackFlags;
};

// -------------------
// - ImplOverlapData -
// -------------------

struct ImplOverlapData
{
    VirtualDevice*      mpSaveBackDev;      // Gesicherte Hintergrund-Bitmap
    Region*             mpSaveBackRgn;      // Gesicherte Region, was invalidiert werden muss
    Window*             mpNextBackWin;      // Naechstes Fenster mit Hintergrund-Sicherung
    ULONG               mnSaveBackSize;     // Groesse Bitmap fuer Hintergrund-Sicherung
    BOOL                mbSaveBack;         // TRUE: Background sichern
    BYTE                mnTopLevel;         // Level for Overlap-Window
};

// -----------------
// - ImplFrameData -
// -----------------

struct ImplFrameData
{
    Timer               maPaintTimer;       // paint timer
    InputContext        maOldInputContext;  // Last set Input Context
    Window*             mpNextFrame;        // next frame window
    Window*             mpFirstOverlap;     // first overlap window
    Window*             mpFocusWin;         // focus window (is also set, when frame doesn't have the focous)
    Window*             mpMouseMoveWin;     // last window, where MouseMove() called
    Window*             mpMouseDownWin;     // last window, where MouseButtonDown() called
    Window*             mpFirstBackWin;     // Erstes Overlap-Window mit Hintergrund-Sicherung
    ImplDevFontList*    mpFontList;         // Font-List for this frame
    ImplFontCache*      mpFontCache;        // Font-Cache for this frame
    long                mnDPIX;             // Original Screen Resolution
    long                mnDPIY;             // Original Screen Resolution
    long                mnFontDPIX;         // Original Font Resolution
    long                mnFontDPIY;         // Original Font Resolution
    ImplMapRes          maMapUnitRes;       // for LogicUnitToPixel
    ULONG               mnAllSaveBackSize;  // Groesse aller Bitmaps fuer Hintergrund-Sicherung
    ULONG               mnFocusId;          // FocusId for PostUserLink
    ULONG               mnMouseMoveId;      // MoveId for PostUserLink
    long                mnLastMouseX;       // last x mouse position
    long                mnLastMouseY;       // last y mouse position
    long                mnFirstMouseX;      // first x mouse position by mousebuttondown
    long                mnFirstMouseY;      // first y mouse position by mousebuttondown
    long                mnLastMouseWinX;    // last x mouse position, rel. to pMouseMoveWin
    long                mnLastMouseWinY;    // last y mouse position, rel. to pMouseMoveWin
    USHORT              mnModalMode;        // frame based modal count (app based makes no sense anymore)
    ULONG               mnMouseDownTime;    // mouse button down time for double click
    USHORT              mnClickCount;       // mouse click count
    USHORT              mnFirstMouseCode;   // mouse code by mousebuttondown
    USHORT              mnMouseCode;        // mouse code
    USHORT              mnMouseMode;        // mouse mode
    MapUnit             meMapUnit;          // last MapUnit for LogicUnitToPixel
    BOOL                mbHasFocus;         // focus
    BOOL                mbInMouseMove;      // is MouseMove on stack
    BOOL                mbMouseIn;          // is Mouse inside the frame
    BOOL                mbStartDragCalled;  // is command startdrag called
    BOOL                mbNeedSysWindow;    // set, when FrameSize <= IMPL_MIN_NEEDSYSWIN
    BOOL                mbMinimized;        // set, when FrameSize <= 0
    BOOL                mbStartFocusState;  // FocusState, beim abschicken des Events
    BOOL                mbInSysObjFocusHdl; // Innerhalb vom GetFocus-Handler eines SysChilds
    BOOL                mbInSysObjToTopHdl; // Innerhalb vom ToTop-Handler eines SysChilds
    BOOL                mbSysObjFocus;      // Hat ein SysChild den Focus

    ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDragSource > mxDragSource;
    ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDropTarget > mxDropTarget;
    ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDropTargetListener > mxDropTargetListener;
    ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::clipboard::XClipboard > mxClipboard;
    ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::clipboard::XClipboard > mxSelection;
    
    BOOL                mbInternalDragGestureRecognizer;
    BOOL				mbTriggerHangulHanja;
};

// -----------------
// - Hilfsmethoden -
// -----------------

long ImplHandleMouseEvent( Window* pWindow, USHORT nSVEvent, BOOL bMouseLeave,
                           long nX, long nY, ULONG nMsgTime,
                           USHORT nCode, USHORT nMode );
void ImplHandleResize( Window* pWindow, long nNewWidth, long nNewHeight );

#endif // _SV_WINDOW_H
