/*************************************************************************
 *
 *  $RCSfile: uiitems.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: er $ $Date: 2001/05/13 03:33:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _UIITEMS_HXX
#define _UIITEMS_HXX

#include "pagedesc.hxx"
#include "cmdid.h"
#ifndef _SFXINTITEM_HXX
#include <svtools/intitem.hxx>
#endif
class SwNumRule;
class IntlWrapper;

/*--------------------------------------------------------------------
	Beschreibung: Container fuer FootNote
 --------------------------------------------------------------------*/
class SwPageFtnInfoItem : public SfxPoolItem
{
	SwPageFtnInfo aFtnInfo;

public:

	SwPageFtnInfoItem(const USHORT nId, SwPageFtnInfo& rInfo);
	SwPageFtnInfoItem(const SwPageFtnInfoItem& rItem );
	~SwPageFtnInfoItem();

	virtual SfxPoolItem*    Clone( SfxItemPool *pPool = 0 ) const;
	virtual int             operator==( const SfxPoolItem& ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
									String &rText,
                                    const IntlWrapper*    pIntl = 0 ) const;

    virtual BOOL             QueryValue( com::sun::star::uno::Any& rVal, BYTE nMemberId = 0 ) const;
	virtual	BOOL			 PutValue( const com::sun::star::uno::Any& rVal, BYTE nMemberId = 0 );

    SwPageFtnInfo& GetPageFtnInfo()             { return aFtnInfo; }
	const SwPageFtnInfo& GetPageFtnInfo() const { return aFtnInfo; }
	void SetPageFtnInfo(SwPageFtnInfo& rInf) 	{ aFtnInfo = rInf; }
};

/*******************************************************************/

class SwPtrItem : public SfxPoolItem
{
	void* pMisc;

public:
	SwPtrItem( const USHORT nId = FN_PARAM_GRF_DIALOG, void* pPtr = 0);
	SwPtrItem( const SwPtrItem& rItem );

	virtual SfxPoolItem*    Clone( SfxItemPool *pPool = 0 ) const;
	virtual int             operator==( const SfxPoolItem& ) const;

	void	SetValue(void * pPtr) 	{ pMisc= pPtr; }
	void*	GetValue() const 		{ return pMisc; }
};

/*******************************************************************/

class SwUINumRuleItem : public SfxPoolItem
{
	SwNumRule* pRule;

public:
	SwUINumRuleItem( const String& rName, const USHORT = FN_PARAM_ACT_NUMBER);
	SwUINumRuleItem( const SwNumRule& rRule, const USHORT = FN_PARAM_ACT_NUMBER);
	SwUINumRuleItem( const SwUINumRuleItem& rItem );
	virtual ~SwUINumRuleItem();

	virtual SfxPoolItem*    Clone( SfxItemPool *pPool = 0 ) const;
	virtual int             operator==( const SfxPoolItem& ) const;

	virtual	BOOL        	 QueryValue( com::sun::star::uno::Any& rVal, BYTE nMemberId = 0 ) const;
	virtual	BOOL			 PutValue( const com::sun::star::uno::Any& rVal, BYTE nMemberId = 0 );

	const SwNumRule* GetNumRule() const 		{ return pRule; }
		  SwNumRule* GetNumRule() 				{ return pRule; }
};

/* -----------------17.06.98 17:40-------------------
 *
 * --------------------------------------------------*/
class SwBackgroundDestinationItem : public SfxUInt16Item
{
public:
	SwBackgroundDestinationItem(USHORT  nWhich, USHORT nValue);

	virtual SfxPoolItem*     Clone( SfxItemPool *pPool = 0 ) const;
};

#endif // _UIITEMS_HXX
