/*************************************************************************
 *
 *  $RCSfile: environ.cxx,v $
 *
 *  $Revision: 1.54.80.2.18.3 $
 *
 *  last change: $Author: vg $ $Date: 2004/05/03 16:29:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 - 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _TOOLS_TEMPFILE_HXX
#include <tools/tempfile.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _VOS_SECURITY_HXX_
#include <vos/security.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#include "environ.hxx"
#include "decltor.hxx"
#include "tools/l2txtenc.hxx"
#include "stringhelper.hxx"
#include "agentdlg.hxx"

using namespace osl;

SiEnvironment::SiEnvironment()
{
	pArchive = NULL;
	ClearEnvironment();
}

void SiEnvironment::ClearEnvironment()
{
	if( pArchive )
		delete pArchive;

	m_bParamDestPath					= FALSE;
	m_bBigMode							= FALSE;
	pArchive							= NULL;
	m_bFirstInstallation				= TRUE;
	m_pActiveModuleSet					= NULL;

	m_bInUpdate							= FALSE;
	m_bUpdateNoVersion					= FALSE;
	m_bUpdateOldVersion    				= FALSE;
	m_bUpgradeOldVersion				= FALSE;
	m_bUpdateOldVersionNoRights			= FALSE;
	m_bUpdateOldVersionWrongLanguage	= FALSE;

	m_bReboot							= FALSE;
	m_bLogout							= FALSE;
	m_bDefuseRestart					= FALSE;
	m_bPropagateWinEnvChange 			= FALSE;

	m_bAutoRepair						= TRUE;
	m_bMigrationAvailalbe				= FALSE;
	m_bDoMigration						= FALSE;
	m_nMigrationSize					= 0;

	m_eInstallType 						= IT_INVALID;
	m_bIsLocal							= TRUE;
	m_bInstallFromNet					= FALSE;
	m_bIsResponseWizard					= FALSE;
	m_bIsResponse						= FALSE;
	m_nResponseStep						= 0;
	m_bVerboseMode						= FALSE;
	m_bIsAutoWorkstation				= FALSE;
	m_bInstallOnRoot					= FALSE;

	ByteString aEmpty;

	m_aSuiteName						= aEmpty;
	m_aProductName						= aEmpty;
	m_aStartPath						= aEmpty;
	m_aSourcePath						= aEmpty;
	m_aDestPath							= aEmpty;
	m_anInstalledPath					= aEmpty;

	m_aUserName							= rtl::OUString();
	m_aUserFirstName					= rtl::OUString();
	m_aUserId							= rtl::OUString();
	m_aUserEmail						= rtl::OUString();
	m_aCompanyName						= rtl::OUString();
	m_aStreet							= rtl::OUString();
	m_aZip								= rtl::OUString();
	m_aCity								= rtl::OUString();
	m_aCustomerNr						= rtl::OUString();
	m_aCountry							= rtl::OUString();
	m_nCountry							= 0;

	m_nUILanguage						= 0;
	m_nDefLanguage						= 0;
    m_nLangType                         = 0;

	m_bUIDoNiceLangDefault 				= TRUE;
	m_bHasKHPatched						= FALSE;
	m_bDoOnlineReg						= FALSE;
	m_bNoBasicError						= FALSE;
	m_bVirtualMode						= FALSE;
	m_bTimeCheck						= TRUE;
	m_bNoRegistration					= FALSE;
	m_bDlgPrecreateDir					= FALSE;
	m_bForceReinstall					= FALSE;
	m_bForceDeinstall					= FALSE;

	m_bHackFlag_1						= FALSE;
	m_bHackFlag_2						= FALSE;
	m_bHackFlag_3						= FALSE;
	m_bHackFlag_4						= FALSE;
	m_bHackFlag_5						= FALSE;

	m_bUNOEvil							= FALSE;
    m_bHasVCL                           = TRUE;
	m_bAuseStreamFlush					= FALSE;
    m_bForceRepair                      = FALSE;
    m_bInstallForAll                    = FALSE;
	m_bATToolSupport                    = FALSE; // Accessibility
	m_bIsUpdateOnly                     = FALSE;
	
    m_bCantUpdateNetInst                = FALSE;
    m_bCantUpdateStdInst                = FALSE;
    m_bCantUpdateWrkInst                = FALSE;
    m_bCantUpdateThatVers               = FALSE;
    m_bNoAdminError                     = FALSE;

	ULONG i;
	for( i = 0; i < m_aModSetList.Count(); ++i )
		delete m_aModSetList.GetObject(i);
	m_aModSetList.Clear();

	for( i = 0; i < m_aFollowAppList.Count(); ++i )
		delete m_aFollowAppList.GetObject(i);
	m_aFollowAppList.Clear();

	for( i = 0; i < m_aWorkstationList.Count(); ++i )
		delete m_aWorkstationList.GetObject(i);
	m_aWorkstationList.Clear();

	for( i = 0; i < m_aReplacementList.Count(); ++i )
		delete m_aReplacementList.GetObject(i);
	m_aReplacementList.Clear();

	// Languages
	for( i = 0; i < m_aLangContext.Count(); ++i )
    {
        LanguageContext *pData = m_aLangContext.GetObject(i);
		delete pData;
    }
	m_aLangContext.Clear();

	for( i = 0; i < m_aUILangContext.Count(); ++i )
    {
        LanguageContext *pData = m_aUILangContext.GetObject(i);
		delete pData;
    }
	m_aUILangContext.Clear();

	for( i = 0; i < m_aSwitchCtxInstall.Count(); ++i )
		delete m_aSwitchCtxInstall.GetObject(i);
	m_aSwitchCtxInstall.Clear();

	for( i = 0; i < m_aSwitchCtxDelete.Count(); ++i )
		delete m_aSwitchCtxDelete.GetObject(i);
	m_aSwitchCtxDelete.Clear();
}

SiEnvironment::~SiEnvironment()
{
	ClearEnvironment();
}

void SiEnvironment::SetProductName( const ByteString& rName,
                                    const ByteString& rVersion )
{
	m_aProductName = rName;

    if ( rVersion.Len() )
    {
        m_aProductName += ' ';
        m_aProductName += rVersion;
    }
}

void SiEnvironment::AddReplacement(const ByteString& rTag, const ByteString& rValue, sal_Int16 _nEncoding)
{
	ReplacementEntry* pNew = new ReplacementEntry;

	pNew->aTag = rTag;
	pNew->aValue = rValue;
	pNew->nEncoding = _nEncoding;

	AddReplacementList( pNew );
}

ByteString _getLangStr( USHORT nLang )
{
	switch( nLang )
	{
		case 1 : return ByteString("en-US");
		case 3 : return ByteString("pt");
		case 7 : return ByteString("ru");
		case 26 : return ByteString("ns");
		case 27 : return ByteString("af");
		case 28 : return ByteString("zu");
		case 30 : return ByteString("el");
		case 31 : return ByteString("nl");
		case 33 : return ByteString("fr");
		case 34 : return ByteString("es");
		case 50 : return ByteString("sl");
		case 39 : return ByteString("it");
		case 45 : return ByteString("da");
		case 46 : return ByteString("sv");
		case 47 : return ByteString("nb");
		case 48 : return ByteString("pl");
		case 49 : return ByteString("de");
		case 53 : return ByteString("cy");
		case 77 : return ByteString("et");
		case 79 : return ByteString("nn");
		case 81 : return ByteString("ja");
		case 82 : return ByteString("ko");
		case 86 : return ByteString("zh-CN");
		case 88 : return ByteString("zh-TW");
		case 90 : return ByteString("tr");
		case 96 : return ByteString("ar");
		case 97 : return ByteString("he");
	}
	return ByteString("");
}

void SiEnvironment::InitReplacement( SiInstallMode eIMode )
{
	for( ULONG i = 0; i < m_aReplacementList.Count(); ++i )
		delete m_aReplacementList.GetObject(i);
	m_aReplacementList.Clear();

    ByteString aProgPath = GetProgPath( eIMode );
    AddReplacement( "<progpath>", aProgPath, OSL_GETTHREADTEXTENCODING );

    aProgPath.Convert( OSL_GETTHREADTEXTENCODING, RTL_TEXTENCODING_UTF8 );
    AddReplacement( "<progpath_utf8>", aProgPath, RTL_TEXTENCODING_UTF8 );

    AddReplacement( "<workpath>", GetWorkPath( eIMode ), OSL_GETTHREADTEXTENCODING );

	UniString suProgPath( GetProgPath( eIMode ), osl_getThreadTextEncoding() );
	rtl::OUString suProgPathURL;
	FileBase::getFileURLFromSystemPath( suProgPath, suProgPathURL );
    AddReplacement( "<progpath_url>", ByteString(UniString(suProgPathURL), osl_getThreadTextEncoding()), OSL_GETTHREADTEXTENCODING );

	UniString suWorkPath( GetWorkPath( eIMode ), osl_getThreadTextEncoding() );
	rtl::OUString suWorkPathURL;
	FileBase::getFileURLFromSystemPath( suWorkPath, suWorkPathURL );
    AddReplacement( "<workpath_url>", ByteString(UniString(suWorkPathURL), osl_getThreadTextEncoding()), OSL_GETTHREADTEXTENCODING );

    AddReplacement( "<useraddress>", ByteString(""), OSL_GETTHREADTEXTENCODING );
    //  #i9441# substituted Langcode2TextEncoding with RTL_TEXTENCODING_UTF8
    //  sal_Int16 nLanguage = m_nDefLanguage;
    //  AddReplacement( "<userfirstname>", ByteString(stringhelper::rtlStr2Str(GetUserFirstName()) ,Langcode2TextEncoding(nLanguage)));
    AddReplacement( "<userfirstname>", ByteString(UniString( GetUserFirstName()), RTL_TEXTENCODING_UTF8), RTL_TEXTENCODING_UTF8 );
    AddReplacement( "<username>", 	   ByteString(UniString( GetUserName()),      RTL_TEXTENCODING_UTF8), RTL_TEXTENCODING_UTF8 );
    AddReplacement( "<userid>",   	   ByteString(UniString( GetUserId()),        RTL_TEXTENCODING_UTF8), RTL_TEXTENCODING_UTF8 );
    AddReplacement( "<customernr>",    ByteString(UniString( GetCustomerNr()),    RTL_TEXTENCODING_UTF8), RTL_TEXTENCODING_UTF8 );
    AddReplacement( "<title>",    	   ByteString(UniString( GetTitle()),         RTL_TEXTENCODING_UTF8), RTL_TEXTENCODING_UTF8 );
    AddReplacement( "<email>",    	   ByteString(UniString( GetUserEMail()),     RTL_TEXTENCODING_UTF8), RTL_TEXTENCODING_UTF8 );
    AddReplacement( "<position>", 	   ByteString(UniString( GetPosition()),      RTL_TEXTENCODING_UTF8), RTL_TEXTENCODING_UTF8 );
    AddReplacement( "<city>",  		   ByteString(UniString( GetCity()),          RTL_TEXTENCODING_UTF8), RTL_TEXTENCODING_UTF8 );
    AddReplacement( "<fax>",   		   ByteString(UniString( GetFax()),           RTL_TEXTENCODING_UTF8), RTL_TEXTENCODING_UTF8 );
    AddReplacement( "<telefonwork>",   ByteString(UniString( GetTelefonWork()),   RTL_TEXTENCODING_UTF8), RTL_TEXTENCODING_UTF8 );
    AddReplacement( "<telefonhome>",   ByteString(UniString( GetTelefonHome()),   RTL_TEXTENCODING_UTF8), RTL_TEXTENCODING_UTF8 );
    AddReplacement( "<street>",  	   ByteString(UniString( GetStreet()),        RTL_TEXTENCODING_UTF8), RTL_TEXTENCODING_UTF8 );
    AddReplacement( "<company>", 	   ByteString(UniString( GetCompanyName()),   RTL_TEXTENCODING_UTF8), RTL_TEXTENCODING_UTF8 );
    AddReplacement( "<country>", 	   ByteString(UniString( GetCountry()),       RTL_TEXTENCODING_UTF8), RTL_TEXTENCODING_UTF8 );
    AddReplacement( "<state>",   	   ByteString(UniString( GetState()),         RTL_TEXTENCODING_UTF8), RTL_TEXTENCODING_UTF8 );
    AddReplacement( "<zip>",     	   ByteString(UniString( GetZip()),           RTL_TEXTENCODING_UTF8), RTL_TEXTENCODING_UTF8 );
    AddReplacement( "<ossystem>", OS::GetGUIPath(), OSL_GETTHREADTEXTENCODING );

    UniString aTempFile = TempFile::CreateTempName();
    INetURLObject aTempDir( aTempFile );
    aTempDir.CutLastName();
    AddReplacement( "<temppath_url>", ByteString( aTempDir.GetMainURL(INetURLObject::NO_DECODE), osl_getThreadTextEncoding() ), OSL_GETTHREADTEXTENCODING );

    AddReplacement( "<ssl_encryption>",
            GetCountryIdx() == VEREINIGTE_STAATEN_VON_AMERIKA ||
            GetCountryIdx() == BUNDESREPUBLIK_DEUTSCHLAND ?
            ByteString("2") : ByteString("1"), OSL_GETTHREADTEXTENCODING );

    AddReplacement("<productkey>", GetProductKey() );
    AddReplacement("<suitename>", GetSuiteName() );
    AddReplacement("<productname>", GetProductName() );
    AddReplacement("<singleproductname>", GetSingleProductName() );
    AddReplacement("<productversion>", GetProductVersion() );
    AddReplacement("<internalversion>", GetInternalVersion() );
    AddReplacement("<vendorname>", GetVendorName() );
    AddReplacement("<vendorversion>", GetVendorVersion() );

	ByteString aSingleProductName_NoSpace( GetSingleProductName() );
	aSingleProductName_NoSpace.SearchAndReplaceAll( " ", "_" );
    AddReplacement("<singleproductname_nospace>", aSingleProductName_NoSpace );

	ByteString aInstLanguages;
	for( i = 0; i < m_aLangContext.Count(); ++i )
	{
		LanguageContext* pCtx = m_aLangContext.GetObject(i);

		if( i ) aInstLanguages += "|";
		aInstLanguages += _getLangStr( pCtx->nLanguage == LANG_DEFAULT? GetDefLanguage() : pCtx->nLanguage );
	}
	AddReplacement( "<sequence_languages>", aInstLanguages, OSL_GETTHREADTEXTENCODING );

	::rtl::OUString aConfigDir;
	NAMESPACE_VOS(OSecurity) aSecurity;
	aSecurity.getConfigDir(aConfigDir);
	::rtl::OString oStrConfigDir = ::rtl::OUStringToOString( aConfigDir, RTL_TEXTENCODING_ASCII_US );
	AddReplacement("<configpath>", ByteString(oStrConfigDir), OSL_GETTHREADTEXTENCODING );

	ByteString aMyDocs;
	rtl::OUString suMyDocsURL;

#if defined(WNT)
	AddReplacement("<osshowextension>", WinOS::SHDoShowExtension()?
			ByteString("1") : ByteString("0"), OSL_GETTHREADTEXTENCODING )	;
	AddReplacement( "<osdesktop>", ByteString( WinOS::SHGetSystemDesktopFolderName(), osl_getThreadTextEncoding() ), OSL_GETTHREADTEXTENCODING );
	AddReplacement("<ospersonal>", ByteString( WinOS::SHGetPersonalFolderName(),      osl_getThreadTextEncoding() ), OSL_GETTHREADTEXTENCODING );
	AddReplacement("<osbookmarkdir>", ByteString( WinOS::SHGetFavoritesFolderName(),  osl_getThreadTextEncoding() ), OSL_GETTHREADTEXTENCODING );
	aMyDocs = ByteString(WinOS::SHGetPersonalFolderName(), osl_getThreadTextEncoding());

	UniString aMyDocsUNI( aMyDocs, osl_getThreadTextEncoding() );
	FileBase::getFileURLFromSystemPath( aMyDocsUNI, suMyDocsURL );
#endif
#if defined(UNX)
	//::rtl::OUString aHomeDirURL;
	aSecurity.getHomeDir(suMyDocsURL);
	// ::rtl::OString oStrHomeDir = ::rtl::OUStringToOString( aHomeDir, osl_getThreadTextEncoding() );
	// aMyDocsURL = ByteString(aHomeDirURL);
	rtl::OUString suMyDocs;
	FileBase::getSystemPathFromFileURL( suMyDocsURL, suMyDocs );
	aMyDocs = ByteString(UniString(suMyDocs), osl_getThreadTextEncoding());
#endif

	AddReplacement("<mydocuments>", aMyDocs, OSL_GETTHREADTEXTENCODING );
	AddReplacement("<mydocuments_url>", ByteString(UniString(suMyDocsURL), osl_getThreadTextEncoding()), OSL_GETTHREADTEXTENCODING );

	AddReplacement("<outerpath>", GetOuterDestPath(), OSL_GETTHREADTEXTENCODING);

	if( eIMode == IM_NETWORK )
    {
        AddReplacement( "<installmode>", ByteString( "NETWORK" ), OSL_GETTHREADTEXTENCODING );
    }
    else
    {
        AddReplacement( "<installmode>", ByteString( "STANDALONE" ), OSL_GETTHREADTEXTENCODING );
        AddReplacement( "<user_progpath>", GetProgPath( eIMode ), OSL_GETTHREADTEXTENCODING );
        AddReplacement( "<user_workpath>", GetWorkPath( eIMode ), OSL_GETTHREADTEXTENCODING );
    }

#if defined (UNX)
	if ( (eIMode == IM_NETWORK) && UnixOS::bSOfficeRemoteApplication() )
    {
        AddReplacement( "<exec_host>", UnixOS::rGetExecHostAction() );
        #if !defined (USE_DTACTION)
        AddReplacement( "<display_host>", "-display %DisplayHost%$DISPLAY" );
        #endif
    }
    else
    {
        AddReplacement( "<exec_host>", 	"" );
        #if !defined (USE_DTACTION)
        AddReplacement( "<display_host>", 	"" );
        #endif
    }
#endif
	AddReplacement("<ATToolSupport>", GetATToolSupport(), OSL_GETTHREADTEXTENCODING );
}

void SiEnvironment::UpdateReplacement( const ByteString& rKey,
                                       const ByteString& rValue,
                                       sal_Int16 nEncoding )
{
	const SiReplacementList& rList = GetReplacementList();

    for( ULONG i = 0; i < rList.Count(); i++ )
    {
        ReplacementEntry* pEntry = rList.GetObject(i);

        if( pEntry->aTag.CompareIgnoreCaseToAscii( rKey ) == COMPARE_EQUAL )
        {
			pEntry->aValue = rValue;
            pEntry->nEncoding = nEncoding;
            return;
        }
    }
}

BOOL SiEnvironment::IsHackFlag(USHORT nFlag) const
{
	switch( nFlag )
	{
		case 1 : return m_bHackFlag_1;
		case 2 : return m_bHackFlag_2;
		case 3 : return m_bHackFlag_3;
		case 4 : return m_bHackFlag_4;
		case 5 : return m_bHackFlag_5;
	}
	return FALSE;
}

void SiEnvironment::SetHackFlag(USHORT nFlag)
{
	switch( nFlag )
	{
		case 1 : m_bHackFlag_1 = TRUE; break;
		case 2 : m_bHackFlag_2 = TRUE; break;
		case 3 : m_bHackFlag_3 = TRUE; break;
		case 4 : m_bHackFlag_4 = TRUE; break;
		case 5 : m_bHackFlag_5 = TRUE; break;
	}
}

void SiEnvironment::ClearHackFlag(USHORT nFlag)
{
	switch( nFlag )
	{
		case 1 : m_bHackFlag_1 = FALSE; break;
		case 2 : m_bHackFlag_2 = FALSE; break;
		case 3 : m_bHackFlag_3 = FALSE; break;
		case 4 : m_bHackFlag_4 = FALSE; break;
		case 5 : m_bHackFlag_5 = FALSE; break;
	}
}

void SiEnvironment::AddSwitchContextInstall(LanguageContext* pToAdd)
{
	for( USHORT i = 0; i < m_aSwitchCtxInstall.Count(); ++i )
	{
		LanguageContext* pCmp = m_aSwitchCtxInstall.GetObject(i);
		if( pCmp->nLanguage == pToAdd->nLanguage	&&
			pCmp->isProg	== pToAdd->isProg		&&
			pCmp->isDoc		== pToAdd->isDoc )
			return;
	}
	m_aSwitchCtxInstall.Insert(pToAdd,LIST_APPEND);
}

void SiEnvironment::AddSwitchContextDelete(LanguageContext* pToAdd)
{
	for( USHORT i = 0; i < m_aSwitchCtxDelete.Count(); ++i )
	{
		LanguageContext* pCmp = m_aSwitchCtxDelete.GetObject(i);
		if( pCmp->nLanguage == pToAdd->nLanguage	&&
			pCmp->isProg	== pToAdd->isProg		&&
			pCmp->isDoc		== pToAdd->isDoc )
			return;
	}
	m_aSwitchCtxDelete.Insert(pToAdd,LIST_APPEND);
}

void SiEnvironment::SetArchive(ArchDirectory* pNew, FncFindArch fncFindArch)
{
	if( pArchive )
		delete pArchive;
	pArchive = pNew;
	pArchive->SetFindArchHdl( fncFindArch );
}

void SiEnvironment::InitStartPath()
{
	String anAppFileName( Application::GetAppFileName() );
    SiDirEntry anAppEntry( anAppFileName );
	anAppEntry.ToAbs();

    if ( anAppFileName.Len() )
	    m_aStartPath = ((const SiDirEntry&)anAppEntry.GetPath()).GetFull();
    else
        m_aStartPath = anAppEntry.GetFull();

	SiDirEntry aKHPatch( m_aStartPath );
	aKHPatch += ByteString(KH_PATCH_DETECTOR);
	if( aKHPatch.Exists() )
		m_bHasKHPatched = TRUE;
};

void SiEnvironment::SetUpdateError( const SiEnvironment::UpdateError eError )
{
    switch ( eError )
    {
        case CANT_UPDATE_THAT_VERSION:      m_bCantUpdateThatVers = TRUE; break;
        case CANT_UPDATE_NET_INSTALL:       m_bCantUpdateNetInst = TRUE; break;
        case CANT_UPDATE_STD_INSTALL_NET:   m_bCantUpdateStdInst = TRUE;
                                            m_bCantUpdateWrkInst = FALSE;
                                            break;
        case CANT_UPDATE_STD_INSTALL_WRK:   m_bCantUpdateStdInst = TRUE;
                                            m_bCantUpdateWrkInst = TRUE;
                                            break;
        case CANT_UPDATE_WRK_INSTALL:       m_bCantUpdateWrkInst = TRUE; break;
    }
}

void SiEnvironment::SetUpdateError( const SiInstallMode eSrcInstMode,
                                    const SiInstallMode eDstInstMode )
{
    switch ( eDstInstMode )
    {
        case IM_NETWORK:        m_bCantUpdateNetInst = TRUE;
                                break;
        case IM_STANDALONE:     m_bCantUpdateStdInst = TRUE;
                                m_bCantUpdateWrkInst = ( eSrcInstMode == IM_WORKSTATION );
                                break;
        case IM_WORKSTATION:    m_bCantUpdateWrkInst = TRUE;
                                break;
    }
}

SiEnvironment::UpdateError SiEnvironment::GetUpdateError() const
{
    SiEnvironment::UpdateError eErr;

    if      ( m_bCantUpdateNetInst )            eErr = CANT_UPDATE_NET_INSTALL;
    else if ( m_bCantUpdateStdInst )
    {
        if ( m_bCantUpdateWrkInst )
            eErr = CANT_UPDATE_STD_INSTALL_WRK;
        else
            eErr = CANT_UPDATE_STD_INSTALL_NET;
    }
    else if ( m_bCantUpdateWrkInst )            eErr = CANT_UPDATE_WRK_INSTALL;
    else if ( m_bCantUpdateThatVers )           eErr = CANT_UPDATE_THAT_VERSION;
    else if ( m_bUpdateOldVersionWrongLanguage ) eErr = CANT_UPDATE_WRONG_LANG;
    else if ( m_bUpdateOldVersionNoRights )     eErr = CANT_UPDATE_NO_RIGHTS;
    else if ( m_bIsUpdateOnly )                 eErr = ONLY_UPDATE_ALLOWED;
    else if ( m_bUpdateNoVersion )              eErr = UPDATE_NO_VERSION;
    else                                        eErr = NO_ERR;

    return eErr;
}

///////////////////////////////////////////////////////////////////////////////
//
//		Store Environment
//

#ifdef WNT
ByteString _Setup_ConvertForRegistry( const ByteString rSource );
ByteString _Setup_ConvertFromRegistry( const ByteString rSource );
#endif

#define MAIN_KEY	"HKEY_CURRENT_USER"
#define SUB_KEY		"Software\\Sun Microsystems\\setup\\recycle"

void SiEnvironment::StoreRecycle()
{
#ifdef WNT
    ByteString aTmp;

    WinOS::Register(MAIN_KEY, SUB_KEY, "version",			ByteString::CreateFromInt32(2), FALSE );

    aTmp = Setup_ConvertForRegistry( m_aUserName );
    WinOS::Register(MAIN_KEY, SUB_KEY, "lastname",			aTmp, FALSE );

    aTmp = Setup_ConvertForRegistry( m_aUserFirstName );
    WinOS::Register(MAIN_KEY, SUB_KEY, "firstname",			aTmp, FALSE );

    aTmp = Setup_ConvertForRegistry( m_aStreet );
    WinOS::Register(MAIN_KEY, SUB_KEY, "street",			aTmp, FALSE );

    aTmp = Setup_ConvertForRegistry( m_aZip );
    WinOS::Register(MAIN_KEY, SUB_KEY, "zip",				aTmp, FALSE );

    aTmp = Setup_ConvertForRegistry( m_aCity );
    WinOS::Register(MAIN_KEY, SUB_KEY, "city",				aTmp, FALSE );

    aTmp = Setup_ConvertForRegistry( m_aCountry );
    WinOS::Register(MAIN_KEY, SUB_KEY, "country",			aTmp, FALSE );

    WinOS::Register(MAIN_KEY, SUB_KEY, "countryid",			ByteString::CreateFromInt32(m_nCountry), FALSE );

    aTmp = Setup_ConvertForRegistry( m_aCompanyName );
    WinOS::Register(MAIN_KEY, SUB_KEY, "company",			aTmp, FALSE );

    aTmp = Setup_ConvertForRegistry( m_aCustomerNr );
    WinOS::Register(MAIN_KEY, SUB_KEY, "customernr",		aTmp, FALSE );

    aTmp = Setup_ConvertForRegistry( m_aUserId );
    WinOS::Register(MAIN_KEY, SUB_KEY, "id",				aTmp, FALSE );

    aTmp = Setup_ConvertForRegistry( m_aUserEmail );
    WinOS::Register(MAIN_KEY, SUB_KEY, "email",				aTmp, FALSE );
#else
#endif
}

void SiEnvironment::InitRecycle()
{
#ifdef WNT
    USHORT nVersion			= (USHORT) ByteString(WinOS::GetRegValue(MAIN_KEY, SUB_KEY, "version")).ToInt32();

    m_aUserName				= Setup_ConvertFromRegistry( WinOS::GetRegValue( MAIN_KEY, SUB_KEY, "lastname" ) );
    m_aUserFirstName		= Setup_ConvertFromRegistry( WinOS::GetRegValue( MAIN_KEY, SUB_KEY, "firstname" ) );
    m_aStreet				= Setup_ConvertFromRegistry( WinOS::GetRegValue( MAIN_KEY, SUB_KEY, "street" ) );
    m_aZip					= Setup_ConvertFromRegistry( WinOS::GetRegValue( MAIN_KEY, SUB_KEY, "zip" ) );
    m_aCity					= Setup_ConvertFromRegistry( WinOS::GetRegValue( MAIN_KEY, SUB_KEY, "city" ) );
    m_aCountry				= Setup_ConvertFromRegistry( WinOS::GetRegValue( MAIN_KEY, SUB_KEY, "country" ) );
    m_nCountry				= (USHORT) ByteString(WinOS::GetRegValue(MAIN_KEY, SUB_KEY, "countryid")).ToInt32();
    m_aCompanyName			= Setup_ConvertFromRegistry( WinOS::GetRegValue( MAIN_KEY, SUB_KEY, "company" ) );
    m_aCustomerNr			= Setup_ConvertFromRegistry( WinOS::GetRegValue( MAIN_KEY, SUB_KEY, "customernr" ) );
    m_aUserId				= Setup_ConvertFromRegistry( WinOS::GetRegValue( MAIN_KEY, SUB_KEY, "id" ) );
    m_aUserEmail 			= Setup_ConvertFromRegistry( WinOS::GetRegValue( MAIN_KEY, SUB_KEY, "email" ) );

#else
#endif
}

//------------------------------------------------------------------------------
void SiEnvironment::SetUILanguage( USHORT nNew )
{
    m_nUILanguage = nNew;
    m_nLangType = SvAgentDlg::Lang2LangType( nNew );
}

//------------------------------------------------------------------------------
ByteString SiEnvironment::GetDefaultDestPath( BOOL bWorkStation,
                                              const ByteString &rDefault ) const
{
    ByteString aRet;
#if defined (UNX)

    if ( bWorkStation || IsLocal() )
    {
        ByteString aPath;
        if ( ( GetInstallType() == IT_WORKSTATION ) &&
		       ! rDefault.EqualsIgnoreCaseAscii( ".", 0, 1 ) )
            aPath += '.';
        aPath += rDefault;

        SiDirEntry aUNXDefPath( UnixOS::GetHomeDir() );
        aUNXDefPath += aPath;
        aUNXDefPath.ToAbs();
        aRet = aUNXDefPath.GetFull();
    }
    else
    {
        aRet = "/opt/";

        // append program dir
        ByteString aProgDir( rDefault );
        if ( aProgDir.EqualsIgnoreCaseAscii( ".", 0, 1 ) )
            aProgDir.Erase( 0, 1 );
        aRet += aProgDir;
    }

#elif defined (MAC)

    aRet = MacOS::GetSystemVolumeName();

    if ( !rDefault.EqualsIgnoreCaseAscii( ":". 0, 1 ) )
        aRet += ':';
    aRet += rDefault;

#elif defined (WNT)

    ByteString aStr;
    aRet = rDefault;
    if ( bWorkStation )
    {
        NAMESPACE_VOS(OSecurity) aSecurity;
        ::rtl::OUString aConfigDir;
        aSecurity.getConfigDir(aConfigDir);
        FileBase::getSystemPathFromFileURL( aConfigDir, aConfigDir );
        aStr = ByteString( ::rtl::OUStringToOString( aConfigDir, osl_getThreadTextEncoding() ) );
    }
    else
        aStr = ByteString( WinOS::SHGetUserProgramFilesFolder(), osl_getThreadTextEncoding() );

    if ( aRet.Len() )
        aRet.SearchAndReplace("<winprogpath>", aStr );
    else
        aRet = aStr;

#else

#error "Not implemented yet!"

#endif
    return aRet;
}


#ifdef WNT

ByteString SiEnvironment::Setup_ConvertForRegistry( rtl::OUString const& _rSource )
{
    ByteString aStr( stringhelper::rtlStr2Str(_rSource), Langcode2TextEncoding(m_nDefLanguage) );
	return _Setup_ConvertForRegistry(aStr);
}

ByteString _Setup_ConvertForRegistry( const ByteString rSource )
{
    ByteString aStr( rSource );

    aStr.SearchAndReplaceAll( ByteString( '~' ), ByteString( "~~" ) );
    aStr.SearchAndReplaceAll( '&', '~' );

    return aStr;
}

rtl::OUString SiEnvironment::Setup_ConvertFromRegistry(ByteString const& _rSource)
{
	ByteString sSource(_Setup_ConvertFromRegistry(_rSource));
	UniString suSource(sSource, Langcode2TextEncoding(m_nDefLanguage));
	rtl::OUString aStr(suSource);
	return aStr;
}

ByteString _Setup_ConvertFromRegistry( const ByteString rSource )
{
    // Replace all occurrences of '~' with '&' and all '~~' with '~'
    ByteString aStr( rSource );
    xub_StrLen  nPos = 0;

    while ( STRING_NOTFOUND != ( nPos = aStr.Search( '~', nPos ) ) )
    {
        xub_StrLen nLastPos = nPos;
        nPos = aStr.Search( '~', nPos+1 );

        if ( nPos == nLastPos + 1 )
            aStr.Erase( nLastPos, 1 );
        else
        {
            aStr.SearchAndReplace( '~', '&', nLastPos );
            nPos = nLastPos + 1;
        }
    }

    return aStr;
}
#endif
