/*************************************************************************
 *
 *  $RCSfile: ChainablePropertySet.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: mtg $ $Date: 2001/07/24 20:36:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Martin Gallwey ( gallwey@sun.com )
 *
 *
 ************************************************************************/

#ifndef _COMPHELPER_CHAINABLEPROPERTYSET_HXX_
#include <comphelper/ChainablePropertySet.hxx>
#endif
#ifndef _COMPHELPER_CHAINABLEPROPERTYSETINFO_HXX_
#include <comphelper/ChainablePropertySetInfo.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

using namespace ::rtl;
using namespace ::comphelper;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::beans;
using ::vos::IMutex;

ChainablePropertySet::ChainablePropertySet( comphelper::ChainablePropertySetInfo* pInfo, vos::IMutex *pMutex ) 
	throw()
: mpInfo ( pInfo )
, mxInfo ( pInfo )
, mpMutex ( pMutex )
{
}

ChainablePropertySet::~ChainablePropertySet() 
	throw()
{
}

// XPropertySet
Reference< XPropertySetInfo > SAL_CALL ChainablePropertySet::getPropertySetInfo(  ) 
	throw(RuntimeException)
{
	return mxInfo;
}

void ChainablePropertySet::lockMutex()
{
	if (mpMutex)
		mpMutex->acquire();
}
void ChainablePropertySet::unlockMutex()
{
	if (mpMutex)
		mpMutex->release();
}
void SAL_CALL ChainablePropertySet::setPropertyValue( const ::rtl::OUString& rPropertyName, const Any& rValue ) 
	throw(UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException, RuntimeException)
{
	lockMutex();
	PropertyInfoHash::const_iterator aIter = mpInfo->maMap.find ( rPropertyName );

	if( aIter == mpInfo->maMap.end())
		throw UnknownPropertyException();

	_preSetValues();
	_setSingleValue( *((*aIter).second), rValue );
	_postSetValues();
	unlockMutex();
}

Any SAL_CALL ChainablePropertySet::getPropertyValue( const ::rtl::OUString& rPropertyName ) 
	throw(UnknownPropertyException, WrappedTargetException, RuntimeException)
{
	lockMutex();

	PropertyInfoHash::const_iterator aIter = mpInfo->maMap.find ( rPropertyName );

	if( aIter == mpInfo->maMap.end())
		throw UnknownPropertyException();

	Any aAny;
	_preGetValues ();
	_getSingleValue( *((*aIter).second), aAny );
	_postGetValues ();

	unlockMutex();
	return aAny;
}

void SAL_CALL ChainablePropertySet::addPropertyChangeListener( const ::rtl::OUString& aPropertyName, const Reference< XPropertyChangeListener >& xListener ) 
	throw(UnknownPropertyException, WrappedTargetException, RuntimeException)
{
	// todo
}

void SAL_CALL ChainablePropertySet::removePropertyChangeListener( const ::rtl::OUString& aPropertyName, const Reference< XPropertyChangeListener >& aListener ) 
	throw(UnknownPropertyException, WrappedTargetException, RuntimeException)
{
	// todo
}

void SAL_CALL ChainablePropertySet::addVetoableChangeListener( const ::rtl::OUString& PropertyName, const Reference< XVetoableChangeListener >& aListener ) 
	throw(UnknownPropertyException, WrappedTargetException, RuntimeException)
{
	// todo
}

void SAL_CALL ChainablePropertySet::removeVetoableChangeListener( const ::rtl::OUString& PropertyName, const Reference< XVetoableChangeListener >& aListener ) 
	throw(UnknownPropertyException, WrappedTargetException, RuntimeException)
{
	// todo
}

// XMultiPropertySet
void SAL_CALL ChainablePropertySet::setPropertyValues( const Sequence< ::rtl::OUString >& aPropertyNames, const Sequence< Any >& aValues ) 
	throw(PropertyVetoException, IllegalArgumentException, WrappedTargetException, RuntimeException)
{
	lockMutex();
	const sal_Int32 nCount = aPropertyNames.getLength();

	if( nCount != aValues.getLength() )
		throw IllegalArgumentException();

	if( nCount )
	{
		_preSetValues();

		const Any * pAny = aValues.getConstArray();
		const OUString * pString = aPropertyNames.getConstArray();
		PropertyInfoHash::const_iterator aEnd = mpInfo->maMap.end(), aIter;

		for ( sal_Int32 i = 0; i < nCount; ++i, ++pString, ++pAny )
		{
			aIter = mpInfo->maMap.find ( *pString );
			if ( aIter == aEnd )
				throw UnknownPropertyException();

			_setSingleValue ( *((*aIter).second), *pAny );
		}

		_postSetValues();
	}
	unlockMutex();
}

Sequence< Any > SAL_CALL ChainablePropertySet::getPropertyValues( const Sequence< ::rtl::OUString >& aPropertyNames ) 
	throw(RuntimeException)
{
	lockMutex();
	const sal_Int32 nCount = aPropertyNames.getLength();

	Sequence < Any > aValues ( nCount );

	if( nCount )
	{
		_preGetValues();

		Any * pAny = aValues.getArray();
		const OUString * pString = aPropertyNames.getConstArray();
		PropertyInfoHash::const_iterator aEnd = mpInfo->maMap.end(), aIter;

		for ( sal_Int32 i = 0; i < nCount; ++i, ++pString, ++pAny )
		{
			aIter = mpInfo->maMap.find ( *pString );
			if ( aIter == aEnd )
				throw UnknownPropertyException();

			_getSingleValue ( *((*aIter).second), *pAny );
		}

		_postGetValues();
	}
	unlockMutex();
	return aValues;
}

void SAL_CALL ChainablePropertySet::addPropertiesChangeListener( const Sequence< ::rtl::OUString >& aPropertyNames, const Reference< XPropertiesChangeListener >& xListener ) 
	throw(RuntimeException)
{
	// todo
}

void SAL_CALL ChainablePropertySet::removePropertiesChangeListener( const Reference< XPropertiesChangeListener >& xListener ) 
	throw(RuntimeException)
{
	// todo
}

void SAL_CALL ChainablePropertySet::firePropertiesChangeEvent( const Sequence< ::rtl::OUString >& aPropertyNames, const Reference< XPropertiesChangeListener >& xListener ) 
	throw(RuntimeException)
{
	// todo
}

// XPropertyState
PropertyState SAL_CALL ChainablePropertySet::getPropertyState( const ::rtl::OUString& PropertyName ) 
	throw(UnknownPropertyException, RuntimeException)
{
	PropertyInfoHash::const_iterator aIter =  mpInfo->maMap.find( PropertyName );
	if( aIter == mpInfo->maMap.end())
		throw UnknownPropertyException();

	PropertyState aState;

	_preGetPropertyState();
	_getPropertyState( *((*aIter).second), aState );
	_postGetPropertyState();

	return aState;
}

Sequence< PropertyState > SAL_CALL ChainablePropertySet::getPropertyStates( const Sequence< ::rtl::OUString >& rPropertyNames ) 
	throw(UnknownPropertyException, RuntimeException)
{
	const sal_Int32 nCount = rPropertyNames.getLength();

	Sequence< PropertyState > aStates( nCount );
	if( nCount )
	{
		PropertyState * pState = aStates.getArray();
		const OUString * pString = rPropertyNames.getConstArray();
		PropertyInfoHash::const_iterator aEnd = mpInfo->maMap.end(), aIter;
		_preGetPropertyState();

		for ( sal_Int32 i = 0; i < nCount; ++i, ++pString, ++pState )
		{
			aIter = mpInfo->maMap.find ( *pString );
			if ( aIter == aEnd )
				throw UnknownPropertyException();

			_getPropertyState ( *((*aIter).second), *pState );
		}
		_postGetPropertyState();
	}
	return aStates;
}

void SAL_CALL ChainablePropertySet::setPropertyToDefault( const ::rtl::OUString& rPropertyName ) 
	throw(UnknownPropertyException, RuntimeException)
{
	PropertyInfoHash::const_iterator aIter = mpInfo->maMap.find ( rPropertyName );

	if( aIter == mpInfo->maMap.end())
		throw UnknownPropertyException();
	_setPropertyToDefault( *((*aIter).second) );
}

Any SAL_CALL ChainablePropertySet::getPropertyDefault( const ::rtl::OUString& rPropertyName ) 
	throw(UnknownPropertyException, WrappedTargetException, RuntimeException)
{
	PropertyInfoHash::const_iterator aIter = mpInfo->maMap.find ( rPropertyName );

	if( aIter == mpInfo->maMap.end())
		throw UnknownPropertyException();
	return _getPropertyDefault( *((*aIter).second) );
}

void ChainablePropertySet::_preGetPropertyState ()
	throw(::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::beans::PropertyVetoException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::lang::WrappedTargetException )
{
	OSL_ENSURE( sal_False, "you have to implement this yourself!");
}

void ChainablePropertySet::_getPropertyState( const comphelper::PropertyInfo& rInfo, PropertyState& rStates ) 
	throw(UnknownPropertyException )
{
	OSL_ENSURE( sal_False, "you have to implement this yourself!");
}

void ChainablePropertySet::_postGetPropertyState ()
	throw(::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::beans::PropertyVetoException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::lang::WrappedTargetException )
{
	OSL_ENSURE( sal_False, "you have to implement this yourself!");
}

void ChainablePropertySet::_setPropertyToDefault( const comphelper::PropertyInfo& rInfo )  
	throw(UnknownPropertyException )
{
	OSL_ENSURE( sal_False, "you have to implement this yourself!");
}

Any ChainablePropertySet::_getPropertyDefault( const comphelper::PropertyInfo& rInfo ) 
	throw(UnknownPropertyException, WrappedTargetException )
{
	OSL_ENSURE( sal_False, "you have to implement this yourself!");

	Any aAny;
	return aAny;
}
