/*************************************************************************
 *
 *  $RCSfile: Decompressor.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: abi $ $Date: 2001/06/18 11:59:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _XMLSEARCH_UTIL_DECOMPRESSOR_HXX_
#define _XMLSEARCH_UTIL_DECOMPRESSOR_HXX_

#ifndef INCLUDED_STL_VECTOR
#include <vector>
#define INCLUDED_STL_VECTOR
#endif
#ifndef _XMLSEARCH_EXCEP_XMLSEARCHEXCEPTIONS_HXX_
#include <excep/XmlSearchExceptions.hxx>
#endif
#ifndef _XMLEARCH_UTIL_RANDOMACCESSSTREAM_HXX_
#include <util/RandomAccessStream.hxx>
#endif


namespace xmlsearch {
  
	namespace util {

    
		class CompressorIterator;

    
		class Decompressor
		{
		public:

			Decompressor()
				: toRead_( 0 ),
				  path_( 0 )
			{
			}

			virtual ~Decompressor() { }
	
			virtual sal_Int32 getNextByte() = 0;
      
			sal_Int32 read( sal_Int32 kBits ) throw( xmlsearch::excep::XmlSearchException );

			sal_Int32 ascendingDecode( sal_Int32 k,sal_Int32 start,sal_Int32 *concepts )
				throw( xmlsearch::excep::XmlSearchException );
      
			void ascDecode( sal_Int32 k,std::vector< sal_Int32 >& array) throw( xmlsearch::excep::XmlSearchException );

			void decode(sal_Int32 k, sal_Int32* array ) throw( xmlsearch::excep::XmlSearchException );

			void decode( sal_Int32 k,std::vector< sal_Int32 >& array) throw( xmlsearch::excep::XmlSearchException );
      
			virtual void initReading()
			{
				toRead_ = 0;
			}
      
			bool readNext( sal_Int32 k,CompressorIterator* it) throw( xmlsearch::excep::XmlSearchException );

		private:

			static const sal_Int32 BitsInByte;
			static const sal_Int32 NBits;
      
			sal_Int32 readByte_, toRead_, path_;
      
			sal_Int32 read() throw( xmlsearch::excep::XmlSearchException );

			sal_Int32 countZeroes() throw( xmlsearch::excep::XmlSearchException );
      
		};



    
		class StreamDecompressor
			: public Decompressor
		{
		public:
      
			StreamDecompressor( RandomAccessStream* in )
				: in_( in )
			{
			}
      
			~StreamDecompressor() { }


			virtual sal_Int32 getNextByte();

		private:
      
			RandomAccessStream* in_;
            
		};

    
    
		class ByteArrayDecompressor
			: public Decompressor
		{
		public:
			
			ByteArrayDecompressor( sal_Int32 arrayL,sal_Int8* array,sal_Int32 index )
			{
				initReading(array,arrayL,index);
			}


			~ByteArrayDecompressor() { }
      
			sal_Int32 bytesRead()
			{
				return index_ - index0_;
			}
      

			sal_Int32 getNextByte() throw( xmlsearch::excep::XmlSearchException )
			{
				if( arrayL_ <= index_ )
					throw  xmlsearch::excep::XmlSearchException(
						rtl::OUString::createFromAscii( "ByteArrayDecompressor->getNextByte()" ) );
				return array_[index_++] & 0xFF;
			}

      
		private:
      
			sal_Int32  arrayL_;
			sal_Int8   *array_;

			sal_Int32  index_,index0_;

			void initReading( sal_Int8* array,sal_Int32 arrayL,sal_Int32 index )
			{
				arrayL_ = arrayL;
				array_ = array;
				index_ = index0_ = index;
				Decompressor::initReading();
			}
      
		};
    
    
	}

}


#endif
