/*************************************************************************
 *
 *  $RCSfile: VCLView.m,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2002/08/27 11:57:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *		 - GNU Lesser General Public License Version 2.1
 *		 - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#import <VCLView.h>
#import <VCLWindow.h>

#define _SV_VCLVIEW_M

// -------------
// - VCLView -
// -------------

@implementation VCLView

- (void)drawRect: (NSRect)aRect
{
}

- init
{
	qdRgnResized=0;
	return self;
}

- (void)lockFocus
{
	[super lockFocus];
	
	// [ed] 12/15/01 If we haven't done so yet, adjust the visRgn and clipRgn of the port
	// to match the view.  OS 10.1 changed the default behaviour of the clipping of
	// NSQDViews and they now require initialization.
	
	if(!qdRgnResized)
	{
		RgnHandle tempRgn;
		Rect r;
		
		r.left=0;
		r.top=0;
		r.right=[self bounds].size.width;
		r.bottom=[self bounds].size.height;
		
		SetPort([self qdPort]);
		
		tempRgn=NewRgn();
		RectRgn(tempRgn, &r);
		
		ClipRect(&r);
		SetPortVisibleRegion([self qdPort], tempRgn);
		PortChanged([self qdPort]);
		
		DisposeRgn(tempRgn);
		qdRgnResized=1;
	}
}

- (MacOSBOOL)isOpaque
{
	// Set background to white to avoid flickering when timer paints
	return YES;
}

@end

// -----------------------
// - C wrapper functions -
// -----------------------

