/*************************************************************************
 *
 *  $RCSfile: simpresf.cpp,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef SOM_Module_simpressf_Source
#define SOM_Module_simpressf_Source
#endif
#define StarImpressFile_Class_Source
#define M_StarImpressFile_Class_Source

#include "simpresf.xih"
#include <wpsids.hrc>
#include <wpsdll.h>
#include <sdataf.h>

#include <stdio.h>

#ifdef StarImpressFileMethodDebug
#undef StarImpressFileMethodDebug
#endif
#define StarImpressFileMethodDebug

#ifdef M_StarImpressFileMethodDebug
#undef M_StarImpressFileMethodDebug
#endif
#define M_StarImpressFileMethodDebug

SOM_Scope void  SOMLINK simpressf_wpInitData(StarImpressFile *somSelf)
{
    /* StarImpressFileData *somThis = StarImpressFileGetData(somSelf); */
    StarImpressFileMethodDebug("StarImpressFile","simpressf_wpInitData");

    StarImpressFile_parent_WPDataFile_wpInitData(somSelf);

    /* ensure correct icon */
    _wpSetAssociatedFileIcon();
}

SOM_Scope HWND  SOMLINK simpressf_wpViewObject(StarImpressFile *somSelf,
                                              HWND hwndCnr, ULONG ulView, 
                                              ULONG param)
{
    /* StarImpressFileData *somThis = StarImpressFileGetData(somSelf); */
    StarImpressFileMethodDebug("StarImpressFile","simpressf_wpViewObject");

    if(ulView == OPEN_DEFAULT)
    {
        if(hwndCnr == openObject(somSelf, hwndCnr))
            return hwndCnr;
    }

    return (StarImpressFile_parent_WPDataFile_wpViewObject(somSelf, 
                                                          hwndCnr, 
                                                          ulView, 
                                                          param));
}

SOM_Scope BOOL  SOMLINK simpressf_wpPrintObject(StarImpressFile *somSelf, 
                                               PPRINTDEST pPrintDest, 
                                               ULONG ulReserved)
{
    /* StarImpressFileData *somThis = StarImpressFileGetData(somSelf); */
    StarImpressFileMethodDebug("StarImpressFile","simpressf_wpPrintObject");

    return printObject(somSelf, pPrintDest);
}

SOM_Scope void  SOMLINK simpressf_wpSetAssociatedFileIcon(StarImpressFile *somSelf)
{
    /* StarImpressFileData *somThis = StarImpressFileGetData(somSelf); */
    StarImpressFileMethodDebug("StarImpressFile","simpressf_wpSetAssociatedFileIcon");


    _wpSetIcon(_StarImpressFile->wpclsQueryIcon());
}


SOM_Scope void  SOMLINK simpressfM_wpclsInitData(M_StarImpressFile *somSelf)
{
    HMODULE hModule;

    M_StarImpressFileData *somThis = M_StarImpressFileGetData(somSelf);
    M_StarImpressFileMethodDebug("M_StarImpressFile","simpressfM_wpclsInitData");

    _hIcon = NULLHANDLE;

    // the dll must be loaded already
    if(NO_ERROR == DosQueryModuleHandle(_TEMPLATES_DLL_NAME, &hModule))
    {
        _hIcon = WinLoadPointer(HWND_DESKTOP, hModule, WPS_RESID_ICON_SIMPRESS);
    }

    // set default icon if resource not loaded
    if(_hIcon == NULLHANDLE)
    {
        _hIcon = M_StarImpressFile_parent_M_WPDataFile_wpclsQueryIcon(somSelf);
    }

    M_StarImpressFile_parent_M_WPDataFile_wpclsInitData(somSelf);
}

SOM_Scope void  SOMLINK simpressfM_wpclsUnInitData(M_StarImpressFile *somSelf)
{
    M_StarImpressFileData *somThis = M_StarImpressFileGetData(somSelf);
    M_StarImpressFileMethodDebug("M_StarImpressFile","simpressfM_wpclsUnInitData");

    // release class default icon
    WinDestroyPointer(_hIcon);

    M_StarImpressFile_parent_M_WPDataFile_wpclsUnInitData(somSelf);
}

SOM_Scope HPOINTER  SOMLINK simpressfM_wpclsQueryIcon(M_StarImpressFile *somSelf)
{
    M_StarImpressFileData *somThis = M_StarImpressFileGetData(somSelf);
    M_StarImpressFileMethodDebug("M_StarImpressFile","simpressfM_wpclsQueryIcon");

    return _hIcon;
}

SOM_Scope PSZ  SOMLINK simpressfM_wpclsQueryInstanceFilter(M_StarImpressFile *somSelf)
{
    /* M_StarImpressFileData *somThis = M_StarImpressFileGetData(somSelf); */
    M_StarImpressFileMethodDebug("M_StarImpressFile","simpressfM_wpclsQueryInstanceFilter");

    return "*.sdd,*.soc,*.sog,*.sob,*.soh,*.sod,*.soe,*.sop";
}

SOM_Scope PSZ  SOMLINK simpressfM_wpclsQueryInstanceType(M_StarImpressFile *somSelf)
{
    /* M_StarImpressFileData *somThis = M_StarImpressFileGetData(somSelf); */
    M_StarImpressFileMethodDebug("M_StarImpressFile","simpressfM_wpclsQueryInstanceType");

    return "StarImpress Document";
}

SOM_Scope BOOL  SOMLINK simpressfM_wpclsCreateDefaultTemplates(M_StarImpressFile *somSelf, 
                                                              WPObject* Folder)
{
    /* M_StarImpressFileData *somThis = M_StarImpressFileGetData(somSelf); */
    M_StarImpressFileMethodDebug("M_StarImpressFile","simpressfM_wpclsCreateDefaultTemplates");

    /* tell the wps not to create a template itself */
    return TRUE;
}
