/*************************************************************************
 *
 *  $RCSfile: option.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:01:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#define _SVX_OPTHYPH_CXX

// include ---------------------------------------------------------------

#include <lingwrap.hxx>
#include "option.hxx"
#include "dlgutil.hxx"

#include "lingtest.hrc"


// class SfxHyphenTabPage ------------------------------------------------

OptionDialog::OptionDialog( Window* pParent ) :

	ModalDialog( pParent, ResId( RID_OPTION ) ),

	aPreBreakText	( this, ResId( FT_PREBREAK ) ),
	aPreBreakEdit	( this, ResId( ED_PREBREAK ) ),
	aAfterBreakText	( this, ResId( FT_AFTERBREAK ) ),
	aAfterBreakEdit	( this, ResId( ED_AFTERBREAK ) ),
	aWordText		( this, ResId( FT_WORD ) ),
	aWordEdit		( this, ResId( ED_WORD ) ),
	aRuleBox		( this, ResId( GB_RULES ) ),
	aLangText		( this, ResId( FT_LANGUAGE ) ),
	aLangLB			( this, ResId( LB_LANGUAGE ) ),
	aOKBtn			( this, ResId( BTN_OK ) ),
	aCancelBtn 		( this, ResId( BTN_CANCEL ) )

{
	FreeResource();

	// Sprachen initialisieren und anzeigen
	const USHORT nLangCount = ::GetLanguageCount();

	for ( USHORT i = 0; i < nLangCount; i++ )
		aLangLB.InsertEntry( GetLanguageString(i) );
}

// -----------------------------------------------------------------------

OptionDialog::~OptionDialog()
{
}

// -----------------------------------------------------------------------

USHORT OptionDialog::GetMinHead() const
{
	return (USHORT)aPreBreakEdit.Denormalize( aPreBreakEdit.GetValue() );
}

// -----------------------------------------------------------------------

void OptionDialog::SetMinHead( const USHORT nNew )
{
	aPreBreakEdit.SetValue( aPreBreakEdit.Normalize( nNew ) );
}

// -----------------------------------------------------------------------

USHORT OptionDialog::GetMinTrail() const
{
	return (USHORT)aAfterBreakEdit.Denormalize( aAfterBreakEdit.GetValue() );
}

// -----------------------------------------------------------------------

void OptionDialog::SetMinTrail( const USHORT nNew )
{
	aAfterBreakEdit.SetValue( aAfterBreakEdit.Normalize( nNew ) );
}

// -----------------------------------------------------------------------

USHORT OptionDialog::GetLanguage() const
{
	return ::GetLanguage( aLangLB.GetSelectEntryPos() );
}

// -----------------------------------------------------------------------

void OptionDialog::SetLanguage( const USHORT nLang )
{
	aLangLB.SelectEntryPos( ::GetLanguagePos( nLang ) );
}


