/*************************************************************************
 *
 *  $RCSfile: futransform.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: iha $ $Date: 2002/10/31 12:46:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "futransform.hxx"

// headers from chart
#include "schview.hxx"
#include "schresid.hxx"
#include "strings.hrc"
#include "chtmodel.hxx"
#include "schgroup.hxx"
#include "transform.hxx"

// headers from other dlls
#ifndef _E3D_POLYSC3D_HXX
#include <svx/polysc3d.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#include "undmovsize.hxx"
#include "viewshel.hxx"
#include "chtscene.hxx"

TYPEINIT1( SchFuTransform, SchFuPoor );

SchFuTransform::SchFuTransform(
    SchViewShell* pViewShell, SchWindow* pWindow, SchView* pView,
    ChartModel* pModel, SfxRequest& rRequest ) :
        SchFuPoor( pViewShell, pWindow, pView, pModel, rRequest )
{
    if( pView->HasMarkedObj() )
    {
		const SfxItemSet* pArgs = rRequest.GetArgs();

		if( NULL == pArgs )
		{
			// item set for size and position
			SfxItemSet aSet( pView->GetGeoAttrFromMarked() );
            aSet.DisableItem( SID_ATTR_TRANSFORM_PROTECT_POS );
            aSet.DisableItem( SID_ATTR_TRANSFORM_PROTECT_SIZE );

			const SdrMarkList& rMarkList = pView->GetMarkList();
			SdrObject* pObj = rMarkList.GetMark(0)->GetObj();

            bool bSizable = false;
            bool bRotatable = false;

			Matrix4D	aUndoOldSceneMatrix;
			SfxItemSet	aUndoItemSet(aSet);

            DBG_ASSERT( pObj, "Have Marked Object, but Object is NULL!" );

            UINT16 nObjId = CHOBJID_ANY;
            SchObjectId * pObjId = GetObjectId( *pObj );
            if( pObjId )
                nObjId = pObjId->GetObjId();

            if( CHOBJID_DIAGRAM == nObjId )
            {
                bSizable = true;
                bRotatable = ( TRUE == pChDoc->Is3DChart() );
				if(pObj&&pObj->ISA(ChartScene))
					aUndoOldSceneMatrix = ((ChartScene*)pObj)->GetTransform();
            }

            SchTransformTabDialog aDlg = SchTransformTabDialog( NULL, &aSet, pView, bSizable, bRotatable );
            if( aDlg.Execute() != RET_OK )
                return;
           
            rRequest.Done( *( aDlg.GetOutputItemSet() ) );
            pArgs = rRequest.GetArgs();

            // apply changed attributes only for ChartScene via DrawingLayer
            // necessary to get the new adjusted attributes
            if(pObj&&pObj->ISA(ChartScene)) 
            {
                pView->SetGeoAttrToMarked( *pArgs );
                pView->SetAttributes( *pArgs );
            }

			//create undo action and use undo-action to perform the action itself
			{
				Rectangle aOldPosSize(0,0,0,0);
				Rectangle aNewPosSize(0,0,0,0);
				Rectangle aRotateDummy(0,0,0,0);
				Matrix4D  aUndoNewSceneMatrix;

				SchUndoMoveOrResize::GetGeoAttribFromItemSet(aUndoItemSet,aOldPosSize,aRotateDummy);
				aUndoItemSet.Put(*pArgs);//overwrite old items with changed ones
				SchUndoMoveOrResize::GetGeoAttribFromItemSet(aUndoItemSet,aNewPosSize,aRotateDummy);
				
				if(pObj&&pObj->ISA(ChartScene))
				{
					aUndoNewSceneMatrix = ((ChartScene*)pObj)->GetTransform();
					aNewPosSize = pObj->GetSnapRect();
				}
                else if(pObj&&pObj->ISA(SchObjGroup)&&nObjId==CHOBJID_DIAGRAM)
                {
                    aOldPosSize = pChDoc->GetChartRect();
                    aNewPosSize = CreateNewDiagrammRectangle(aNewPosSize, pObj->GetSnapRect(), pChDoc->GetChartRect());
                }
				

				SchUndoMoveOrResize* pUndo = new SchUndoMoveOrResize( *pChDoc, nObjId
					, aOldPosSize, aNewPosSize
					, aUndoOldSceneMatrix, aUndoNewSceneMatrix );

                //perform the action itself:
                pUndo->Redo();


				pViewShell->GetViewFrame()->GetObjectShell()->
					GetUndoManager()->AddUndoAction(pUndo);
			}
        }
    }
}

SchFuTransform::~SchFuTransform()
{}


/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

void SchFuTransform::Activate()
{
	SchFuPoor::Activate();
}

/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

void SchFuTransform::Deactivate()
{
	SchFuPoor::Deactivate();
}


/*************************************************************************
|*
|* Function ResizeObject
|*
\************************************************************************/

Point SchFuTransform::GetPoint( Rectangle aRect, RECT_POINT eRP )
{
    switch( eRP )
	{
		case RP_LT: return Point( aRect.Left(), aRect.Top() );
		case RP_MT: return Point( aRect.Center().X(), aRect.Top() );
		case RP_RT: return Point( aRect.Right(), aRect.Top() );
		case RP_LM: return Point( aRect.Left(), aRect.Center().Y() );
		case RP_MM: return Point( aRect.Center().X(), aRect.Center().Y() );
		case RP_RM: return Point( aRect.Right(), aRect.Center().Y() );
		case RP_LB: return Point( aRect.Left(), aRect.Bottom() );
		case RP_MB: return Point( aRect.Center().X(), aRect.Bottom() );
		case RP_RB: return Point( aRect.Right(), aRect.Bottom() );
	}
    return Point( 0, 0 );
}

Rectangle SchFuTransform::CreateNewDiagrammRectangle(const Rectangle& rNew, const Rectangle& rOld, const Rectangle& rOldChartRect)
{
    //rNew is the new bound or snap rect
    //rOld is the old bound or snap rect (bound and snap rect should be ever identical for 2D Diagramms)
	
    //remind differences between old ChartRect and old BoundRect:
	Point aDifferenceLeftBottom = rOldChartRect.BottomLeft() - rOld.BottomLeft();
	Point aDifferenceTopRight = rOldChartRect.TopRight() - rOld.TopRight();

    //take the new BoundRect
    Rectangle aRect(rNew);
    //add old differences to new BoundRect to receive the new ChartRect
	aRect.Left() += aDifferenceLeftBottom.X();
	aRect.Bottom() += aDifferenceLeftBottom.Y();
	aRect.Right() += aDifferenceTopRight.X();
	aRect.Top() += aDifferenceTopRight.Y();
    return aRect;
}

