/*************************************************************************
 *
 *  $RCSfile: excupn.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: gt $ $Date: 2001/06/19 15:10:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _EXCUPN_HXX
#define _EXCUPN_HXX

#ifndef _XL_COMP_HXX
#include "xl_comp.hxx"
#endif
#ifndef _ROOT_HXX
#include "root.hxx"
#endif
#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif

class ScAddress;
class ExcUPN;
class ExcUPNList;
class ScRangeList;
class ExcArrays;




extern ExcUPN* CreateExcUpnFromScRangeList( RootData&, ScRangeList& );


class ExcUPNList : protected List
{
private:
protected:
public:
	virtual					~ExcUPNList();

	inline ExcUPN*			First( void );
	inline ExcUPN*			Last( void );
	inline ExcUPN*			Next( void );
	inline ExcUPN*			Prev( void );

	inline void				Append( ExcUPN* p );

	List::Count;
};


inline ExcUPN* ExcUPNList::First( void )
{
	return ( ExcUPN* ) List::First();
}


inline ExcUPN* ExcUPNList::Last( void )
{
	return ( ExcUPN* ) List::Last();
}


inline ExcUPN* ExcUPNList::Next( void )
{
	return ( ExcUPN* ) List::Next();
}


inline ExcUPN* ExcUPNList::Prev( void )
{
	return ( ExcUPN* ) List::Prev();
}


inline void ExcUPNList::Append( ExcUPN* p )
{
	List::Insert( p, LIST_APPEND );
}




class ExcUPN : public CExcelCompiler
{
public:
	inline					ExcUPN( RootData*, const ScTokenArray&, EC_Codetype& rCodeType,
									const ScAddress* pAddr = NULL, BOOL bConditionlFormat = FALSE,
									ExcArrays* pShrdFmlas = NULL );
	inline					ExcUPN( const ScTokenArray&, EC_Codetype& rCodeType );
	inline					ExcUPN( BOOL bDummy, RootData*, const ScTokenArray&, EC_Codetype& rCodeType,
									const ScAddress& rAddr  );
	inline					~ExcUPN();

	inline const sal_Char*	GetData( void ) const;
	inline UINT16			GetLen( void ) const;
};


inline ExcUPN::ExcUPN(	RootData* pRD, const ScTokenArray& rTA, EC_Codetype& rCodeType,
						const ScAddress* pAddr, BOOL bCF, ExcArrays* pShrdFmlas ) :
	CExcelCompiler( pRD, rTA, pAddr, bCF )
{
	rCodeType = CreateCode( pShrdFmlas );
}


inline ExcUPN::ExcUPN( const ScTokenArray& rTA, EC_Codetype& rCodeType ) :
	CExcelCompiler( NULL, rTA )
{
	rCodeType = CreateArrayCode();
}


inline ExcUPN::ExcUPN(	BOOL, RootData* pRD, const ScTokenArray& rTA, EC_Codetype& rCodeType,
						const ScAddress& rAddr ) :
	CExcelCompiler( pRD, rTA, &rAddr )
{
	rCodeType = CreateArrayCode( TRUE );
}


inline ExcUPN::~ExcUPN()
{
}

static const sal_Char pDef[] = { 0x1C, 0x2A };


inline const sal_Char* ExcUPN::GetData( void ) const
{
	return GetError() ? pDef : ( const sal_Char* ) ( GetCode()->nCode );
}


static const UINT16 nDefLen = 2;


inline UINT16 ExcUPN::GetLen( void ) const
{
	return GetError() ? nDefLen : GetCode()->nCce;
}


#endif

