/*************************************************************************
 *
 *  $RCSfile: shmalloc.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define SHAlloc_PROC_NAME					MAKEINTRESOURCE(196)
#define SHFree_PROC_NAME					MAKEINTRESOURCE(196)
#define ILFree_PROC_NAME					MAKEINTRESOURCE(155)

#define SHILCreateFromPath_PROC_NAME		MAKEINTRESOURCE(28)
#define ILCreateFromPath_PROC_NAME			MAKEINTRESOURCE(157)
#define SHSimpleIDListFromPath_PROC_NAME	MAKEINTRESOURCE(162)

#define ILGetNext_PROC_NAME					MAKEINTRESOURCE(153)
#define ILFindLastID_PROC_NAME				MAKEINTRESOURCE(16)
#define ILFindChild_PROC_NAME				MAKEINTRESOURCE(14)

#define ILClone_PROC_NAME					MAKEINTRESOURCE(18)
#define ILCloneFirst_PROC_NAME				MAKEINTRESOURCE(19)
#define ILCombine_PROC_NAME					MAKEINTRESOURCE(15)
#define ILAppendID_PROC_NAME				MAKEINTRESOURCE(154)

#define ILRemoveLastID_PROC_NAME			MAKEINTRESOURCE(17)
#define ILIsEqual_PROC_NAME					MAKEINTRESOURCE(21)
#define ILIsParent_PROC_NAME				MAKEINTRESOURCE(23)



extern "C" {

LPVOID WINAPI SHAlloc( ULONG cb )
{
	IMalloc	*pMalloc = NULL;
	LPVOID	pv = NULL;

	if ( SUCCEEDED(SHGetMalloc( &pMalloc)) && pMalloc )
	{
		pv = pMalloc->Alloc( cb );
		pMalloc->Release();
	}

	return pv;
}


LPVOID WINAPI SHRealloc( LPVOID	pv, ULONG cb )
{
	IMalloc	*pMalloc = NULL;
	LPVOID	pvNew = NULL;

	if ( SUCCEEDED(SHGetMalloc( &pMalloc)) && pMalloc )
	{
		pvNew = pMalloc->Realloc( pv, cb );
		pMalloc->Release();
	}

	return pvNew;
}

VOID WINAPI SHFree( LPVOID pv )
{
	IMalloc	*pMalloc = NULL;

	if ( SUCCEEDED(SHGetMalloc( &pMalloc)) && pMalloc )
	{
		pMalloc->Free( pv );
		pMalloc->Release();
	}
}


HRESULT WINAPI SHILCreateFromPathW( LPCWSTR lpszPath, LPITEMIDLIST *ppidl, LPDWORD pdwAttributes )
{
	IShellFolder	*pFolder = NULL;
	HRESULT			hResult;
	
	if ( SUCCEEDED(hResult = SHGetDesktopFolder( &pFolder )) && pFolder )
	{
		ULONG	chEaten = 0;

		hResult = pFolder->ParseDisplayName( NULL, NULL, lpszPath, &chEaten, ppidl, pdwAttributes );
		pFolder->Release();
	}

	return hResult;
}


HRESULT WINAPI SHILCreateFromPathA( LPCSTR lpszPath, LPITEMIDLIST *ppidl, LPDWORD pdwAttributes )
{
	IShellFolder	*pFolder = NULL;
	HRESULT			hResult;
	
	if ( SUCCEEDED(hResult = SHGetDesktopFolder( &pFolder )) && pFolder )
	{
		ULONG	chEaten = 0;
		int		nPathSize = 0;
		LPWSTR	lpszPathW = lpszPath ? (LPWSTR)calloc( nPathSize = MultiByteToWideChar( CP_ACP, 0, lpszPath, -1, NULL, 0 ), sizeof(WCHAR)) : NULL;

		if ( lpszPatzhW )
			MultiByteToWideChar( CP_ACP, 0, lpszPath, -1, lpszPathW, nPathSize );

		hResult = pFolder->ParseDisplayName( NULL, NULL, lpszPathW, &chEaten, ppidl, pdwAttributes );

		if ( lpszPatzhW )
			free( lpszPathW );

		pFolder->Release();
	}

	return hResult;
}


LPITEMIDLIST WINAPI ILCreateFromPathA( LPCSTR lpszPath )
{
	LPITEMIDLIST	pidl = NULL;

	SHILCreateFromPathA( lpszPath, &pidl, NULL );

	return pidl;
}


LPITEMIDLIST WINAPI ILCreateFromPathW( LPCWSTR lpszPath )
{
	LPITEMIDLIST	pidl = NULL;

	SHILCreateFromPathW( lpszPath, &pidl, NULL );

	return pidl;
}


extern "C" LPITEMIDLIST WINAPI SHSimpleIDListFromPath( LPVOID lpPath );

LPITEMIDLIST WINAPI SHSimpleIDListFromPathA( LPCSTR lpszPath )
{
	LPITEMIDLIST	pidl;

	if ( IsWinNT() )
	{
		int		nPathSize;
		LPWSTR	lpszPathW = lpszPath ? (LPWSTR)calloc( nPathSize = MultiByteToWideChar( CP_ACP, 0, lpszPath, -1, NULL, 0 ), sizeof(WCHAR)) : NULL;

		if ( lpszPatzhW )
			MultiByteToWideChar( CP_ACP, 0, lpszPath, -1, lpszPathW, nPathSize );

		pidl = SHSimpleIDListFromPath( lpszPathW );

		if ( lpszPatzhW )
			free( lpszPathW );
	}
	else
		pidl = SHSimpleIDListFromPath( lpszPath );

	return pidl;
}


LPITEMIDLIST WINAPI SHSimpleIDListFromPathW( LPCWSTR lpszPath )
{
	LPITEMIDLIST	pidl;

	if ( IsWinNT() )
		pidl = SHSimpleIDListFromPath( lpszPath );
	else
	{
		int		nPathSize;
		LPSTR	lpszPathA = lpszPath ? (LPWSTR)calloc( nPathSize = WideCharToMultiByte( CP_ACP, 0, lpszPath, -1, NULL, 0, NULL, NULL ), sizeof(CHAR)) : NULL;

		if ( lpszPathA )
			WideCharToMultiByte( CP_ACP, 0, lpszPath, -1, lpszPathA, nPathSize, NULL, NULL );

		pidl = SHSimpleIDListFromPath( lpszPathA );

		if ( lpszPatzhA )
			free( lpszPathA );
	}

	return pidl;
}


}	// extern "C"

