/*************************************************************************
 *
 *  $RCSfile: appctor.cxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/12 11:05:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ofapch.hxx"
#endif

#ifndef _IDERDLL_HXX
#include <basctl/iderdll.hxx>
#endif

#ifndef _MyEDITENG_HXX //autogen
#include <svx/editeng.hxx>
#endif
#ifndef _SVX_DIALDLL_HXX
#include <svx/dialdll.hxx>
#endif
#ifndef _BASRDLL_HXX
#include <basic/basrdll.hxx>
#endif
#ifndef _EDITDLL_HXX
#include <svx/editdll.hxx>
#endif
#ifndef _SVX_ITEMDATA_HXX
#include <svx/itemdata.hxx>
#endif
#ifndef _SV_EDIT_HXX
#include <vcl/edit.hxx>
#endif
#ifndef _SVX_CHARMAP_HXX
#include <svx/charmap.hxx>
#endif
#ifndef _SVDETC_HXX
#include <svx/svdetc.hxx>
#endif
#ifndef _SVDOUTL_HXX
#include <svx/svdoutl.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _SVXERR_HXX
#include <svx/svxerr.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_MODULEOPTIONS_HXX
#include <svtools/moduleoptions.hxx>
#endif
#include <rtl/logfile.hxx>

#pragma hdrstop

#include "app.hxx"
#include "appimp.hxx"

#define DEFINE_CONST_UNICODE(CONSTASCII)        UniString(RTL_CONSTASCII_USTRINGPARAM(CONSTASCII))

static SvxDialogDll*   pSvxDLL  = NULL;
static BasicDLL*       pBasic   = NULL;
static EditDLL*        pEditDLL = NULL;
//static BasicIDEDLL*    pIdeDLL  = NULL;
static SvxGlobalItemData* pItemData = NULL;
static SvxErrorHandler* pSvxErrorHdl = NULL;

// ------------------------------------------------------------------------
//Sonderzeichen einfuegen fuer Edits

String GetSpecialCharsForEdit(Window* pParent, const Font& rFont)
{
    String sRet;
	SvxCharacterMap* pMap = new SvxCharacterMap(pParent, sal_False);
	pMap->DisableFontSelection();
	pMap->SetCharFont(rFont);
	if(RET_OK == pMap->Execute())
		sRet = pMap->GetCharacters();
	delete pMap;
	return sRet;
}

OfficeApplication::OfficeApplication() :

	SfxApplication(),
	pImpl		( NULL ),
	pDataImpl   ( NULL )

{
	RTL_LOGFILE_CONTEXT( aLog, "offmgr (cd100003) ::OfficeApplication::OfficeApplication" );
    SetName( DEFINE_CONST_UNICODE("StarOffice") );

    sal_uInt32 nFeatures = SvtModuleOptions().GetFeatures();
	if ( nFeatures )
		SetFeatures( nFeatures );

	RTL_LOGFILE_CONTEXT_TRACE( aLog, "{ create OfficeAppl_Impl,OfficeData_Impl,SetResManager" );
	pImpl = new OfficeAppl_Impl;
	pDataImpl = new OfficeData_Impl(*this);
	Resource::SetResManager( GetOffResManager() );
	RTL_LOGFILE_CONTEXT_TRACE( aLog, "} create OfficeAppl_Impl,OfficeData_Impl,SetResManager" );

	RTL_LOGFILE_CONTEXT_TRACE( aLog, "{ initialize libraries: SvxDialogDLL,BasicDLL,EditDLL,BasicIDEDLL" );
    InitLabelResMgr( "iso" );
	Edit::SetGetSpecialCharsFunction(&GetSpecialCharsForEdit);
    pSvxDLL  = new SvxDialogDll;
    pBasic   = new BasicDLL;
    pEditDLL = new EditDLL;
//    pIdeDLL  = new BasicIDEDLL;
    pItemData = new SvxGlobalItemData;
	EditEngine::SetGetAutoCorrectHdl( LINK( this, OfficeApplication, ImplGetAutoCorrect ) );
	RTL_LOGFILE_CONTEXT_TRACE( aLog, "} initialize libraries: SvxDialogDLL,BasicDLL,EditDLL,BasicIDEDLL" );

	SfxApplication::SetApp( this );
    BasicIDEDLL::LibInit();
	pSvxErrorHdl = new SvxErrorHandler();
}

//-------------------------------------------------------------------------

OfficeApplication::~OfficeApplication()
{
    Deinitialize();
	delete pSvxErrorHdl;
	delete ( &GetSdrGlobalData() )->pOutliner;  // vor EditDLL, wegen Static-Defaults
	( &GetSdrGlobalData() )->pOutliner = NULL;
	delete pEditDLL;
	delete pBasic;
//    delete pIdeDLL;
    BasicIDEDLL::LibExit();
	delete pSvxDLL;

	Resource::SetResManager( NULL );

	DeleteDataImpl();
	delete pImpl->pResMgr;
	delete pImpl;
    delete pItemData;
}


