/*************************************************************************
 *
 *  $RCSfile: typedetection.cxx,v $
 *
 *  $Revision: 1.24.6.1 $
 *
 *  last change: $Author: vg $ $Date: 2004/01/15 14:28:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_______________________________________________
// my own includes

#ifndef __FRAMEWORK_SERVICES_TYPEDETECTION_HXX_
#include <services/typedetection.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_READGUARD_HXX_
#include <threadhelp/readguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_WRITEGUARD_HXX_
#include <threadhelp/writeguard.hxx>
#endif

#ifndef __FRAMEWORK_PROTOCOLS_H_
#include <protocols.h>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

//_______________________________________________
// interface includes

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif

//_______________________________________________
// includes of other projects

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

//_______________________________________________
// namespace

namespace framework{

//_______________________________________________
// non exported const

//_______________________________________________
// non exported definitions

//_______________________________________________
// declarations

//***********************************************
// XInterface, XTypeProvider, XServiceInfo

DEFINE_XINTERFACE_8(TypeDetection                                   ,
                    OWeakObject                                     ,
                    DIRECT_INTERFACE(css::lang::XTypeProvider      ),
                    DIRECT_INTERFACE(css::lang::XServiceInfo       ),
                    DIRECT_INTERFACE(css::document::XTypeDetection ),
                    DIRECT_INTERFACE(css::container::XNameContainer),
                    DIRECT_INTERFACE(css::container::XNameReplace  ),
                    DIRECT_INTERFACE(css::container::XNameAccess   ),
                    DIRECT_INTERFACE(css::container::XElementAccess),
                    DIRECT_INTERFACE(css::util::XFlushable         ))

DEFINE_XTYPEPROVIDER_8(TypeDetection                 ,
                       css::lang::XTypeProvider      ,
                       css::lang::XServiceInfo       ,
                       css::document::XTypeDetection ,
                       css::container::XNameContainer,
                       css::container::XNameReplace  ,
                       css::container::XNameAccess   ,
                       css::container::XElementAccess,
                       css::util::XFlushable         )

DEFINE_XSERVICEINFO_ONEINSTANCESERVICE(TypeDetection                   ,
                                       ::cppu::OWeakObject             ,
                                       SERVICENAME_TYPEDETECTION       ,
                                       IMPLEMENTATIONNAME_TYPEDETECTION)

DEFINE_INIT_SERVICE(TypeDetection,
                    {
                        /* Add special code for initialization here, if you have to use your own instance
                           during your ctor is still in progress! */
                    }
                   )

/*-------------------------------------------------------------------------------------------------
    10.03.2003 11:08
-------------------------------------------------------------------------------------------------*/
TypeDetection::TypeDetection( const css::uno::Reference< css::lang::XMultiServiceFactory >& xSMGR )
        : ThreadHelpBase      (&Application::GetSolarMutex())
        , OWeakObject         (                              )
        , m_xSMGR             (xSMGR                         )
        , m_aCache            (                              )
        , m_aListenerContainer(m_aLock.getShareableOslMutex())
{
	// Safe impossible cases
	// We need our cache for working.
    LOG_ASSERT(m_aCache.isValidOrRepairable(), "TypeDetection::TypeDetection()\nInitializing of cache failed. Office will not work!\n" )
}

/*-------------------------------------------------------------------------------------------------
    10.03.2003 11:08
-------------------------------------------------------------------------------------------------*/
TypeDetection::~TypeDetection()
{
}

/*-------------------------------------------------------------------------------------------------
    24.03.2003 13:20
-------------------------------------------------------------------------------------------------*/
::rtl::OUString SAL_CALL TypeDetection::queryTypeByURL( const ::rtl::OUString& sURL )
    throw(css::uno::RuntimeException)
{
    // check and react for wrong using of this method
    ::rtl::OUString sTypeName;
    if (sURL.getLength()>0)
    {
        // otherwhise search for a suitable type
        CheckedTypeIterator pIterator;
        // SAFE {
        ReadGuard aReadLock(m_aLock);
        m_aCache.searchType(sURL, ::rtl::OUString(), ::rtl::OUString(), pIterator, sTypeName);
        aReadLock.unlock();
        // } SAFE
    }

	return sTypeName;
}

/*-------------------------------------------------------------------------------------------------
    24.03.2003 13:20
-------------------------------------------------------------------------------------------------*/
::rtl::OUString SAL_CALL TypeDetection::queryTypeByDescriptor( css::uno::Sequence< css::beans::PropertyValue >& lDescriptor ,
                                                               sal_Bool                                         bDeep       )
    throw(css::uno::RuntimeException)
{
    // needed to measure office performance! Don't touch it ...
    RTL_LOGFILE_CONTEXT(aLog, "framework (as96863) ::TypeDetection::queryTypeByDescriptor");

    // analyze given descriptor arguments first.
    // search for mime type/clipboardformat/ preselected type or filter ...
    /** FIXME: preselection is not supported yet. */
    ArgumentAnalyzer aAnalyzer(lDescriptor);
    ::rtl::OUString  sURL                  ;
    ::rtl::OUString  sMediaType            ;
    ::rtl::OUString  sClipboardFormat      ;

    aAnalyzer.getArgument(E_URL      , sURL            );
    aAnalyzer.getArgument(E_MEDIATYPE, sMediaType      );
    aAnalyzer.getArgument(E_FORMAT   , sClipboardFormat);

    // If we have a valid URL (and it's not a special one, designed for stream detection ... "private:stream/"!)
    // we have to make a combined flat/deep detection.
    // But in case such valid URL is missing ... or the this flat/deep detection failed ...
    // we have to step over all(!) registered deep detection services and ask it for it's meaning.
    // The local variable sType regulate this search. If it's an empty value at the end of this method
    // we start this last-chance detection. And in case the URL isn't valid we must be shure that sType is empty too.
    ::rtl::OUString sType;
    if (
        (sURL.getLength()>0                                              ) &&
        (!ProtocolCheck::isProtocol(sURL,ProtocolCheck::E_PRIVATE_STREAM))
       )
    {
        // step over our type cache items to find right one. It's a flat detection.
        // Note: This iterator must(!) be defined outside ths following loop!
        // Otherwhise it will be initialized as "new search started" and the loop
        // will never end!
        CheckedTypeIterator pTypeIterator;
        while(true)
		{
            // SAFE {
            ReadGuard aReadLock(m_aLock);
            // search next suitable type
            // If search failed break this loop! But you must be shure, that the sType value is empty or
            // realy a valid result of this combined flat/deep detection!
            // Reset it for every new loop.
            sType = ::rtl::OUString();
            if (
                (!m_aCache.searchType(sURL, sMediaType, sClipboardFormat, pTypeIterator, sType)) ||
                (sType.getLength()<1                                                           )
               )
            {
                // No further type found.
                // Break this loop. sType must be empty then to start last-chance ... our
                // generic deep detection at the end of this method!
                sType = ::rtl::OUString();
                break;
            }
            aReadLock.unlock();
            //  SAFE

            // no deep detection allowed ... break this loop. First matched type will be used then.
            if (!bDeep)
                break;

            // Otherwhise try deep detection.
            ::rtl::OUString sDeepType;
            sal_Bool bDeepDetected = impl_checkDeepForType(sType, aAnalyzer, &sDeepType);

            // But if no deep detect service could be located
            // -> break this loop. Then the flat detection (means value of sType) will be used for return.
            if (!bDeepDetected)
                break;

            // In case deep detection was done - but nobody of the used detect services known this
            // type ... we must try the next flat detected candidate!
            // Because it seams that e.g. the extension of the given URL isn't the right one.
            if (sDeepType.getLength()<1)
                continue;

            // In case deep detection was done and returns a valid information ...
            // we have to accept it. Then we must leave this loop with the deep detected type value.
            sType = sDeepType;
            break;
		}
	}

    // Have we found any valid type?
    // If not - a deep detection over all well known detect services can be our last-chance!
    // But look if such deep detection is allowed ...
    if (
        (sType.getLength()<1) &&
        (bDeep              )
       )
	{
        // SAFE {
        ReadGuard aReadLock(m_aLock);
        // get list of all well known detect services.
        // and try to get access to the needed factory for detect services ...
        css::uno::Sequence< ::rtl::OUString >                  lAllDetectors   = m_aCache.getAllDetectorNamesWithDefault();
        css::uno::Reference< css::lang::XMultiServiceFactory > xDetectorFactory(m_xSMGR->createInstance(SERVICENAME_DETECTORFACTORY), css::uno::UNO_QUERY);
        aReadLock.unlock();
        // } SAFE
        if (xDetectorFactory.is())
        {
            sal_Int32 c = lAllDetectors.getLength();
            for (sal_Int32 i=0; i<c; ++i)
            {
                // try to create the current detect service.
                // Try next one if it failed!
                css::uno::Reference< css::document::XExtendedFilterDetection > xDetector(xDetectorFactory->createInstance(lAllDetectors[i]), css::uno::UNO_QUERY);
                if (!xDetector.is())
                    continue;

                lDescriptor = aAnalyzer.getArgumentsAndReset();
                ::rtl::OUString sDetectorDecision = xDetector->detect(lDescriptor);
                aAnalyzer.setArguments(lDescriptor);
                // BINGO. This detector knows this format.
                // Set it's decision as result. The descriptor will be adjusted at the end of this method.
                // Break loop only here.
                if (sDetectorDecision.getLength() > 0)
                {
                    sType = sDetectorDecision;
                    break;
                }
            }
        }
	}

	// Return result of detection.
    aAnalyzer.deleteArgument(E_DETECTSERVICE);
    impl_updateDescriptorForType(sType,&aAnalyzer);
    lDescriptor = aAnalyzer.getArgumentsAndReset();
    return sType;
}

/*-------------------------------------------------------------------------------------------------
    10.03.2003 11:08
-------------------------------------------------------------------------------------------------*/
void TypeDetection::impl_updateDescriptorForType( const ::rtl::OUString& sType, ArgumentAnalyzer* pAnalyzer )
{
    pAnalyzer->deleteArgument(E_TYPENAME );
    pAnalyzer->deleteArgument(E_MEDIATYPE);
    pAnalyzer->deleteArgument(E_FORMAT   );
    // SAFE {
    ReadGuard aReadLock(m_aLock);
    if (sType.getLength()>0 && m_aCache.existsType(sType))
    {
        FileType aType = m_aCache.getType(sType);
        pAnalyzer->setArgument(E_TYPENAME, aType.sName);
        // don't set empty values!
        if (aType.sMediaType.getLength()>0)
            pAnalyzer->setArgument(E_MEDIATYPE, aType.sMediaType);
        if (aType.sClipboardFormat.getLength()>0)
            pAnalyzer->setArgument(E_FORMAT, aType.sClipboardFormat);
    }
    aReadLock.unlock();
    // } SAFE
}

/*-------------------------------------------------------------------------------------------------
    18.07.2003 07:06
-------------------------------------------------------------------------------------------------*/
sal_Bool TypeDetection::impl_checkDeepForType( const ::rtl::OUString&  sFlatType ,
                                                     ArgumentAnalyzer& rAnalyzer ,
                                                     ::rtl::OUString*  pDeepType )
{
    // SAFE {
    ReadGuard aReadLock(m_aLock);

    // indicates, if we tried a deep detection ... it doesnt say anything
    // about the results!
    sal_Bool bDeepTried = sal_False;

    // no factory - no detect service - no deep detection ...
    css::uno::Reference< css::lang::XMultiServiceFactory > xFactory(m_xSMGR->createInstance(SERVICENAME_DETECTORFACTORY), css::uno::UNO_QUERY);
    if (!xFactory.is())
        return bDeepTried;

    // Search for any suitable detector ...
    ::rtl::OUString sDetectorName;
    CheckedStringListIterator pDetectorIterator;
    if (
        (!m_aCache.searchDetectorForType(sFlatType, pDetectorIterator, sDetectorName)) ||
        (sDetectorName.getLength()<1                                                 )
       )
    {
        return bDeepTried;
    }

    // Try to create the detector service.
    // Continue with next one, if creation failed.
    // It doesn't matter if we use this or another detect service. We are
    // interested on any result!
    css::uno::Reference< css::document::XExtendedFilterDetection > xDetector(xFactory->createInstance(sDetectorName), css::uno::UNO_QUERY);
    if (!xDetector.is())
        return bDeepTried;

    // OK. This detector seems to work.
    // We have to reset our return value. Deep detection will start
    // now and it can influence the external decisions
    bDeepTried = sal_True;

    // Before created service can work - we must add our collected informations to descriptor!
    // Don't forget to read arguments after detect again!
    // A detect service can add his informations to the descriptor too.
    // We have to do this for every loop. Because the detector itself can
    // remove these entries too .. but we need it for a possible new detector too.
    impl_updateDescriptorForType(sFlatType,&rAnalyzer);
    rAnalyzer.setArgument(E_DETECTSERVICE, sDetectorName);
    css::uno::Sequence< css::beans::PropertyValue > lDescriptor = rAnalyzer.getArgumentsAndReset();
    ::rtl::OUString sDetectorDecision = xDetector->detect(lDescriptor);
    rAnalyzer.setArguments(lDescriptor);
    rAnalyzer.deleteArgument(E_DETECTSERVICE);

    // The detect service has the following possibilities:
    // a) He agree with our result.
    if (sDetectorDecision == sFlatType)
    {
        *pDeepType = sFlatType;
    }
    else
    // b) He disagree with our result. (sDetectorDecision not empty but different from sFlatType)
    //    => Then we must return his decision for a type name ...
    if (sDetectorDecision.getLength() > 0)
    {
        *pDeepType = sDetectorDecision;
    }

    // update the descriptor
    impl_updateDescriptorForType(*pDeepType,&rAnalyzer);
    return bDeepTried;
}

/*-------------------------------------------------------------------------------------------------
    10.03.2003 11:10
-------------------------------------------------------------------------------------------------*/
void SAL_CALL TypeDetection::insertByName( const ::rtl::OUString& sName         ,
                                           const css::uno::Any&   aPropertyList )
    throw(css::lang::IllegalArgumentException  ,
          css::container::ElementExistException,
          css::lang::WrappedTargetException    ,
          css::uno::RuntimeException           )
{
    // check parameter
    if (sName.getLength()<1)
        throw css::lang::IllegalArgumentException(
                DECLARE_ASCII("invalid type name"),
                static_cast< ::cppu::OWeakObject* >(this),
                0);

    css::uno::Sequence< css::beans::PropertyValue > lProperties;
    if (!(aPropertyList >>= lProperties))
        throw css::lang::IllegalArgumentException(
                DECLARE_ASCII("invalid property list"),
                static_cast< ::cppu::OWeakObject* >(this),
                1);

    // Attention: Some exception are thrown by addType() automaticly.
    // But some of them must be wrapped for the outside code!
    try
    {
        // SAFE {
        ReadGuard aReadLock(m_aLock);
        m_aCache.addType(sName,lProperties,sal_True);
        aReadLock.unlock();
        // } SAFE
    }
    catch(const css::registry::InvalidRegistryException& exInvalid)
    {
        throw css::lang::WrappedTargetException(
            DECLARE_ASCII("wrapped by service method TypeDetection::insertByName()"),
            static_cast< ::cppu::OWeakObject* >(this),
            css::uno::makeAny(exInvalid));
    }
}

/*-------------------------------------------------------------------------------------------------
    10.03.2003 11:10
-------------------------------------------------------------------------------------------------*/
void SAL_CALL TypeDetection::removeByName( const ::rtl::OUString& sName )
    throw(css::container::NoSuchElementException,
          css::lang::WrappedTargetException     ,
          css::uno::RuntimeException            )
{
    // check parameter
    if (sName.getLength()<1)
        throw css::lang::IllegalArgumentException(
                DECLARE_ASCII("invalid type name"),
                static_cast< ::cppu::OWeakObject* >(this),
                0);

    // Attention: Some exception are thrown by removeType() automaticly.
    // But some of them must be wrapped for the outside code!
    try
    {
        // SAFE {
        ReadGuard aReadLock(m_aLock);
        m_aCache.removeType(sName,sal_True);
        aReadLock.unlock();
        // } SAFE
    }
    catch(const css::registry::InvalidRegistryException& exInvalid)
    {
        throw css::lang::WrappedTargetException(
            DECLARE_ASCII("wrapped by service method TypeDetection::removeByName()"),
            static_cast< ::cppu::OWeakObject* >(this),
            css::uno::makeAny(exInvalid));
    }
}

/*-------------------------------------------------------------------------------------------------
    10.03.2003 11:10
-------------------------------------------------------------------------------------------------*/
void SAL_CALL TypeDetection::replaceByName( const ::rtl::OUString& sName         ,
                                            const css::uno::Any&   aPropertyList )
    throw(css::lang::IllegalArgumentException   ,
          css::container::NoSuchElementException,
          css::lang::WrappedTargetException     ,
          css::uno::RuntimeException            )
{
    // check parameter
    if (sName.getLength()<1)
        throw css::lang::IllegalArgumentException(
                DECLARE_ASCII("invalid type name"),
                static_cast< ::cppu::OWeakObject* >(this),
                0);

    css::uno::Sequence< css::beans::PropertyValue > lProperties;
    if (!(aPropertyList >>= lProperties))
        throw css::lang::IllegalArgumentException(
                DECLARE_ASCII("invalid property list"),
                static_cast< ::cppu::OWeakObject* >(this),
                1);

    // Attention: Some exception are thrown by addType() automaticly.
    // But some of them must be wrapped for the outside code!
    try
    {
        // SAFE {
        ReadGuard aReadLock(m_aLock);
        m_aCache.replaceType(sName,lProperties,sal_True);
        aReadLock.unlock();
        // } SAFE
    }
    catch(const css::registry::InvalidRegistryException& exInvalid)
    {
        throw css::lang::WrappedTargetException(
            DECLARE_ASCII("wrapped by service method TypeDetection::replaceByName()"),
            static_cast< ::cppu::OWeakObject* >(this),
            css::uno::makeAny(exInvalid));
    }
}

//_______________________________________________
/*-------------------------------------------------------------------------------------------------
    10.03.2003 11:10
-------------------------------------------------------------------------------------------------*/
css::uno::Any SAL_CALL TypeDetection::getByName( const ::rtl::OUString& sName )
    throw(css::container::NoSuchElementException,
          css::lang::WrappedTargetException     ,
          css::uno::RuntimeException            )
{
    css::uno::Any aPropertyList;

    // SAFE {
    ReadGuard aReadLock(m_aLock);
    if (!m_aCache.existsType(sName))
        throw css::container::NoSuchElementException(DECLARE_ASCII("called for unknown type name"), static_cast< ::cppu::OWeakObject* >(this));
    aPropertyList <<= m_aCache.getTypeProperties(sName);
    aReadLock.unlock();
    // } SAFE

    return aPropertyList;
}

/*-------------------------------------------------------------------------------------------------
    10.03.2003 11:10
-------------------------------------------------------------------------------------------------*/
css::uno::Sequence< ::rtl::OUString > SAL_CALL TypeDetection::getElementNames()
    throw(css::uno::RuntimeException)
{
    // SAFE {
    ReadGuard aReadLock(m_aLock);
	return m_aCache.getAllTypeNames();
    // } SAFE
}

/*-------------------------------------------------------------------------------------------------
    10.03.2003 11:10
-------------------------------------------------------------------------------------------------*/
sal_Bool SAL_CALL TypeDetection::hasByName( const ::rtl::OUString& sName )
    throw(css::uno::RuntimeException)
{
    // SAFE {
    ReadGuard aReadLock(m_aLock);
    return m_aCache.existsType(sName);
    // } SAFE
}

/*-------------------------------------------------------------------------------------------------
    10.03.2003 11:10
-------------------------------------------------------------------------------------------------*/
css::uno::Type SAL_CALL TypeDetection::getElementType()
    throw(css::uno::RuntimeException)
{
    return ::getCppuType((const css::uno::Sequence< css::beans::PropertyValue >*)NULL);
}

/*-------------------------------------------------------------------------------------------------
    10.03.2003 11:10
-------------------------------------------------------------------------------------------------*/
sal_Bool SAL_CALL TypeDetection::hasElements()
    throw(css::uno::RuntimeException)
{
    // SAFE {
    ReadGuard aReadLock(m_aLock);
    return m_aCache.hasTypes();
    // } SAFE
}

/*-------------------------------------------------------------------------------------------------
    10.03.2003 11:11
-------------------------------------------------------------------------------------------------*/
void SAL_CALL TypeDetection::flush()
    throw(css::uno::RuntimeException)
{
    // SAFE {
    WriteGuard aWriteLock(m_aLock);

        // it checks all made changes
        // If it found some invalid states or items, it try to repair it.
        // If this was not successfully - we should throw an exception.
        // Because this cache will not be useable further more!
        // Supress updating of the configuration layer.
        // Otherwhise may wrong data are written to it and next start of office can fail.
        css::uno::Reference< css::uno::XInterface > xThis(static_cast< ::cppu::OWeakObject* >(this), css::uno::UNO_QUERY);
        if (!m_aCache.validateAndRepairTypes())
            throw css::uno::RuntimeException(DECLARE_ASCII("cache seams to be invalid and could not be repaired"), xThis);

        m_aCache.flush(DataContainer::E_TYPE);

    aWriteLock.unlock();
    // } SAFE

    // inform listener
    // dont lock our mutex here ...
    // we share it with this helper instance!
    ::cppu::OInterfaceContainerHelper* pContainer = m_aListenerContainer.getContainer(::getCppuType((const css::uno::Reference< css::util::XFlushListener >*)NULL));
    if (!pContainer)
        return;

    css::lang::EventObject aEvent;
    aEvent.Source = xThis;
    ::cppu::OInterfaceIteratorHelper pIterator(*pContainer);
    while (pIterator.hasMoreElements())
    {
        try
        {
            ((css::util::XFlushListener*)pIterator.next())->flushed(aEvent);
        }
        catch(const css::uno::RuntimeException&)
        {
            // fiter invalid listener (already disposed ..)
            // or may our bridge was damaged ...
            // Then we will get an exception for every remote call.
            pIterator.remove();
        }
    }
}

/*-------------------------------------------------------------------------------------------------
    10.03.2003 11:13
-------------------------------------------------------------------------------------------------*/
void SAL_CALL TypeDetection::addFlushListener( const css::uno::Reference< css::util::XFlushListener >& xListener )
    throw(css::uno::RuntimeException)
{
    if (!xListener.is())
    {
        LOG_WARNING("TypeDetection::addFlushListener()", "invalid reference - listener won't be inserted into our listener container")
        return;
    }

    // dont lock our mutex here ...
    // we share it with this helper instance!
    m_aListenerContainer.addInterface(::getCppuType((const css::uno::Reference< css::util::XFlushListener >*)NULL), xListener);
}

/*-------------------------------------------------------------------------------------------------
    10.03.2003 11:13
-------------------------------------------------------------------------------------------------*/
void SAL_CALL TypeDetection::removeFlushListener( const css::uno::Reference< css::util::XFlushListener >& xListener )
    throw(css::uno::RuntimeException)
{
    if (!xListener.is())
    {
        LOG_WARNING("TypeDetection::removeFlushListener()", "invalid reference - listener won't be inserted into our listener container")
        return;
    }

    // dont lock our mutex here ...
    // we share it with this helper instance!
    m_aListenerContainer.removeInterface(::getCppuType((const css::uno::Reference< css::util::XFlushListener >*)NULL), xListener);
}

} // namespace framework
