/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _REGION_WRAP_P_H_
#define _REGION_WRAP_P_H_

//---------------------- WARNING ----------------------//
// Whenever the following structure is edited,         //
// it's llvm declaration must be changed too in        //
// Wrapper::createRegionType !                         //
//---------------------- WARNING ----------------------//
struct RegionWrap {
  float x, y, width, height;
};

extern "C" {
  float region_wrap_left( RegionWrap* self );
  float region_wrap_top( RegionWrap* self );
  float region_wrap_right( RegionWrap* self );
  float region_wrap_bottom( RegionWrap* self );
  
  void region_wrap_intersect( RegionWrap* self, const RegionWrap* reg );
  void region_wrap_union( RegionWrap* self, const RegionWrap* reg );
  
  void region_wrap_outset( RegionWrap* self, float amount );
  void region_wrap_inset( RegionWrap* self, float amount );
}

#endif
