/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "RegionWrap_p.h"

extern "C" {

float region_wrap_left( RegionWrap* self )
{
  return self->x;
}

float region_wrap_top( RegionWrap* self )
{
  return self->y;
}

float region_wrap_right( RegionWrap* self )
{
  return self->x + self->width;
}

float region_wrap_bottom( RegionWrap* self )
{
  return self->y + self->height;
}

void region_wrap_intersect( RegionWrap* self, const RegionWrap* reg )
{
  float s_x2 = self->x + self->width;
  float s_y2 = self->y + self->height;
  float r_x2 = reg->x + reg->width;
  float r_y2 = reg->y + reg->height;
  
  if( self->x < reg->x) self->x = reg->x;
  if( self->y < reg->y) self->y = reg->y;
  self->width = ( ( s_x2 > r_x2 ) ? r_x2 : s_x2 ) - self->x;
  self->height = ( ( s_y2 > r_y2 ) ? r_y2 : s_y2 ) - self->y;
}

void region_wrap_union( RegionWrap* self, const RegionWrap* reg )
{
  float s_x2 = self->x + self->width;
  float s_y2 = self->y + self->height;
  float r_x2 = reg->x + reg->width;
  float r_y2 = reg->y + reg->height;
  
  if( self->x > reg->x) self->x = reg->x;
  if( self->y > reg->y) self->y = reg->y;
  self->width = ( ( s_x2 > r_x2 ) ? s_x2 : r_x2 ) - self->x;
  self->height = ( ( s_y2 > r_y2 ) ? s_y2 : r_y2 ) - self->y;
}

void region_wrap_outset( RegionWrap* self, float amount )
{
  self->x -= amount;
  self->y -= amount;
  self->width += 2 * amount;
  self->height += 2 * amount;
}

void region_wrap_inset( RegionWrap* self, float amount )
{
  self->x += amount;
  self->y += amount;
  self->width -= 2 * amount;
  self->height -= 2 * amount;
}

}
