/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENSHIVA_LEXER_P_H_
#define _OPENSHIVA_LEXER_P_H_

#include <GTLCore/LexerBase_p.h>

namespace GTLCore {
  class Token;
}

namespace OpenShiva {
  class Lexer : public GTLCore::LexerBase {
    public:
      /**
       * Creates a new lexer with the given stream.
       * @code
       *  std::istringstream iss(sourceCode);
       *  OpenShiva::Lexer lng( &iss);
       * @endcode
       */
      Lexer(std::istream* sstream);
      ~Lexer();
    public:
      /**
       * @return the next token
       */
      GTLCore::Token nextToken();
  };
}

#endif
