/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "TypeManager_p.h"

#include "Debug.h"

using namespace GTLCore;

bool TypeManager::Private::isKnownType(const GTLCore::String& _name) const
{
  return knownTypes.find(_name) != knownTypes.end();
}

const GTLCore::Type* TypeManager::Private::createStructure( const GTLCore::String& _name, const std::vector<GTLCore::Type::StructDataMember>& _members)
{
  GTL_DEBUG("createStructure " << _name);
  if(isKnownType( _name) )
  {
    GTL_DEBUG("Allready exist");
    return 0;
  }
  GTLCore::Type* t = new GTLCore::Type( _name, _members);
  knownTypes[ _name ] = t;
  GTL_ASSERT(isKnownType( _name) );
  return t;
}
