import "TestFramework";

int main()
{
  int errorcount = 0;
  // Data
  float x[3] = { 1, 2 ,3 };
  float y[3] = { 4, 5, 6 };
  float A[3][3] = { { 1, 2, 3 }, { 4, 5, 6 }, { 7, 8, 9 } };
  float B[3][3] = { { 10, 11, 12 }, { 13, 14, 15 }, { 16, 17, 18 } };
  float C[4][4] = { { 1, 2, 3, 4 }, { 5, 6, 7, 8 }, { 9, 10, 11, 12 }, { 13, 14, 15, 16 } };
  float D[4][4] = { { 17, 18, 19, 20 }, { 21, 22, 23, 24}, { 25, 26, 27, 28 }, { 29, 30, 31, 32} };
  
  float E[3][3] = { { 2, 2, 2 }, { 2, 0, 2 }, { 0, 1, 2 } };
  float F[4][4] = { { 2, 2, 2, 2 }, { 2, 0, 2, 0 }, { 0, 1, 2,0 }, {1, 0, 0, 2} };
  
  // Test vectors
  Test::checkNearEqualVec( mult_f_f3( 1.5, x ), { 1.5, 3.0, 4.5 }, errorcount );
  Test::checkNearEqualVec( add_f3_f3( x, y ), { 5, 7, 9 }, errorcount );
  Test::checkNearEqualVec( sub_f3_f3( x, y ), { -3, -3, -3 }, errorcount );
  Test::checkNearEqualVec( cross_f3_f3( x, y ), { -3, 6, -3 }, errorcount );
  Test::checkNearEqual( dot_f3_f3( x, y ), 32, errorcount );
  Test::checkNearEqual( length_f3( x ), 3.74166, errorcount );
  Test::checkNearEqual( length_f3( y ), 8.77496, errorcount );
  
  // Test matrixes
  Test::checkNearEqualMat( mult_f_f33( 1.5, A), { { 1.5, 3.0, 4.5 }, { 6, 7.5, 9 }, { 10.5, 12, 13.5 } }, errorcount);
  Test::checkNearEqualMat( mult_f_f44( 2.0, C), { { 2, 4, 6, 8 }, { 10, 12, 14, 16 }, { 18, 20, 22, 24 }, { 26, 28, 30, 32 } }, errorcount);
  Test::checkNearEqualMat( add_f33_f33( A, B), { { 11, 13, 15 }, { 17, 19, 21 }, { 23, 25, 27 } }, errorcount);
  Test::checkNearEqualMat( add_f44_f44( C, D), { { 18, 20, 22, 24 }, { 26, 28, 30, 32 }, { 34, 36, 38, 40 }, { 42, 44, 46, 48 } }, errorcount);
  
  Test::checkNearEqualMat( mult_f33_f33(A,B), { { 84, 90, 96 }, { 201, 216, 231 }, { 318, 342, 366} }, errorcount );
  Test::checkNearEqualMat( mult_f44_f44(C,D), { { 250, 260, 270, 280 }, { 618, 644, 670, 696 }, { 986, 1028, 1070, 1112 }, { 1354, 1412, 1470, 1528 } }, errorcount );

  Test::checkNearEqualMat( invert_f33(E), { { 0.25, 0.25, -0.5 }, { 0.5, -0.5, 0.0 }, {-0.25, 0.25, 0.5 } }, errorcount );
  Test::checkNearEqualMat( invert_f44(F), { { 0.33333, 0.33333, -0.66667, -0.33333 }, {0.66667,-0.33333, -0.33333, -0.66667}, {-0.33333, 0.16667, 0.66667, 0.33333 }, {-0.16667, -0.16667, 0.33333, 0.66667 } }, errorcount );
  
  // Test vectors+matrixes
  Test::checkNearEqualVec( mult_f3_f33( x, A ), { 30, 36, 42 }, errorcount );
  Test::checkNearEqualVec( mult_f3_f44( x, C ), {  0.70833, 0.80556, 0.90278 }, errorcount );
  
  
  
  return errorcount;
}
