/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/CafCoreTypesXml/PropertyXml.h"

#include "Doc/CafCoreTypesDoc/CPropertyDoc.h"
#include "Doc/DiagTypesDoc/CDiagSetValueDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/DiagTypesXml/DiagSetValueXml.h"

using namespace Caf;

void DiagSetValueXml::add(
	const SmartPtrCDiagSetValueDoc diagSetValueDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("DiagSetValueXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(diagSetValueDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string jobIdVal =
			BasePlatform::UuidToString(diagSetValueDoc->getJobId());
		CAF_CM_VALIDATE_STRING(jobIdVal);
		thisXml->addAttribute("jobId", jobIdVal);

		const std::string fileAliasVal = diagSetValueDoc->getFileAlias();
		CAF_CM_VALIDATE_STRING(fileAliasVal);
		thisXml->addAttribute("fileAlias", fileAliasVal);

		const SmartPtrCPropertyDoc valueVal =
			diagSetValueDoc->getValue();
		CAF_CM_VALIDATE_SMARTPTR(valueVal);

		const SmartPtrCXmlElement valueXml =
			thisXml->createAndAddElement("value");
		PropertyXml::add(valueVal, valueXml);
	}
	CAF_CM_EXIT;
}

SmartPtrCDiagSetValueDoc DiagSetValueXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("DiagSetValueXml", "parse");

	SmartPtrCDiagSetValueDoc diagSetValueDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string jobIdStrVal =
			thisXml->findRequiredAttribute("jobId");
		UUID jobIdVal = CAFCOMMON_GUID_NULL;
		if (! jobIdStrVal.empty()) {
			BasePlatform::UuidFromString(jobIdStrVal.c_str(), jobIdVal);
		}

		const std::string fileAliasStrVal =
			thisXml->findRequiredAttribute("fileAlias");
		const std::string fileAliasVal = fileAliasStrVal;

		const SmartPtrCXmlElement valueXml =
			thisXml->findRequiredChild("value");

		SmartPtrCPropertyDoc valueVal;
		if (! valueXml.IsNull()) {
			valueVal = PropertyXml::parse(valueXml);
		}

		diagSetValueDoc.CreateInstance();
		diagSetValueDoc->initialize(
			jobIdVal,
			fileAliasVal,
			valueVal);
	}
	CAF_CM_EXIT;

	return diagSetValueDoc;
}

