/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2007 Tadas Dailyda <tadas@dailyda.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __ODS_MANAGER_H
#define __ODS_MANAGER_H

#include <glib-object.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

#define	ODS_MANAGER_DBUS_PATH			"/org/openobex"
#define	ODS_MANAGER_DBUS_INTERFACE		"org.openobex.Manager"

#define ODS_MANAGER_OPP_STR		"opp"
#define ODS_MANAGER_FTP_STR		"ftp"
#define ODS_MANAGER_PBAP_STR	"pbap"

/** Standard folder browsing service UUID */
#define OBEX_FTP_UUID \
    "\xF9\xEC\x7B\xC4\x95\x3C\x11\xD2\x98\x4E\x52\x54\x00\xDC\x9E\x09"
/** Length of OBEX_FTP_UUID */
#define OBEX_FTP_UUID_LEN 16

/** Phone Book Access Profile UUID */
#define OBEX_PBAP_UUID \
    "\x79\x61\x35\xF0\xF0\xC5\x11\xD8\x09\x66\x08\x00\x20\x0C\x9A\x66"
/** Length of OBEX_PBAP_UUID */
#define OBEX_PBAP_UUID_LEN 16

#define ODS_TYPE_MANAGER	 (ods_manager_get_type ())
#define ODS_MANAGER(o)		 (G_TYPE_CHECK_INSTANCE_CAST ((o), ODS_TYPE_MANAGER, OdsManager))
#define ODS_MANAGER_CLASS(k)	 (G_TYPE_CHECK_CLASS_CAST((k), ODS_TYPE_MANAGER, OdsManagerClass))
#define ODS_IS_MANAGER(o)	 (G_TYPE_CHECK_INSTANCE_TYPE ((o), ODS_TYPE_MANAGER))
#define ODS_IS_MANAGER_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), ODS_TYPE_MANAGER))
#define ODS_MANAGER_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), ODS_TYPE_MANAGER, OdsManagerClass))

typedef struct OdsManagerPrivate OdsManagerPrivate;

typedef struct
{
	 GObject		 parent;
	 OdsManagerPrivate	*priv;
} OdsManager;

typedef struct
{
	GObjectClass	parent_class;
	void		(* session_created)		(OdsManager	*manager,
							 			const gchar *session_object);
	void		(* session_removed)		(OdsManager	*manager,
							 			const gchar *session_object);
	void		(* disposed)			(OdsManager	*manager);
	DBusGConnection *connection;
} OdsManagerClass;


GType		 ods_manager_get_type		  	(void);
OdsManager	*ods_manager_new				(void);
gboolean	 ods_manager_is_initialized		(OdsManager *manager);

gboolean	 ods_manager_create_bluetooth_session (OdsManager *manager,
											const gchar *address,
											const gchar *pattern,
											DBusGMethodInvocation *context);
gboolean	 ods_manager_create_bluetooth_server (OdsManager *manager,
											const gchar *source_address,
											const gchar *pattern,
											gboolean require_pairing,
											DBusGMethodInvocation *context);
GHashTable	*ods_manager_get_session_info (OdsManager *manager, gchar *session_object);
GHashTable	*ods_manager_get_server_info (OdsManager *manager, gchar *server_object);

G_END_DECLS

#endif /* __ODS_MANAGER_H */

