
from nevow import rend, loaders, inevow, guard, livepage


getValue = livepage.js('getValue')
changeLabel = livepage.js('changeLabel')


def onCommand(client, text):
    client.sendScript(changeLabel(text))


class XulApp(livepage.LivePage):
    docFactory = loaders.xmlfile('xul_example.xul')

    def locateChild(self, ctx, segments):
        inevow.IRequest(ctx).setHeader("Content-Type", "application/vnd.mozilla.xul+xml; charset=UTF-8")
        return rend.Page.locateChild(self, ctx, segments)

    def render_btn(self, ctx, data):
        return ctx.tag(oncommand=livepage.handler(onCommand, getValue('some-text')))


def createResource():
    return XulApp()

