from atop.store import Store, referenced, Pool, Item, NameIndex
from atop.powerup import Storeup, IPowerStation

from nevow import compy

class Book(Item):
    def __init__(self, store, title):
        Item.__init__(self, store, name = "Title: %s" % title)
        self.title = title

class ILibrary(compy.Interface):
    pass

class Library(Storeup):
    __implements__ = ILibrary
    
    powerupName = "Library"
    booksPool = referenced
    
    def setUpPools(self, store):
        # this is called only the first time we
        # initialize this powerup. By default we
        # add a book with title 1.
        self.booksPool = Pool(store)
        self.booksPool.addIndex(NameIndex)
        self.addNewBook(store, "1")
        store.setComponent(ILibrary, self)
        
    def addNewBook(self, store, title):
        newBook = Book(store, title)
        self.booksPool.addItem(newBook)
    
    def getBookByTitle(self, title):
        books = self.booksPool.queryIndex(NameIndex, startKey=title, endKey=title)
        for book in books:
            return book
        
def initialize(dbname, fsname):
    # This is store initialization. 
    s = Store(dbname, fsname)
    ps = IPowerStation(s)
    def _(s, ps):
        ps.installPowerup(Library)
    s.transact(_, s, ps)
    return s
