from twisted.application import strports, service

from nevow import rend, loaders, appserver, tags as t

import powerups as pups

class BasePage(rend.Page):
    def renderHTTP(self, *args, **kwargs):
        # We need this to avoid starting a transaction for every query we run
        # since bsddb (atop backend) needs to acquire a lock before opening the
        # database for each query.
        # Why renderHTTP? because this is where all the rendering begins. wrapping
        # from here we guarantee that each method in our subclasses are run in 
        # a transaction.
        self.original.transact(rend.Page.renderHTTP, self, *args, **kwargs) 

class LibraryPage(BasePage):
    docFactory = loaders.stan(
        t.html[
            t.head[
                t.title["My Library"]
            ],
            t.body[
                t.p(render=t.directive("book"))[
                    t.slot(name="title")
                ]
            ]
        ]
    )
    def render_book(self, ctx, data):
        # This is dumb because it's hardcoded, if you add other books
        # to the store you may try to use ctx.args.get() to pass some
        # arguments through the url
        key = "Title: 1"
        # self.original here, is actually our store.Store instance.
        # using pups.ILibrary(self.original) brings us the Powerup subclass
        # that we defined as a Store component in module powerups.py
        book = pups.ILibrary(self.original).getBookByTitle('Title: 1')
        ctx.tag.fillSlots('title', book.title)
        return ctx.tag

# starting the database
s = pups.initialize("db","fs")
site = appserver.NevowSite(resource = LibraryPage(s))
application = service.Application("Nevow_and_Atop")
webserver = strports.service("tcp:8080", site)
webserver.setServiceParent(application)
