/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util.internal;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ExecutorUtil {
    public static boolean isShutdown(Executor executor) {
        return executor instanceof ExecutorService && ((ExecutorService)executor).isShutdown();
    }

    public static void terminate(Executor ... executors) {
        Executor[] executorsCopy = new Executor[executors.length];
        for (int i = 0; i < executors.length; ++i) {
            if (executors[i] == null) {
                throw new NullPointerException("executors[" + i + "]");
            }
            executorsCopy[i] = executors[i];
        }
        block9: for (Executor e : executorsCopy) {
            if (!(e instanceof ExecutorService)) continue;
            ExecutorService es = (ExecutorService)e;
            while (true) {
                try {
                    es.shutdownNow();
                }
                catch (SecurityException ex) {
                    try {
                        es.shutdown();
                    }
                    catch (SecurityException ex2) {
                        continue block9;
                    }
                    catch (NullPointerException ex2) {
                    }
                }
                catch (NullPointerException ex) {
                    // empty catch block
                }
                try {
                    if (!es.awaitTermination(100L, TimeUnit.MILLISECONDS)) continue;
                    continue block9;
                }
                catch (InterruptedException ex) {
                    continue;
                }
                break;
            }
        }
    }

    private ExecutorUtil() {
    }
}

