/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.execution;

import java.util.LinkedList;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.handler.execution.ChannelEventRunnable;
import org.jboss.netty.handler.execution.MemoryAwareThreadPoolExecutor;
import org.jboss.netty.util.ObjectSizeEstimator;
import org.jboss.netty.util.internal.ConcurrentIdentityWeakKeyHashMap;

public class OrderedMemoryAwareThreadPoolExecutor
extends MemoryAwareThreadPoolExecutor {
    private final ConcurrentMap<Channel, Executor> childExecutors = new ConcurrentIdentityWeakKeyHashMap<Channel, Executor>();

    public OrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize);
    }

    public OrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit);
    }

    public OrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit, threadFactory);
    }

    public OrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit, ObjectSizeEstimator objectSizeEstimator, ThreadFactory threadFactory) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit, objectSizeEstimator, threadFactory);
    }

    protected void doExecute(Runnable task) {
        if (!(task instanceof ChannelEventRunnable)) {
            this.doUnorderedExecute(task);
        } else {
            ChannelEventRunnable r = (ChannelEventRunnable)task;
            this.getOrderedExecutor(r.getEvent()).execute(task);
        }
    }

    private Executor getOrderedExecutor(ChannelEvent e) {
        ChannelStateEvent se;
        Executor oldExecutor;
        Channel channel = e.getChannel();
        Executor executor = (Executor)this.childExecutors.get(channel);
        if (executor == null && (oldExecutor = this.childExecutors.putIfAbsent(channel, executor = new ChildExecutor())) != null) {
            executor = oldExecutor;
        }
        if (e instanceof ChannelStateEvent && (se = (ChannelStateEvent)e).getState() == ChannelState.OPEN && !channel.isOpen()) {
            this.childExecutors.remove(channel);
        }
        return executor;
    }

    protected boolean shouldCount(Runnable task) {
        if (task instanceof ChildExecutor) {
            return false;
        }
        return super.shouldCount(task);
    }

    void onAfterExecute(Runnable r, Throwable t) {
        this.afterExecute(r, t);
    }

    private final class ChildExecutor
    implements Executor,
    Runnable {
        private final LinkedList<Runnable> tasks = new LinkedList();

        ChildExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Runnable command) {
            boolean needsExecution;
            LinkedList<Runnable> linkedList = this.tasks;
            synchronized (linkedList) {
                needsExecution = this.tasks.isEmpty();
                this.tasks.add(command);
            }
            if (needsExecution) {
                OrderedMemoryAwareThreadPoolExecutor.this.doUnorderedExecute(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Thread thread = Thread.currentThread();
            while (true) {
                LinkedList<Runnable> linkedList;
                Object var6_5;
                Runnable task;
                LinkedList<Runnable> linkedList2 = this.tasks;
                synchronized (linkedList2) {
                    task = this.tasks.getFirst();
                }
                boolean ran = false;
                OrderedMemoryAwareThreadPoolExecutor.this.beforeExecute(thread, task);
                try {
                    try {
                        task.run();
                        ran = true;
                        OrderedMemoryAwareThreadPoolExecutor.this.onAfterExecute(task, null);
                    }
                    catch (RuntimeException e) {
                        if (ran) throw e;
                        OrderedMemoryAwareThreadPoolExecutor.this.onAfterExecute(task, e);
                        throw e;
                    }
                    var6_5 = null;
                    linkedList = this.tasks;
                }
                catch (Throwable throwable) {
                    var6_5 = null;
                    linkedList = this.tasks;
                    synchronized (linkedList) {
                        this.tasks.removeFirst();
                        if (!this.tasks.isEmpty()) throw throwable;
                        return;
                    }
                }
                synchronized (linkedList) {
                    this.tasks.removeFirst();
                    if (this.tasks.isEmpty()) {
                        return;
                    }
                }
            }
        }
    }
}

