/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.xnio;

import java.io.Closeable;
import java.net.SocketAddress;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.xnio.BaseXnioChannel;
import org.jboss.netty.channel.xnio.DefaultXnioChannelConfig;
import org.jboss.netty.channel.xnio.XnioChannelRegistry;
import org.jboss.netty.channel.xnio.XnioServerChannel;
import org.jboss.netty.channel.xnio.XnioServerChannelFactory;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.BoundServer;

final class DefaultXnioServerChannel
extends BaseXnioChannel
implements XnioServerChannel {
    private static final Object bindLock = new Object();
    final BoundServer xnioServer;

    DefaultXnioServerChannel(XnioServerChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, BoundServer xnioServer) {
        super(null, factory, pipeline, sink, new DefaultXnioChannelConfig());
        this.xnioServer = xnioServer;
        Channels.fireChannelOpen(this);
    }

    public XnioServerChannelFactory getFactory() {
        return (XnioServerChannelFactory)super.getFactory();
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.getUnsupportedOperationFuture();
    }

    public ChannelFuture disconnect() {
        return this.getUnsupportedOperationFuture();
    }

    public int getInterestOps() {
        return 0;
    }

    public ChannelFuture setInterestOps(int interestOps) {
        return this.getUnsupportedOperationFuture();
    }

    protected void setInterestOpsNow(int interestOps) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindNow(ChannelFuture future, SocketAddress localAddress) {
        try {
            Object object = bindLock;
            synchronized (object) {
                IoFuture bindFuture = this.xnioServer.bind((Object)localAddress);
                block11: while (true) {
                    IoFuture.Status bindStatus = bindFuture.await();
                    switch (bindStatus) {
                        case WAITING: {
                            continue block11;
                        }
                        case CANCELLED: {
                            throw new Error("should not reach here");
                        }
                        case DONE: {
                            break block11;
                        }
                        case FAILED: {
                            throw bindFuture.getException();
                        }
                        default: {
                            throw new Error("should not reach here: " + bindStatus);
                        }
                    }
                    break;
                }
                BoundChannel xnioChannel = (BoundChannel)bindFuture.get();
                this.xnioChannel = xnioChannel;
                XnioChannelRegistry.registerServerChannel(this);
            }
            future.setSuccess();
            Channels.fireChannelBound(this, this.getLocalAddress());
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(this, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeNow(ChannelFuture future) {
        block7: {
            SocketAddress localAddress = this.getLocalAddress();
            boolean bound = localAddress != null;
            try {
                if (this.setClosed()) {
                    future.setSuccess();
                    Object object = bindLock;
                    synchronized (object) {
                        IoUtils.safeClose((Closeable)this.xnioChannel);
                        XnioChannelRegistry.unregisterServerChannel(localAddress);
                        XnioChannelRegistry.unregisterChannelMapping(this);
                    }
                    if (bound) {
                        Channels.fireChannelUnbound(this);
                    }
                    Channels.fireChannelClosed(this);
                    break block7;
                }
                future.setSuccess();
            }
            catch (Throwable t) {
                future.setFailure(t);
                Channels.fireExceptionCaught(this, t);
            }
        }
    }
}

