/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.AbstractChannelSink;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannel;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.IoWorkerRunnable;
import org.jboss.netty.util.internal.LinkedTransferQueue;

class NioClientSocketPipelineSink
extends AbstractChannelSink {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(NioClientSocketPipelineSink.class);
    private static final AtomicInteger nextId = new AtomicInteger();
    final int id = nextId.incrementAndGet();
    final Executor bossExecutor;
    private final Boss boss = new Boss();
    private final NioWorker[] workers;
    private final AtomicInteger workerIndex = new AtomicInteger();

    NioClientSocketPipelineSink(Executor bossExecutor, Executor workerExecutor, int workerCount) {
        this.bossExecutor = bossExecutor;
        this.workers = new NioWorker[workerCount];
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = new NioWorker(this.id, i + 1, workerExecutor);
        }
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            NioClientSocketChannel channel = (NioClientSocketChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    NioWorker.close(channel, future);
                    break;
                }
                case BOUND: {
                    if (value != null) {
                        this.bind(channel, future, (SocketAddress)value);
                        break;
                    }
                    NioWorker.close(channel, future);
                    break;
                }
                case CONNECTED: {
                    if (value != null) {
                        this.connect(channel, future, (SocketAddress)value);
                        break;
                    }
                    NioWorker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    NioWorker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            boolean offered = channel.writeBuffer.offer(event);
            assert (offered);
            NioWorker.write(channel, true);
        }
    }

    private void bind(NioClientSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        try {
            channel.socket.socket().bind(localAddress);
            channel.boundManually = true;
            future.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private void connect(NioClientSocketChannel channel, ChannelFuture future, SocketAddress remoteAddress) {
        try {
            if (channel.socket.connect(remoteAddress)) {
                channel.worker.register(channel, future);
            } else {
                future.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
                channel.connectFuture = future;
                this.boss.register(channel);
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    NioWorker nextWorker() {
        return this.workers[Math.abs(this.workerIndex.getAndIncrement() % this.workers.length)];
    }

    private static final class RegisterTask
    implements Runnable {
        private final Boss boss;
        private final NioSocketChannel channel;

        RegisterTask(Boss boss, NioSocketChannel channel) {
            this.boss = boss;
            this.channel = channel;
        }

        public void run() {
            try {
                this.channel.socket.register(this.boss.selector, 8, this.channel);
            }
            catch (ClosedChannelException e) {
                throw new ChannelException("Failed to register a socket to the selector.", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Boss
    implements Runnable {
        volatile Selector selector;
        private boolean started;
        private final AtomicBoolean wakenUp = new AtomicBoolean();
        private final Object startStopLock = new Object();
        private final Queue<Runnable> registerTaskQueue = new LinkedTransferQueue<Runnable>();

        Boss() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void register(NioSocketChannel channel) {
            Selector selector;
            RegisterTask registerTask = new RegisterTask(this, channel);
            Object object = this.startStopLock;
            synchronized (object) {
                if (!this.started) {
                    try {
                        this.selector = selector = Selector.open();
                    }
                    catch (Throwable t) {
                        throw new ChannelException("Failed to create a selector.", t);
                    }
                    boolean success = false;
                    try {
                        NioClientSocketPipelineSink.this.bossExecutor.execute(new IoWorkerRunnable(new ThreadRenamingRunnable(this, "New I/O client boss #" + NioClientSocketPipelineSink.this.id)));
                        success = true;
                    }
                    finally {
                        if (!success) {
                            try {
                                selector.close();
                            }
                            catch (Throwable t) {
                                logger.warn("Failed to close a selector.", t);
                            }
                            selector = null;
                            this.selector = null;
                        }
                    }
                }
                selector = this.selector;
                assert (selector != null && selector.isOpen());
                this.started = true;
                boolean offered = this.registerTaskQueue.offer(registerTask);
                assert (offered);
            }
            if (this.wakenUp.compareAndSet(false, true)) {
                selector.wakeup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean shutdown = false;
            Selector selector = this.selector;
            while (true) {
                this.wakenUp.set(false);
                try {
                    int selectedKeyCount = selector.select(500L);
                    if (this.wakenUp.get()) {
                        selector.wakeup();
                    }
                    this.processRegisterTaskQueue();
                    if (selectedKeyCount > 0) {
                        this.processSelectedKeys(selector.selectedKeys());
                    }
                    if (selector.keys().isEmpty()) {
                        if (shutdown || NioClientSocketPipelineSink.this.bossExecutor instanceof ExecutorService && ((ExecutorService)NioClientSocketPipelineSink.this.bossExecutor).isShutdown()) {
                            Object object = this.startStopLock;
                            synchronized (object) {
                                if (this.registerTaskQueue.isEmpty() && selector.keys().isEmpty()) {
                                    this.started = false;
                                    try {
                                        selector.close();
                                    }
                                    catch (IOException e) {
                                        logger.warn("Failed to close a selector.", e);
                                    }
                                    finally {
                                        this.selector = null;
                                    }
                                    break;
                                }
                                shutdown = false;
                                continue;
                            }
                        }
                        shutdown = true;
                        continue;
                    }
                    shutdown = false;
                }
                catch (Throwable t) {
                    logger.warn("Unexpected exception in the selector loop.", t);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }

        private void processRegisterTaskQueue() {
            Runnable task;
            while ((task = this.registerTaskQueue.poll()) != null) {
                task.run();
            }
        }

        private void processSelectedKeys(Set<SelectionKey> selectedKeys) {
            Iterator<SelectionKey> i = selectedKeys.iterator();
            while (i.hasNext()) {
                SelectionKey k = i.next();
                i.remove();
                if (!k.isValid()) {
                    this.close(k);
                    continue;
                }
                if (!k.isConnectable()) continue;
                this.connect(k);
            }
        }

        private void connect(SelectionKey k) {
            NioClientSocketChannel ch = (NioClientSocketChannel)k.attachment();
            try {
                if (ch.socket.finishConnect()) {
                    k.cancel();
                    ch.worker.register(ch, ch.connectFuture);
                }
            }
            catch (Throwable t) {
                ch.connectFuture.setFailure(t);
                Channels.fireExceptionCaught(ch, t);
                this.close(k);
            }
        }

        private void close(SelectionKey k) {
            k.cancel();
            NioSocketChannel ch = (NioSocketChannel)k.attachment();
            NioWorker.close(ch, Channels.succeededFuture(ch));
        }
    }
}

