/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.http;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.local.LocalAddress;
import org.jboss.netty.channel.socket.http.HttpTunnelingChannelHandler;

public class HttpTunnelingSessionListener
implements HttpSessionListener,
ChannelHandler {
    public void sessionCreated(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        ClientBootstrap bootstrap = (ClientBootstrap)session.getServletContext().getAttribute("bootstrap");
        Boolean streaming = (Boolean)session.getServletContext().getAttribute("streaming");
        if (streaming.booleanValue()) {
            session.setMaxInactiveInterval(-1);
        }
        HttpTunnelingChannelHandler handler = new HttpTunnelingChannelHandler(streaming, session, (Long)session.getServletContext().getAttribute("reconnectTimeout"));
        session.setAttribute("handler", (Object)handler);
        bootstrap.setPipelineFactory(new HttpTunnelingChannelPipelineFactory(handler));
        ChannelFuture future = bootstrap.connect(new LocalAddress((String)session.getServletContext().getAttribute("serverChannelName")));
        future.awaitUninterruptibly();
        Channel ch = future.getChannel();
        session.setAttribute("channel", (Object)ch);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        Channel channel = (Channel)event.getSession().getAttribute("channel");
        if (channel != null) {
            channel.close();
        }
    }

    private static final class HttpTunnelingChannelPipelineFactory
    implements ChannelPipelineFactory {
        private final HttpTunnelingChannelHandler handler;

        HttpTunnelingChannelPipelineFactory(HttpTunnelingChannelHandler handler) {
            this.handler = handler;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast(HttpTunnelingSessionListener.class.getName(), this.handler);
            return pipeline;
        }
    }
}

