/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.http;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.local.DefaultLocalClientChannelFactory;

public class HttpTunnelingContextListener
implements ServletContextListener {
    private static final long DEFAULT_RECONNECT_TIMEOUT = 5000L;
    private static final boolean DEFAULT_IS_STREAMING = true;
    static final String SERVER_CHANNEL_PROP = "serverChannelName";
    static final String RECONNECT_PROP = "reconnectTimeout";
    static final String STREAMING_PROP = "streaming";
    static final String BOOTSTRAP_PROP = "bootstrap";
    private final ChannelFactory factory = new DefaultLocalClientChannelFactory();

    public void contextInitialized(ServletContextEvent context) {
        context.getServletContext().setAttribute(BOOTSTRAP_PROP, (Object)new ClientBootstrap(this.factory));
        String timeoutParam = context.getServletContext().getInitParameter(RECONNECT_PROP);
        context.getServletContext().setAttribute(RECONNECT_PROP, (Object)(timeoutParam == null ? 5000L : Long.decode(timeoutParam.trim())));
        String streaming = context.getServletContext().getInitParameter(STREAMING_PROP);
        context.getServletContext().setAttribute(STREAMING_PROP, (Object)(streaming == null ? true : Boolean.valueOf(streaming.trim())));
        String serverChannel = context.getServletContext().getInitParameter(SERVER_CHANNEL_PROP);
        context.getServletContext().setAttribute(SERVER_CHANNEL_PROP, (Object)serverChannel);
    }

    public void contextDestroyed(ServletContextEvent context) {
    }
}

