/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.http;

import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.AbstractChannelSink;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.http.HttpTunnelAddress;
import org.jboss.netty.channel.socket.http.HttpTunnelWorker;
import org.jboss.netty.channel.socket.http.HttpTunnelingClientSocketChannel;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.IoWorkerRunnable;

final class HttpTunnelingClientSocketPipelineSink
extends AbstractChannelSink {
    static final String LINE_TERMINATOR = "\r\n";
    private final Executor workerExecutor;

    HttpTunnelingClientSocketPipelineSink(Executor workerExecutor) {
        this.workerExecutor = workerExecutor;
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        HttpTunnelingClientSocketChannel channel = (HttpTunnelingClientSocketChannel)e.getChannel();
        ChannelFuture future = e.getFuture();
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent stateEvent = (ChannelStateEvent)e;
            ChannelState state = stateEvent.getState();
            Object value = stateEvent.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    HttpTunnelWorker.close(channel, future);
                    break;
                }
                case BOUND: {
                    if (value != null) {
                        this.bind(channel, future, (SocketAddress)value);
                        break;
                    }
                    HttpTunnelWorker.close(channel, future);
                    break;
                }
                case CONNECTED: {
                    if (value != null) {
                        this.connect(channel, future, (HttpTunnelAddress)value);
                        break;
                    }
                    HttpTunnelWorker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    HttpTunnelWorker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            HttpTunnelWorker.write(channel, future, ((MessageEvent)e).getMessage());
        }
    }

    private void bind(HttpTunnelingClientSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        try {
            channel.bindSocket(localAddress);
            future.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connect(HttpTunnelingClientSocketChannel channel, ChannelFuture future, HttpTunnelAddress remoteAddress) {
        boolean bound = channel.isBound();
        boolean connected = false;
        boolean workerStarted = false;
        future.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        try {
            try {
                channel.connectAndSendHeaders(false, remoteAddress);
                future.setSuccess();
                if (!bound) {
                    Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
                }
                Channels.fireChannelConnected(channel, (SocketAddress)channel.getRemoteAddress());
                this.workerExecutor.execute(new IoWorkerRunnable(new ThreadRenamingRunnable(new HttpTunnelWorker(channel), "HTTP Tunnel I/O client worker (channelId: " + channel.getId() + ", " + channel.getLocalAddress() + " => " + channel.getRemoteAddress() + ')')));
                workerStarted = true;
            }
            catch (Throwable t) {
                future.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
                Object var9_8 = null;
                if (!connected) return;
                if (workerStarted) return;
                HttpTunnelWorker.close(channel, future);
                return;
            }
            Object var9_7 = null;
            if (!connected) return;
            if (workerStarted) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!connected) throw throwable;
            if (workerStarted) throw throwable;
            HttpTunnelWorker.close(channel, future);
            throw throwable;
        }
        HttpTunnelWorker.close(channel, future);
    }
}

