/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.http;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.AbstractChannel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.SocketChannel;
import org.jboss.netty.channel.socket.SocketChannelConfig;
import org.jboss.netty.channel.socket.http.HttpTunnelAddress;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.internal.LinkedTransferQueue;

class HttpTunnelingClientSocketChannel
extends AbstractChannel
implements SocketChannel {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(HttpTunnelingClientSocketChannel.class);
    private final Lock reconnectLock = new ReentrantLock();
    volatile boolean awaitingInitialResponse = true;
    private final Object writeLock = new Object();
    final Object interestOpsLock = new Object();
    volatile Thread workerThread;
    String sessionId;
    boolean closed = false;
    LinkedTransferQueue<byte[]> messages = new LinkedTransferQueue();
    private final ClientSocketChannelFactory clientSocketChannelFactory;
    SocketChannel channel;
    private final DelimiterBasedFrameDecoder handler = new DelimiterBasedFrameDecoder(8092, ChannelBuffers.wrappedBuffer(new byte[]{13, 10}));
    private final ServletChannelHandler servletHandler = new ServletChannelHandler();
    private HttpTunnelAddress remoteAddress;

    HttpTunnelingClientSocketChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, ClientSocketChannelFactory clientSocketChannelFactory) {
        super(null, factory, pipeline, sink);
        this.clientSocketChannelFactory = clientSocketChannelFactory;
        DefaultChannelPipeline channelPipeline = new DefaultChannelPipeline();
        channelPipeline.addLast("DelimiterBasedFrameDecoder", this.handler);
        channelPipeline.addLast("servletHandler", this.servletHandler);
        this.channel = clientSocketChannelFactory.newChannel(channelPipeline);
        Channels.fireChannelOpen(this);
    }

    public SocketChannelConfig getConfig() {
        return this.channel.getConfig();
    }

    public InetSocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.channel.getRemoteAddress();
    }

    public boolean isBound() {
        return this.channel.isOpen();
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    protected boolean setClosed() {
        return super.setClosed();
    }

    protected void setInterestOpsNow(int interestOps) {
        super.setInterestOpsNow(interestOps);
    }

    public ChannelFuture write(Object message, SocketAddress remoteAddress) {
        if (remoteAddress == null || remoteAddress.equals(this.getRemoteAddress())) {
            return super.write(message, null);
        }
        return this.getUnsupportedOperationFuture();
    }

    void connectAndSendHeaders(boolean reconnect, HttpTunnelAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
        URI url = remoteAddress.getUri();
        if (reconnect) {
            this.closeSocket();
            DefaultChannelPipeline channelPipeline = new DefaultChannelPipeline();
            channelPipeline.addLast("DelimiterBasedFrameDecoder", this.handler);
            channelPipeline.addLast("servletHandler", this.servletHandler);
            this.channel = this.clientSocketChannelFactory.newChannel(channelPipeline);
        }
        InetSocketAddress connectAddress = new InetSocketAddress(url.getHost(), url.getPort());
        this.channel.connect(connectAddress).awaitUninterruptibly();
        StringBuilder builder = new StringBuilder();
        builder.append("POST ").append(url.getRawPath()).append(" HTTP/1.1").append("\r\n").append("Host: ").append(url.getHost()).append(":").append(url.getPort()).append("\r\n").append("Content-Type: application/octet-stream").append("\r\n").append("Transfer-Encoding: chunked").append("\r\n").append("Content-Transfer-Encoding: Binary").append("\r\n").append("Connection: Keep-Alive").append("\r\n");
        if (reconnect) {
            builder.append("Cookie: JSESSIONID=").append(this.sessionId).append("\r\n");
        }
        builder.append("\r\n");
        String msg = builder.toString();
        this.channel.write(ChannelBuffers.copiedBuffer(msg, "ASCII"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sendChunk(ChannelBuffer a) {
        int size = a.readableBytes();
        String hex = Integer.toHexString(size) + "\r\n";
        Object object = this.writeLock;
        synchronized (object) {
            ChannelFuture future = this.channel.write(ChannelBuffers.wrappedBuffer(ChannelBuffers.copiedBuffer(hex, "ASCII"), a, ChannelBuffers.copiedBuffer("\r\n", "ASCII")));
            future.awaitUninterruptibly();
        }
        return size + hex.length() + "\r\n".length();
    }

    byte[] receiveChunk() {
        byte[] buf = null;
        try {
            buf = this.messages.take();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconnect() throws Exception {
        if (this.closed) {
            throw new IllegalStateException("channel closed");
        }
        if (this.reconnectLock.tryLock()) {
            try {
                this.awaitingInitialResponse = true;
                this.connectAndSendHeaders(true, this.remoteAddress);
            }
            finally {
                this.reconnectLock.unlock();
            }
        }
        try {
            this.reconnectLock.lock();
        }
        finally {
            this.reconnectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeSocket() {
        if (this.setClosed()) {
            Object object = this.writeLock;
            synchronized (object) {
                ChannelFuture future = this.channel.write(ChannelBuffers.copiedBuffer("0\r\n\r\n", "ASCII"));
                future.awaitUninterruptibly();
            }
            this.closed = true;
            this.channel.close();
        }
    }

    void bindSocket(SocketAddress localAddress) {
        this.channel.bind(localAddress);
    }

    @ChannelPipelineCoverage(value="one")
    class ServletChannelHandler
    extends SimpleChannelUpstreamHandler {
        int nextChunkSize = -1;

        ServletChannelHandler() {
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            ChannelBuffer buf = (ChannelBuffer)e.getMessage();
            byte[] bytes = new byte[buf.readableBytes()];
            buf.getBytes(0, bytes);
            if (HttpTunnelingClientSocketChannel.this.awaitingInitialResponse) {
                String line = new String(bytes);
                if (line.contains("Set-Cookie")) {
                    int start = line.indexOf("JSESSIONID=") + 11;
                    int end = line.indexOf(";", start);
                    HttpTunnelingClientSocketChannel.this.sessionId = line.substring(start, end);
                } else if (line.equals("")) {
                    HttpTunnelingClientSocketChannel.this.awaitingInitialResponse = false;
                }
            } else if (this.nextChunkSize == -1) {
                String hex = new String(bytes);
                this.nextChunkSize = Integer.parseInt(hex, 16);
                if (this.nextChunkSize == 0 && !HttpTunnelingClientSocketChannel.this.closed) {
                    this.nextChunkSize = -1;
                    HttpTunnelingClientSocketChannel.this.awaitingInitialResponse = true;
                    HttpTunnelingClientSocketChannel.this.reconnect();
                }
            } else {
                HttpTunnelingClientSocketChannel.this.messages.put(bytes);
                this.nextChunkSize = -1;
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            logger.warn("Unexpected exception", e.getCause());
            HttpTunnelingClientSocketChannel.this.channel.close();
        }
    }
}

