/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.buffer;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.UnsupportedCharsetException;
import org.jboss.netty.buffer.BigEndianHeapChannelBuffer;
import org.jboss.netty.buffer.ByteBufferBackedChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBufferIndexFinder;
import org.jboss.netty.buffer.CompositeChannelBuffer;
import org.jboss.netty.buffer.DynamicChannelBuffer;
import org.jboss.netty.buffer.LittleEndianHeapChannelBuffer;
import org.jboss.netty.buffer.ReadOnlyChannelBuffer;
import org.jboss.netty.buffer.SlicedChannelBuffer;
import org.jboss.netty.buffer.TruncatedChannelBuffer;

public class ChannelBuffers {
    public static final ByteOrder BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
    public static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
    public static final ChannelBuffer EMPTY_BUFFER = new BigEndianHeapChannelBuffer(0);
    private static final char[] HEXDUMP_TABLE = new char[1024];

    public static ChannelBuffer buffer(int capacity) {
        return ChannelBuffers.buffer(BIG_ENDIAN, capacity);
    }

    public static ChannelBuffer buffer(ByteOrder endianness, int capacity) {
        if (endianness == BIG_ENDIAN) {
            if (capacity == 0) {
                return EMPTY_BUFFER;
            }
            return new BigEndianHeapChannelBuffer(capacity);
        }
        if (endianness == LITTLE_ENDIAN) {
            if (capacity == 0) {
                return EMPTY_BUFFER;
            }
            return new LittleEndianHeapChannelBuffer(capacity);
        }
        throw new NullPointerException("endianness");
    }

    public static ChannelBuffer directBuffer(int capacity) {
        return ChannelBuffers.directBuffer(BIG_ENDIAN, capacity);
    }

    public static ChannelBuffer directBuffer(ByteOrder endianness, int capacity) {
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        if (capacity == 0) {
            return EMPTY_BUFFER;
        }
        ByteBufferBackedChannelBuffer buffer = new ByteBufferBackedChannelBuffer(ByteBuffer.allocateDirect(capacity).order(endianness));
        buffer.clear();
        return buffer;
    }

    public static ChannelBuffer dynamicBuffer() {
        return ChannelBuffers.dynamicBuffer(BIG_ENDIAN, 256);
    }

    public static ChannelBuffer dynamicBuffer(ChannelBufferFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        return new DynamicChannelBuffer(factory.getDefaultOrder(), 256, factory);
    }

    public static ChannelBuffer dynamicBuffer(int estimatedLength) {
        return ChannelBuffers.dynamicBuffer(BIG_ENDIAN, estimatedLength);
    }

    public static ChannelBuffer dynamicBuffer(ByteOrder endianness, int estimatedLength) {
        return new DynamicChannelBuffer(endianness, estimatedLength);
    }

    public static ChannelBuffer dynamicBuffer(int estimatedLength, ChannelBufferFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        return new DynamicChannelBuffer(factory.getDefaultOrder(), estimatedLength, factory);
    }

    public static ChannelBuffer dynamicBuffer(ByteOrder endianness, int estimatedLength, ChannelBufferFactory factory) {
        return new DynamicChannelBuffer(endianness, estimatedLength, factory);
    }

    public static ChannelBuffer wrappedBuffer(byte[] array) {
        return ChannelBuffers.wrappedBuffer(BIG_ENDIAN, array);
    }

    public static ChannelBuffer wrappedBuffer(ByteOrder endianness, byte[] array) {
        if (endianness == BIG_ENDIAN) {
            if (array.length == 0) {
                return EMPTY_BUFFER;
            }
            return new BigEndianHeapChannelBuffer(array);
        }
        if (endianness == LITTLE_ENDIAN) {
            if (array.length == 0) {
                return EMPTY_BUFFER;
            }
            return new LittleEndianHeapChannelBuffer(array);
        }
        throw new NullPointerException("endianness");
    }

    public static ChannelBuffer wrappedBuffer(byte[] array, int offset, int length) {
        return ChannelBuffers.wrappedBuffer(BIG_ENDIAN, array, offset, length);
    }

    public static ChannelBuffer wrappedBuffer(ByteOrder endianness, byte[] array, int offset, int length) {
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        if (offset == 0) {
            if (length == array.length) {
                return ChannelBuffers.wrappedBuffer(endianness, array);
            }
            if (length == 0) {
                return EMPTY_BUFFER;
            }
            return new TruncatedChannelBuffer(ChannelBuffers.wrappedBuffer(endianness, array), length);
        }
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        return new SlicedChannelBuffer(ChannelBuffers.wrappedBuffer(endianness, array), offset, length);
    }

    public static ChannelBuffer wrappedBuffer(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return EMPTY_BUFFER;
        }
        if (!buffer.isReadOnly() && buffer.hasArray()) {
            return ChannelBuffers.wrappedBuffer(buffer.array(), buffer.arrayOffset(), buffer.remaining());
        }
        return new ByteBufferBackedChannelBuffer(buffer);
    }

    public static ChannelBuffer wrappedBuffer(ChannelBuffer buffer) {
        if (buffer.readable()) {
            return buffer.slice();
        }
        return EMPTY_BUFFER;
    }

    public static ChannelBuffer wrappedBuffer(byte[] ... arrays) {
        return ChannelBuffers.wrappedBuffer(BIG_ENDIAN, arrays);
    }

    public static ChannelBuffer wrappedBuffer(ByteOrder endianness, byte[] ... arrays) {
        switch (arrays.length) {
            case 0: {
                break;
            }
            case 1: {
                if (arrays[0].length == 0) break;
                return ChannelBuffers.wrappedBuffer(endianness, arrays[0]);
            }
            default: {
                ChannelBuffer[] wrappedBuffers = new ChannelBuffer[arrays.length];
                for (int i = 0; i < arrays.length; ++i) {
                    wrappedBuffers[i] = ChannelBuffers.wrappedBuffer(endianness, arrays[i]);
                }
                return ChannelBuffers.wrappedBuffer(wrappedBuffers);
            }
        }
        return EMPTY_BUFFER;
    }

    public static ChannelBuffer wrappedBuffer(ChannelBuffer ... buffers) {
        switch (buffers.length) {
            case 0: {
                break;
            }
            case 1: {
                if (!buffers[0].readable()) break;
                return ChannelBuffers.wrappedBuffer(buffers[0]);
            }
            default: {
                for (ChannelBuffer b : buffers) {
                    if (!b.readable()) continue;
                    return new CompositeChannelBuffer(buffers);
                }
            }
        }
        return EMPTY_BUFFER;
    }

    public static ChannelBuffer wrappedBuffer(ByteBuffer ... buffers) {
        switch (buffers.length) {
            case 0: {
                break;
            }
            case 1: {
                if (!buffers[0].hasRemaining()) break;
                return ChannelBuffers.wrappedBuffer(buffers[0]);
            }
            default: {
                ChannelBuffer[] wrappedBuffers = new ChannelBuffer[buffers.length];
                for (int i = 0; i < buffers.length; ++i) {
                    wrappedBuffers[i] = ChannelBuffers.wrappedBuffer(buffers[i]);
                }
                return ChannelBuffers.wrappedBuffer(wrappedBuffers);
            }
        }
        return EMPTY_BUFFER;
    }

    public static ChannelBuffer copiedBuffer(byte[] array) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, array);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, byte[] array) {
        if (endianness == BIG_ENDIAN) {
            if (array.length == 0) {
                return EMPTY_BUFFER;
            }
            return new BigEndianHeapChannelBuffer((byte[])array.clone());
        }
        if (endianness == LITTLE_ENDIAN) {
            if (array.length == 0) {
                return EMPTY_BUFFER;
            }
            return new LittleEndianHeapChannelBuffer((byte[])array.clone());
        }
        throw new NullPointerException("endianness");
    }

    public static ChannelBuffer copiedBuffer(byte[] array, int offset, int length) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, array, offset, length);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, byte[] array, int offset, int length) {
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        byte[] copy = new byte[length];
        System.arraycopy(array, offset, copy, 0, length);
        return ChannelBuffers.wrappedBuffer(endianness, copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChannelBuffer copiedBuffer(ByteBuffer buffer) {
        int length = buffer.remaining();
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        byte[] copy = new byte[length];
        int position = buffer.position();
        try {
            buffer.get(copy);
        }
        finally {
            buffer.position(position);
        }
        return ChannelBuffers.wrappedBuffer(buffer.order(), copy);
    }

    public static ChannelBuffer copiedBuffer(ChannelBuffer buffer) {
        if (buffer.readable()) {
            return buffer.copy();
        }
        return EMPTY_BUFFER;
    }

    public static ChannelBuffer copiedBuffer(byte[] ... arrays) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, arrays);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, byte[] ... arrays) {
        switch (arrays.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                if (arrays[0].length == 0) {
                    return EMPTY_BUFFER;
                }
                return ChannelBuffers.copiedBuffer(endianness, arrays[0]);
            }
        }
        int length = 0;
        for (byte[] a : arrays) {
            if (Integer.MAX_VALUE - length < a.length) {
                throw new IllegalArgumentException("The total length of the specified arrays is too big.");
            }
            length += a.length;
        }
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        byte[] mergedArray = new byte[length];
        int j = 0;
        for (int i = 0; i < arrays.length; ++i) {
            byte[] a;
            a = arrays[i];
            System.arraycopy(a, 0, mergedArray, j, a.length);
            j += a.length;
        }
        return ChannelBuffers.wrappedBuffer(endianness, mergedArray);
    }

    public static ChannelBuffer copiedBuffer(ChannelBuffer ... buffers) {
        switch (buffers.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return ChannelBuffers.copiedBuffer(buffers[0]);
            }
        }
        ChannelBuffer[] copiedBuffers = new ChannelBuffer[buffers.length];
        for (int i = 0; i < buffers.length; ++i) {
            copiedBuffers[i] = ChannelBuffers.copiedBuffer(buffers[i]);
        }
        return ChannelBuffers.wrappedBuffer(copiedBuffers);
    }

    public static ChannelBuffer copiedBuffer(ByteBuffer ... buffers) {
        switch (buffers.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return ChannelBuffers.copiedBuffer(buffers[0]);
            }
        }
        ChannelBuffer[] copiedBuffers = new ChannelBuffer[buffers.length];
        for (int i = 0; i < buffers.length; ++i) {
            copiedBuffers[i] = ChannelBuffers.copiedBuffer(buffers[i]);
        }
        return ChannelBuffers.wrappedBuffer(copiedBuffers);
    }

    public static ChannelBuffer copiedBuffer(String string, String charsetName) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, string, charsetName);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, String string, String charsetName) {
        try {
            return ChannelBuffers.wrappedBuffer(endianness, string.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedCharsetException(charsetName);
        }
    }

    public static ChannelBuffer unmodifiableBuffer(ChannelBuffer buffer) {
        if (buffer instanceof ReadOnlyChannelBuffer) {
            buffer = ((ReadOnlyChannelBuffer)buffer).unwrap();
        }
        return new ReadOnlyChannelBuffer(buffer);
    }

    public static String hexDump(ChannelBuffer buffer) {
        return ChannelBuffers.hexDump(buffer, buffer.readerIndex(), buffer.readableBytes());
    }

    public static String hexDump(ChannelBuffer buffer, int fromIndex, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length: " + length);
        }
        if (length == 0) {
            return "";
        }
        int endIndex = fromIndex + length;
        char[] buf = new char[length << 1];
        int srcIdx = fromIndex;
        int dstIdx = 0;
        while (srcIdx < endIndex) {
            System.arraycopy(HEXDUMP_TABLE, buffer.getUnsignedByte(srcIdx) << 1, buf, dstIdx, 2);
            ++srcIdx;
            dstIdx += 2;
        }
        return new String(buf);
    }

    public static int hashCode(ChannelBuffer buffer) {
        int i;
        int aLen = buffer.readableBytes();
        int intCount = aLen >>> 2;
        int byteCount = aLen & 3;
        int hashCode = 1;
        int arrayIndex = buffer.readerIndex();
        if (buffer.order() == BIG_ENDIAN) {
            for (i = intCount; i > 0; --i) {
                hashCode = 31 * hashCode + buffer.getInt(arrayIndex);
                arrayIndex += 4;
            }
        } else {
            for (i = intCount; i > 0; --i) {
                hashCode = 31 * hashCode + ChannelBuffers.swapInt(buffer.getInt(arrayIndex));
                arrayIndex += 4;
            }
        }
        for (i = byteCount; i > 0; --i) {
            hashCode = 31 * hashCode + buffer.getByte(arrayIndex++);
        }
        if (hashCode == 0) {
            hashCode = 1;
        }
        return hashCode;
    }

    public static boolean equals(ChannelBuffer bufferA, ChannelBuffer bufferB) {
        int i;
        int aLen = bufferA.readableBytes();
        if (aLen != bufferB.readableBytes()) {
            return false;
        }
        int longCount = aLen >>> 3;
        int byteCount = aLen & 7;
        int aIndex = bufferA.readerIndex();
        int bIndex = bufferB.readerIndex();
        if (bufferA.order() == bufferB.order()) {
            for (i = longCount; i > 0; --i) {
                if (bufferA.getLong(aIndex) != bufferB.getLong(bIndex)) {
                    return false;
                }
                aIndex += 8;
                bIndex += 8;
            }
        } else {
            for (i = longCount; i > 0; --i) {
                if (bufferA.getLong(aIndex) != ChannelBuffers.swapLong(bufferB.getLong(bIndex))) {
                    return false;
                }
                aIndex += 8;
                bIndex += 8;
            }
        }
        for (i = byteCount; i > 0; --i) {
            if (bufferA.getByte(aIndex) != bufferB.getByte(bIndex)) {
                return false;
            }
            ++aIndex;
            ++bIndex;
        }
        return true;
    }

    public static int compare(ChannelBuffer bufferA, ChannelBuffer bufferB) {
        long vb;
        long va;
        int i;
        int aLen = bufferA.readableBytes();
        int bLen = bufferB.readableBytes();
        int minLength = Math.min(aLen, bLen);
        int uintCount = minLength >>> 2;
        int byteCount = minLength & 3;
        int aIndex = bufferA.readerIndex();
        int bIndex = bufferB.readerIndex();
        if (bufferA.order() == bufferB.order()) {
            for (i = uintCount; i > 0; --i) {
                va = bufferA.getUnsignedInt(aIndex);
                if (va > (vb = bufferB.getUnsignedInt(bIndex))) {
                    return 1;
                }
                if (va < vb) {
                    return -1;
                }
                aIndex += 4;
                bIndex += 4;
            }
        } else {
            for (i = uintCount; i > 0; --i) {
                va = bufferA.getUnsignedInt(aIndex);
                if (va > (vb = (long)ChannelBuffers.swapInt(bufferB.getInt(bIndex)) & 0xFFFFFFFFL)) {
                    return 1;
                }
                if (va < vb) {
                    return -1;
                }
                aIndex += 4;
                bIndex += 4;
            }
        }
        for (i = byteCount; i > 0; --i) {
            byte vb2;
            byte va2 = bufferA.getByte(aIndex);
            if (va2 > (vb2 = bufferB.getByte(bIndex))) {
                return 1;
            }
            if (va2 < vb2) {
                return -1;
            }
            ++aIndex;
            ++bIndex;
        }
        return aLen - bLen;
    }

    public static int indexOf(ChannelBuffer buffer, int fromIndex, int toIndex, byte value) {
        if (fromIndex <= toIndex) {
            return ChannelBuffers.firstIndexOf(buffer, fromIndex, toIndex, value);
        }
        return ChannelBuffers.lastIndexOf(buffer, fromIndex, toIndex, value);
    }

    public static int indexOf(ChannelBuffer buffer, int fromIndex, int toIndex, ChannelBufferIndexFinder indexFinder) {
        if (fromIndex <= toIndex) {
            return ChannelBuffers.firstIndexOf(buffer, fromIndex, toIndex, indexFinder);
        }
        return ChannelBuffers.lastIndexOf(buffer, fromIndex, toIndex, indexFinder);
    }

    public static short swapShort(short value) {
        return (short)(value << 8 | value >>> 8 & 0xFF);
    }

    public static int swapMedium(int value) {
        return value << 16 & 0xFF0000 | value & 0xFF00 | value >>> 16 & 0xFF;
    }

    public static int swapInt(int value) {
        return ChannelBuffers.swapShort((short)value) << 16 | ChannelBuffers.swapShort((short)(value >>> 16)) & 0xFFFF;
    }

    public static long swapLong(long value) {
        return (long)ChannelBuffers.swapInt((int)value) << 32 | (long)ChannelBuffers.swapInt((int)(value >>> 32)) & 0xFFFFFFFFL;
    }

    private static int firstIndexOf(ChannelBuffer buffer, int fromIndex, int toIndex, byte value) {
        if ((fromIndex = Math.max(fromIndex, 0)) >= toIndex || buffer.capacity() == 0) {
            return -1;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            if (buffer.getByte(i) != value) continue;
            return i;
        }
        return -1;
    }

    private static int lastIndexOf(ChannelBuffer buffer, int fromIndex, int toIndex, byte value) {
        if ((fromIndex = Math.min(fromIndex, buffer.capacity())) < 0 || buffer.capacity() == 0) {
            return -1;
        }
        for (int i = fromIndex - 1; i >= toIndex; --i) {
            if (buffer.getByte(i) != value) continue;
            return i;
        }
        return -1;
    }

    private static int firstIndexOf(ChannelBuffer buffer, int fromIndex, int toIndex, ChannelBufferIndexFinder indexFinder) {
        if ((fromIndex = Math.max(fromIndex, 0)) >= toIndex || buffer.capacity() == 0) {
            return -1;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!indexFinder.find(buffer, i)) continue;
            return i;
        }
        return -1;
    }

    private static int lastIndexOf(ChannelBuffer buffer, int fromIndex, int toIndex, ChannelBufferIndexFinder indexFinder) {
        if ((fromIndex = Math.min(fromIndex, buffer.capacity())) < 0 || buffer.capacity() == 0) {
            return -1;
        }
        for (int i = fromIndex - 1; i >= toIndex; --i) {
            if (!indexFinder.find(buffer, i)) continue;
            return i;
        }
        return -1;
    }

    private ChannelBuffers() {
    }

    static {
        char[] DIGITS = "0123456789abcdef".toCharArray();
        for (int i = 0; i < 256; ++i) {
            ChannelBuffers.HEXDUMP_TABLE[(i << 1) + 0] = DIGITS[i >>> 4 & 0xF];
            ChannelBuffers.HEXDUMP_TABLE[(i << 1) + 1] = DIGITS[i >>> 0 & 0xF];
        }
    }
}

