/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.bootstrap;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.internal.MapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bootstrap
implements ExternalResourceReleasable {
    private volatile ChannelFactory factory;
    private volatile ChannelPipeline pipeline = Channels.pipeline();
    private volatile ChannelPipelineFactory pipelineFactory = Channels.pipelineFactory(this.pipeline);
    private volatile Map<String, Object> options = new HashMap<String, Object>();

    protected Bootstrap() {
    }

    protected Bootstrap(ChannelFactory channelFactory) {
        this.setFactory(channelFactory);
    }

    public ChannelFactory getFactory() {
        ChannelFactory factory = this.factory;
        if (factory == null) {
            throw new IllegalStateException("factory is not set yet.");
        }
        return factory;
    }

    public void setFactory(ChannelFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (this.factory != null) {
            throw new IllegalStateException("factory can't change once set.");
        }
        this.factory = factory;
    }

    public ChannelPipeline getPipeline() {
        ChannelPipeline pipeline = this.pipeline;
        if (pipeline == null) {
            throw new IllegalStateException("getPipeline() cannot be called if setPipelineFactory() was called.");
        }
        return pipeline;
    }

    public void setPipeline(ChannelPipeline pipeline) {
        if (pipeline == null) {
            throw new NullPointerException("pipeline");
        }
        this.pipeline = pipeline;
        this.pipelineFactory = Channels.pipelineFactory(pipeline);
    }

    public Map<String, ChannelHandler> getPipelineAsMap() {
        ChannelPipeline pipeline = this.pipeline;
        if (pipeline == null) {
            throw new IllegalStateException("pipelineFactory in use");
        }
        return pipeline.toMap();
    }

    public void setPipelineAsMap(Map<String, ChannelHandler> pipelineMap) {
        if (pipelineMap == null) {
            throw new NullPointerException("pipelineMap");
        }
        if (!MapUtil.isOrderedMap(pipelineMap)) {
            throw new IllegalArgumentException("pipelineMap is not an ordered map. Please use " + LinkedHashMap.class.getName() + ".");
        }
        ChannelPipeline pipeline = Channels.pipeline();
        for (Map.Entry<String, ChannelHandler> e : pipelineMap.entrySet()) {
            pipeline.addLast(e.getKey(), e.getValue());
        }
        this.setPipeline(pipeline);
    }

    public ChannelPipelineFactory getPipelineFactory() {
        return this.pipelineFactory;
    }

    public void setPipelineFactory(ChannelPipelineFactory pipelineFactory) {
        if (pipelineFactory == null) {
            throw new NullPointerException("pipelineFactory");
        }
        this.pipeline = null;
        this.pipelineFactory = pipelineFactory;
    }

    public Map<String, Object> getOptions() {
        return new TreeMap<String, Object>(this.options);
    }

    public void setOptions(Map<String, Object> options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.options = new HashMap<String, Object>(options);
    }

    public Object getOption(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.options.get(key);
    }

    public void setOption(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            this.options.remove(key);
        } else {
            this.options.put(key, value);
        }
    }

    @Override
    public void releaseExternalResources() {
        ChannelFactory factory = this.factory;
        if (factory != null) {
            factory.releaseExternalResources();
        }
    }
}

