/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "nl-favorite.h"

G_DEFINE_ABSTRACT_TYPE (NlFavorite, nl_favorite, CTK_TYPE_BIN);

enum
{
  BEGIN_DRAG_MOVE,
  REMOVE_ME,
  ACTIVE,

  LAST_SIGNAL
};

/* Globals */
static guint32 _fav_signals[LAST_SIGNAL] = { 0 };

/* Forwards */


/* GObject stuff */
static void
nl_favorite_finalize (GObject *object)
{
  G_OBJECT_CLASS (nl_favorite_parent_class)->finalize (object);
}


static void
nl_favorite_class_init (NlFavoriteClass *klass)
{
  GObjectClass      *obj_class = G_OBJECT_CLASS (klass);

  obj_class->finalize     = nl_favorite_finalize;

  _fav_signals[BEGIN_DRAG_MOVE] =
    g_signal_new ("begin-drag-move",
                  G_OBJECT_CLASS_TYPE (obj_class),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET (NlFavoriteClass, begin_drag_move),
                  NULL, NULL,
                  g_cclosure_marshal_VOID__POINTER,
                  G_TYPE_NONE, 1, G_TYPE_POINTER);

  _fav_signals[REMOVE_ME] =
    g_signal_new ("remove-me",
                  G_OBJECT_CLASS_TYPE (obj_class),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET (NlFavoriteClass, remove_me),
                  NULL, NULL,
                  g_cclosure_marshal_VOID__VOID,
                  G_TYPE_NONE, 0);

  _fav_signals[ACTIVE] =
    g_signal_new ("active",
                  G_OBJECT_CLASS_TYPE (obj_class),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET (NlFavoriteClass, active),
                  NULL, NULL,
                  g_cclosure_marshal_VOID__VOID,
                  G_TYPE_NONE, 0);

}

static void
nl_favorite_init (NlFavorite *tile)
{
}

/*
 * Private methods
 */

/*
 * Public methods
 */
const gchar *
nl_favorite_get_name (NlFavorite *self)
{
  NlFavoriteClass *klass;

  g_return_val_if_fail (NL_IS_FAVORITE (self), NULL);
  klass = NL_FAVORITE_GET_CLASS (self);

  if (klass->get_name)
    return klass->get_name (self);

  return NULL;
}

GdkPixbuf *
nl_favorite_get_icon (NlFavorite *self)
{
  NlFavoriteClass *klass;

  g_return_val_if_fail (NL_IS_FAVORITE (self), NULL);
  klass = NL_FAVORITE_GET_CLASS (self);

  if (klass->get_icon)
    return klass->get_icon (self);

  return NULL;
}

void
nl_favorite_removed  (NlFavorite *self)
{
  NlFavoriteClass *klass;

  g_return_if_fail (NL_IS_FAVORITE (self));
  klass = NL_FAVORITE_GET_CLASS (self);

  if (klass->removed)
    klass->removed (self);
}

NlFavoriteViewType
nl_favorite_get_view_type (NlFavorite *self)
{
  NlFavoriteClass *klass;

  g_return_val_if_fail (NL_IS_FAVORITE (self), NL_FAVORITE_VIEW_FIXED);
  klass = NL_FAVORITE_GET_CLASS (self);

  if (klass->get_view_type)
    return klass->get_view_type (self);

  return NL_FAVORITE_VIEW_FIXED;
}
