/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_DRAG_SERVER_H_
#define _NL_DRAG_SERVER_H_

#include <glib.h>
#include <clutter/clutter.h>

#include <netbook-launcher/nl-drag-dest.h>

#define CLUTTER_TYPE_DRAG_SERVER (nl_drag_server_get_type ())

#define NL_DRAG_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CLUTTER_TYPE_DRAG_SERVER, NlDragServer))

#define NL_DRAG_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CLUTTER_TYPE_DRAG_SERVER, NlDragServerClass))

#define CLUTTER_IS_DRAG_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CLUTTER_TYPE_DRAG_SERVER))

#define CLUTTER_IS_DRAG_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CLUTTER_TYPE_DRAG_SERVER))

#define NL_DRAG_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CLUTTER_TYPE_DRAG_SERVER, NlDragServerClass))

typedef struct _NlDragServer        NlDragServer;
typedef struct _NlDragServerClass   NlDragServerClass;
typedef struct _NlDragServerPrivate NlDragServerPrivate;
 
struct _NlDragServer
{
  GObject        parent;	

  NlDragServerPrivate *priv;
};

struct _NlDragServerClass
{
  GObjectClass   parent_class;

  /*<signals>*/
  void (*drag_started)  (NlDragServer *server);
  void (*drag_finished) (NlDragServer *server);
};

GType          nl_drag_server_get_type         (void) G_GNUC_CONST;

NlDragServer * nl_drag_server_get_default      (void);

void           nl_drag_server_add_drag_dest    (NlDragServer *server,
                                                NlDragDest *dest);
void           nl_drag_server_remove_drag_dest (NlDragServer *server,
                                                NlDragDest *dest);


void           nl_drag_server_begin_drag       (NlDragServer *server,
                                                ClutterActor      *context,
                                                gpointer           udata);

void           nl_drag_server_finish_drag      (NlDragServer *);

#endif /* _NL_DRAG_SERVER_H_ */

