/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */


#ifndef __NL_SHELL_H__
#define __NL_SHELL_H__

#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <netbook-launcher/nl-content-view.h>
#include <netbook-launcher/nl-favorites-loader.h>
#include <netbook-launcher/nl-sidebar.h>

G_BEGIN_DECLS

#define NL_TYPE_SHELL (nl_shell_get_type ())
#define NL_SHELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
        NL_TYPE_SHELL, NlShell))
#define NL_IS_SHELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
        NL_TYPE_SHELL))
#define NL_SHELL_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), \
        NL_TYPE_SHELL, NlShellIface))

typedef struct _NlShell        NlShell;
typedef struct _NlShellIface   NlShellIface;

typedef gchar * (*NlShellGetFavoriteDataFunc) (GObject *origin);
typedef void    (*NlShellDragFinishedFunc)    (GObject *origin);

struct _NlShellIface
{
  /*< private >*/
  GTypeInterface g_iface;

  /*< public >*/
  ClutterActor  * (*get_stage)             (NlShell           *self);

  NlContentView * (*get_content_view)      (NlShell           *self);

  NlSidebar     * (*get_sidebar)           (NlShell           *self);

  GSList        * (*get_favorites_loaders) (NlShell           *self);

  void            (*add_places_source)     (NlShell           *self,
                                            ClutterActor      *source);

  void            (*add_favorites_loader)  (NlShell           *self,
                                            NlFavoritesLoader *l);
                                            
  void            (*show_favorites)        (NlShell           *self);

  GtkWidget     * (*get_toplevel)          (NlShell           *self);

  void            (*begin_favorite_drag)   (NlShell           *shell,
                                            GObject           *origin,
                                            ClutterActor      *clone,
                                            NlShellGetFavoriteDataFunc dfunc,
                                            NlShellDragFinishedFunc ffunc);
  
  /* signals */
  void            (*favorite_added)        (NlShell           *self,
                                            const gchar       *uid);

  void            (*favorite_removed)      (NlShell           *self,
                                            const gchar       *uid);
};

GType           nl_shell_get_type              (void) G_GNUC_CONST;

ClutterActor  * nl_shell_get_stage             (NlShell           *self);

NlContentView * nl_shell_get_content_view      (NlShell           *self);

NlSidebar     * nl_shell_get_sidebar           (NlShell           *self);

GSList        * nl_shell_get_favorites_loaders (NlShell           *self);

void            nl_shell_add_places_source     (NlShell           *self,
                                                ClutterActor      *source);

void            nl_shell_add_favorites_loader  (NlShell           *self,
                                                NlFavoritesLoader *d);
                                                
void            nl_shell_show_favorites        (NlShell           *self);

GtkWidget     * nl_shell_get_toplevel          (NlShell           *self);

void            nl_shell_add_favorite          (NlShell           *self,
                                                const gchar       *uid);

void            nl_shell_remove_favorite       (NlShell           *self,
                                                const gchar       *uid);

void            nl_shell_begin_favorite_drag   (NlShell           *shell,
                                                GObject           *origin,
                                                ClutterActor      *clone,
                                               NlShellGetFavoriteDataFunc dfunc,
                                               NlShellDragFinishedFunc ffunc);


G_END_DECLS

#endif /* __NL_SHELL_H__ */
