/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_FAVORITES_LOADER_H_
#define _NL_FAVORITES_LOADER_H_

#include <glib.h>
#include <gdk/gdk.h>
#include <clutter/clutter.h>
#include <netbook-launcher/nl-favorite.h>

#define NL_TYPE_FAVORITES_LOADER (nl_favorites_loader_get_type ())

#define NL_FAVORITES_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	NL_TYPE_FAVORITES_LOADER, NlFavoritesLoader))

#define NL_FAVORITES_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST \
        ((klass),NL_TYPE_FAVORITES_LOADER, NlFavoritesLoaderClass))

#define NL_IS_FAVORITES_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
      	NL_TYPE_FAVORITES_LOADER))

#define NL_IS_FAVORITES_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE \
        ((klass),	NL_TYPE_FAVORITES_LOADER))

#define NL_FAVORITES_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS \
        ((obj), NL_TYPE_FAVORITES_LOADER, NlFavoritesLoaderClass))

typedef struct _NlFavoritesLoader        NlFavoritesLoader;
typedef struct _NlFavoritesLoaderClass   NlFavoritesLoaderClass;

struct _NlFavoritesLoader
{
  GObject        parent;	
};

struct _NlFavoritesLoaderClass
{
  GObjectClass   parent_class;

  /*< vtable >*/
  gboolean      (*handles_type) (NlFavoritesLoader *self,
                                 const gchar       *type);

  NlFavorite *  (*load)         (NlFavoritesLoader *self,
                                 const gchar       *uid);
       gchar * (*uid_for_path) (NlFavoritesLoader *self,
                                 const gchar       *path);
};

GType        nl_favorites_loader_get_type     (void) G_GNUC_CONST;

gboolean     nl_favorites_loader_handles_type (NlFavoritesLoader *s,
                                               const gchar       *type);

NlFavorite * nl_favorites_loader_load         (NlFavoritesLoader *self,
                                               const gchar       *uid);

gchar *      nl_favorites_loader_uid_for_path (NlFavoritesLoader *self,
                                               const gchar       *path);

#endif /* _NL_FAVORITES_LOADER_H_ */

