# $Id: mk-1st.awk,v 1.3 2010/06/26 23:37:46 tom Exp $
##############################################################################
# Copyright (c) 2010 Free Software Foundation, Inc.                          #
#                                                                            #
# Permission is hereby granted, free of charge, to any person obtaining a    #
# copy of this software and associated documentation files (the "Software"), #
# to deal in the Software without restriction, including without limitation  #
# the rights to use, copy, modify, merge, publish, distribute, distribute    #
# with modifications, sublicense, and/or sell copies of the Software, and to #
# permit persons to whom the Software is furnished to do so, subject to the  #
# following conditions:                                                      #
#                                                                            #
# The above copyright notice and this permission notice shall be included in #
# all copies or substantial portions of the Software.                        #
#                                                                            #
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR #
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    #
# THE ABOVE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER      #
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    #
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        #
# DEALINGS IN THE SOFTWARE.                                                  #
#                                                                            #
# Except as contained in this notice, the name(s) of the above copyright     #
# holders shall not be used in advertising or otherwise to promote the sale, #
# use or other dealings in this Software without prior written               #
# authorization.                                                             #
##############################################################################
#
# Author: Thomas E. Dickey
#
# Generate compile-rules for the Ada95 modules that we are using in libraries
# or programs.  This script is used for older versions of gnatmake, which do
# not build libraries reliably, e.g., gnatmake 3.15.
#
# Fields in src/modules:
#	$1 = module name
#	$2 = directory where spec-dependency ".ads" is found
#	$3 = directory where body-dependency ".adb" is found
#	$4 = unit to compile (spec or body)
#
BEGIN	{
		printf "\n";
		printf "# generated by Ada95/mk-1st.awk\n";
	}
	/^[#]/ {
		next
	}
	/^$/ {
		next
	}
	{
		printf "\n";
		printf "%s.o :", $1.o

		if ( $2 == "none" ) {
			pre_spec = "";
		} else if ( $2 == "." ) {
			pre_spec = "";
			printf " \\\n\t\t%s.ads", $1;
		} else {
			pre_spec = sprintf("%s/", $2);
			printf " \\\n\t\t%s%s.ads", pre_spec, $1;
		}

		if ( $3 == "none" ) {
			pre_body = "";
		} else if ( $3 == "." ) {
			pre_body = "";
			printf " \\\n\t\t%s.adb", $1;
		} else {
			pre_body = sprintf("%s/", $3);
			printf " \\\n\t\t%s%s.adb", pre_body, $1;
			printf " \\\n\t\t$(BASEDEPS)";
		}

		if ( $4 == "spec" ) {
			suffix = "ads";
			prefix = pre_spec;
		} else {
			suffix = "adb";
			prefix = pre_body;
		}

		printf  "\n";
		printf "\t$(ADA) $(ADAFLAGS) -c -o $@ %s%s.%s\n", prefix, $1, suffix
	}
END	{
		print  ""
	}
