/* 
* Copyright 2004-2005, Canonical Ltd.
* 
* Author: Daniel Stone <daniel.stone@ubuntu.com>
* 
* This program is free software; you can redistribute it and/or modify it under
* the terms of the GNU General Public License as published by the Free Software
* Foundation; either version 2, or (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful, but WITHOUT ANY
* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
* PARTICULAR PURPOSE.  See the GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License with your
* Debian GNU system, in /usr/share/common-licenses/GPL.  If not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
* 02111-1307, USA.
*/

#include <stdio.h>
#include <sys/select.h>
#include <errno.h>
#include <limits.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/time.h>
#include <time.h>

int main(int argc, char *argv[]) {
	int retval, maxfd = 0, i, j;
	int *fdset, *activity;
	fd_set watchfds;
	struct timeval tv;
	char **filenames;
	char buf[10000];
	struct timeval origtime, newtime;
	struct timezone origtz, newtz;

	if (argc < 2)
		return 0;
	
	fdset = (int *) calloc(argc, sizeof(int));
	activity = (int *) calloc(argc, sizeof(int));
	filenames = (char **) calloc(argc, sizeof(char *));

	if (!fdset || !filenames) {
		fprintf(stderr, "failed to allocate fdset or filenames!\n");
		return 1;
	}

	FD_ZERO(&watchfds);
	for (i = 1, j = 0; i < argc; i++, j++) {
		if (!strchr(argv[i], '/')) {
			filenames[j] = (char *)malloc(PATH_MAX * sizeof(char));
			snprintf(filenames[j], PATH_MAX, "/dev/input/%s", argv[i]);
		}
		else {
			filenames[j] = (char *)malloc(strlen(argv[i]) * sizeof(char));
			strcpy(filenames[j], argv[i]);
		}

		if((fdset[j] = open(filenames[j], O_RDONLY)) < 0) {
			fprintf(stderr, "failed to open fd %d: %s!\n", j, strerror(errno));
			return 1;
		}

		if (fdset[i - 1] > maxfd)
			maxfd = fdset[j];

		FD_SET(fdset[j], &watchfds);
		activity[j] = 0;
	}

	maxfd++;

	tv.tv_sec = 5;
	tv.tv_usec = 0;
	if (gettimeofday(&origtime, &origtz) != 0) {
		fprintf(stderr, "failed to gettimeofday for origtime: %s!\n",
		        strerror(errno));
		return 1;
	}

	while (1) {
		retval = select(maxfd, &watchfds, NULL, NULL, &tv);
		if (retval) {
			for (i = 0; i < (argc - 1); i++) {
				if (FD_ISSET(fdset[i], &watchfds)) {
					activity[i]++;
					/* fprintf(stderr, "%s %d\n", filenames[i], activity[i]); */
					read(fdset[i], buf, (sizeof(buf) - 1));
				}
			}
		}

		if (gettimeofday(&newtime, &newtz) != 0) {
			fprintf(stderr, "failed to gettimeofday: %s!\n",
			        strerror(errno));
			return 1;
		}
		else {
			if (newtime.tv_sec >= origtime.tv_sec + 5) {
				break;
			}
		}
	}
	
	for (i = 0, j = -1; i < (argc - 1); i++) {
		if (activity[i] && (j != -1 || activity[i] > activity[j])) {
			j = i;
			fprintf(stderr, "final count: %s %d\n", filenames[i],
			        activity[i]);
		}
		close(fdset[i]);
	}

	if (j != -1) {
		fprintf(stderr, "%d is current best candidate (%s %d)\n", j,
		        filenames[j], activity[j]);
		if (activity[j] > 3) {
			printf("%s\n", filenames[j]);
		}
	}
	else {
		printf("timeout\n");
	}

	return 0;
}
