/* unity-launcher.c generated by valac 0.12.0, the Vala compiler
 * generated from unity-launcher.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */
/*
 * IMPLEMENTATION NOTE:
 * We want the generated C API to be nice and not too Vala-ish. We must
 * anticipate that libunity consumers will be written in both Vala , C,
 * and through GObject Introspection
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <dee.h>
#include <float.h>
#include <math.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/dbusmenu-glib.h>
#include <libdbusmenu-glib/enum-types.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>
#include <libdbusmenu-glib/types.h>


#define UNITY_TYPE_LAUNCHER_ENTRY_DBUS_IMPL (unity_launcher_entry_dbus_impl_get_type ())
#define UNITY_LAUNCHER_ENTRY_DBUS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_LAUNCHER_ENTRY_DBUS_IMPL, UnityLauncherEntryDBusImpl))
#define UNITY_LAUNCHER_ENTRY_DBUS_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_LAUNCHER_ENTRY_DBUS_IMPL, UnityLauncherEntryDBusImplClass))
#define UNITY_IS_LAUNCHER_ENTRY_DBUS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_LAUNCHER_ENTRY_DBUS_IMPL))
#define UNITY_IS_LAUNCHER_ENTRY_DBUS_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_LAUNCHER_ENTRY_DBUS_IMPL))
#define UNITY_LAUNCHER_ENTRY_DBUS_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_LAUNCHER_ENTRY_DBUS_IMPL, UnityLauncherEntryDBusImplClass))

typedef struct _UnityLauncherEntryDBusImpl UnityLauncherEntryDBusImpl;
typedef struct _UnityLauncherEntryDBusImplClass UnityLauncherEntryDBusImplClass;
typedef struct _UnityLauncherEntryDBusImplPrivate UnityLauncherEntryDBusImplPrivate;

#define UNITY_TYPE_LAUNCHER_ENTRY (unity_launcher_entry_get_type ())
#define UNITY_LAUNCHER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_LAUNCHER_ENTRY, UnityLauncherEntry))
#define UNITY_LAUNCHER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_LAUNCHER_ENTRY, UnityLauncherEntryClass))
#define UNITY_IS_LAUNCHER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_LAUNCHER_ENTRY))
#define UNITY_IS_LAUNCHER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_LAUNCHER_ENTRY))
#define UNITY_LAUNCHER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_LAUNCHER_ENTRY, UnityLauncherEntryClass))

typedef struct _UnityLauncherEntry UnityLauncherEntry;
typedef struct _UnityLauncherEntryClass UnityLauncherEntryClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _UnityLauncherEntryPrivate UnityLauncherEntryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define UNITY_TYPE_INSPECTOR (unity_inspector_get_type ())
#define UNITY_INSPECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_INSPECTOR, UnityInspector))
#define UNITY_INSPECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_INSPECTOR, UnityInspectorClass))
#define UNITY_IS_INSPECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_INSPECTOR))
#define UNITY_IS_INSPECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_INSPECTOR))
#define UNITY_INSPECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_INSPECTOR, UnityInspectorClass))

typedef struct _UnityInspector UnityInspector;
typedef struct _UnityInspectorClass UnityInspectorClass;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))

struct _UnityLauncherEntryDBusImpl {
	GObject parent_instance;
	UnityLauncherEntryDBusImplPrivate * priv;
	UnityLauncherEntry* owner;
};

struct _UnityLauncherEntryDBusImplClass {
	GObjectClass parent_class;
};

struct _UnityLauncherEntry {
	GObject parent_instance;
	UnityLauncherEntryPrivate * priv;
	char* _object_path;
};

struct _UnityLauncherEntryClass {
	GObjectClass parent_class;
};

struct _UnityLauncherEntryPrivate {
	gchar* _app_uri;
	gint64 _count;
	gboolean _count_visible;
	gdouble _progress;
	gboolean _progress_visible;
	gboolean _urgent;
	DbusmenuMenuitem* _quicklist;
	GHashTable* _queued_properties;
	DbusmenuServer* _quicklist_server;
	guint _property_source_id;
	GDBusConnection* _bus;
	UnityLauncherEntryDBusImpl* _dbus_impl;
};


static gpointer unity_launcher_entry_dbus_impl_parent_class = NULL;
static gpointer unity_launcher_entry_parent_class = NULL;
static GHashTable* unity_launcher_entry_global_entries_map;
static GHashTable* unity_launcher_entry_global_entries_map = NULL;
static DeeSerializableIface* unity_launcher_entry_dee_serializable_parent_iface = NULL;

GType unity_launcher_entry_dbus_impl_get_type (void) G_GNUC_CONST;
guint unity_launcher_entry_dbus_impl_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_launcher_entry_get_type (void) G_GNUC_CONST;
enum  {
	UNITY_LAUNCHER_ENTRY_DBUS_IMPL_DUMMY_PROPERTY
};
UnityLauncherEntryDBusImpl* unity_launcher_entry_dbus_impl_new (GDBusConnection* conn, const char* object_path, UnityLauncherEntry* owner);
UnityLauncherEntryDBusImpl* unity_launcher_entry_dbus_impl_construct (GType object_type, GDBusConnection* conn, const char* object_path, UnityLauncherEntry* owner);
GHashTable* unity_launcher_entry_dbus_impl_query (UnityLauncherEntryDBusImpl* self);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
GHashTable* unity_collect_launcher_entry_properties (UnityLauncherEntry* l);
static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void unity_launcher_entry_dbus_impl_finalize (GObject* obj);
static void _dbus_unity_launcher_entry_dbus_impl_query (UnityLauncherEntryDBusImpl* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void unity_launcher_entry_dbus_impl_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* unity_launcher_entry_dbus_impl_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean unity_launcher_entry_dbus_impl_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_unity_launcher_entry_dbus_impl_update (GObject* _sender, const gchar* app_uri, GHashTable* properties, gpointer* _data);
static void _unity_launcher_entry_dbus_impl_unregister_object (gpointer user_data);
#define UNITY_LAUNCHER_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_LAUNCHER_ENTRY, UnityLauncherEntryPrivate))
enum  {
	UNITY_LAUNCHER_ENTRY_DUMMY_PROPERTY,
	UNITY_LAUNCHER_ENTRY_APP_URI,
	UNITY_LAUNCHER_ENTRY_COUNT,
	UNITY_LAUNCHER_ENTRY_COUNT_VISIBLE,
	UNITY_LAUNCHER_ENTRY_PROGRESS,
	UNITY_LAUNCHER_ENTRY_PROGRESS_VISIBLE,
	UNITY_LAUNCHER_ENTRY_URGENT,
	UNITY_LAUNCHER_ENTRY_QUICKLIST
};
static UnityLauncherEntry* unity_launcher_entry_new (const gchar* app_uri);
static UnityLauncherEntry* unity_launcher_entry_construct (GType object_type, const gchar* app_uri);
UnityLauncherEntry* unity_launcher_entry_get_for_app_uri (const gchar* app_uri);
static void _g_object_unref0_ (gpointer var);
UnityLauncherEntry* unity_launcher_entry_get_for_desktop_id (const gchar* desktop_id);
UnityLauncherEntry* unity_launcher_entry_get_for_desktop_file (const gchar* desktop_file);
static GVariant* unity_launcher_entry_real_serialize (DeeSerializable* base);
static GVariant* _variant_new1 (GHashTable* value);
const gchar* unity_launcher_entry_get_app_uri (UnityLauncherEntry* self);
static GObject* unity_launcher_entry_parse_serializable (GVariant* data);
void unity_launcher_entry_set_count (UnityLauncherEntry* self, gint64 value);
void unity_launcher_entry_set_count_visible (UnityLauncherEntry* self, gboolean value);
void unity_launcher_entry_set_progress (UnityLauncherEntry* self, gdouble value);
void unity_launcher_entry_set_progress_visible (UnityLauncherEntry* self, gboolean value);
void unity_launcher_entry_set_urgent (UnityLauncherEntry* self, gboolean value);
static void unity_launcher_entry_queue_property_notification (UnityLauncherEntry* self, GObject* _self_, GParamSpec* pspec);
gint64 unity_launcher_entry_get_count (UnityLauncherEntry* self);
static GVariant* _variant_new2 (gint64 value);
gboolean unity_launcher_entry_get_count_visible (UnityLauncherEntry* self);
static GVariant* _variant_new3 (gboolean value);
gdouble unity_launcher_entry_get_progress (UnityLauncherEntry* self);
static GVariant* _variant_new4 (gdouble value);
gboolean unity_launcher_entry_get_progress_visible (UnityLauncherEntry* self);
static GVariant* _variant_new5 (gboolean value);
gboolean unity_launcher_entry_get_urgent (UnityLauncherEntry* self);
static GVariant* _variant_new6 (gboolean value);
static GVariant* _variant_new7 (const gchar* value);
static GVariant* _variant_new8 (const gchar* value);
static gboolean unity_launcher_entry_dispatch_property_notification (UnityLauncherEntry* self);
static gboolean _unity_launcher_entry_dispatch_property_notification_gsource_func (gpointer self);
GType unity_inspector_get_type (void) G_GNUC_CONST;
UnityInspector* unity_inspector_get_default (void);
gboolean unity_inspector_get_unity_running (UnityInspector* self);
static void unity_launcher_entry_on_unity_running_changed (UnityLauncherEntry* self, GObject* _inspector, GParamSpec* pspec);
void unity_launcher_entry_set_app_uri (UnityLauncherEntry* self, const gchar* value);
DbusmenuMenuitem* unity_launcher_entry_get_quicklist (UnityLauncherEntry* self);
void unity_launcher_entry_set_quicklist (UnityLauncherEntry* self, DbusmenuMenuitem* value);
static GObject * unity_launcher_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _unity_launcher_entry_on_unity_running_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _unity_launcher_entry_queue_property_notification_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static GObject* _unity_launcher_entry_parse_serializable_dee_serializable_parse_func (GVariant* data);
static void unity_launcher_entry_finalize (GObject* obj);
static void _vala_unity_launcher_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_launcher_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static GVariant* _variant_new9 (gint64 value);
static GVariant* _variant_new10 (gboolean value);
static GVariant* _variant_new11 (gdouble value);
static GVariant* _variant_new12 (gboolean value);
static GVariant* _variant_new13 (gboolean value);
static GVariant* _variant_new14 (const char* value);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _unity_launcher_entry_dbus_impl_dbus_arg_info_query_result = {-1, "result", "a{sv}"};
static const GDBusArgInfo * const _unity_launcher_entry_dbus_impl_dbus_arg_info_query_in[] = {NULL};
static const GDBusArgInfo * const _unity_launcher_entry_dbus_impl_dbus_arg_info_query_out[] = {&_unity_launcher_entry_dbus_impl_dbus_arg_info_query_result, NULL};
static const GDBusMethodInfo _unity_launcher_entry_dbus_impl_dbus_method_info_query = {-1, "Query", (GDBusArgInfo **) (&_unity_launcher_entry_dbus_impl_dbus_arg_info_query_in), (GDBusArgInfo **) (&_unity_launcher_entry_dbus_impl_dbus_arg_info_query_out)};
static const GDBusMethodInfo * const _unity_launcher_entry_dbus_impl_dbus_method_info[] = {&_unity_launcher_entry_dbus_impl_dbus_method_info_query, NULL};
static const GDBusArgInfo _unity_launcher_entry_dbus_impl_dbus_arg_info_update_app_uri = {-1, "app_uri", "s"};
static const GDBusArgInfo _unity_launcher_entry_dbus_impl_dbus_arg_info_update_properties = {-1, "properties", "a{sv}"};
static const GDBusArgInfo * const _unity_launcher_entry_dbus_impl_dbus_arg_info_update[] = {&_unity_launcher_entry_dbus_impl_dbus_arg_info_update_app_uri, &_unity_launcher_entry_dbus_impl_dbus_arg_info_update_properties, NULL};
static const GDBusSignalInfo _unity_launcher_entry_dbus_impl_dbus_signal_info_update = {-1, "Update", (GDBusArgInfo **) (&_unity_launcher_entry_dbus_impl_dbus_arg_info_update)};
static const GDBusSignalInfo * const _unity_launcher_entry_dbus_impl_dbus_signal_info[] = {&_unity_launcher_entry_dbus_impl_dbus_signal_info_update, NULL};
static const GDBusPropertyInfo * const _unity_launcher_entry_dbus_impl_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _unity_launcher_entry_dbus_impl_dbus_interface_info = {-1, "com.canonical.Unity.LauncherEntry", (GDBusMethodInfo **) (&_unity_launcher_entry_dbus_impl_dbus_method_info), (GDBusSignalInfo **) (&_unity_launcher_entry_dbus_impl_dbus_signal_info), (GDBusPropertyInfo **) (&_unity_launcher_entry_dbus_impl_dbus_property_info)};
static const GDBusInterfaceVTable _unity_launcher_entry_dbus_impl_dbus_interface_vtable = {unity_launcher_entry_dbus_impl_dbus_interface_method_call, unity_launcher_entry_dbus_impl_dbus_interface_get_property, unity_launcher_entry_dbus_impl_dbus_interface_set_property};

UnityLauncherEntryDBusImpl* unity_launcher_entry_dbus_impl_construct (GType object_type, GDBusConnection* conn, const char* object_path, UnityLauncherEntry* owner) {
	UnityLauncherEntryDBusImpl * self = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (conn != NULL, NULL);
	g_return_val_if_fail (object_path != NULL, NULL);
	g_return_val_if_fail (owner != NULL, NULL);
	self = (UnityLauncherEntryDBusImpl*) g_object_new (object_type, NULL);
	unity_launcher_entry_dbus_impl_register_object (self, conn, (const gchar*) object_path, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch12_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	goto __finally12;
	__catch12_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("Unable to connecto to session bus. Unable to control " "LauncherEntry for %s", object_path);
		_g_error_free0 (e);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->owner = owner;
	return self;
}


UnityLauncherEntryDBusImpl* unity_launcher_entry_dbus_impl_new (GDBusConnection* conn, const char* object_path, UnityLauncherEntry* owner) {
	return unity_launcher_entry_dbus_impl_construct (UNITY_TYPE_LAUNCHER_ENTRY_DBUS_IMPL, conn, object_path, owner);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


GHashTable* unity_launcher_entry_dbus_impl_query (UnityLauncherEntryDBusImpl* self) {
	GHashTable* result = NULL;
	GHashTable* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->owner == NULL) {
		GHashTable* _tmp0_ = NULL;
		_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_variant_unref0_);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = unity_collect_launcher_entry_properties (self->owner);
	result = _tmp1_;
	return result;
}


static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOXED) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}


static void unity_launcher_entry_dbus_impl_class_init (UnityLauncherEntryDBusImplClass * klass) {
	unity_launcher_entry_dbus_impl_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = unity_launcher_entry_dbus_impl_finalize;
	g_signal_new ("update", UNITY_TYPE_LAUNCHER_ENTRY_DBUS_IMPL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_HASH_TABLE);
}


static void unity_launcher_entry_dbus_impl_instance_init (UnityLauncherEntryDBusImpl * self) {
}


static void unity_launcher_entry_dbus_impl_finalize (GObject* obj) {
	UnityLauncherEntryDBusImpl * self;
	self = UNITY_LAUNCHER_ENTRY_DBUS_IMPL (obj);
	G_OBJECT_CLASS (unity_launcher_entry_dbus_impl_parent_class)->finalize (obj);
}


GType unity_launcher_entry_dbus_impl_get_type (void) {
	static volatile gsize unity_launcher_entry_dbus_impl_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_entry_dbus_impl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityLauncherEntryDBusImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_launcher_entry_dbus_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLauncherEntryDBusImpl), 0, (GInstanceInitFunc) unity_launcher_entry_dbus_impl_instance_init, NULL };
		GType unity_launcher_entry_dbus_impl_type_id;
		unity_launcher_entry_dbus_impl_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityLauncherEntryDBusImpl", &g_define_type_info, 0);
		g_type_set_qdata (unity_launcher_entry_dbus_impl_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) unity_launcher_entry_dbus_impl_register_object);
		g_once_init_leave (&unity_launcher_entry_dbus_impl_type_id__volatile, unity_launcher_entry_dbus_impl_type_id);
	}
	return unity_launcher_entry_dbus_impl_type_id__volatile;
}


static void _dbus_unity_launcher_entry_dbus_impl_query (UnityLauncherEntryDBusImpl* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable* result;
	GVariantBuilder _tmp0_;
	GHashTableIter _tmp1_;
	gpointer _tmp2_;
	gpointer _tmp3_;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = unity_launcher_entry_dbus_impl_query (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp1_, result);
	g_variant_builder_init (&_tmp0_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp1_, &_tmp2_, &_tmp3_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp2_;
		_value = (GVariant*) _tmp3_;
		g_variant_builder_add (&_tmp0_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp0_));
	_g_hash_table_unref0 ( result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void unity_launcher_entry_dbus_impl_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Query") == 0) {
		_dbus_unity_launcher_entry_dbus_impl_query (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* unity_launcher_entry_dbus_impl_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean unity_launcher_entry_dbus_impl_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_unity_launcher_entry_dbus_impl_update (GObject* _sender, const gchar* app_uri, GHashTable* properties, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp4_;
	GHashTableIter _tmp5_;
	gpointer _tmp6_;
	gpointer _tmp7_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (app_uri));
	g_hash_table_iter_init (&_tmp5_, properties);
	g_variant_builder_init (&_tmp4_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp5_, &_tmp6_, &_tmp7_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp6_;
		_value = (GVariant*) _tmp7_;
		g_variant_builder_add (&_tmp4_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp4_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.Unity.LauncherEntry", "Update", _arguments, NULL);
}


guint unity_launcher_entry_dbus_impl_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_unity_launcher_entry_dbus_impl_dbus_interface_info), &_unity_launcher_entry_dbus_impl_dbus_interface_vtable, data, _unity_launcher_entry_dbus_impl_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "update", (GCallback) _dbus_unity_launcher_entry_dbus_impl_update, data);
	return result;
}


static void _unity_launcher_entry_dbus_impl_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


/**
     * Create a new LauncherEntry for the desktop file id of your application.
     *
     * This constructor is private because consumers should create instances
     * via the static getter methods on this class to avoid duplicate entries
     * for the same application.
     *
     * The desktop file id is defined as the basename of your application's
     * .desktop file (including the extension), eg. myapp.desktop.
     */
static UnityLauncherEntry* unity_launcher_entry_construct (GType object_type, const gchar* app_uri) {
	UnityLauncherEntry * self = NULL;
	g_return_val_if_fail (app_uri != NULL, NULL);
	self = (UnityLauncherEntry*) g_object_new (object_type, "app-uri", app_uri, NULL);
	return self;
}


static UnityLauncherEntry* unity_launcher_entry_new (const gchar* app_uri) {
	return unity_launcher_entry_construct (UNITY_TYPE_LAUNCHER_ENTRY, app_uri);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


UnityLauncherEntry* unity_launcher_entry_get_for_app_uri (const gchar* app_uri) {
	UnityLauncherEntry* result = NULL;
	gconstpointer _tmp1_ = NULL;
	UnityLauncherEntry* _tmp2_;
	UnityLauncherEntry* entry;
	UnityLauncherEntry* _tmp3_ = NULL;
	gchar* _tmp4_;
	UnityLauncherEntry* _tmp5_;
	g_return_val_if_fail (app_uri != NULL, NULL);
	if (unity_launcher_entry_global_entries_map == NULL) {
		GHashTable* _tmp0_ = NULL;
		_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
		_g_hash_table_unref0 (unity_launcher_entry_global_entries_map);
		unity_launcher_entry_global_entries_map = _tmp0_;
	}
	_tmp1_ = g_hash_table_lookup (unity_launcher_entry_global_entries_map, app_uri);
	_tmp2_ = _g_object_ref0 ((UnityLauncherEntry*) _tmp1_);
	entry = _tmp2_;
	if (entry != NULL) {
		result = entry;
		return result;
	}
	_tmp3_ = unity_launcher_entry_new (app_uri);
	_g_object_unref0 (entry);
	entry = _tmp3_;
	_tmp4_ = g_strdup (app_uri);
	_tmp5_ = _g_object_ref0 (entry);
	g_hash_table_insert (unity_launcher_entry_global_entries_map, _tmp4_, _tmp5_);
	result = entry;
	return result;
}


UnityLauncherEntry* unity_launcher_entry_get_for_desktop_id (const gchar* desktop_id) {
	UnityLauncherEntry* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	UnityLauncherEntry* _tmp2_ = NULL;
	UnityLauncherEntry* _tmp3_;
	g_return_val_if_fail (desktop_id != NULL, NULL);
	_tmp0_ = g_strconcat ("application://", desktop_id, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = unity_launcher_entry_get_for_app_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


UnityLauncherEntry* unity_launcher_entry_get_for_desktop_file (const gchar* desktop_file) {
	UnityLauncherEntry* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	UnityLauncherEntry* _tmp2_ = NULL;
	UnityLauncherEntry* _tmp3_;
	g_return_val_if_fail (desktop_file != NULL, NULL);
	_tmp0_ = g_path_get_basename (desktop_file);
	_tmp1_ = _tmp0_;
	_tmp2_ = unity_launcher_entry_get_for_desktop_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static GVariant* _variant_new1 (GHashTable* value) {
	GVariantBuilder _tmp1_;
	GHashTableIter _tmp2_;
	gpointer _tmp3_;
	gpointer _tmp4_;
	g_hash_table_iter_init (&_tmp2_, value);
	g_variant_builder_init (&_tmp1_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp2_, &_tmp3_, &_tmp4_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp3_;
		_value = (GVariant*) _tmp4_;
		g_variant_builder_add (&_tmp1_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp1_));
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static GVariant* unity_launcher_entry_real_serialize (DeeSerializable* base) {
	UnityLauncherEntry * self;
	GVariant* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GVariant* props;
	GVariant* _tmp5_ = NULL;
	GVariant* _app_uri;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GVariant** _tmp8_ = NULL;
	GVariant** _tmp9_;
	gint _tmp9__length1;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_;
	self = (UnityLauncherEntry*) base;
	_tmp0_ = unity_collect_launcher_entry_properties (self);
	props = _variant_new1 (_tmp0_);
	_tmp5_ = g_variant_new_string (self->priv->_app_uri);
	_app_uri = g_variant_ref_sink (_tmp5_);
	_tmp6_ = _g_variant_ref0 (_app_uri);
	_tmp7_ = _g_variant_ref0 (props);
	_tmp8_ = g_new0 (GVariant*, 2 + 1);
	_tmp8_[0] = _tmp6_;
	_tmp8_[1] = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 2;
	_tmp10_ = g_variant_new_tuple (_tmp9_, 2);
	_tmp11_ = g_variant_ref_sink (_tmp10_);
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_variant_unref), NULL);
	result = _tmp11_;
	_g_variant_unref0 (_app_uri);
	_g_variant_unref0 (props);
	return result;
}


static GObject* unity_launcher_entry_parse_serializable (GVariant* data) {
	GObject* result = NULL;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* app_uri;
	GVariant* _tmp5_ = NULL;
	GVariant* props;
	UnityLauncherEntry* _tmp6_ = NULL;
	UnityLauncherEntry* _self_;
	gint64 count = 0LL;
	gboolean _tmp7_;
	gboolean visible = FALSE;
	gboolean _tmp8_;
	gdouble progress = 0.0;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean urgent = FALSE;
	gboolean _tmp11_;
	gchar* quicklist_path = NULL;
	gboolean _tmp12_;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = g_variant_get_child_value (data, (gsize) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_get_string (_tmp1_, NULL);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_variant_unref0 (_tmp1_);
	app_uri = _tmp4_;
	_tmp5_ = g_variant_get_child_value (data, (gsize) 1);
	props = _tmp5_;
	_tmp6_ = unity_launcher_entry_get_for_app_uri (app_uri);
	_self_ = _tmp6_;
	_tmp7_ = g_variant_lookup (props, "count", "x", &count, NULL);
	if (_tmp7_) {
		unity_launcher_entry_set_count (_self_, count);
	}
	_tmp8_ = g_variant_lookup (props, "count-visible", "b", &visible, NULL);
	if (_tmp8_) {
		unity_launcher_entry_set_count_visible (_self_, visible);
	}
	_tmp9_ = g_variant_lookup (props, "count-visible", "d", &progress, NULL);
	if (_tmp9_) {
		unity_launcher_entry_set_progress (_self_, progress);
	}
	_tmp10_ = g_variant_lookup (props, "progress-visible", "b", &visible, NULL);
	if (_tmp10_) {
		unity_launcher_entry_set_progress_visible (_self_, visible);
	}
	_tmp11_ = g_variant_lookup (props, "urgent", "b", &urgent, NULL);
	if (_tmp11_) {
		unity_launcher_entry_set_urgent (_self_, urgent);
	}
	_tmp12_ = g_variant_lookup (props, "quicklist", "s", &quicklist_path, NULL);
	if (_tmp12_) {
		if (g_strcmp0 (quicklist_path, "") != 0) {
			char* _tmp13_ = NULL;
			_tmp13_ = g_strdup (quicklist_path);
			_g_free0 (_self_->_object_path);
			_self_->_object_path = _tmp13_;
		}
	}
	result = (GObject*) _self_;
	_g_free0 (quicklist_path);
	_g_variant_unref0 (props);
	_g_free0 (app_uri);
	return result;
}


static GVariant* _variant_new2 (gint64 value) {
	return g_variant_ref_sink (g_variant_new_int64 (value));
}


static GVariant* _variant_new3 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new4 (gdouble value) {
	return g_variant_ref_sink (g_variant_new_double (value));
}


static GVariant* _variant_new5 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new6 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new7 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new8 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static gboolean _unity_launcher_entry_dispatch_property_notification_gsource_func (gpointer self) {
	gboolean result;
	result = unity_launcher_entry_dispatch_property_notification (self);
	return result;
}


static void unity_launcher_entry_queue_property_notification (UnityLauncherEntry* self, GObject* _self_, GParamSpec* pspec) {
	GVariant* v = NULL;
	gchar* object_path = NULL;
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	static GQuark _tmp1__label4 = 0;
	static GQuark _tmp1__label5 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_self_ != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = pspec->name;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("count")))) {
		switch (0) {
			default:
			{
				_g_variant_unref0 (v);
				v = _variant_new2 (self->priv->_count);
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("count-visible")))) {
		switch (0) {
			default:
			{
				_g_variant_unref0 (v);
				v = _variant_new3 (self->priv->_count_visible);
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("progress")))) {
		switch (0) {
			default:
			{
				_g_variant_unref0 (v);
				v = _variant_new4 (self->priv->_progress);
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("progress-visible")))) {
		switch (0) {
			default:
			{
				_g_variant_unref0 (v);
				v = _variant_new5 (self->priv->_progress_visible);
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label4) ? _tmp1__label4 : (_tmp1__label4 = g_quark_from_static_string ("urgent")))) {
		switch (0) {
			default:
			{
				_g_variant_unref0 (v);
				v = _variant_new6 (self->priv->_urgent);
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label5) ? _tmp1__label5 : (_tmp1__label5 = g_quark_from_static_string ("quicklist")))) {
		switch (0) {
			default:
			{
				if (self->priv->_quicklist_server != NULL) {
					g_object_get ((GObject*) self->priv->_quicklist_server, "dbus-object", &object_path, NULL);
					_g_variant_unref0 (v);
					v = _variant_new7 (object_path);
				} else {
					_g_variant_unref0 (v);
					v = _variant_new8 ("");
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				_g_variant_unref0 (v);
				v = NULL;
				break;
			}
		}
	}
	if (v != NULL) {
		gchar* _tmp2_;
		GVariant* _tmp3_;
		_tmp2_ = g_strdup (pspec->name);
		_tmp3_ = _g_variant_ref0 (v);
		g_hash_table_insert (self->priv->_queued_properties, _tmp2_, _tmp3_);
	}
	if (self->priv->_property_source_id == 0) {
		guint _tmp4_;
		_tmp4_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _unity_launcher_entry_dispatch_property_notification_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->_property_source_id = _tmp4_;
	}
	_g_free0 (object_path);
	_g_variant_unref0 (v);
}


static gboolean unity_launcher_entry_dispatch_property_notification (UnityLauncherEntry* self) {
	gboolean result = FALSE;
	UnityInspector* _tmp0_ = NULL;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = unity_inspector_get_default ();
	_tmp1_ = unity_inspector_get_unity_running (_tmp0_);
	if (_tmp1_) {
		g_signal_emit_by_name (self->priv->_dbus_impl, "update", self->priv->_app_uri, self->priv->_queued_properties);
	}
	self->priv->_property_source_id = (guint) 0;
	g_hash_table_remove_all (self->priv->_queued_properties);
	result = FALSE;
	return result;
}


static void unity_launcher_entry_on_unity_running_changed (UnityLauncherEntry* self, GObject* _inspector, GParamSpec* pspec) {
	GObject* _tmp0_;
	UnityInspector* _tmp1_;
	UnityInspector* inspector;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_inspector != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = _inspector;
	_tmp1_ = _g_object_ref0 (UNITY_IS_INSPECTOR (_tmp0_) ? ((UnityInspector*) _tmp0_) : NULL);
	inspector = _tmp1_;
	_tmp2_ = unity_inspector_get_unity_running (inspector);
	if (_tmp2_) {
		GVariant* _tmp3_ = NULL;
		GVariant* _tmp4_;
		_tmp3_ = dee_serializable_serialize ((DeeSerializable*) self);
		_tmp4_ = _tmp3_;
		g_dbus_connection_emit_signal (self->priv->_bus, NULL, (const gchar*) self->_object_path, "com.canonical.Unity.LauncherEntry", "Update", _tmp4_, &_inner_error_);
		_g_variant_unref0 (_tmp4_);
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("unity-launcher.vala:325: Failed to emit com.canonical.Unity.LauncherEn" \
"try.Update on the session bus: %s", e->message);
			_g_error_free0 (e);
		}
		__finally13:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (inspector);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (inspector);
}


const gchar* unity_launcher_entry_get_app_uri (UnityLauncherEntry* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_app_uri;
	return result;
}


void unity_launcher_entry_set_app_uri (UnityLauncherEntry* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_app_uri);
	self->priv->_app_uri = _tmp0_;
	g_object_notify ((GObject *) self, "app-uri");
}


gint64 unity_launcher_entry_get_count (UnityLauncherEntry* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_count;
	return result;
}


void unity_launcher_entry_set_count (UnityLauncherEntry* self, gint64 value) {
	g_return_if_fail (self != NULL);
	self->priv->_count = value;
	g_object_notify ((GObject *) self, "count");
}


gboolean unity_launcher_entry_get_count_visible (UnityLauncherEntry* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_count_visible;
	return result;
}


void unity_launcher_entry_set_count_visible (UnityLauncherEntry* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_count_visible = value;
	g_object_notify ((GObject *) self, "count-visible");
}


gdouble unity_launcher_entry_get_progress (UnityLauncherEntry* self) {
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_progress;
	return result;
}


void unity_launcher_entry_set_progress (UnityLauncherEntry* self, gdouble value) {
	g_return_if_fail (self != NULL);
	self->priv->_progress = value;
	g_object_notify ((GObject *) self, "progress");
}


gboolean unity_launcher_entry_get_progress_visible (UnityLauncherEntry* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_progress_visible;
	return result;
}


void unity_launcher_entry_set_progress_visible (UnityLauncherEntry* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_progress_visible = value;
	g_object_notify ((GObject *) self, "progress-visible");
}


gboolean unity_launcher_entry_get_urgent (UnityLauncherEntry* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_urgent;
	return result;
}


void unity_launcher_entry_set_urgent (UnityLauncherEntry* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_urgent = value;
	g_object_notify ((GObject *) self, "urgent");
}


DbusmenuMenuitem* unity_launcher_entry_get_quicklist (UnityLauncherEntry* self) {
	DbusmenuMenuitem* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_quicklist;
	return result;
}


void unity_launcher_entry_set_quicklist (UnityLauncherEntry* self, DbusmenuMenuitem* value) {
	DbusmenuMenuitem* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_quicklist);
	self->priv->_quicklist = _tmp0_;
	if (self->priv->_quicklist != NULL) {
		DbusmenuServer* _tmp1_ = NULL;
		_tmp1_ = dbusmenu_server_new ((const gchar*) self->_object_path);
		_g_object_unref0 (self->priv->_quicklist_server);
		self->priv->_quicklist_server = _tmp1_;
		g_object_set (self->priv->_quicklist_server, "root-node", self->priv->_quicklist, NULL);
	}
	g_object_notify ((GObject *) self, "quicklist");
}


static void _unity_launcher_entry_on_unity_running_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_entry_on_unity_running_changed (self, _sender, pspec);
}


static void _unity_launcher_entry_queue_property_notification_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_entry_queue_property_notification (self, _sender, pspec);
}


static GObject * unity_launcher_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityLauncherEntry * self;
	GHashTable* _tmp0_ = NULL;
	GDBusConnection* _tmp1_ = NULL;
	GDBusConnection* _tmp2_;
	guint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	char* _tmp8_ = NULL;
	UnityLauncherEntryDBusImpl* _tmp9_ = NULL;
	UnityInspector* _tmp10_ = NULL;
	UnityInspector* _tmp11_;
	UnityInspector* inspector;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_launcher_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_LAUNCHER_ENTRY (obj);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (self->priv->_queued_properties);
	self->priv->_queued_properties = _tmp0_;
	_g_object_unref0 (self->priv->_quicklist_server);
	self->priv->_quicklist_server = NULL;
	self->priv->_property_source_id = (guint) 0;
	_tmp1_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch14_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_g_object_unref0 (self->priv->_bus);
	self->priv->_bus = _tmp2_;
	_tmp3_ = g_str_hash (self->priv->_app_uri);
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("/com/canonical/unity/launcherentry/", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (self->_object_path);
	self->_object_path = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp9_ = unity_launcher_entry_dbus_impl_new (self->priv->_bus, self->_object_path, self);
	_g_object_unref0 (self->priv->_dbus_impl);
	self->priv->_dbus_impl = _tmp9_;
	_tmp10_ = unity_inspector_get_default ();
	_tmp11_ = _g_object_ref0 (_tmp10_);
	inspector = _tmp11_;
	g_signal_connect_object ((GObject*) inspector, "notify::unity-running", (GCallback) _unity_launcher_entry_on_unity_running_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) _unity_launcher_entry_queue_property_notification_g_object_notify, self, 0);
	_g_object_unref0 (inspector);
	goto __finally14;
	__catch14_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("unity-launcher.vala:154: Unable to connect to session bus: %s", e->message);
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static GObject* _unity_launcher_entry_parse_serializable_dee_serializable_parse_func (GVariant* data) {
	GObject* result;
	result = unity_launcher_entry_parse_serializable (data);
	return result;
}


static void unity_launcher_entry_class_init (UnityLauncherEntryClass * klass) {
	GVariantType* _tmp0_ = NULL;
	GVariantType* _tmp1_;
	unity_launcher_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityLauncherEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_launcher_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_launcher_entry_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_launcher_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_launcher_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_ENTRY_APP_URI, g_param_spec_string ("app-uri", "app-uri", "app-uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_ENTRY_COUNT, g_param_spec_int64 ("count", "count", "count", G_MININT64, G_MAXINT64, (gint64) 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_ENTRY_COUNT_VISIBLE, g_param_spec_boolean ("count-visible", "count-visible", "count-visible", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_ENTRY_PROGRESS, g_param_spec_double ("progress", "progress", "progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_ENTRY_PROGRESS_VISIBLE, g_param_spec_boolean ("progress-visible", "progress-visible", "progress-visible", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_ENTRY_URGENT, g_param_spec_boolean ("urgent", "urgent", "urgent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_ENTRY_QUICKLIST, g_param_spec_object ("quicklist", "quicklist", "quicklist", DBUSMENU_TYPE_MENUITEM, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_variant_type_new ("(sa{sv})");
	_tmp1_ = _tmp0_;
	dee_serializable_register_parser (UNITY_TYPE_LAUNCHER_ENTRY, _tmp1_, _unity_launcher_entry_parse_serializable_dee_serializable_parse_func);
	_g_variant_type_free0 (_tmp1_);
}


static void unity_launcher_entry_dee_serializable_interface_init (DeeSerializableIface * iface) {
	unity_launcher_entry_dee_serializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize = (GVariant* (*)(DeeSerializable*)) unity_launcher_entry_real_serialize;
}


static void unity_launcher_entry_instance_init (UnityLauncherEntry * self) {
	self->priv = UNITY_LAUNCHER_ENTRY_GET_PRIVATE (self);
	self->priv->_count = (gint64) 0;
	self->priv->_count_visible = FALSE;
	self->priv->_progress = 0.0;
	self->priv->_progress_visible = FALSE;
	self->priv->_urgent = FALSE;
}


static void unity_launcher_entry_finalize (GObject* obj) {
	UnityLauncherEntry * self;
	self = UNITY_LAUNCHER_ENTRY (obj);
	_g_free0 (self->priv->_app_uri);
	_g_object_unref0 (self->priv->_quicklist);
	_g_hash_table_unref0 (self->priv->_queued_properties);
	_g_object_unref0 (self->priv->_quicklist_server);
	_g_object_unref0 (self->priv->_bus);
	_g_object_unref0 (self->priv->_dbus_impl);
	_g_free0 (self->_object_path);
	G_OBJECT_CLASS (unity_launcher_entry_parent_class)->finalize (obj);
}


/**
   * This class represents your control point for your application's icon
   * in the Unity Launcher. You can control properties such as a counter,
   * progress, or emblem that will be overlaid on your application's launcher
   * icon. You can also set a quicklist on it by setting the "quicklist"
   * property to point at the Dbusmenu.Menuitem which is the root of your
   * quicklist.
   *
   * Create a LauncherEntry by giving your desktop file id to the constructor
   * (eg. "myapp.desktop").
   */
GType unity_launcher_entry_get_type (void) {
	static volatile gsize unity_launcher_entry_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityLauncherEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_launcher_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLauncherEntry), 0, (GInstanceInitFunc) unity_launcher_entry_instance_init, NULL };
		static const GInterfaceInfo dee_serializable_info = { (GInterfaceInitFunc) unity_launcher_entry_dee_serializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_launcher_entry_type_id;
		unity_launcher_entry_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityLauncherEntry", &g_define_type_info, 0);
		g_type_add_interface_static (unity_launcher_entry_type_id, DEE_TYPE_SERIALIZABLE, &dee_serializable_info);
		g_once_init_leave (&unity_launcher_entry_type_id__volatile, unity_launcher_entry_type_id);
	}
	return unity_launcher_entry_type_id__volatile;
}


static void _vala_unity_launcher_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityLauncherEntry * self;
	self = UNITY_LAUNCHER_ENTRY (object);
	switch (property_id) {
		case UNITY_LAUNCHER_ENTRY_APP_URI:
		g_value_set_string (value, unity_launcher_entry_get_app_uri (self));
		break;
		case UNITY_LAUNCHER_ENTRY_COUNT:
		g_value_set_int64 (value, unity_launcher_entry_get_count (self));
		break;
		case UNITY_LAUNCHER_ENTRY_COUNT_VISIBLE:
		g_value_set_boolean (value, unity_launcher_entry_get_count_visible (self));
		break;
		case UNITY_LAUNCHER_ENTRY_PROGRESS:
		g_value_set_double (value, unity_launcher_entry_get_progress (self));
		break;
		case UNITY_LAUNCHER_ENTRY_PROGRESS_VISIBLE:
		g_value_set_boolean (value, unity_launcher_entry_get_progress_visible (self));
		break;
		case UNITY_LAUNCHER_ENTRY_URGENT:
		g_value_set_boolean (value, unity_launcher_entry_get_urgent (self));
		break;
		case UNITY_LAUNCHER_ENTRY_QUICKLIST:
		g_value_set_object (value, unity_launcher_entry_get_quicklist (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_launcher_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityLauncherEntry * self;
	self = UNITY_LAUNCHER_ENTRY (object);
	switch (property_id) {
		case UNITY_LAUNCHER_ENTRY_APP_URI:
		unity_launcher_entry_set_app_uri (self, g_value_get_string (value));
		break;
		case UNITY_LAUNCHER_ENTRY_COUNT:
		unity_launcher_entry_set_count (self, g_value_get_int64 (value));
		break;
		case UNITY_LAUNCHER_ENTRY_COUNT_VISIBLE:
		unity_launcher_entry_set_count_visible (self, g_value_get_boolean (value));
		break;
		case UNITY_LAUNCHER_ENTRY_PROGRESS:
		unity_launcher_entry_set_progress (self, g_value_get_double (value));
		break;
		case UNITY_LAUNCHER_ENTRY_PROGRESS_VISIBLE:
		unity_launcher_entry_set_progress_visible (self, g_value_get_boolean (value));
		break;
		case UNITY_LAUNCHER_ENTRY_URGENT:
		unity_launcher_entry_set_urgent (self, g_value_get_boolean (value));
		break;
		case UNITY_LAUNCHER_ENTRY_QUICKLIST:
		unity_launcher_entry_set_quicklist (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static GVariant* _variant_new9 (gint64 value) {
	return g_variant_ref_sink (g_variant_new_int64 (value));
}


static GVariant* _variant_new10 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new11 (gdouble value) {
	return g_variant_ref_sink (g_variant_new_double (value));
}


static GVariant* _variant_new12 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new13 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new14 (const char* value) {
	return g_variant_ref_sink (g_variant_new_object_path (value));
}


GHashTable* unity_collect_launcher_entry_properties (UnityLauncherEntry* l) {
	GHashTable* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* props;
	gchar* _tmp1_;
	gint64 _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gchar* _tmp5_;
	gdouble _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	DbusmenuMenuitem* _tmp11_ = NULL;
	g_return_val_if_fail (l != NULL, NULL);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_variant_unref0_);
	props = _tmp0_;
	_tmp1_ = g_strdup ("count");
	_tmp2_ = unity_launcher_entry_get_count (l);
	g_hash_table_insert (props, _tmp1_, _variant_new9 (_tmp2_));
	_tmp3_ = g_strdup ("count-visible");
	_tmp4_ = unity_launcher_entry_get_count_visible (l);
	g_hash_table_insert (props, _tmp3_, _variant_new10 (_tmp4_));
	_tmp5_ = g_strdup ("progress");
	_tmp6_ = unity_launcher_entry_get_progress (l);
	g_hash_table_insert (props, _tmp5_, _variant_new11 (_tmp6_));
	_tmp7_ = g_strdup ("progress-visible");
	_tmp8_ = unity_launcher_entry_get_progress_visible (l);
	g_hash_table_insert (props, _tmp7_, _variant_new12 (_tmp8_));
	_tmp9_ = g_strdup ("urgent");
	_tmp10_ = unity_launcher_entry_get_urgent (l);
	g_hash_table_insert (props, _tmp9_, _variant_new13 (_tmp10_));
	_tmp11_ = unity_launcher_entry_get_quicklist (l);
	if (_tmp11_ != NULL) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("quicklist");
		g_hash_table_insert (props, _tmp12_, _variant_new14 (l->_object_path));
	}
	result = props;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



